/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.presentation;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioningListener;
import org.eclipse.jface.text.IDocumentPartitioningListenerExtension;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension3;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;

public class PresentationReconciler
implements IPresentationReconciler {
    protected static final String TRACKED_PARTITION = "__reconciler_tracked_partition";
    private Map fDamagers;
    private Map fRepairers;
    private ITextViewer fViewer;
    private InternalListener fInternalListener = new InternalListener();
    private String fPositionCategory = "__reconciler_tracked_partition" + this.hashCode();
    private IPositionUpdater fPositionUpdater = new DefaultPositionUpdater(this.fPositionCategory);
    private TypedPosition fRememberedPosition;
    private boolean fDocumentPartitioningChanged = false;
    private IRegion fChangedDocumentPartitions = null;

    public void setDamager(IPresentationDamager damager, String contentType) {
        Assert.isNotNull((Object)contentType);
        if (this.fDamagers == null) {
            this.fDamagers = new HashMap();
        }
        if (damager == null) {
            this.fDamagers.remove(contentType);
        } else {
            this.fDamagers.put(contentType, damager);
        }
    }

    public void setRepairer(IPresentationRepairer repairer, String contentType) {
        Assert.isNotNull((Object)contentType);
        if (this.fRepairers == null) {
            this.fRepairers = new HashMap();
        }
        if (repairer == null) {
            this.fRepairers.remove(contentType);
        } else {
            this.fRepairers.put(contentType, repairer);
        }
    }

    public void install(ITextViewer viewer) {
        Assert.isNotNull((Object)viewer);
        this.fViewer = viewer;
        this.fViewer.addTextInputListener(this.fInternalListener);
    }

    public void uninstall() {
        this.fViewer.removeTextInputListener(this.fInternalListener);
    }

    public IPresentationDamager getDamager(String contentType) {
        if (this.fDamagers == null) {
            return null;
        }
        return (IPresentationDamager)this.fDamagers.get(contentType);
    }

    public IPresentationRepairer getRepairer(String contentType) {
        if (this.fRepairers == null) {
            return null;
        }
        return (IPresentationRepairer)this.fRepairers.get(contentType);
    }

    private void setDocumentToDamagers(IDocument document) {
        if (this.fDamagers != null) {
            Iterator e = this.fDamagers.values().iterator();
            while (e.hasNext()) {
                IPresentationDamager damager = (IPresentationDamager)e.next();
                damager.setDocument(document);
            }
        }
    }

    private void setDocumentToRepairers(IDocument document) {
        if (this.fRepairers != null) {
            Iterator e = this.fRepairers.values().iterator();
            while (e.hasNext()) {
                IPresentationRepairer repairer = (IPresentationRepairer)e.next();
                repairer.setDocument(document);
            }
        }
    }

    private TextPresentation createPresentation(IRegion damage, IDocument document) {
        try {
            TextPresentation presentation = new TextPresentation(1000);
            ITypedRegion[] partitioning = document.computePartitioning(damage.getOffset(), damage.getLength());
            int i = 0;
            while (i < partitioning.length) {
                ITypedRegion r = partitioning[i];
                IPresentationRepairer repairer = this.getRepairer(r.getType());
                if (repairer != null) {
                    repairer.createPresentation(presentation, r);
                }
                ++i;
            }
            return presentation;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private IRegion getDamage(DocumentEvent e) {
        IRegion damage = null;
        try {
            ITypedRegion partition = e.getDocument().getPartition(e.getOffset());
            IPresentationDamager damager = this.getDamager(partition.getType());
            if (damager == null) {
                return null;
            }
            IRegion r = damager.getDamageRegion(partition, e, this.fDocumentPartitioningChanged);
            if (!this.fDocumentPartitioningChanged) {
                damage = r;
            } else {
                int end;
                int damageEnd = this.getDamageEndOffset(e);
                int parititionDamageEnd = -1;
                if (this.fChangedDocumentPartitions != null) {
                    parititionDamageEnd = this.fChangedDocumentPartitions.getOffset() + this.fChangedDocumentPartitions.getLength();
                }
                damage = (end = Math.max(damageEnd, parititionDamageEnd)) == -1 ? r : new Region(r.getOffset(), end - r.getOffset());
            }
        }
        catch (BadLocationException badLocationException) {}
        return damage;
    }

    private int getDamageEndOffset(DocumentEvent e) throws BadLocationException {
        IPresentationDamager damager;
        ITypedRegion partition;
        int endOffset;
        IDocument d = e.getDocument();
        int length = 0;
        if (e.getText() != null && (length = e.getText().length()) > 0) {
            --length;
        }
        if ((endOffset = (partition = d.getPartition(e.getOffset() + length)).getOffset() + partition.getLength()) == e.getOffset()) {
            return -1;
        }
        int end = this.fRememberedPosition.getOffset() + this.fRememberedPosition.getLength();
        if (endOffset < end) {
            partition = d.getPartition(end);
        }
        if ((damager = this.getDamager(partition.getType())) == null) {
            return -1;
        }
        IRegion r = damager.getDamageRegion(partition, e, this.fDocumentPartitioningChanged);
        return r.getOffset() + r.getLength();
    }

    private void processDamage(IRegion damage, IDocument document) {
        TextPresentation p;
        if (damage != null && damage.getLength() > 0 && (p = this.createPresentation(damage, document)) != null && !p.isEmpty()) {
            this.applyTextRegionCollection(p);
        }
    }

    private void applyTextRegionCollection(TextPresentation presentation) {
        this.fViewer.changeTextPresentation(presentation, false);
    }

    class InternalListener
    implements ITextInputListener,
    IDocumentListener,
    ITextListener,
    IDocumentPartitioningListener,
    IDocumentPartitioningListenerExtension {
        private boolean fDocumentChanging = false;

        InternalListener() {
        }

        public void inputDocumentAboutToBeChanged(IDocument oldDocument, IDocument newDocument) {
            if (oldDocument != null) {
                try {
                    PresentationReconciler.this.fViewer.removeTextListener(this);
                    oldDocument.removeDocumentListener((IDocumentListener)this);
                    oldDocument.removeDocumentPartitioningListener((IDocumentPartitioningListener)this);
                    oldDocument.removePositionUpdater(PresentationReconciler.this.fPositionUpdater);
                    oldDocument.removePositionCategory(PresentationReconciler.this.fPositionCategory);
                }
                catch (BadPositionCategoryException badPositionCategoryException) {}
            }
        }

        public void inputDocumentChanged(IDocument oldDocument, IDocument newDocument) {
            this.fDocumentChanging = false;
            if (newDocument != null) {
                newDocument.addPositionCategory(PresentationReconciler.this.fPositionCategory);
                newDocument.addPositionUpdater(PresentationReconciler.this.fPositionUpdater);
                newDocument.addDocumentPartitioningListener((IDocumentPartitioningListener)this);
                newDocument.addDocumentListener((IDocumentListener)this);
                PresentationReconciler.this.fViewer.addTextListener(this);
                PresentationReconciler.this.setDocumentToDamagers(newDocument);
                PresentationReconciler.this.setDocumentToRepairers(newDocument);
                PresentationReconciler.this.processDamage((IRegion)new Region(0, newDocument.getLength()), newDocument);
            }
        }

        public void documentPartitioningChanged(IDocument document) {
            if (!this.fDocumentChanging) {
                PresentationReconciler.this.processDamage((IRegion)new Region(0, document.getLength()), document);
            } else {
                PresentationReconciler.this.fDocumentPartitioningChanged = true;
            }
        }

        public void documentPartitioningChanged(IDocument document, IRegion changedRegion) {
            if (!this.fDocumentChanging) {
                PresentationReconciler.this.processDamage((IRegion)new Region(changedRegion.getOffset(), changedRegion.getLength()), document);
            } else {
                PresentationReconciler.this.fDocumentPartitioningChanged = true;
                PresentationReconciler.this.fChangedDocumentPartitions = changedRegion;
            }
        }

        public void documentAboutToBeChanged(DocumentEvent e) {
            this.fDocumentChanging = true;
            try {
                int offset = e.getOffset() + e.getLength();
                PresentationReconciler.this.fRememberedPosition = new TypedPosition(e.getDocument().getPartition(offset));
                e.getDocument().addPosition(PresentationReconciler.this.fPositionCategory, (Position)PresentationReconciler.this.fRememberedPosition);
            }
            catch (BadLocationException badLocationException) {
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
        }

        public void documentChanged(DocumentEvent e) {
            try {
                e.getDocument().removePosition(PresentationReconciler.this.fPositionCategory, (Position)PresentationReconciler.this.fRememberedPosition);
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
            this.fDocumentChanging = false;
        }

        public void textChanged(TextEvent e) {
            if (!e.getViewerRedrawState()) {
                return;
            }
            DocumentEvent de = e.getDocumentEvent();
            if (de == null) {
                if (e.getOffset() == 0 && e.getLength() == 0 && e.getText() == null) {
                    IDocument d = PresentationReconciler.this.fViewer.getDocument();
                    PresentationReconciler.this.processDamage((IRegion)new Region(0, d.getLength()), d);
                } else {
                    IRegion region = this.widgetRegion2ModelRegion(e);
                    PresentationReconciler.this.processDamage(region, PresentationReconciler.this.fViewer.getDocument());
                }
            } else {
                IRegion damage = PresentationReconciler.this.getDamage(de);
                if (damage != null) {
                    PresentationReconciler.this.processDamage(damage, de.getDocument());
                }
            }
            PresentationReconciler.this.fDocumentPartitioningChanged = false;
            PresentationReconciler.this.fChangedDocumentPartitions = null;
        }

        protected IRegion widgetRegion2ModelRegion(TextEvent e) {
            if (PresentationReconciler.this.fViewer instanceof ITextViewerExtension3) {
                ITextViewerExtension3 extension = (ITextViewerExtension3)((Object)PresentationReconciler.this.fViewer);
                return extension.widgetRange2ModelRange((IRegion)new Region(e.getOffset(), e.getLength()));
            }
            IRegion visible = PresentationReconciler.this.fViewer.getVisibleRegion();
            Region region = new Region(e.getOffset() + visible.getOffset(), e.getLength());
            return region;
        }
    }
}

