/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.reconciler;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.DirtyRegionQueue;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;

public abstract class AbstractReconciler
implements IReconciler {
    private DirtyRegionQueue fDirtyRegionQueue;
    private BackgroundThread fThread;
    private Listener fListener;
    private int fDelay = 500;
    private boolean fIsIncrementalReconciler = true;
    private IProgressMonitor fProgressMonitor;
    private IDocument fDocument;
    private ITextViewer fViewer;

    protected abstract void process(DirtyRegion var1);

    protected abstract void reconcilerDocumentChanged(IDocument var1);

    protected AbstractReconciler() {
    }

    public void setDelay(int delay) {
        this.fDelay = delay;
    }

    public void setIsIncrementalReconciler(boolean isIncremental) {
        this.fIsIncrementalReconciler = isIncremental;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.fProgressMonitor = monitor;
    }

    protected boolean isIncrementalReconciler() {
        return this.fIsIncrementalReconciler;
    }

    protected IDocument getDocument() {
        return this.fDocument;
    }

    protected ITextViewer getTextViewer() {
        return this.fViewer;
    }

    protected IProgressMonitor getProgressMonitor() {
        return this.fProgressMonitor;
    }

    public void install(ITextViewer textViewer) {
        Assert.isNotNull((Object)textViewer);
        this.fViewer = textViewer;
        this.fListener = new Listener();
        this.fViewer.addTextInputListener(this.fListener);
        this.fDirtyRegionQueue = new DirtyRegionQueue();
        this.fThread = new BackgroundThread(this.getClass().getName());
    }

    public void uninstall() {
        if (this.fListener != null) {
            this.fViewer.removeTextInputListener(this.fListener);
            if (this.fDocument != null) {
                this.fDocument.removeDocumentListener((IDocumentListener)this.fListener);
            }
            this.fListener = null;
            AbstractReconciler abstractReconciler = this;
            synchronized (abstractReconciler) {
                BackgroundThread bt = this.fThread;
                this.fThread = null;
                bt.cancel();
            }
        }
    }

    private void createDirtyRegion(DocumentEvent e) {
        if (e.getLength() == 0 && e.getText() != null) {
            this.fDirtyRegionQueue.addDirtyRegion(new DirtyRegion(e.getOffset(), e.getText().length(), "__insert", e.getText()));
        } else if (e.getText() == null || e.getText().length() == 0) {
            this.fDirtyRegionQueue.addDirtyRegion(new DirtyRegion(e.getOffset(), e.getLength(), "__remove", null));
        } else {
            this.fDirtyRegionQueue.addDirtyRegion(new DirtyRegion(e.getOffset(), e.getLength(), "__remove", null));
            this.fDirtyRegionQueue.addDirtyRegion(new DirtyRegion(e.getOffset(), e.getText().length(), "__insert", e.getText()));
        }
    }

    protected void initialProcess() {
    }

    protected void forceReconciling() {
        if (this.fDocument != null) {
            if (this.fIsIncrementalReconciler) {
                DocumentEvent e = new DocumentEvent(this.fDocument, 0, this.fDocument.getLength(), this.fDocument.get());
                this.createDirtyRegion(e);
            }
            this.startReconciling();
        }
    }

    protected synchronized void startReconciling() {
        if (this.fThread == null) {
            return;
        }
        if (!this.fThread.isAlive()) {
            this.fThread.start();
        }
        this.fThread.reset();
    }

    protected void reconcilerReset() {
    }

    public abstract IReconcilingStrategy getReconcilingStrategy(String var1);

    class BackgroundThread
    extends Thread {
        private boolean fCanceled = false;
        private boolean fReset = false;
        private boolean fIsDirty = false;
        private boolean fIsActive = false;

        public BackgroundThread(String name) {
            super(name);
            this.setPriority(1);
            this.setDaemon(true);
        }

        public boolean isActive() {
            return this.fIsActive;
        }

        public void cancel() {
            this.fCanceled = true;
            DirtyRegionQueue dirtyRegionQueue = AbstractReconciler.this.fDirtyRegionQueue;
            synchronized (dirtyRegionQueue) {
                AbstractReconciler.this.fDirtyRegionQueue.notifyAll();
            }
        }

        public void suspendCallerWhileDirty() {
            while (this.fIsDirty) {
                DirtyRegionQueue dirtyRegionQueue = AbstractReconciler.this.fDirtyRegionQueue;
                synchronized (dirtyRegionQueue) {
                    if (this.fIsDirty) {
                        try {
                            AbstractReconciler.this.fDirtyRegionQueue.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }

        public void reset() {
            if (AbstractReconciler.this.fDelay > 0) {
                BackgroundThread backgroundThread = this;
                synchronized (backgroundThread) {
                    this.fIsDirty = true;
                    this.fReset = true;
                }
            }
            Object object = this;
            synchronized (object) {
                this.fIsDirty = true;
            }
            object = AbstractReconciler.this.fDirtyRegionQueue;
            synchronized (object) {
                AbstractReconciler.this.fDirtyRegionQueue.notifyAll();
            }
            AbstractReconciler.this.reconcilerReset();
        }

        public void run() {
            Object object = AbstractReconciler.this.fDirtyRegionQueue;
            synchronized (object) {
                try {
                    AbstractReconciler.this.fDirtyRegionQueue.wait(AbstractReconciler.this.fDelay);
                }
                catch (InterruptedException interruptedException) {}
            }
            AbstractReconciler.this.initialProcess();
            while (!this.fCanceled) {
                object = AbstractReconciler.this.fDirtyRegionQueue;
                synchronized (object) {
                    try {
                        AbstractReconciler.this.fDirtyRegionQueue.wait(AbstractReconciler.this.fDelay);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.fCanceled) break;
                if (!this.fIsDirty) continue;
                if (this.fReset) {
                    object = this;
                    synchronized (object) {
                        this.fReset = false;
                        continue;
                    }
                }
                DirtyRegion r = null;
                DirtyRegionQueue dirtyRegionQueue = AbstractReconciler.this.fDirtyRegionQueue;
                synchronized (dirtyRegionQueue) {
                    r = AbstractReconciler.this.fDirtyRegionQueue.removeNextDirtyRegion();
                }
                this.fIsActive = true;
                if (AbstractReconciler.this.fProgressMonitor != null) {
                    AbstractReconciler.this.fProgressMonitor.setCanceled(false);
                }
                AbstractReconciler.this.process(r);
                dirtyRegionQueue = AbstractReconciler.this.fDirtyRegionQueue;
                synchronized (dirtyRegionQueue) {
                    if (AbstractReconciler.this.fDirtyRegionQueue.getSize() == 0) {
                        BackgroundThread backgroundThread = this;
                        synchronized (backgroundThread) {
                            this.fIsDirty = false;
                        }
                        AbstractReconciler.this.fDirtyRegionQueue.notifyAll();
                    }
                }
                this.fIsActive = false;
            }
        }
    }

    class Listener
    implements IDocumentListener,
    ITextInputListener {
        Listener() {
        }

        public void documentAboutToBeChanged(DocumentEvent e) {
        }

        public void documentChanged(DocumentEvent e) {
            if (AbstractReconciler.this.fProgressMonitor != null && AbstractReconciler.this.fThread.isActive()) {
                AbstractReconciler.this.fProgressMonitor.setCanceled(true);
            }
            if (AbstractReconciler.this.fIsIncrementalReconciler) {
                AbstractReconciler.this.createDirtyRegion(e);
            }
            AbstractReconciler.this.fThread.reset();
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
            if (oldInput == AbstractReconciler.this.fDocument) {
                if (AbstractReconciler.this.fDocument != null) {
                    AbstractReconciler.this.fDocument.removeDocumentListener((IDocumentListener)this);
                }
                if (AbstractReconciler.this.fIsIncrementalReconciler) {
                    AbstractReconciler.this.fDirtyRegionQueue.purgeQueue();
                    if (AbstractReconciler.this.fDocument != null && AbstractReconciler.this.fDocument.getLength() > 0) {
                        DocumentEvent e = new DocumentEvent(AbstractReconciler.this.fDocument, 0, AbstractReconciler.this.fDocument.getLength(), null);
                        AbstractReconciler.this.createDirtyRegion(e);
                        AbstractReconciler.this.fThread.suspendCallerWhileDirty();
                    }
                }
                AbstractReconciler.this.fDocument = null;
            }
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            AbstractReconciler.this.fDocument = newInput;
            if (AbstractReconciler.this.fDocument == null) {
                return;
            }
            AbstractReconciler.this.reconcilerDocumentChanged(AbstractReconciler.this.fDocument);
            AbstractReconciler.this.fDocument.addDocumentListener((IDocumentListener)this);
            if (AbstractReconciler.this.fIsIncrementalReconciler) {
                DocumentEvent e = new DocumentEvent(AbstractReconciler.this.fDocument, 0, 0, AbstractReconciler.this.fDocument.get());
                AbstractReconciler.this.createDirtyRegion(e);
            }
            AbstractReconciler.this.startReconciling();
        }
    }
}

