/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.ITextViewerExtension3;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public final class LineNumberRulerColumn
implements IVerticalRulerColumn {
    private CompositeRuler fParentRuler;
    private ITextViewer fCachedTextViewer;
    private StyledText fCachedTextWidget;
    private Canvas fCanvas;
    private int fScrollPos;
    private Image fBuffer;
    private InternalListener fInternalListener = new InternalListener();
    private Font fFont;
    private int[] fIndentation;
    private boolean fSensitiveToTextChanges = false;
    private Color fForeground;
    private Color fBackground;
    private int fCachedNumberOfDigits = -1;
    private boolean fRelayoutRequired = false;

    public void setForeground(Color foreground) {
        this.fForeground = foreground;
    }

    public void setBackground(Color background) {
        this.fBackground = background;
        if (this.fCanvas != null && !this.fCanvas.isDisposed()) {
            this.fCanvas.setBackground(this.getBackground(this.fCanvas.getDisplay()));
        }
    }

    protected Color getBackground(Display display) {
        if (this.fBackground == null) {
            return display.getSystemColor(25);
        }
        return this.fBackground;
    }

    public Control getControl() {
        return this.fCanvas;
    }

    public int getWidth() {
        return this.fIndentation[0];
    }

    protected boolean computeNumberOfDigits() {
        IDocument document = this.fCachedTextViewer.getDocument();
        int lines = document == null ? 0 : document.getNumberOfLines();
        int digits = 2;
        while ((double)lines > Math.pow(10.0, digits) - 1.0) {
            ++digits;
        }
        if (this.fCachedNumberOfDigits != digits) {
            this.fCachedNumberOfDigits = digits;
            return true;
        }
        return false;
    }

    protected void layout(boolean redraw) {
        ITextViewerExtension extension;
        Control control;
        if (!redraw) {
            this.fRelayoutRequired = true;
            return;
        }
        this.fRelayoutRequired = false;
        if (this.fCachedTextViewer instanceof ITextViewerExtension && (control = (extension = (ITextViewerExtension)((Object)this.fCachedTextViewer)).getControl()) instanceof Composite && !control.isDisposed()) {
            Composite composite = (Composite)control;
            composite.layout(true);
        }
    }

    protected void computeIndentations() {
        GC gc = new GC((Drawable)this.fCanvas);
        try {
            gc.setFont(this.fCanvas.getFont());
            this.fIndentation = new int[this.fCachedNumberOfDigits + 1];
            Float number = new Float(Math.pow(10.0, this.fCachedNumberOfDigits) - 1.0);
            Point p = gc.stringExtent(Integer.toString(number.intValue()));
            this.fIndentation[0] = p.x;
            int i = 1;
            while (i <= this.fCachedNumberOfDigits) {
                number = new Float(Math.pow(10.0, i) - 1.0);
                p = gc.stringExtent(Integer.toString(number.intValue()));
                this.fIndentation[i] = this.fIndentation[0] - p.x;
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            gc.dispose();
            throw throwable;
        }
        Object var5_7 = null;
        gc.dispose();
    }

    public Control createControl(CompositeRuler parentRuler, Composite parentControl) {
        this.fParentRuler = parentRuler;
        this.fCachedTextViewer = parentRuler.getTextViewer();
        this.fCachedTextWidget = this.fCachedTextViewer.getTextWidget();
        this.fCanvas = new Canvas(parentControl, 0);
        this.fCanvas.setBackground(this.getBackground(this.fCanvas.getDisplay()));
        this.fCanvas.setForeground(this.fForeground);
        this.fCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                if (LineNumberRulerColumn.this.fCachedTextViewer != null) {
                    LineNumberRulerColumn.this.doubleBufferPaint(event.gc);
                }
            }
        });
        this.fCanvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                LineNumberRulerColumn.this.handleDispose();
                LineNumberRulerColumn.this.fCachedTextViewer = null;
                LineNumberRulerColumn.this.fCachedTextWidget = null;
            }
        });
        this.fCanvas.addMouseListener((MouseListener)new MouseHandler());
        if (this.fCachedTextViewer != null) {
            this.fCachedTextViewer.addViewportListener(this.fInternalListener);
            this.fCachedTextViewer.addTextListener(this.fInternalListener);
            if (this.fFont == null && this.fCachedTextWidget != null && !this.fCachedTextWidget.isDisposed()) {
                this.fFont = this.fCachedTextWidget.getFont();
            }
        }
        if (this.fFont != null) {
            this.fCanvas.setFont(this.fFont);
        }
        this.computeNumberOfDigits();
        this.computeIndentations();
        return this.fCanvas;
    }

    private void handleDispose() {
        if (this.fCachedTextViewer != null) {
            this.fCachedTextViewer.removeViewportListener(this.fInternalListener);
            this.fCachedTextViewer.removeTextListener(this.fInternalListener);
        }
        if (this.fBuffer != null) {
            this.fBuffer.dispose();
            this.fBuffer = null;
        }
    }

    private void doubleBufferPaint(GC dest) {
        Point size = this.fCanvas.getSize();
        if (size.x <= 0 || size.y <= 0) {
            return;
        }
        if (this.fBuffer != null) {
            Rectangle r = this.fBuffer.getBounds();
            if (r.width != size.x || r.height != size.y) {
                this.fBuffer.dispose();
                this.fBuffer = null;
            }
        }
        if (this.fBuffer == null) {
            this.fBuffer = new Image((Device)this.fCanvas.getDisplay(), size.x, size.y);
        }
        GC gc = new GC((Drawable)this.fBuffer);
        gc.setFont(this.fCanvas.getFont());
        if (this.fForeground != null) {
            gc.setForeground(this.fForeground);
        }
        try {
            gc.setBackground(this.getBackground(this.fCanvas.getDisplay()));
            gc.fillRectangle(0, 0, size.x, size.y);
            if (this.fCachedTextViewer instanceof ITextViewerExtension3) {
                this.doPaint1(gc);
            } else {
                this.doPaint(gc);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            gc.dispose();
            throw throwable;
        }
        Object var4_6 = null;
        gc.dispose();
        dest.drawImage(this.fBuffer, 0, 0);
    }

    protected int getVisibleLinesInViewport() {
        Rectangle clArea = this.fCachedTextWidget.getClientArea();
        if (!clArea.isEmpty()) {
            return clArea.height / this.fCachedTextWidget.getLineHeight();
        }
        return -1;
    }

    private void doPaint(GC gc) {
        if (this.fCachedTextViewer == null) {
            return;
        }
        int firstLine = 0;
        int topLine = this.fCachedTextViewer.getTopIndex() - 1;
        int bottomLine = this.fCachedTextViewer.getBottomIndex() + 1;
        try {
            int lastLine;
            IRegion region = this.fCachedTextViewer.getVisibleRegion();
            IDocument doc = this.fCachedTextViewer.getDocument();
            firstLine = doc.getLineOfOffset(region.getOffset());
            if (firstLine > topLine) {
                topLine = firstLine;
            }
            if ((lastLine = doc.getLineOfOffset(region.getOffset() + region.getLength())) < bottomLine) {
                bottomLine = lastLine;
            }
        }
        catch (BadLocationException badLocationException) {
            return;
        }
        this.fSensitiveToTextChanges = bottomLine - topLine < this.getVisibleLinesInViewport();
        int lineheight = this.fCachedTextWidget.getLineHeight();
        this.fScrollPos = this.fCachedTextWidget.getTopPixel();
        int canvasheight = this.fCanvas.getSize().y;
        int y = (topLine - firstLine) * lineheight - this.fScrollPos + this.fCachedTextViewer.getTopInset();
        int line = topLine;
        while (line <= bottomLine) {
            if (y >= canvasheight) break;
            String s = Integer.toString(line + 1);
            int indentation = this.fIndentation[s.length()];
            gc.drawString(s, indentation, y);
            ++line;
            y += lineheight;
        }
    }

    private void doPaint1(GC gc) {
        if (this.fCachedTextViewer == null) {
            return;
        }
        ITextViewerExtension3 extension = (ITextViewerExtension3)((Object)this.fCachedTextViewer);
        int firstLine = 0;
        int widgetTopLine = this.fCachedTextWidget.getTopIndex();
        if (widgetTopLine > 0) {
            --widgetTopLine;
        }
        int topLine = extension.widgetlLine2ModelLine(widgetTopLine);
        int bottomLine = this.fCachedTextViewer.getBottomIndex();
        if (bottomLine >= 0) {
            ++bottomLine;
        }
        try {
            int lastLine;
            IRegion region = extension.getModelCoverage();
            IDocument doc = this.fCachedTextViewer.getDocument();
            firstLine = doc.getLineOfOffset(region.getOffset());
            if (firstLine > topLine || topLine == -1) {
                topLine = firstLine;
            }
            if ((lastLine = doc.getLineOfOffset(region.getOffset() + region.getLength())) < bottomLine || bottomLine == -1) {
                bottomLine = lastLine;
            }
        }
        catch (BadLocationException badLocationException) {
            return;
        }
        this.fSensitiveToTextChanges = bottomLine - topLine < this.getVisibleLinesInViewport();
        int lineheight = this.fCachedTextWidget.getLineHeight();
        this.fScrollPos = this.fCachedTextWidget.getTopPixel();
        int canvasheight = this.fCanvas.getSize().y;
        int y = widgetTopLine * lineheight - this.fScrollPos + this.fCachedTextViewer.getTopInset();
        int modelLine = topLine;
        while (modelLine <= bottomLine) {
            if (y >= canvasheight) break;
            int widgetLine = extension.modelLine2WidgetLine(modelLine);
            if (widgetLine != -1) {
                String s = Integer.toString(modelLine + 1);
                int indentation = this.fIndentation[s.length()];
                gc.drawString(s, indentation, y);
                y += lineheight;
            }
            ++modelLine;
        }
    }

    public void redraw() {
        if (this.fRelayoutRequired) {
            this.layout(true);
            return;
        }
        if (this.fCanvas != null && !this.fCanvas.isDisposed()) {
            GC gc = new GC((Drawable)this.fCanvas);
            this.doubleBufferPaint(gc);
            gc.dispose();
        }
    }

    public void setModel(IAnnotationModel model) {
    }

    public void setFont(Font font) {
        this.fFont = font;
        if (this.fCanvas != null && !this.fCanvas.isDisposed()) {
            this.fCanvas.setFont(this.fFont);
            this.computeNumberOfDigits();
            this.computeIndentations();
        }
    }

    class InternalListener
    implements IViewportListener,
    ITextListener {
        InternalListener() {
        }

        public void viewportChanged(int verticalPosition) {
            if (verticalPosition != LineNumberRulerColumn.this.fScrollPos) {
                LineNumberRulerColumn.this.redraw();
            }
        }

        public void textChanged(TextEvent event) {
            Display d;
            if (LineNumberRulerColumn.this.computeNumberOfDigits()) {
                LineNumberRulerColumn.this.computeIndentations();
                LineNumberRulerColumn.this.layout(event.getViewerRedrawState());
                return;
            }
            if (!event.getViewerRedrawState()) {
                return;
            }
            if ((LineNumberRulerColumn.this.fSensitiveToTextChanges || event.getDocumentEvent() == null) && LineNumberRulerColumn.this.fCanvas != null && !LineNumberRulerColumn.this.fCanvas.isDisposed() && (d = LineNumberRulerColumn.this.fCanvas.getDisplay()) != null) {
                d.asyncExec(new Runnable(this){
                    final /* synthetic */ InternalListener this$1;
                    {
                        this.this$1 = internalListener;
                    }

                    public void run() {
                        InternalListener.access$0(this.this$1).redraw();
                    }
                });
            }
        }

        static /* synthetic */ LineNumberRulerColumn access$0(InternalListener internalListener) {
            return internalListener.LineNumberRulerColumn.this;
        }
    }

    class MouseHandler
    implements MouseListener,
    MouseMoveListener,
    MouseTrackListener {
        private int fCachedViewportSize;
        private IRegion fStartLine;
        private int fStartLineNumber;
        private int fAutoScrollDirection;

        MouseHandler() {
        }

        public void mouseUp(MouseEvent event) {
            this.stopSelecting();
            this.stopAutoScroll();
        }

        public void mouseDown(MouseEvent event) {
            LineNumberRulerColumn.this.fParentRuler.setLocationOfLastMouseButtonActivity(event.x, event.y);
            this.startSelecting();
        }

        public void mouseDoubleClick(MouseEvent event) {
            LineNumberRulerColumn.this.fParentRuler.setLocationOfLastMouseButtonActivity(event.x, event.y);
            this.stopSelecting();
            this.stopAutoScroll();
        }

        public void mouseMove(MouseEvent event) {
            if (!this.autoScroll(event)) {
                int newLine = LineNumberRulerColumn.this.fParentRuler.toDocumentLineNumber(event.y);
                this.expandSelection(newLine);
            }
        }

        public void mouseEnter(MouseEvent event) {
        }

        public void mouseExit(MouseEvent event) {
        }

        public void mouseHover(MouseEvent event) {
        }

        private void startSelecting() {
            try {
                IDocument document = LineNumberRulerColumn.this.fCachedTextViewer.getDocument();
                this.fStartLineNumber = LineNumberRulerColumn.this.fParentRuler.getLineOfLastMouseButtonActivity();
                this.fStartLine = document.getLineInformation(this.fStartLineNumber);
                LineNumberRulerColumn.this.fCachedTextViewer.setSelectedRange(this.fStartLine.getOffset(), this.fStartLine.getLength());
                this.fCachedViewportSize = LineNumberRulerColumn.this.getVisibleLinesInViewport();
                LineNumberRulerColumn.this.fCanvas.addMouseMoveListener((MouseMoveListener)this);
                LineNumberRulerColumn.this.fCanvas.addMouseTrackListener((MouseTrackListener)this);
            }
            catch (BadLocationException badLocationException) {}
        }

        private void stopSelecting() {
            LineNumberRulerColumn.this.fCanvas.removeMouseMoveListener((MouseMoveListener)this);
            LineNumberRulerColumn.this.fCanvas.removeMouseTrackListener((MouseTrackListener)this);
        }

        private void expandSelection(int lineNumber) {
            try {
                IDocument document = LineNumberRulerColumn.this.fCachedTextViewer.getDocument();
                IRegion lineInfo = document.getLineInformation(lineNumber);
                int start = Math.min(this.fStartLine.getOffset(), lineInfo.getOffset());
                int end = Math.max(this.fStartLine.getOffset() + this.fStartLine.getLength(), lineInfo.getOffset() + lineInfo.getLength());
                if (lineNumber < this.fStartLineNumber) {
                    LineNumberRulerColumn.this.fCachedTextViewer.setSelectedRange(end, start - end);
                } else {
                    LineNumberRulerColumn.this.fCachedTextViewer.setSelectedRange(start, end - start);
                }
            }
            catch (BadLocationException badLocationException) {}
        }

        private void stopAutoScroll() {
            this.fAutoScrollDirection = 0;
        }

        private boolean autoScroll(MouseEvent event) {
            Rectangle area = LineNumberRulerColumn.this.fCanvas.getClientArea();
            if (event.y > area.height) {
                this.autoScroll(1024);
                return true;
            }
            if (event.y < 0) {
                this.autoScroll(128);
                return true;
            }
            this.stopAutoScroll();
            return false;
        }

        private void autoScroll(int direction) {
            if (this.fAutoScrollDirection == direction) {
                return;
            }
            Display display = LineNumberRulerColumn.this.fCanvas.getDisplay();
            Runnable timer = null;
            switch (direction) {
                case 128: {
                    timer = new Runnable(this, display){
                        final /* synthetic */ MouseHandler this$1;
                        private final /* synthetic */ Display val$display;
                        {
                            this.this$1 = mouseHandler;
                            this.val$display = display;
                        }

                        public void run() {
                            int top;
                            if (MouseHandler.access$0(this.this$1) == 128 && (top = MouseHandler.access$1(this.this$1)) > 0) {
                                LineNumberRulerColumn.access$4(MouseHandler.access$4(this.this$1)).setTopIndex(top - 1);
                                MouseHandler.access$2(this.this$1, top - 1);
                                this.val$display.timerExec(5, (Runnable)this);
                            }
                        }
                    };
                    break;
                }
                case 1024: {
                    timer = new Runnable(this, display){
                        final /* synthetic */ MouseHandler this$1;
                        private final /* synthetic */ Display val$display;
                        {
                            this.this$1 = mouseHandler;
                            this.val$display = display;
                        }

                        public void run() {
                            if (MouseHandler.access$0(this.this$1) == 1024) {
                                int top = MouseHandler.access$1(this.this$1);
                                LineNumberRulerColumn.access$4(MouseHandler.access$4(this.this$1)).setTopIndex(top + 1);
                                MouseHandler.access$2(this.this$1, top + 1 + MouseHandler.access$3(this.this$1));
                                this.val$display.timerExec(5, (Runnable)this);
                            }
                        }
                    };
                }
            }
            if (timer != null) {
                this.fAutoScrollDirection = direction;
                display.timerExec(5, timer);
            }
        }

        private int getInclusiveTopIndex() {
            if (LineNumberRulerColumn.this.fCachedTextWidget != null && !LineNumberRulerColumn.this.fCachedTextWidget.isDisposed()) {
                int top = LineNumberRulerColumn.this.fCachedTextViewer.getTopIndex();
                if (LineNumberRulerColumn.this.fCachedTextWidget.getTopPixel() % LineNumberRulerColumn.this.fCachedTextWidget.getLineHeight() != 0) {
                    --top;
                }
                return top;
            }
            return -1;
        }

        static /* synthetic */ int access$0(MouseHandler mouseHandler) {
            return mouseHandler.fAutoScrollDirection;
        }

        static /* synthetic */ int access$1(MouseHandler mouseHandler) {
            return mouseHandler.getInclusiveTopIndex();
        }

        static /* synthetic */ void access$2(MouseHandler mouseHandler, int n) {
            mouseHandler.expandSelection(n);
        }

        static /* synthetic */ int access$3(MouseHandler mouseHandler) {
            return mouseHandler.fCachedViewportSize;
        }

        static /* synthetic */ LineNumberRulerColumn access$4(MouseHandler mouseHandler) {
            return mouseHandler.LineNumberRulerColumn.this;
        }
    }
}

