/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ProjectionSourceViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;

public class ProjectionAnnotation
extends Annotation {
    private static final int OUTER_MARGIN = 1;
    private static final int INNER_MARGIN = 1;
    private static final int PIXELS = 1;
    private static final int LEGS = 2;
    private static final int MIDDLE = 4;
    private static final int SIZE = 9;
    private Position fProjectionRange;
    private boolean fIsFolded = false;

    public ProjectionAnnotation(Position range) {
        this.fProjectionRange = range;
    }

    public void paint(GC gc, Canvas canvas, Rectangle rectangle) {
        Color fg = gc.getForeground();
        gc.setForeground(canvas.getDisplay().getSystemColor(9));
        Rectangle r = new Rectangle(rectangle.x + 1, rectangle.y + 1, 8, 8);
        gc.drawRectangle(r);
        gc.drawLine(r.x + 1 + 1, r.y + 4, r.x + r.width - 1 - 1, r.y + 4);
        if (this.fIsFolded) {
            gc.drawLine(r.x + 4, r.y + 1 + 1, r.x + 4, r.y + r.height - 1 - 1);
        } else {
            gc.drawLine(r.x + 4, r.y + r.height, r.x + 4, rectangle.y + rectangle.height - 1);
            gc.drawLine(r.x + 4, rectangle.y + rectangle.height - 1, r.x + r.width - 1, rectangle.y + rectangle.height - 1);
        }
        gc.setForeground(fg);
    }

    public void run(ITextViewer viewer) {
        if (viewer instanceof ProjectionSourceViewer) {
            ProjectionSourceViewer projectionViewer = (ProjectionSourceViewer)viewer;
            if (this.fIsFolded) {
                this.fIsFolded = false;
                projectionViewer.expand(this.fProjectionRange.getOffset(), this.fProjectionRange.getLength());
            } else {
                try {
                    IDocument document = projectionViewer.getDocument();
                    int line = document.getLineOfOffset(this.fProjectionRange.getOffset());
                    int offset = document.getLineOffset(line + 1);
                    int length = this.fProjectionRange.getLength() - (offset - this.fProjectionRange.getOffset());
                    if (length > 0) {
                        this.fIsFolded = true;
                        projectionViewer.collapse(offset, length);
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
        }
    }

    public boolean isFolded() {
        return this.fIsFolded;
    }
}

