/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nio.cs;

import com.ibm.nio.cs.IBMCharsetEncoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CoderResult;
import sun.nio.cs.Surrogate;

class DirectEncoder
extends IBMCharsetEncoder {
    private int maxCode;
    private final Surrogate.Parser sgp = new Surrogate.Parser();

    protected DirectEncoder(Charset charset, int n, byte[] byArray) {
        super(charset, 1.0f, 1.0f);
        this.maxCode = n;
        if (byArray != null) {
            this.replaceWith(byArray);
        }
    }

    public boolean isLegalReplacement(byte[] byArray) {
        if (this.maxCode == 0) {
            return true;
        }
        return (char)(byArray[0] & 0xFF) <= this.maxCode;
    }

    public boolean canEncode(char c) {
        return c <= this.maxCode;
    }

    private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        int n;
        char[] cArray = charBuffer.array();
        int n2 = charBuffer.arrayOffset() + charBuffer.limit();
        byte[] byArray = byteBuffer.array();
        int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
        int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
        CoderResult coderResult = CoderResult.UNDERFLOW;
        for (n = charBuffer.arrayOffset() + charBuffer.position(); n < n2; ++n) {
            char c = cArray[n];
            if (c <= this.maxCode) {
                if (n4 - n3 < 1) {
                    coderResult = CoderResult.OVERFLOW;
                    break;
                }
            } else {
                if (this.sgp.parse(c, cArray, n, n2) < 0) {
                    coderResult = this.sgp.error();
                    break;
                }
                coderResult = this.sgp.unmappableResult();
                break;
            }
            byArray[n3++] = (byte)c;
        }
        charBuffer.position(n - charBuffer.arrayOffset());
        byteBuffer.position(n3 - byteBuffer.arrayOffset());
        return coderResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        int n = charBuffer.position();
        try {
            while (charBuffer.hasRemaining()) {
                char c = charBuffer.get();
                if (c <= this.maxCode) {
                    if (!byteBuffer.hasRemaining()) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    byteBuffer.put((byte)c);
                    ++n;
                    continue;
                }
                if (Surrogate.is(c) && this.sgp.parse(c, charBuffer) < 0) {
                    CoderResult coderResult = this.sgp.error();
                    return coderResult;
                }
                CoderResult coderResult = this.sgp.unmappableResult();
                return coderResult;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            charBuffer.position(n);
        }
    }

    protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        if (charBuffer.hasArray() && byteBuffer.hasArray() && !UseBuffer) {
            return this.encodeArrayLoop(charBuffer, byteBuffer);
        }
        return this.encodeBufferLoop(charBuffer, byteBuffer);
    }
}

