/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.io.ByteArrayInputStream;
import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Iterator;
import java.util.List;

public abstract class CertPath
implements Serializable {
    private String type;

    protected CertPath(String string) {
        this.type = string;
    }

    public String getType() {
        return this.type;
    }

    public abstract Iterator getEncodings();

    /*
     * Unable to fully structure code
     */
    public boolean equals(Object var1_1) {
        var4_2 = false;
        if (!(var1_1 instanceof CertPath)) {
            return false;
        }
        if (this == (CertPath)var1_1) {
            return true;
        }
        if (!this.getType().equals(((CertPath)var1_1).getType())) {
            return false;
        }
        var5_3 = this.getCertificates();
        var6_4 = ((CertPath)var1_1).getCertificates();
        var2_5 = var5_3.iterator();
        var3_6 = var6_4.iterator();
        if (var5_3.size() == var6_4.size()) ** GOTO lbl18
        return false;
lbl-1000:
        // 1 sources

        {
            var7_7 = (Certificate)var2_5.next();
            if (!var7_7.equals(var8_8 = (Certificate)var3_6.next())) {
                return false;
            }
            var4_2 = true;
lbl18:
            // 2 sources

            ** while (var2_5.hasNext())
        }
lbl19:
        // 1 sources

        return var4_2 == true || var5_3.size() == 0 && var6_4.size() == 0;
    }

    public int hashCode() {
        int n = this.type.hashCode();
        n = 31 * n + this.getCertificates().hashCode();
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        List list = this.getCertificates();
        stringBuffer.append("\n" + this.type + " Cert Path: length = " + list.size() + ".\n[\n");
        Iterator iterator = list.iterator();
        int n = 1;
        while (iterator.hasNext()) {
            Certificate certificate = (Certificate)iterator.next();
            stringBuffer.append("=========================================================Certificate " + n + " start.\n" + certificate.toString() + "\n=========================================================Certificate " + n + " end.\n\n\n");
            ++n;
        }
        stringBuffer.append("\n]");
        return stringBuffer.toString();
    }

    public abstract byte[] getEncoded() throws CertificateEncodingException;

    public abstract byte[] getEncoded(String var1) throws CertificateEncodingException;

    public abstract List getCertificates();

    protected Object writeReplace() throws ObjectStreamException {
        try {
            return new CertPathRep(this.type, this.getEncoded());
        }
        catch (CertificateException certificateException) {
            NotSerializableException notSerializableException = new NotSerializableException("java.security.cert.CertPath: " + this.type);
            notSerializableException.initCause(certificateException);
            throw notSerializableException;
        }
    }

    protected static class CertPathRep
    implements Serializable {
        private String type;
        private byte[] data;

        protected CertPathRep(String string, byte[] byArray) {
            this.type = string;
            this.data = byArray;
        }

        protected Object readResolve() throws ObjectStreamException {
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance(this.type);
                return certificateFactory.generateCertPath(new ByteArrayInputStream(this.data));
            }
            catch (CertificateException certificateException) {
                NotSerializableException notSerializableException = new NotSerializableException("java.security.cert.CertPath: " + this.type);
                notSerializableException.initCause(certificateException);
                throw notSerializableException;
            }
        }
    }
}

