/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.CPSuri;
import com.ibm.security.x509.PKIXExtensions;
import com.ibm.security.x509.UserNotice;
import java.io.IOException;

public final class PolicyQualifierInfo {
    private byte[] encodedInfo;
    private ObjectIdentifier qualifierId;
    private byte[] qualifier;
    private String pqiString;

    public PolicyQualifierInfo(byte[] byArray) throws IOException {
        DerInputStream derInputStream = new DerInputStream(byArray);
        DerValue derValue = derInputStream.getDerValue();
        this.decode(derValue);
        this.encodedInfo = (byte[])byArray.clone();
    }

    public byte[] getEncoded() {
        return (byte[])this.encodedInfo.clone();
    }

    public String getPolicyQualifierId() {
        return this.qualifierId.toString();
    }

    public byte[] getPolicyQualifier() {
        if (this.qualifier == null) {
            return null;
        }
        return (byte[])this.qualifier.clone();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PolicyQualifierInfo: [\nqualifier ID:\t" + this.getPolicyQualifierId() + "\n");
        if (this.pqiString != null) {
            stringBuffer.append("qualifier:\t" + this.pqiString + "\n]");
        } else {
            HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
            stringBuffer.append("qualifier:\t" + (this.qualifier == null ? "null" : hexDumpEncoder.encodeBuffer(this.qualifier)) + "\n]");
        }
        return stringBuffer.toString();
    }

    private void decode(DerValue derValue) throws IOException {
        if (derValue.getTag() != 48) {
            throw new IOException("PolicyQualifierInfo parsing error, not a SEQUENCE");
        }
        this.qualifierId = derValue.getData().getOID();
        DerValue derValue2 = derValue.getData().getDerValue();
        byte[] byArray = derValue2.toByteArray();
        if (byArray == null) {
            this.qualifier = null;
        } else {
            this.qualifier = (byte[])byArray.clone();
            if (this.qualifierId.equals(PKIXExtensions.UserNotice_Id)) {
                try {
                    this.pqiString = new UserNotice(this.qualifier).toString();
                }
                catch (IOException iOException) {
                    this.pqiString = null;
                }
            } else if (this.qualifierId.equals(PKIXExtensions.CPSuri_Id)) {
                try {
                    this.pqiString = new CPSuri(this.qualifier).toString();
                }
                catch (IOException iOException) {
                    this.pqiString = null;
                }
            }
        }
        if (derValue.getData().available() != 0) {
            throw new IOException("PolicyQualifierInfo parsing error - data overrun, bytes = " + derValue.getData().available());
        }
    }
}

