/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.AuthorityKeyIdentifierExtension;
import com.ibm.security.x509.CertificatePoliciesExtension;
import com.ibm.security.x509.DNSName;
import com.ibm.security.x509.EDIPartyName;
import com.ibm.security.x509.ExtKeyUsageExtension;
import com.ibm.security.x509.GeneralName;
import com.ibm.security.x509.GeneralNameInterface;
import com.ibm.security.x509.GeneralNames;
import com.ibm.security.x509.GeneralSubtree;
import com.ibm.security.x509.GeneralSubtrees;
import com.ibm.security.x509.IPAddressName;
import com.ibm.security.x509.KeyIdentifier;
import com.ibm.security.x509.NameConstraintsExtension;
import com.ibm.security.x509.OIDName;
import com.ibm.security.x509.OtherName;
import com.ibm.security.x509.PolicyInformation;
import com.ibm.security.x509.PrivateKeyUsageExtension;
import com.ibm.security.x509.RFC822Name;
import com.ibm.security.x509.SubjectAlternativeNameExtension;
import com.ibm.security.x509.SubjectKeyIdentifierExtension;
import com.ibm.security.x509.URIName;
import com.ibm.security.x509.X400Address;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CertImpl;
import com.ibm.security.x509.X509Key;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.PrivilegedAction;
import java.security.PublicKey;
import java.security.cert.CertPathHelperInitializer;
import java.security.cert.CertSelector;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;

public class X509CertSelector
implements CertSelector {
    private static final Debug debug = Debug.getInstance((String)"certpath");
    private BigInteger serialNumber;
    private X500Name issuer;
    private boolean issuerAsString;
    private X500Name subject;
    private boolean subjectAsString;
    private byte[] subjectKeyIdentifier;
    private byte[] authorityKeyIdentifier;
    private Date certificateValid;
    private Date privateKeyValid;
    private AlgorithmId subjectPublicKeyAlgID;
    private PublicKey subjectPublicKey;
    private boolean[] keyUsage;
    private ArrayList subjectAlternativeNames;
    private ArrayList subjectAlternativeNamesFromApp;
    private GeneralSubtrees[] nameConstraints;
    private byte[] baNameConstraints = null;
    private int basicConstraints;
    private Set policy;
    private Set keyPurposeSet;
    private X509Certificate certificate;
    private boolean matchAllNames;
    private ArrayList pathToNames;
    private ArrayList pathToNamesFromApp;

    public X509CertSelector() {
        try {
            this.setCertificate(null);
            this.setExtendedKeyUsage(null);
            this.setSerialNumber(null);
            this.setIssuer((byte[])null);
            this.setSubject((byte[])null);
            this.setSubjectKeyIdentifier(null);
            this.setAuthorityKeyIdentifier(null);
            this.setCertificateValid(null);
            this.setPrivateKeyValid(null);
            this.setSubjectPublicKeyAlgID(null);
            this.setSubjectPublicKey((PublicKey)null);
            this.setKeyUsage(null);
            this.setSubjectAlternativeNames(null);
            this.setNameConstraints(null);
            this.setBasicConstraints(-1);
            this.setPolicy(null);
            this.setPathToNames(null);
            this.setMatchAllSubjectAltNames(true);
        }
        catch (IOException iOException) {}
    }

    public void setSerialNumber(BigInteger bigInteger) {
        this.serialNumber = bigInteger != null ? new BigInteger(bigInteger.toByteArray()) : null;
    }

    public void setIssuer(String string) throws IOException {
        this.issuer = string != null ? new X500Name(string) : null;
        this.issuerAsString = true;
    }

    public void setIssuer(byte[] byArray) throws IOException {
        this.issuer = byArray != null ? new X500Name(byArray) : null;
        this.issuerAsString = false;
    }

    void setIssuer(X500Principal x500Principal) {
        try {
            this.issuer = x500Principal != null ? new X500Name(x500Principal.getEncoded()) : null;
        }
        catch (IOException iOException) {
            this.issuer = null;
        }
    }

    public void setSubject(String string) throws IOException {
        this.subject = string != null ? new X500Name(string) : null;
        this.subjectAsString = true;
    }

    public void setSubject(byte[] byArray) throws IOException {
        this.subject = byArray != null ? new X500Name(byArray) : null;
        this.subjectAsString = false;
    }

    void setSubject(X500Principal x500Principal) {
        try {
            this.subject = x500Principal != null ? new X500Name(x500Principal.getEncoded()) : null;
        }
        catch (IOException iOException) {
            this.subject = null;
        }
    }

    public void setSubjectKeyIdentifier(byte[] byArray) {
        this.subjectKeyIdentifier = byArray != null ? (byte[])byArray.clone() : null;
    }

    public void setAuthorityKeyIdentifier(byte[] byArray) {
        this.authorityKeyIdentifier = byArray != null ? (byte[])byArray.clone() : null;
    }

    public void setCertificate(X509Certificate x509Certificate) {
        this.certificate = x509Certificate;
    }

    public void setCertificateValid(Date date) {
        this.certificateValid = date != null ? new Date(date.getTime()) : null;
    }

    public void setExtendedKeyUsage(Set set) throws IOException {
        if (set != null) {
            HashSet hashSet = new HashSet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                ObjectIdentifier objectIdentifier;
                Object object = iterator.next();
                if (!(object instanceof String)) {
                    throw new IOException("all elements in the keyPurposeSet must be String");
                }
                try {
                    objectIdentifier = new ObjectIdentifier((String)object);
                }
                catch (Exception exception) {
                    throw new IOException("invalid OID " + object.toString());
                }
                hashSet.add(objectIdentifier);
            }
            this.keyPurposeSet = hashSet;
        } else {
            this.keyPurposeSet = null;
        }
    }

    public void setPrivateKeyValid(Date date) {
        this.privateKeyValid = date != null ? new Date(date.getTime()) : null;
    }

    public void setSubjectPublicKeyAlgID(String string) throws IOException {
        if (string != null) {
            try {
                this.subjectPublicKeyAlgID = new AlgorithmId(new ObjectIdentifier(string));
            }
            catch (Exception exception) {
                throw new IOException("invalid OID: " + string);
            }
        } else {
            this.subjectPublicKeyAlgID = null;
        }
    }

    public void setSubjectPublicKey(PublicKey publicKey) {
        this.subjectPublicKey = publicKey;
    }

    public void setSubjectPublicKey(byte[] byArray) throws IOException {
        if (byArray == null) {
            this.subjectPublicKey = null;
        } else {
            X509Key x509Key = new X509Key();
            try {
                x509Key.decode((InputStream)new ByteArrayInputStream((byte[])byArray.clone()));
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new IOException(invalidKeyException.getMessage());
            }
            this.subjectPublicKey = x509Key;
        }
    }

    public void setKeyUsage(boolean[] blArray) {
        this.keyUsage = (boolean[])(blArray == null ? null : (boolean[])blArray.clone());
    }

    public void setMatchAllSubjectAltNames(boolean bl) {
        this.matchAllNames = bl;
    }

    public void setSubjectAlternativeNames(Collection collection) throws IOException {
        if (collection != null && collection.size() > 0) {
            this.subjectAlternativeNames = new ArrayList();
            this.subjectAlternativeNamesFromApp = new ArrayList();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (!(object instanceof List)) {
                    throw new IOException("each entry of names should be instance of List");
                }
                List list = (List)object;
                if (list.size() < 2) {
                    throw new IOException("each entry of names should contain two elements");
                }
                Object object2 = list.get(0);
                if (!(object2 instanceof Integer)) {
                    throw new IOException("first element in each entry of names should be an Integer");
                }
                int n = (Integer)object2;
                if (n < 0 || n > 8) {
                    throw new IOException("name type not 0-8");
                }
                Object object3 = list.get(1);
                if (object3 instanceof byte[]) {
                    this.addSubjectAlternativeName(n, (byte[])object3);
                    continue;
                }
                if (object3 instanceof String) {
                    this.addSubjectAlternativeName(n, (String)object3);
                    continue;
                }
                throw new IOException("second element in each entry of names should be a byte array or a String");
            }
        } else {
            this.subjectAlternativeNamesFromApp = null;
            this.subjectAlternativeNames = null;
        }
    }

    public void addSubjectAlternativeName(int n, String string) throws IOException {
        if (string == null) {
            throw new IOException("name is null");
        }
        if (this.subjectAlternativeNames == null) {
            this.subjectAlternativeNamesFromApp = new ArrayList();
            this.subjectAlternativeNames = new ArrayList();
        }
        ArrayList arrayList = new ArrayList();
        arrayList.add(new Integer(n));
        arrayList.add(string);
        this.subjectAlternativeNamesFromApp.add(arrayList);
        this.subjectAlternativeNames.add(this.processGeneralName(n, string));
    }

    public void addSubjectAlternativeName(int n, byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IOException("name is null");
        }
        if (this.subjectAlternativeNames == null) {
            this.subjectAlternativeNames = new ArrayList();
            this.subjectAlternativeNamesFromApp = new ArrayList();
        }
        ArrayList arrayList = new ArrayList();
        arrayList.add(new Integer(n));
        arrayList.add(byArray.clone());
        this.subjectAlternativeNamesFromApp.add(arrayList);
        this.subjectAlternativeNames.add(this.processGeneralName(n, (byte[])byArray.clone()));
    }

    public void setNameConstraints(byte[] byArray) throws IOException {
        if (byArray != null) {
            this.baNameConstraints = (byte[])byArray.clone();
            if (this.nameConstraints == null) {
                this.nameConstraints = new GeneralSubtrees[2];
            }
            NameConstraintsExtension nameConstraintsExtension = new NameConstraintsExtension(Boolean.TRUE, (Object)byArray);
            GeneralSubtrees generalSubtrees = (GeneralSubtrees)nameConstraintsExtension.get("permitted_subtrees");
            GeneralSubtrees generalSubtrees2 = (GeneralSubtrees)nameConstraintsExtension.get("excluded_subtrees");
            this.nameConstraints[0] = generalSubtrees;
            this.nameConstraints[1] = generalSubtrees2;
        } else {
            this.baNameConstraints = null;
            this.nameConstraints = null;
        }
    }

    public void setBasicConstraints(int n) {
        if (n < -2) {
            throw new IllegalArgumentException("Max path length < -2");
        }
        this.basicConstraints = n;
    }

    public void setPolicy(Set set) throws IOException {
        if (set != null) {
            HashSet hashSet = new HashSet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                ObjectIdentifier objectIdentifier;
                Object object = iterator.next();
                if (!(object instanceof String)) {
                    throw new IOException("all elements in the Set must be String");
                }
                try {
                    objectIdentifier = new ObjectIdentifier((String)object);
                }
                catch (Exception exception) {
                    throw new IOException("invalid OID: " + object.toString());
                }
                hashSet.add(objectIdentifier);
            }
            this.policy = hashSet;
        } else {
            this.policy = null;
        }
    }

    public void setPathToNames(Collection collection) throws IOException {
        if (collection != null && collection.size() > 0) {
            this.pathToNames = new ArrayList();
            this.pathToNamesFromApp = new ArrayList();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (!(object instanceof List)) {
                    throw new IOException("each entry of names should be instance of List");
                }
                List list = (List)object;
                if (list.size() < 2) {
                    throw new IOException("each entry of names should contain two elements");
                }
                Object object2 = list.get(0);
                if (!(object2 instanceof Integer)) {
                    throw new IOException("first element in each entry of names should be an Integer");
                }
                int n = (Integer)object2;
                if (n < 0 || n > 8) {
                    throw new IOException("name type not 0-8");
                }
                Object object3 = list.get(1);
                if (object3 instanceof byte[]) {
                    this.addPathToName(n, (byte[])object3);
                    continue;
                }
                if (object3 instanceof String) {
                    this.addPathToName(n, (String)object3);
                    continue;
                }
                throw new IOException("second element in each entry of names should be a byte array or a String");
            }
        } else {
            this.pathToNames = null;
            this.pathToNamesFromApp = null;
        }
    }

    void setPathToNamesInternal(Set set) {
        Class clazz = null;
        try {
            clazz = Class.forName("sun.security.x509.GeneralNameInterface");
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (debug != null) {
                System.out.println("X509CertSelector.setPathToNamesInternal: sun.security.x509.GeneralNameInterface not found");
            }
            return;
        }
        Class clazz2 = null;
        try {
            clazz2 = Class.forName("sun.security.util.DerOutputStream");
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (debug != null) {
                System.out.println("X509CertSelector.setPathToNamesInternal: sun.security.util.DerOutputStream not found");
            }
            return;
        }
        Method method = this.getMethod(clazz, "getType", null);
        if (method == null) {
            if (debug != null) {
                System.out.println("X509CertSelector.setPathToNamesInternal: cannot find getType() method");
            }
            return;
        }
        Method method2 = this.getMethod(clazz, "encode", new Class[]{clazz2});
        if (method2 == null && debug != null) {
            System.out.println("X509CertSelector.setPathToNamesInternal: cannot find encode() method");
        }
        this.pathToNames = new ArrayList();
        this.pathToNamesFromApp = new ArrayList();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!clazz.isInstance(object)) {
                if (debug != null) {
                    System.out.println("X509CertSelector.setPathToNamesInternal: objects in the set are not GeneralNameInterface");
                }
                return;
            }
            Object object2 = null;
            Object object3 = null;
            try {
                object3 = clazz2.newInstance();
            }
            catch (InstantiationException instantiationException) {
                if (debug != null) {
                    System.out.println("X509CertSelector.setPathToNamesInternal: " + instantiationException.toString());
                }
                return;
            }
            catch (IllegalAccessException illegalAccessException) {
                if (debug != null) {
                    System.out.println("X509CertSelector.setPathToNamesInternal:" + illegalAccessException.toString());
                }
                return;
            }
            try {
                object2 = method.invoke(object, null);
                method2.invoke(object, new Object[]{object3});
            }
            catch (IllegalAccessException illegalAccessException) {
                if (debug != null) {
                    System.out.println("X509CertSelector.setPathToNamesInternal: " + illegalAccessException.toString());
                }
                return;
            }
            catch (InvocationTargetException invocationTargetException) {
                if (debug != null) {
                    System.out.println("X509CertSelector.setPathToNamesInternal: " + invocationTargetException.toString());
                }
                return;
            }
            int n = 0;
            byte[] byArray = null;
            if (!(object2 instanceof Integer)) {
                if (debug != null) {
                    System.out.println("X509CertSelector.setPathToNamesInternal: fail to getType");
                }
                return;
            }
            n = (Integer)object2;
            if (!(object3 instanceof ByteArrayOutputStream)) {
                if (debug != null) {
                    System.out.println("X509CertSelector.setPathToNamesInternal: sun.security.util.DerOutputStream not a ByteArrayOutputStream");
                }
                return;
            }
            byArray = ((ByteArrayOutputStream)object3).toByteArray();
            ArrayList arrayList = new ArrayList();
            arrayList.add((Integer)object2);
            arrayList.add(byArray);
            this.pathToNamesFromApp.add(arrayList);
            arrayList = new ArrayList();
            arrayList.add((Integer)object2);
            arrayList.add(this.getGNS(n, byArray));
            this.pathToNames.add(arrayList);
        }
    }

    private GeneralNameInterface getGNS(int n, byte[] byArray) {
        DerValue derValue = null;
        try {
            derValue = new DerValue(byArray);
        }
        catch (IOException iOException) {
            if (debug != null) {
                System.out.println("X509CertSelector.getGNS: fail to construct DerValue");
            }
            return null;
        }
        OtherName otherName = null;
        switch (n) {
            case 0: {
                try {
                    otherName = new OtherName(derValue);
                }
                catch (IOException iOException) {
                    if (debug == null) break;
                    System.out.println("X509CertSelector.getGNS: fail to construct othername");
                }
                break;
            }
            case 1: {
                try {
                    otherName = new RFC822Name(derValue);
                }
                catch (IOException iOException) {
                    if (debug == null) break;
                    System.out.println("X509CertSelector.getGNS: fail to construct RFC822name");
                }
                break;
            }
            case 2: {
                try {
                    otherName = new DNSName(derValue);
                }
                catch (IOException iOException) {
                    if (debug == null) break;
                    System.out.println("X509CertSelector.getGNS: fail to construct dnsname");
                }
                break;
            }
            case 3: {
                try {
                    otherName = new X400Address(derValue);
                }
                catch (IOException iOException) {
                    if (debug == null) break;
                    System.out.println("X509CertSelector.getGNS: fail to construct x400address");
                }
                break;
            }
            case 4: {
                try {
                    otherName = new X500Name(derValue);
                }
                catch (IOException iOException) {
                    if (debug == null) break;
                    System.out.println("X509CertSelector.getGNS: fail to construct x500name");
                }
                break;
            }
            case 5: {
                try {
                    otherName = new EDIPartyName(derValue);
                }
                catch (IOException iOException) {
                    if (debug == null) break;
                    System.out.println("X509CertSelector.getGNS: fail to construct ediparty name");
                }
                break;
            }
            case 6: {
                try {
                    otherName = new URIName(derValue);
                }
                catch (IOException iOException) {
                    if (debug == null) break;
                    System.out.println("X509CertSelector.getGNS: fail to construct uri name");
                }
                break;
            }
            case 7: {
                try {
                    otherName = new IPAddressName(derValue);
                }
                catch (IOException iOException) {
                    if (debug == null) break;
                    System.out.println("X509CertSelector.getGNS: fail to construct ip address name");
                }
                break;
            }
            case 8: {
                try {
                    otherName = new OIDName(derValue);
                }
                catch (IOException iOException) {
                    if (debug == null) break;
                    System.out.println("X509CertSelector.getGNS: fail to construct oid name");
                }
                break;
            }
            default: {
                if (debug == null) break;
                System.out.println("X509CertSelector.getGNS: illegal type");
            }
        }
        return otherName;
    }

    private Method getMethod(Class clazz, String string, Class[] classArray) {
        final String string2 = string;
        final Class clazz2 = clazz;
        final Class[] classArray2 = classArray;
        Method method = (Method)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Method method;
                block3: {
                    method = null;
                    try {
                        method = clazz2.getMethod(string2, classArray2);
                        if (method != null) {
                            method.setAccessible(true);
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        if (debug == null) break block3;
                        System.out.println("X509CertSelector.getMethod: can not find " + string2);
                    }
                }
                return method;
            }
        });
        return method;
    }

    public void addPathToName(int n, String string) throws IOException {
        if (string == null) {
            throw new IOException("name is null");
        }
        if (this.pathToNames == null) {
            this.pathToNames = new ArrayList();
            this.pathToNamesFromApp = new ArrayList();
        }
        this.pathToNames.add(this.processGeneralName(n, string));
        ArrayList arrayList = new ArrayList(2);
        arrayList.add(new Integer(n));
        arrayList.add(string);
        this.pathToNamesFromApp.add(arrayList);
    }

    public void addPathToName(int n, byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IOException("name is null");
        }
        if (this.pathToNames == null) {
            this.pathToNames = new ArrayList();
            this.pathToNamesFromApp = new ArrayList();
        }
        ArrayList arrayList = new ArrayList();
        arrayList.add(new Integer(n));
        arrayList.add(byArray.clone());
        this.pathToNames.add(this.processGeneralName(n, (byte[])byArray.clone()));
        this.pathToNamesFromApp.add(arrayList);
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber != null ? new BigInteger(this.serialNumber.toByteArray()) : null;
    }

    public String getIssuerAsString() {
        return this.issuer != null ? this.issuer.getRFC2253Name() : null;
    }

    public byte[] getIssuerAsBytes() throws IOException {
        return this.issuer != null ? (byte[])this.issuer.getEncoded().clone() : null;
    }

    X500Principal getIssuer() {
        try {
            return this.issuer != null ? new X500Principal(this.issuer.getEncoded()) : null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getSubjectAsString() {
        return this.subject != null ? this.subject.getRFC2253Name() : null;
    }

    public byte[] getSubjectAsBytes() throws IOException {
        return this.subject != null ? (byte[])this.subject.getEncoded().clone() : null;
    }

    X500Principal getSubject() {
        try {
            return this.subject != null ? new X500Principal(this.subject.getEncoded()) : null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public byte[] getSubjectKeyIdentifier() {
        return this.subjectKeyIdentifier != null ? (byte[])this.subjectKeyIdentifier.clone() : null;
    }

    public byte[] getAuthorityKeyIdentifier() {
        return this.authorityKeyIdentifier != null ? (byte[])this.authorityKeyIdentifier.clone() : null;
    }

    public Date getCertificateValid() {
        return this.certificateValid != null ? new Date(this.certificateValid.getTime()) : null;
    }

    public Set getExtendedKeyUsage() {
        if (this.keyPurposeSet != null) {
            HashSet hashSet = new HashSet();
            Iterator iterator = this.keyPurposeSet.iterator();
            while (iterator.hasNext()) {
                String string = ((ObjectIdentifier)iterator.next()).toString();
                hashSet.add(string);
            }
            return Collections.unmodifiableSet(hashSet);
        }
        return null;
    }

    public Date getPrivateKeyValid() {
        return this.privateKeyValid != null ? new Date(this.privateKeyValid.getTime()) : null;
    }

    public String getSubjectPublicKeyAlgID() {
        return this.subjectPublicKeyAlgID != null ? this.subjectPublicKeyAlgID.getOID().toString() : null;
    }

    public PublicKey getSubjectPublicKey() {
        return this.subjectPublicKey;
    }

    public boolean[] getKeyUsage() {
        if (this.keyUsage != null) {
            return (boolean[])this.keyUsage.clone();
        }
        return null;
    }

    public boolean getMatchAllSubjectAltNames() {
        return this.matchAllNames;
    }

    public Collection getSubjectAlternativeNames() {
        if (this.subjectAlternativeNamesFromApp != null) {
            ArrayList arrayList = new ArrayList();
            Iterator iterator = this.subjectAlternativeNamesFromApp.iterator();
            while (iterator.hasNext()) {
                ArrayList arrayList2 = (ArrayList)iterator.next();
                ArrayList arrayList3 = new ArrayList(2);
                arrayList3.add(arrayList2.get(0));
                if (arrayList2.get(1) instanceof byte[]) {
                    arrayList3.add(((byte[])arrayList2.get(1)).clone());
                } else {
                    arrayList3.add(arrayList2.get(1));
                }
                arrayList.add(arrayList3);
            }
            return arrayList;
        }
        return null;
    }

    public byte[] getNameConstraints() {
        return this.baNameConstraints != null ? (byte[])this.baNameConstraints.clone() : null;
    }

    public int getBasicConstraints() {
        return this.basicConstraints;
    }

    public Set getPolicy() {
        if (this.policy != null) {
            HashSet hashSet = new HashSet();
            Iterator iterator = this.policy.iterator();
            while (iterator.hasNext()) {
                String string = ((ObjectIdentifier)iterator.next()).toString();
                hashSet.add(string);
            }
            return Collections.unmodifiableSet(hashSet);
        }
        return null;
    }

    public Collection getPathToNames() {
        if (this.pathToNamesFromApp != null) {
            ArrayList arrayList = new ArrayList();
            Iterator iterator = this.pathToNamesFromApp.iterator();
            while (iterator.hasNext()) {
                ArrayList arrayList2 = (ArrayList)iterator.next();
                ArrayList arrayList3 = new ArrayList(2);
                arrayList3.add(arrayList2.get(0));
                if (arrayList2.get(1) instanceof byte[]) {
                    arrayList3.add(((byte[])arrayList2.get(1)).clone());
                } else {
                    arrayList3.add(arrayList2.get(1));
                }
                arrayList.add(arrayList3);
            }
            return arrayList;
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("X509CertSelector: [");
        stringBuffer.append("\n    AuthorityKeyIdentifier:");
        this.dumpBA(this.getAuthorityKeyIdentifier(), stringBuffer);
        stringBuffer.append("\n    BasicConstraints:");
        stringBuffer.append(this.getBasicConstraints());
        stringBuffer.append("\n    CertificateEquals:");
        stringBuffer.append(this.getCertificate());
        stringBuffer.append("\n    CertificateValid:");
        stringBuffer.append(this.getCertificateValid());
        stringBuffer.append("\n    ExtendedKeyUsage:");
        stringBuffer.append(this.getExtendedKeyUsage());
        stringBuffer.append("\n    IssuerAsString:");
        stringBuffer.append(this.getIssuerAsString());
        stringBuffer.append("\n    KeyUsage:");
        boolean[] blArray = this.getKeyUsage();
        if (blArray == null || blArray.length == 0) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append(blArray[0]);
            int n = 1;
            while (n < blArray.length) {
                stringBuffer.append(", ");
                stringBuffer.append(blArray[n]);
                ++n;
            }
        }
        stringBuffer.append("\n    MatchAllSubjectAltNames:");
        stringBuffer.append(this.getMatchAllSubjectAltNames());
        stringBuffer.append("\n    NameConstraints:");
        this.dumpBA(this.getNameConstraints(), stringBuffer);
        stringBuffer.append("\n    PathToNames:");
        stringBuffer.append(this.getPathToNames());
        stringBuffer.append("\n    Policy:");
        stringBuffer.append(this.getPolicy());
        stringBuffer.append("\n    PrivateKeyValid:");
        stringBuffer.append(this.getPrivateKeyValid());
        stringBuffer.append("\n    SerialNumber:");
        stringBuffer.append(this.getSerialNumber());
        stringBuffer.append("\n    SubjectAlternativeNames:");
        stringBuffer.append(this.getSubjectAlternativeNames());
        stringBuffer.append("\n    SubjectAsString:");
        stringBuffer.append(this.getSubjectAsString());
        stringBuffer.append("\n    SubjectKeyIdentifier:");
        this.dumpBA(this.getSubjectKeyIdentifier(), stringBuffer);
        stringBuffer.append("\n    SubjectPublicKey:");
        stringBuffer.append(this.getSubjectPublicKey());
        stringBuffer.append("\n    SubjectPublicKeyAlgID:");
        stringBuffer.append(this.getSubjectPublicKeyAlgID());
        stringBuffer.append("\n]");
        return stringBuffer.toString();
    }

    private void dumpBA(byte[] byArray, StringBuffer stringBuffer) {
        if (byArray == null) {
            stringBuffer.append("null");
        } else {
            HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
            stringBuffer.append("\n");
            stringBuffer.append(hexDumpEncoder.encodeBuffer(byArray));
        }
    }

    public boolean match(Certificate certificate) {
        Iterator iterator;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        X509CertImpl x509CertImpl;
        if (certificate == null) {
            return false;
        }
        if (!(certificate instanceof X509Certificate)) {
            if (debug != null) {
                System.out.println("X509CertSelector.match not X509Certificate");
            }
            return false;
        }
        if (certificate instanceof X509CertImpl) {
            x509CertImpl = (X509CertImpl)certificate;
        } else {
            try {
                x509CertImpl = new X509CertImpl(((X509Certificate)certificate).getEncoded());
            }
            catch (CertificateException certificateException) {
                if (debug != null) {
                    System.out.println("X509CertSelector.match exception");
                    certificateException.printStackTrace();
                }
                return false;
            }
        }
        if (debug != null) {
            System.out.println("X509CertSelector.match(SN: " + x509CertImpl.getSerialNumber().toString(16) + "\n  Issuer: " + x509CertImpl.getIssuerDN() + "\n  Subject: " + x509CertImpl.getSubjectDN() + ")");
        }
        if (this.certificate != null && !this.certificate.equals(certificate)) {
            if (debug != null) {
                System.out.println("X509CertSelector.match: certs don't match");
            }
            return false;
        }
        if (this.serialNumber != null && this.serialNumber.compareTo(x509CertImpl.getSerialNumber()) != 0) {
            if (debug != null) {
                System.out.println("X509CertSelector.match: serial numbers don't match");
            }
            return false;
        }
        if (this.issuer != null && !this.issuer.equals((Object)x509CertImpl.getIssuerDN())) {
            if (debug != null) {
                System.out.println("X509CertSelector.match: issuer DNs don't match");
            }
            if (this.issuerAsString) {
                if (!this.issuer.getRFC2253Name().equalsIgnoreCase(((X500Name)x509CertImpl.getIssuerDN()).getRFC2253Name())) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (this.subject != null && !this.subject.equals((Object)x509CertImpl.getSubjectDN())) {
            if (debug != null) {
                System.out.println("X509CertSelector.match: subject DNs don't match");
            }
            if (this.subjectAsString) {
                if (!this.subject.getRFC2253Name().equalsIgnoreCase(((X500Name)x509CertImpl.getSubjectDN()).getRFC2253Name())) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (this.subjectKeyIdentifier != null) {
            try {
                object4 = (SubjectKeyIdentifierExtension)x509CertImpl.get("x509.info.extensions.SubjectKeyIdentifier");
                object3 = (KeyIdentifier)object4.get("key_id");
                object2 = new DerOutputStream();
                object3.encode(object2);
                object = object2.toByteArray();
                if (!Arrays.equals(this.subjectKeyIdentifier, (byte[])object)) {
                    if (debug != null) {
                        System.out.println("X509CertSelector.match: subject key IDs don't match");
                    }
                    return false;
                }
            }
            catch (IOException iOException) {
                if (debug != null) {
                    System.out.println("X509CertSelector.match: exception in subject key ID check");
                }
                return false;
            }
            catch (NullPointerException nullPointerException) {
                if (debug != null) {
                    System.out.println("X509CertSelector.match: no subject key ID extension");
                }
                return false;
            }
            catch (CertificateParsingException certificateParsingException) {
                if (debug != null) {
                    System.out.println("X509CertSelector.match: subjectKeyIdentifier extension parsing exception");
                }
                return false;
            }
        }
        if (this.authorityKeyIdentifier != null) {
            try {
                object4 = (AuthorityKeyIdentifierExtension)x509CertImpl.get("x509.info.extensions.AuthorityKeyIdentifier");
                object3 = (KeyIdentifier)object4.get("key_id");
                object2 = object3.getIdentifier();
                if (!Arrays.equals(this.authorityKeyIdentifier, (byte[])object2)) {
                    if (debug != null) {
                        System.out.println("X509CertSelector.match: authority key IDs don't match");
                    }
                    return false;
                }
            }
            catch (IOException iOException) {
                if (debug != null) {
                    System.out.println("X509CertSelector.match: exception in authority key ID check");
                }
                return false;
            }
            catch (NullPointerException nullPointerException) {
                if (debug != null) {
                    System.out.println("X509CertSelector.match: no authority key ID extension");
                }
                return false;
            }
            catch (CertificateParsingException certificateParsingException) {
                if (debug != null) {
                    System.out.println("X509CertSelector.match: authorityKeyIdentifier extension parsing exception");
                }
                return false;
            }
        }
        if (this.certificateValid != null && (this.certificateValid.before(x509CertImpl.getNotBefore()) || this.certificateValid.after(x509CertImpl.getNotAfter()))) {
            if (debug != null) {
                System.out.println("X509CertSelector.match: certificate not within validity date");
            }
            return false;
        }
        if (this.privateKeyValid != null) {
            try {
                object2 = (PrivateKeyUsageExtension)x509CertImpl.get("x509.info.extensions.PrivateKeyUsage");
                try {
                    object4 = (Date)object2.get("not_before");
                }
                catch (CertificateException certificateException) {
                    object4 = null;
                }
                catch (NullPointerException nullPointerException) {
                    object4 = null;
                }
                try {
                    object3 = (Date)object2.get("not_after");
                }
                catch (CertificateException certificateException) {
                    object3 = null;
                }
                catch (NullPointerException nullPointerException) {
                    object3 = null;
                }
                if (object4 == null && object3 == null || object4 == null && this.privateKeyValid.before((Date)object4) || object3 == null && this.privateKeyValid.after((Date)object3)) {
                    if (debug != null) {
                        System.out.println("X509CertSelector.match: private key usage not within validity date");
                    }
                    return false;
                }
            }
            catch (NullPointerException nullPointerException) {
                if (debug != null) {
                    System.out.println("X509CertSelector.match: NullPointerException in private key usage check; X509CertSelector: ");
                    nullPointerException.printStackTrace();
                }
                return false;
            }
            catch (CertificateParsingException certificateParsingException) {
                if (debug != null) {
                    System.out.println("X509CertSelector.match: CertificateParsingException in private key usage check; X509CertSelector: ");
                    certificateParsingException.printStackTrace();
                }
                return false;
            }
        }
        if (this.subjectPublicKeyAlgID != null && !this.subjectPublicKeyAlgID.equals(((X509Key)x509CertImpl.getPublicKey()).getAlgorithmId())) {
            if (debug != null) {
                System.out.println("X509CertSelector.match: subjectPublicKey algorithm IDs do not match ");
            }
            return false;
        }
        if (this.subjectPublicKey != null && !Arrays.equals(this.subjectPublicKey.getEncoded(), x509CertImpl.getPublicKey().getEncoded())) {
            if (debug != null) {
                System.out.println("X509CertSelector.match: subjectPublicKeys do not match ");
            }
            return false;
        }
        if (this.keyUsage != null && (object4 = (Object)x509CertImpl.getKeyUsage()) != null) {
            int n = 0;
            while (n < this.keyUsage.length) {
                if (this.keyUsage[n] && (n >= ((SubjectKeyIdentifierExtension)object4).length || object4[n] == false)) {
                    if (debug != null) {
                        System.out.println("X509CertSelector.match: key usage bits don't match");
                    }
                    return false;
                }
                ++n;
            }
        }
        if (this.keyPurposeSet != null && !this.keyPurposeSet.isEmpty()) {
            try {
                object4 = (ExtKeyUsageExtension)x509CertImpl.get("x509.info.extensions.ExtKeyUsage");
                Vector vector = (Vector)object4.get("extkeyusage");
                boolean bl = true;
                object = this.keyPurposeSet.iterator();
                while (object.hasNext()) {
                    iterator = new ObjectIdentifier((String)object.next());
                    if (vector.contains(iterator)) continue;
                    if (debug != null) {
                        System.out.println("X509CertSelector.match: key purpose sets do not match");
                    }
                    bl = false;
                    return bl;
                }
            }
            catch (IOException iOException) {
                if (debug != null) {
                    System.out.println("X509CertSelector.match: failed on matching key purpose set");
                    iOException.printStackTrace();
                }
                return false;
            }
            catch (NullPointerException nullPointerException) {
                if (debug != null) {
                    System.out.println("X509CertSelector.match: failed on matching key purpose set");
                    nullPointerException.printStackTrace();
                }
                return false;
            }
            catch (CertificateParsingException certificateParsingException) {
                if (debug != null) {
                    System.out.println("X509CertSeledctor.match:");
                    certificateParsingException.printStackTrace();
                }
                return false;
            }
        }
        if (this.subjectAlternativeNames != null || this.nameConstraints != null) {
            List list;
            Object object5;
            object4 = null;
            ArrayList arrayList = new ArrayList();
            try {
                SubjectAlternativeNameExtension subjectAlternativeNameExtension = (SubjectAlternativeNameExtension)x509CertImpl.get("x509.info.extensions.SubjectAlternativeName");
                object4 = (GeneralNames)subjectAlternativeNameExtension.get("subject_name");
            }
            catch (IOException iOException) {
                object4 = null;
            }
            catch (NullPointerException nullPointerException) {
                object4 = null;
            }
            catch (CertificateParsingException certificateParsingException) {
                object4 = null;
            }
            if (this.subjectAlternativeNames != null) {
                if (object4 == null) {
                    if (debug != null) {
                        System.out.println("X509CertSelector.match: none of subject alternative names match");
                    }
                    return false;
                }
                try {
                    Object object6;
                    Object object7;
                    iterator = object4.iterator();
                    while (iterator.hasNext()) {
                        object = (GeneralName)iterator.next();
                        try {
                            List list2 = this.processGeneralName((GeneralName)object);
                            arrayList.add(list2);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    boolean bl = false;
                    if (this.getMatchAllSubjectAltNames()) {
                        object5 = this.subjectAlternativeNames.iterator();
                        while (object5.hasNext()) {
                            list = (List)object5.next();
                            iterator = arrayList.iterator();
                            bl = false;
                            while (iterator.hasNext()) {
                                List list3 = (List)iterator.next();
                                if (!list3.get(0).equals(list.get(0))) continue;
                                object7 = list3.get(1);
                                object6 = list.get(1);
                                if (object7 instanceof byte[] && object6 instanceof byte[]) {
                                    if (!Arrays.equals((byte[])object7, (byte[])object6)) continue;
                                    bl = true;
                                    break;
                                }
                                if (!object7.equals(object6)) continue;
                                bl = true;
                                break;
                            }
                            if (bl) continue;
                            if (debug != null) {
                                System.out.println("X509CertSelector.match: at least one subject alternative name does not match");
                            }
                            return false;
                        }
                    } else {
                        object5 = this.subjectAlternativeNames.iterator();
                        while (object5.hasNext()) {
                            list = (List)object5.next();
                            iterator = arrayList.iterator();
                            bl = false;
                            while (iterator.hasNext()) {
                                List list4 = (List)iterator.next();
                                if (!list4.get(0).equals(list.get(0))) continue;
                                object7 = list4.get(1);
                                object6 = list.get(1);
                                if (object7 instanceof byte[] && object6 instanceof byte[]) {
                                    if (!Arrays.equals((byte[])object7, (byte[])object6)) continue;
                                    bl = true;
                                    break;
                                }
                                if (!object7.equals(object6)) continue;
                                bl = true;
                                break;
                            }
                            if (bl) break;
                        }
                        if (!bl) {
                            if (debug != null) {
                                System.out.println("X509CertSelector.match: no matched subject alternative name found");
                            }
                            return false;
                        }
                    }
                }
                catch (NullPointerException nullPointerException) {
                    if (debug != null) {
                        System.out.println("X509CertSelector.match: failed on checking subject alternative name");
                        nullPointerException.printStackTrace();
                    }
                    return false;
                }
            }
            if (this.nameConstraints != null && !x509CertImpl.getIssuerDN().equals(x509CertImpl.getSubjectDN())) {
                iterator = (X500Name)x509CertImpl.getSubjectDN();
                ArrayList arrayList2 = new ArrayList();
                object = new ArrayList();
                object.add(new Integer(4));
                object.add(iterator);
                arrayList2.add(object);
                if (!this.namesMatchConstraints(arrayList2, this.nameConstraints[0], this.nameConstraints[1])) {
                    if (debug != null) {
                        System.out.println("X509CertSelector.match: subject name does not match name constraints");
                    }
                    return false;
                }
                try {
                    object5 = iterator.getEmail();
                    if (object5 != null) {
                        list = new DerValue((String)object5);
                        list.resetTag((byte)22);
                        String string = list.getIA5String().toLowerCase();
                        object = this.processGeneralName(1, string);
                        arrayList2.clear();
                        arrayList2.add(object);
                        if (!this.namesMatchConstraints(arrayList2, this.nameConstraints[0], this.nameConstraints[1])) {
                            if (debug != null) {
                                System.out.println("X509CertSelector.match: name constraints do not match");
                            }
                            return false;
                        }
                    }
                }
                catch (IOException iOException) {
                    if (debug != null) {
                        System.out.println("X509CertSelector.match: exception on checking name constraints");
                        iOException.printStackTrace();
                    }
                    return false;
                }
                if (arrayList != null && !this.namesMatchConstraints(arrayList, this.nameConstraints[0], this.nameConstraints[1])) {
                    if (debug != null) {
                        System.out.println("X509CertSelector.match: name constraints do not match");
                    }
                    return false;
                }
            }
        }
        if (this.basicConstraints >= 0 && this.basicConstraints > x509CertImpl.getBasicConstraints()) {
            if (debug != null) {
                System.out.println("X509CertSelector.match: failed to verify basic constraints");
            }
            return false;
        }
        if (this.basicConstraints == -2 && x509CertImpl.getIssuerDN().equals(x509CertImpl.getSubjectDN())) {
            if (debug != null) {
                System.out.println("X509CertSelector.match: not an EE cert");
            }
            return false;
        }
        if (this.policy != null) {
            try {
                object4 = (CertificatePoliciesExtension)x509CertImpl.get("x509.info.extensions.CertificatePolicies");
                Vector vector = (Vector)object4.get("cert_policies");
                if (!this.policy.isEmpty() || vector.isEmpty()) {
                    boolean bl = false;
                    int n = 0;
                    while (n < vector.size()) {
                        ObjectIdentifier objectIdentifier = ((PolicyInformation)vector.get(n)).getPolicyIdentifier();
                        if (this.policy.contains(objectIdentifier)) {
                            bl = true;
                            break;
                        }
                        ++n;
                    }
                    if (!bl) {
                        if (debug != null) {
                            System.out.println("X509CertSelector.match: failed on policy criterion");
                        }
                        return false;
                    }
                }
            }
            catch (IOException iOException) {
                if (debug != null) {
                    System.out.println("X509CertSelector.match: exception when checking cert policies");
                    iOException.printStackTrace();
                }
                return false;
            }
            catch (NullPointerException nullPointerException) {
                if (debug != null) {
                    System.out.println("X509CertSelector.match: exception when checking cert policies");
                    nullPointerException.printStackTrace();
                }
                return false;
            }
            catch (CertificateParsingException certificateParsingException) {
                if (debug != null) {
                    System.out.println("X509CertSelector.match:");
                    certificateParsingException.printStackTrace();
                }
                return false;
            }
        }
        if (this.pathToNames != null) {
            object4 = null;
            try {
                object4 = (NameConstraintsExtension)x509CertImpl.get("x509.info.extensions.NameConstraints");
            }
            catch (CertificateParsingException certificateParsingException) {
                object4 = null;
            }
            if (object4 != null) {
                try {
                    GeneralSubtrees generalSubtrees = (GeneralSubtrees)object4.get("permitted_subtrees");
                    GeneralSubtrees generalSubtrees2 = (GeneralSubtrees)object4.get("excluded_subtrees");
                    if (!this.namesMatchConstraints(this.pathToNames, generalSubtrees, generalSubtrees2)) {
                        if (debug != null) {
                            System.out.println("X509CertSelector.match: failed on pathToNames criterion");
                        }
                        return false;
                    }
                }
                catch (IOException iOException) {
                    if (debug != null) {
                        System.out.println("X509CertSelector.match: exception when checking pathToNames");
                        iOException.printStackTrace();
                    }
                    return false;
                }
                catch (NullPointerException nullPointerException) {
                    if (debug != null) {
                        System.out.println("X509CertSelector.match: exception when checking pathToNames");
                        nullPointerException.printStackTrace();
                    }
                    return false;
                }
            }
        }
        if (debug != null) {
            System.out.println("X509CertSelector.match: returning true");
        }
        return true;
    }

    private boolean namesMatchConstraints(Collection collection, GeneralSubtrees generalSubtrees, GeneralSubtrees generalSubtrees2) {
        if (generalSubtrees == null && generalSubtrees2 == null) {
            return false;
        }
        Vector vector = generalSubtrees != null ? generalSubtrees.getSubtrees() : null;
        Vector vector2 = generalSubtrees2 != null ? generalSubtrees2.getSubtrees() : null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            GeneralName generalName;
            int n;
            List list;
            Object object = iterator.next();
            if (object instanceof GeneralName) {
                try {
                    list = this.processGeneralName((GeneralName)object);
                }
                catch (IOException iOException) {
                    return false;
                }
            } else {
                list = (List)object;
            }
            if (vector2 != null) {
                n = 0;
                while (n < vector2.size()) {
                    generalName = ((GeneralSubtree)vector2.get(n)).getBase();
                    if (((Integer)list.get(0)).intValue() == generalName.getType() && list.get(1).toString().equals(generalName.toString())) {
                        return false;
                    }
                    ++n;
                }
            }
            if (vector == null) continue;
            boolean bl = false;
            n = 0;
            while (n < vector.size()) {
                generalName = ((GeneralSubtree)vector.get(n)).getBase();
                if (((Integer)list.get(0)).intValue() == generalName.getType() && list.get(1).toString().equals(generalName.toString())) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    private boolean nameMatchesConstraint(List list, List list2) {
        int n;
        int n2 = (Integer)list.get(0);
        if (n2 != (n = ((Integer)list2.get(0)).intValue())) {
            return false;
        }
        switch (n2) {
            case 0: 
            case 3: 
            case 5: 
            case 8: {
                String string = (String)list.get(1);
                String string2 = (String)list2.get(1);
                return string.equals(string2);
            }
            case 1: {
                String string = (String)list.get(1);
                String string3 = (String)list2.get(1);
                return string.equals(string3) || string.endsWith("@" + string3) || string3.startsWith(".") && string.endsWith(string3);
            }
            case 2: {
                String string = (String)list.get(1);
                String string4 = (String)list2.get(1);
                return string.equals(string4) || string.endsWith(string4);
            }
            case 4: {
                X500Name x500Name = (X500Name)list.get(1);
                X500Name x500Name2 = (X500Name)list2.get(1);
                if (x500Name2.size() > x500Name.size()) {
                    return false;
                }
                boolean bl = true;
                int n3 = 0;
                while (n3 < x500Name2.size()) {
                    if (!x500Name2.getRDN(n3).equals((Object)x500Name.getRDN(n3))) {
                        bl = false;
                        break;
                    }
                    ++n3;
                }
                return bl;
            }
            case 6: {
                String string = (String)list.get(1);
                String string5 = (String)list2.get(1);
                try {
                    string = new URL(string).getHost().toLowerCase();
                    string5 = new URL(string5).getHost().toLowerCase();
                }
                catch (MalformedURLException malformedURLException) {
                    return false;
                }
                return string.equals(string5) || string.endsWith("." + string5);
            }
            case 7: {
                String string = (String)list.get(1);
                String string6 = (String)list2.get(1);
                return string.equals(string6);
            }
        }
        return false;
    }

    private List processGeneralName(GeneralName generalName) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        generalName.encode(derOutputStream);
        byte[] byArray = derOutputStream.toByteArray();
        DerInputStream derInputStream = new DerInputStream(byArray);
        DerValue derValue = derInputStream.getDerValue();
        byte[] byArray2 = derValue.getData().toByteArray();
        return this.processGeneralName(generalName.getType(), byArray2);
    }

    private List processGeneralName(int n, String string) throws IOException {
        ArrayList arrayList = new ArrayList(2);
        arrayList.add(0, new Integer(n));
        switch (n) {
            case 8: {
                try {
                    arrayList.add(1, new OIDName(new ObjectIdentifier(string)));
                    break;
                }
                catch (Exception exception) {
                    throw new IOException("unable to parse name");
                }
            }
            case 1: {
                arrayList.add(1, new RFC822Name(string));
                break;
            }
            case 7: {
                arrayList.add(1, new IPAddressName(string));
                break;
            }
            case 2: {
                arrayList.add(1, new DNSName(string));
                break;
            }
            case 6: {
                arrayList.add(1, new URIName(string));
                break;
            }
            case 4: {
                arrayList.add(1, new X500Name(string));
                break;
            }
            default: {
                throw new IOException("unable to parse String of name type " + n);
            }
        }
        return arrayList;
    }

    private List processGeneralName(int n, byte[] byArray) throws IOException {
        ArrayList arrayList = new ArrayList(2);
        arrayList.add(0, new Integer(n));
        switch (n) {
            case 0: {
                arrayList.add(1, new OtherName(new DerValue(byArray)));
                break;
            }
            case 5: {
                arrayList.add(1, new EDIPartyName(new DerValue(byArray)));
                break;
            }
            case 8: {
                arrayList.add(1, new OIDName(new DerValue(byArray)));
                break;
            }
            case 1: {
                arrayList.add(1, new RFC822Name(new DerValue(byArray)));
                break;
            }
            case 2: {
                arrayList.add(1, new DNSName(new DerValue(byArray)));
                break;
            }
            case 6: {
                arrayList.add(1, new URIName(new DerValue(byArray)));
                break;
            }
            case 4: {
                arrayList.add(1, new X500Name(new DerValue(byArray)));
                break;
            }
            case 7: {
                arrayList.add(1, new IPAddressName(new DerValue(byArray)));
                break;
            }
            case 3: {
                arrayList.add(1, new X400Address(new DerValue(byArray)));
                break;
            }
            default: {
                throw new IOException("unable to parse byte array of name type " + n);
            }
        }
        return arrayList;
    }

    public Object clone() {
        try {
            Object object = super.clone();
            if (this.subjectAlternativeNames != null) {
                this.subjectAlternativeNames = new ArrayList(this.subjectAlternativeNames);
                this.subjectAlternativeNamesFromApp = new ArrayList(this.subjectAlternativeNamesFromApp);
            }
            if (this.pathToNames != null) {
                this.pathToNames = new ArrayList(this.pathToNames);
                this.pathToNamesFromApp = new ArrayList(this.pathToNamesFromApp);
            }
            return object;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    static {
        if (!CertPathHelperInitializer.isInitialized()) {
            CertPathHelperInitializer.init();
        }
    }
}

