/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class LinkedHashMap
extends HashMap {
    private transient Entry header;
    private final boolean accessOrder;

    public LinkedHashMap(int n, float f) {
        super(n, f);
        this.accessOrder = false;
    }

    public LinkedHashMap(int n) {
        super(n);
        this.accessOrder = false;
    }

    public LinkedHashMap() {
        this.accessOrder = false;
    }

    public LinkedHashMap(Map map) {
        super(map);
        this.accessOrder = false;
    }

    public LinkedHashMap(int n, float f, boolean bl) {
        super(n, f);
        this.accessOrder = bl;
    }

    void init() {
        this.header.before = this.header.after = (this.header = new Entry(-1, null, null, null));
    }

    void transfer(HashMap.Entry[] entryArray) {
        int n = entryArray.length;
        Entry entry = this.header.after;
        while (entry != this.header) {
            int n2 = LinkedHashMap.indexFor(entry.hash, n);
            entry.next = entryArray[n2];
            entryArray[n2] = entry;
            entry = entry.after;
        }
        this.table = entryArray;
    }

    public boolean containsValue(Object object) {
        if (object == null) {
            Entry entry = this.header.after;
            while (entry != this.header) {
                if (entry.value == null) {
                    return true;
                }
                entry = entry.after;
            }
        } else {
            Entry entry = this.header.after;
            while (entry != this.header) {
                if (object.equals(entry.value)) {
                    return true;
                }
                entry = entry.after;
            }
        }
        return false;
    }

    public Object get(Object object) {
        Entry entry = (Entry)this.getEntry(object);
        if (entry == null) {
            return null;
        }
        entry.recordAccess(this);
        return entry.value;
    }

    public void clear() {
        super.clear();
        this.header.before = this.header.after = this.header;
    }

    Iterator newKeyIterator() {
        return new KeyIterator();
    }

    Iterator newValueIterator() {
        return new ValueIterator();
    }

    Iterator newEntryIterator() {
        return new EntryIterator();
    }

    void addEntry(int n, Object object, Object object2, int n2) {
        this.createEntry(n, object, object2, n2);
        Entry entry = this.header.after;
        if (this.removeEldestEntry(entry)) {
            this.removeEntryForKey(entry.key);
        } else if (this.size >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    void createEntry(int n, Object object, Object object2, int n2) {
        Entry entry = new Entry(n, object, object2, this.table[n2]);
        this.table[n2] = entry;
        entry.addBefore(this.header);
        ++this.size;
    }

    protected boolean removeEldestEntry(Map.Entry entry) {
        return false;
    }

    private class EntryIterator
    extends LinkedHashIterator {
        private EntryIterator() {
        }

        public Object next() {
            return this.nextEntry();
        }
    }

    private class ValueIterator
    extends LinkedHashIterator {
        private ValueIterator() {
        }

        public Object next() {
            return this.nextEntry().value;
        }
    }

    private class KeyIterator
    extends LinkedHashIterator {
        private KeyIterator() {
        }

        public Object next() {
            return this.nextEntry().getKey();
        }
    }

    private abstract class LinkedHashIterator
    implements Iterator {
        Entry nextEntry;
        Entry lastReturned;
        int expectedModCount;

        private LinkedHashIterator() {
            this.nextEntry = ((LinkedHashMap)LinkedHashMap.this).header.after;
            this.lastReturned = null;
            this.expectedModCount = LinkedHashMap.this.modCount;
        }

        public boolean hasNext() {
            return this.nextEntry != LinkedHashMap.this.header;
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (LinkedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            LinkedHashMap.this.remove(this.lastReturned.key);
            this.lastReturned = null;
            this.expectedModCount = LinkedHashMap.this.modCount;
        }

        Entry nextEntry() {
            if (LinkedHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.nextEntry == LinkedHashMap.this.header) {
                throw new NoSuchElementException();
            }
            Entry entry = this.lastReturned = this.nextEntry;
            this.nextEntry = entry.after;
            return entry;
        }
    }

    private static class Entry
    extends HashMap.Entry {
        Entry before;
        Entry after;

        Entry(int n, Object object, Object object2, HashMap.Entry entry) {
            super(n, object, object2, entry);
        }

        private void remove() {
            this.before.after = this.after;
            this.after.before = this.before;
        }

        private void addBefore(Entry entry) {
            this.after = entry;
            this.before = entry.before;
            this.before.after = this;
            this.after.before = this;
        }

        void recordAccess(HashMap hashMap) {
            LinkedHashMap linkedHashMap = (LinkedHashMap)hashMap;
            if (linkedHashMap.accessOrder) {
                ++linkedHashMap.modCount;
                this.remove();
                this.addBefore(linkedHashMap.header);
            }
        }

        void recordRemoval(HashMap hashMap) {
            this.remove();
        }
    }
}

