/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class StringTokenizer
implements Enumeration {
    private int currentPosition = 0;
    private int newPosition = -1;
    private int maxPosition;
    private String str;
    private String delimiters;
    private boolean retDelims;
    private boolean delimsChanged = false;
    private char maxDelimChar;

    private void setMaxDelimChar() {
        if (this.delimiters == null) {
            this.maxDelimChar = '\u0000';
            return;
        }
        char c = '\u0000';
        for (int i = 0; i < this.delimiters.length(); ++i) {
            char c2 = this.delimiters.charAt(i);
            if (c >= c2) continue;
            c = c2;
        }
        this.maxDelimChar = c;
    }

    public StringTokenizer(String string, String string2, boolean bl) {
        this.str = string;
        this.maxPosition = string.length();
        this.delimiters = string2;
        this.retDelims = bl;
        this.setMaxDelimChar();
    }

    public StringTokenizer(String string, String string2) {
        this(string, string2, false);
    }

    public StringTokenizer(String string) {
        this(string, " \t\n\r\f", false);
    }

    private int skipDelimiters(int n) {
        char c;
        int n2;
        if (this.delimiters == null) {
            throw new NullPointerException();
        }
        for (n2 = n; !this.retDelims && n2 < this.maxPosition && (c = this.str.charAt(n2)) <= this.maxDelimChar && this.delimiters.indexOf(c) >= 0; ++n2) {
        }
        return n2;
    }

    private int scanToken(int n) {
        char c;
        int n2;
        for (n2 = n; n2 < this.maxPosition && ((c = this.str.charAt(n2)) > this.maxDelimChar || this.delimiters.indexOf(c) < 0); ++n2) {
        }
        if (this.retDelims && n == n2 && (c = this.str.charAt(n2)) <= this.maxDelimChar && this.delimiters.indexOf(c) >= 0) {
            ++n2;
        }
        return n2;
    }

    public boolean hasMoreTokens() {
        this.newPosition = this.skipDelimiters(this.currentPosition);
        return this.newPosition < this.maxPosition;
    }

    public String nextToken() {
        this.currentPosition = this.newPosition >= 0 && !this.delimsChanged ? this.newPosition : this.skipDelimiters(this.currentPosition);
        this.delimsChanged = false;
        this.newPosition = -1;
        if (this.currentPosition >= this.maxPosition || this.str == null) {
            throw new NoSuchElementException();
        }
        int n = this.currentPosition;
        this.currentPosition = this.scanToken(this.currentPosition);
        if (this.currentPosition >= this.maxPosition) {
            String string = this.str.substring(n, this.currentPosition);
            this.str = null;
            return string;
        }
        return this.str.substring(n, this.currentPosition);
    }

    public String nextToken(String string) {
        this.delimiters = string;
        this.delimsChanged = true;
        this.setMaxDelimChar();
        return this.nextToken();
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public Object nextElement() {
        return this.nextToken();
    }

    public int countTokens() {
        int n = 0;
        int n2 = this.currentPosition;
        while (n2 < this.maxPosition && (n2 = this.skipDelimiters(n2)) < this.maxPosition) {
            n2 = this.scanToken(n2);
            ++n;
        }
        return n;
    }
}

