/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import sun.nio.ch.DirectBuffer;
import sun.nio.ch.IOVecWrapper;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.Util;

class IOUtil {
    static final /* synthetic */ boolean $assertionsDisabled;

    private IOUtil() {
    }

    private static int remaining(ByteBuffer[] byteBufferArray) {
        int n = byteBufferArray.length;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            if (!byteBufferArray[i].hasRemaining()) continue;
            return i;
        }
        return -1;
    }

    private static ByteBuffer[] skipBufs(ByteBuffer[] byteBufferArray, int n) {
        int n2 = byteBufferArray.length - n;
        ByteBuffer[] byteBufferArray2 = new ByteBuffer[n2];
        for (int i = 0; i < n2; ++i) {
            byteBufferArray2[i] = byteBufferArray[i + n];
        }
        return byteBufferArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int write(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, long l, NativeDispatcher nativeDispatcher, Object object) throws IOException {
        if (byteBuffer instanceof DirectBuffer) {
            return IOUtil.writeFromNativeBuffer(fileDescriptor, byteBuffer, l, nativeDispatcher, object);
        }
        int n = byteBuffer.position();
        int n2 = byteBuffer.limit();
        if (!$assertionsDisabled && n > n2) {
            throw new AssertionError();
        }
        int n3 = n <= n2 ? n2 - n : 0;
        ByteBuffer byteBuffer2 = null;
        try {
            byteBuffer2 = Util.getTemporaryDirectBuffer(n3);
            byteBuffer2.put(byteBuffer);
            byteBuffer2.flip();
            byteBuffer.position(n);
            int n4 = IOUtil.writeFromNativeBuffer(fileDescriptor, byteBuffer2, l, nativeDispatcher, object);
            if (n4 > 0) {
                byteBuffer.position(n + n4);
            }
            int n5 = n4;
            return n5;
        }
        finally {
            Util.releaseTemporaryDirectBuffer(byteBuffer2);
        }
    }

    private static int writeFromNativeBuffer(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, long l, NativeDispatcher nativeDispatcher, Object object) throws IOException {
        int n = byteBuffer.position();
        int n2 = byteBuffer.limit();
        if (!$assertionsDisabled && n > n2) {
            throw new AssertionError();
        }
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = 0;
        if (n3 == 0) {
            return 0;
        }
        n4 = l != -1L ? nativeDispatcher.pwrite(fileDescriptor, ((DirectBuffer)((Object)byteBuffer)).address() + (long)n, n3, l, object) : nativeDispatcher.write(fileDescriptor, ((DirectBuffer)((Object)byteBuffer)).address() + (long)n, n3);
        if (n4 > 0) {
            byteBuffer.position(n + n4);
        }
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long write(FileDescriptor fileDescriptor, ByteBuffer[] byteBufferArray, NativeDispatcher nativeDispatcher) throws IOException {
        ByteBuffer byteBuffer;
        int n;
        int n2 = IOUtil.remaining(byteBufferArray);
        if (n2 < 0) {
            return 0L;
        }
        if (n2 > 0) {
            byteBufferArray = IOUtil.skipBufs(byteBufferArray, n2);
        }
        int n3 = byteBufferArray.length;
        int n4 = 0;
        ByteBuffer[] byteBufferArray2 = new ByteBuffer[n3];
        for (int i = 0; i < n3; ++i) {
            if (!(byteBufferArray[i] instanceof DirectBuffer)) {
                int n5 = byteBufferArray[i].position();
                int n6 = byteBufferArray[i].limit();
                if (!$assertionsDisabled && n5 > n6) {
                    throw new AssertionError();
                }
                n = n5 <= n6 ? n6 - n5 : 0;
                byteBufferArray2[i] = byteBuffer = ByteBuffer.allocateDirect(n);
                byteBuffer.put(byteBufferArray[i]);
                byteBufferArray[i].position(n5);
                byteBuffer.flip();
                continue;
            }
            byteBufferArray2[i] = byteBufferArray[i];
        }
        IOVecWrapper iOVecWrapper = null;
        long l = 0L;
        try {
            iOVecWrapper = new IOVecWrapper(n3);
            for (n = 0; n < n3; ++n) {
                byteBuffer = byteBufferArray2[n];
                long l2 = byteBuffer.position();
                long l3 = (long)byteBuffer.limit() - l2;
                n4 = (int)((long)n4 + l3);
                iOVecWrapper.putBase(n, ((DirectBuffer)((Object)byteBuffer)).address() + l2);
                iOVecWrapper.putLen(n, l3);
            }
            l = nativeDispatcher.writev(fileDescriptor, iOVecWrapper.address, n3);
        }
        finally {
            iOVecWrapper.free();
        }
        long l4 = l;
        for (int i = 0; i < n3; ++i) {
            int n7;
            int n8;
            ByteBuffer byteBuffer2 = byteBufferArray[i];
            int n9 = byteBuffer2.position();
            int n10 = byteBuffer2.limit();
            if (!$assertionsDisabled && n9 > n10) {
                throw new AssertionError();
            }
            int n11 = n8 = n9 <= n10 ? n10 - n9 : n10;
            if (l >= (long)n8) {
                l -= (long)n8;
            } else {
                if (l <= 0L) break;
                if (!$assertionsDisabled && (long)n9 + l >= Integer.MAX_VALUE) {
                    throw new AssertionError();
                }
                n7 = (int)((long)n9 + l);
                byteBuffer2.position(n7);
                break;
            }
            n7 = n9 + n8;
            byteBuffer2.position(n7);
        }
        return l4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int read(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, long l, NativeDispatcher nativeDispatcher, Object object) throws IOException {
        if (byteBuffer.isReadOnly()) {
            throw new IllegalArgumentException("Read-only buffer");
        }
        if (byteBuffer instanceof DirectBuffer) {
            return IOUtil.readIntoNativeBuffer(fileDescriptor, byteBuffer, l, nativeDispatcher, object);
        }
        ByteBuffer byteBuffer2 = null;
        try {
            byteBuffer2 = Util.getTemporaryDirectBuffer(byteBuffer.remaining());
            int n = IOUtil.readIntoNativeBuffer(fileDescriptor, byteBuffer2, l, nativeDispatcher, object);
            byteBuffer2.flip();
            if (n > 0) {
                byteBuffer.put(byteBuffer2);
            }
            int n2 = n;
            return n2;
        }
        finally {
            Util.releaseTemporaryDirectBuffer(byteBuffer2);
        }
    }

    private static int readIntoNativeBuffer(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, long l, NativeDispatcher nativeDispatcher, Object object) throws IOException {
        int n;
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.limit();
        if (!$assertionsDisabled && n2 > n3) {
            throw new AssertionError();
        }
        int n4 = n = n2 <= n3 ? n3 - n2 : 0;
        if (n == 0) {
            return 0;
        }
        int n5 = 0;
        n5 = l != -1L ? nativeDispatcher.pread(fileDescriptor, ((DirectBuffer)((Object)byteBuffer)).address() + (long)n2, n, l, object) : nativeDispatcher.read(fileDescriptor, ((DirectBuffer)((Object)byteBuffer)).address() + (long)n2, n);
        if (n5 > 0) {
            byteBuffer.position(n2 + n5);
        }
        return n5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long read(FileDescriptor fileDescriptor, ByteBuffer[] byteBufferArray, NativeDispatcher nativeDispatcher) throws IOException {
        int n;
        int n2 = IOUtil.remaining(byteBufferArray);
        if (n2 < 0) {
            return 0L;
        }
        if (n2 > 0) {
            byteBufferArray = IOUtil.skipBufs(byteBufferArray, n2);
        }
        int n3 = byteBufferArray.length;
        ByteBuffer[] byteBufferArray2 = new ByteBuffer[n3];
        for (int i = 0; i < n3; ++i) {
            if (byteBufferArray[i].isReadOnly()) {
                throw new IllegalArgumentException("Read-only buffer");
            }
            byteBufferArray2[i] = !(byteBufferArray[i] instanceof DirectBuffer) ? ByteBuffer.allocateDirect(byteBufferArray[i].remaining()) : byteBufferArray[i];
        }
        IOVecWrapper iOVecWrapper = null;
        long l = 0L;
        try {
            iOVecWrapper = new IOVecWrapper(n3);
            for (int i = 0; i < n3; ++i) {
                ByteBuffer byteBuffer = byteBufferArray2[i];
                long l2 = byteBuffer.position();
                long l3 = byteBuffer.remaining();
                iOVecWrapper.putBase(i, ((DirectBuffer)((Object)byteBuffer)).address() + l2);
                iOVecWrapper.putLen(i, l3);
            }
            l = nativeDispatcher.readv(fileDescriptor, iOVecWrapper.address, n3);
        }
        finally {
            iOVecWrapper.free();
        }
        long l4 = l;
        for (n = 0; n < n3; ++n) {
            int n4;
            ByteBuffer byteBuffer = byteBufferArray2[n];
            int n5 = byteBuffer.position();
            int n6 = byteBuffer.remaining();
            if (l >= (long)n6) {
                l -= (long)n6;
            } else {
                if (l <= 0L) break;
                if (!$assertionsDisabled && (long)n5 + l >= Integer.MAX_VALUE) {
                    throw new AssertionError();
                }
                n4 = (int)((long)n5 + l);
                byteBuffer.position(n4);
                break;
            }
            n4 = n5 + n6;
            byteBuffer.position(n4);
        }
        for (n = 0; n < n3; ++n) {
            if (byteBufferArray[n] instanceof DirectBuffer) continue;
            byteBufferArray2[n].flip();
            byteBufferArray[n].put(byteBufferArray2[n]);
        }
        return l4;
    }

    static FileDescriptor newFD(int n) {
        FileDescriptor fileDescriptor = new FileDescriptor();
        IOUtil.setfdVal(fileDescriptor, n);
        return fileDescriptor;
    }

    static native boolean randomBytes(byte[] var0);

    static native void initPipe(int[] var0, boolean var1);

    static native boolean drain(int var0) throws IOException;

    static native void configureBlocking(FileDescriptor var0, boolean var1) throws IOException;

    static native int fdVal(FileDescriptor var0);

    static native void setfdVal(FileDescriptor var0, int var1);

    static native void initIDs();

    static {
        $assertionsDisabled = !IOUtil.class.desiredAssertionStatus();
        Util.load();
    }
}

