/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.Pipe;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import sun.nio.ch.PollArrayWrapper;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.SelectorImpl;
import sun.nio.ch.Util;

final class WindowsSelectorImpl
extends SelectorImpl {
    private final int INIT_CAP = 8;
    private static final int MAX_SELECTABLE_FDS = 1024;
    private SelectionKeyImpl[] channelArray = new SelectionKeyImpl[8];
    private PollArrayWrapper pollWrapper;
    private int totalChannels = 1;
    private int threadsCount = 0;
    private final List threads = new ArrayList();
    private Pipe wakeupPipe;
    private int wakeupSourceFd;
    private int wakeupSinkFd;
    private final FdMap fdMap = new FdMap();
    private final SubSelector subSelector = new SubSelector();
    private long timeout;
    private final Object interruptLock = new Object();
    private volatile boolean interruptTriggered = false;
    private final StartLock startLock = new StartLock();
    private final FinishLock finishLock = new FinishLock();
    private long updateCount = 0L;

    WindowsSelectorImpl(SelectorProvider selectorProvider) throws IOException {
        super(selectorProvider);
        this.pollWrapper = new PollArrayWrapper(8);
        this.wakeupPipe = Pipe.open();
        this.wakeupSourceFd = ((SelChImpl)((Object)this.wakeupPipe.source())).getFDVal();
        this.wakeupSinkFd = ((SelChImpl)((Object)this.wakeupPipe.sink())).getFDVal();
        this.pollWrapper.addWakeupSocket(this.wakeupSourceFd, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doSelect(long l) throws IOException {
        if (this.channelArray == null) {
            throw new ClosedSelectorException();
        }
        this.timeout = l;
        this.processDeregisterQueue();
        if (this.interruptTriggered) {
            this.resetWakeupSocket();
            return 0;
        }
        this.adjustThreadsCount();
        this.finishLock.reset();
        this.startLock.startThreads();
        try {
            this.begin();
            try {
                this.subSelector.poll();
            }
            catch (IOException iOException) {
                this.finishLock.setException(iOException);
            }
            if (this.threads.size() > 0) {
                this.finishLock.waitForHelperThreads();
            }
        }
        finally {
            this.end();
        }
        this.resetWakeupSocket();
        this.finishLock.checkForException();
        this.processDeregisterQueue();
        return this.updateSelectedKeys();
    }

    private void adjustThreadsCount() {
        block3: {
            block2: {
                if (this.threadsCount <= this.threads.size()) break block2;
                for (int i = this.threads.size(); i < this.threadsCount; ++i) {
                    SelectThread selectThread = new SelectThread(i);
                    this.threads.add(selectThread);
                    selectThread.setDaemon(true);
                    selectThread.start();
                }
                break block3;
            }
            if (this.threadsCount >= this.threads.size()) break block3;
            for (int i = this.threads.size() - 1; i >= this.threadsCount; --i) {
                this.threads.remove(i);
            }
        }
    }

    private void setWakeupSocket() {
        this.setWakeupSocket0(this.wakeupSinkFd);
    }

    private native void setWakeupSocket0(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetWakeupSocket() {
        Object object = this.interruptLock;
        synchronized (object) {
            if (!this.resetWakeupSocket0(this.wakeupSourceFd)) {
                try {
                    this.wakeupPipe.sink().close();
                    this.wakeupPipe.source().close();
                    this.wakeupPipe = Pipe.open();
                    this.wakeupSourceFd = ((SelChImpl)((Object)this.wakeupPipe.source())).getFDVal();
                    this.wakeupSinkFd = ((SelChImpl)((Object)this.wakeupPipe.sink())).getFDVal();
                    for (int i = 0; i <= this.threadsCount; ++i) {
                        this.pollWrapper.addWakeupSocket(this.wakeupSourceFd, i * 1024);
                    }
                }
                catch (IOException iOException) {
                    System.out.println("resetWakeupSocket: " + iOException);
                }
            }
            this.interruptTriggered = false;
        }
    }

    private native boolean resetWakeupSocket0(int var1);

    private int updateSelectedKeys() {
        ++this.updateCount;
        int n = 0;
        n += this.subSelector.processSelectedKeys(this.updateCount);
        Iterator iterator = this.threads.iterator();
        while (iterator.hasNext()) {
            n += ((SelectThread)iterator.next()).subSelector.processSelectedKeys(this.updateCount);
        }
        return n;
    }

    protected void implClose() throws IOException {
        if (this.channelArray != null && this.pollWrapper != null) {
            this.wakeupPipe.sink().close();
            this.wakeupPipe.source().close();
            for (int i = 1; i < this.totalChannels; ++i) {
                if (i % 1024 == 0) continue;
                this.deregister(this.channelArray[i]);
                SelectableChannel selectableChannel = this.channelArray[i].channel();
                if (selectableChannel.isOpen() || selectableChannel.isRegistered()) continue;
                ((SelChImpl)((Object)selectableChannel)).kill();
            }
            this.pollWrapper.free();
            this.pollWrapper = null;
            this.selectedKeys = null;
            this.channelArray = null;
            this.threads.clear();
            this.startLock.startThreads();
        }
    }

    protected void implRegister(SelectionKeyImpl selectionKeyImpl) {
        this.growIfNeeded();
        this.channelArray[this.totalChannels] = selectionKeyImpl;
        selectionKeyImpl.setIndex(this.totalChannels);
        this.fdMap.put(selectionKeyImpl);
        this.keys.add(selectionKeyImpl);
        this.pollWrapper.addEntry(this.totalChannels, selectionKeyImpl);
        ++this.totalChannels;
    }

    private void growIfNeeded() {
        if (this.channelArray.length == this.totalChannels) {
            int n = this.totalChannels * 2;
            SelectionKeyImpl[] selectionKeyImplArray = new SelectionKeyImpl[n];
            System.arraycopy(this.channelArray, 1, selectionKeyImplArray, 1, this.totalChannels - 1);
            this.channelArray = selectionKeyImplArray;
            this.pollWrapper.grow(n);
        }
        if (this.totalChannels % 1024 == 0) {
            this.pollWrapper.addWakeupSocket(this.wakeupSourceFd, this.totalChannels);
            ++this.totalChannels;
            ++this.threadsCount;
        }
    }

    protected void implDereg(SelectionKeyImpl selectionKeyImpl) throws IOException {
        Object object;
        int n = selectionKeyImpl.getIndex();
        if (n != this.totalChannels - 1) {
            object = this.channelArray[this.totalChannels - 1];
            this.channelArray[n] = object;
            ((SelectionKeyImpl)object).setIndex(n);
            this.pollWrapper.replaceEntry(this.pollWrapper, this.totalChannels - 1, this.pollWrapper, n);
        }
        this.channelArray[this.totalChannels - 1] = null;
        --this.totalChannels;
        if (this.totalChannels != 1 && this.totalChannels % 1024 == 1) {
            --this.totalChannels;
            --this.threadsCount;
        }
        this.fdMap.remove(selectionKeyImpl);
        this.keys.remove(selectionKeyImpl);
        this.selectedKeys.remove(selectionKeyImpl);
        this.deregister(selectionKeyImpl);
        object = selectionKeyImpl.channel();
        if (!((AbstractInterruptibleChannel)object).isOpen() && !((SelectableChannel)object).isRegistered()) {
            ((SelChImpl)object).kill();
        }
    }

    void putEventOps(SelectionKeyImpl selectionKeyImpl, int n) {
        this.pollWrapper.putEventOps(selectionKeyImpl.getIndex(), n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Selector wakeup() {
        Object object = this.interruptLock;
        synchronized (object) {
            if (!this.interruptTriggered) {
                this.setWakeupSocket();
                this.interruptTriggered = true;
            }
        }
        return this;
    }

    static {
        Util.load();
    }

    private final class SelectThread
    extends Thread {
        private int index;
        SubSelector subSelector;
        private long lastRun = 0L;

        private SelectThread(int n) {
            this.index = n;
            this.subSelector = new SubSelector(n);
        }

        public void run() {
            while (!WindowsSelectorImpl.this.startLock.waitForStart(this)) {
                try {
                    this.subSelector.poll(this.index);
                }
                catch (IOException iOException) {
                    WindowsSelectorImpl.this.finishLock.setException(iOException);
                }
                WindowsSelectorImpl.this.finishLock.threadFinished();
            }
            return;
        }
    }

    private final class SubSelector {
        private final int pollArrayIndex;
        private final int[] readFds = new int[1025];
        private final int[] writeFds = new int[1025];
        private final int[] exceptFds = new int[1025];

        private SubSelector() {
            this.pollArrayIndex = 0;
        }

        private SubSelector(int n) {
            this.pollArrayIndex = (n + 1) * 1024;
        }

        private int poll() throws IOException {
            return this.poll0(((WindowsSelectorImpl)WindowsSelectorImpl.this).pollWrapper.pollArrayAddress, Math.min(WindowsSelectorImpl.this.totalChannels, 1024), this.readFds, this.writeFds, this.exceptFds, WindowsSelectorImpl.this.timeout);
        }

        private int poll(int n) throws IOException {
            return this.poll0(((WindowsSelectorImpl)WindowsSelectorImpl.this).pollWrapper.pollArrayAddress + (long)(this.pollArrayIndex * PollArrayWrapper.SIZE_POLLFD), Math.min(1024, WindowsSelectorImpl.this.totalChannels - (n + 1) * 1024), this.readFds, this.writeFds, this.exceptFds, WindowsSelectorImpl.this.timeout);
        }

        private native int poll0(long var1, int var3, int[] var4, int[] var5, int[] var6, long var7);

        private int processSelectedKeys(long l) {
            int n = 0;
            n += this.processFDSet(l, this.readFds, 1);
            n += this.processFDSet(l, this.writeFds, 6);
            return n += this.processFDSet(l, this.exceptFds, 7);
        }

        private int processFDSet(long l, int[] nArray, int n) {
            int n2 = 0;
            for (int i = 1; i <= nArray[0]; ++i) {
                try {
                    MapEntry mapEntry;
                    int n3 = nArray[i];
                    if (n3 == WindowsSelectorImpl.this.wakeupSourceFd || (mapEntry = WindowsSelectorImpl.this.fdMap.get(n3)) == null) continue;
                    SelectionKeyImpl selectionKeyImpl = mapEntry.ski;
                    if (WindowsSelectorImpl.this.selectedKeys.contains(selectionKeyImpl)) {
                        if (mapEntry.clearedCount != l) {
                            if (selectionKeyImpl.channel.translateAndSetReadyOps(n, selectionKeyImpl) && mapEntry.updateCount != l) {
                                mapEntry.updateCount = l;
                                ++n2;
                            }
                        } else if (selectionKeyImpl.channel.translateAndUpdateReadyOps(n, selectionKeyImpl) && mapEntry.updateCount != l) {
                            mapEntry.updateCount = l;
                            ++n2;
                        }
                        mapEntry.clearedCount = l;
                        continue;
                    }
                    if (mapEntry.clearedCount != l) {
                        selectionKeyImpl.channel.translateAndSetReadyOps(n, selectionKeyImpl);
                        if ((selectionKeyImpl.readyOps() & selectionKeyImpl.interestOps()) != 0) {
                            WindowsSelectorImpl.this.selectedKeys.add(selectionKeyImpl);
                            mapEntry.updateCount = l;
                            ++n2;
                        }
                    } else {
                        selectionKeyImpl.channel.translateAndUpdateReadyOps(n, selectionKeyImpl);
                        if ((selectionKeyImpl.readyOps() & selectionKeyImpl.interestOps()) != 0) {
                            WindowsSelectorImpl.this.selectedKeys.add(selectionKeyImpl);
                            mapEntry.updateCount = l;
                            ++n2;
                        }
                    }
                    mapEntry.clearedCount = l;
                    continue;
                }
                catch (CancelledKeyException cancelledKeyException) {
                    // empty catch block
                }
            }
            return n2;
        }
    }

    private final class FinishLock {
        private int threadsToFinish;
        IOException exception = null;

        private FinishLock() {
        }

        private void reset() {
            this.threadsToFinish = WindowsSelectorImpl.this.threads.size();
        }

        private synchronized void threadFinished() {
            if (this.threadsToFinish == WindowsSelectorImpl.this.threads.size()) {
                WindowsSelectorImpl.this.wakeup();
            }
            --this.threadsToFinish;
            if (this.threadsToFinish == 0) {
                this.notify();
            }
        }

        private synchronized void waitForHelperThreads() {
            if (this.threadsToFinish == WindowsSelectorImpl.this.threads.size()) {
                WindowsSelectorImpl.this.wakeup();
            }
            while (this.threadsToFinish != 0) {
                try {
                    WindowsSelectorImpl.this.finishLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        private synchronized void setException(IOException iOException) {
            this.exception = iOException;
        }

        private void checkForException() throws IOException {
            if (this.exception == null) {
                return;
            }
            StringBuffer stringBuffer = new StringBuffer("An exception occured during the execution of select(): \n");
            stringBuffer.append(this.exception);
            stringBuffer.append('\n');
            this.exception = null;
            throw new IOException(stringBuffer.toString());
        }
    }

    private final class StartLock {
        private long runsCounter;

        private StartLock() {
        }

        private synchronized void startThreads() {
            ++this.runsCounter;
            this.notifyAll();
        }

        private synchronized boolean waitForStart(SelectThread selectThread) {
            while (this.runsCounter == selectThread.lastRun) {
                try {
                    WindowsSelectorImpl.this.startLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            if (selectThread.index >= WindowsSelectorImpl.this.threads.size()) {
                return true;
            }
            selectThread.lastRun = this.runsCounter;
            return false;
        }
    }

    private static final class MapEntry {
        SelectionKeyImpl ski;
        long updateCount = 0L;
        long clearedCount = 0L;

        MapEntry(SelectionKeyImpl selectionKeyImpl) {
            this.ski = selectionKeyImpl;
        }
    }

    private static final class FdMap
    extends HashMap {
        private FdMap() {
        }

        private MapEntry get(int n) {
            return (MapEntry)this.get(new Integer(n));
        }

        private Object put(SelectionKeyImpl selectionKeyImpl) {
            return this.put(new Integer(selectionKeyImpl.channel.getFDVal()), new MapEntry(selectionKeyImpl));
        }

        private Object remove(SelectionKeyImpl selectionKeyImpl) {
            return this.remove(new Integer(selectionKeyImpl.channel.getFDVal()));
        }
    }
}

