/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.process;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.process.CreationParams;
import com.ibm.ws.process.LinuxProcessSpawnerThread;
import com.ibm.ws.process.Process;
import com.ibm.ws.process.UnixProcessGlue;
import com.ibm.ws.process.UnixProcessImpl;
import com.ibm.ws.process.exception.InvalidDirectoryException;
import com.ibm.ws.process.exception.InvalidExecutableException;
import com.ibm.ws.process.exception.InvalidFileException;
import com.ibm.ws.process.exception.InvalidGroupException;
import com.ibm.ws.process.exception.InvalidPriorityException;
import com.ibm.ws.process.exception.InvalidProcessGroupException;
import com.ibm.ws.process.exception.InvalidUsernameException;
import com.ibm.ws.process.exception.OutOfFileHandlesException;
import com.ibm.ws.process.exception.OutOfMemoryException;
import com.ibm.ws.process.exception.ProcessHasExitedException;
import com.ibm.ws.process.exception.ProcessOpException;
import com.ibm.ws.process.linuxutil.Mutex;

public class LinuxProcessImpl
extends UnixProcessImpl {
    private static TraceComponent tc = Tr.register(class$com$ibm$ws$process$LinuxProcessImpl == null ? (class$com$ibm$ws$process$LinuxProcessImpl = LinuxProcessImpl.class$("com.ibm.ws.process.LinuxProcessImpl")) : class$com$ibm$ws$process$LinuxProcessImpl);
    private LinuxProcessSpawnerThread pSpawner = null;
    private Mutex spawnerThreadMutex = new Mutex();
    static /* synthetic */ Class class$com$ibm$ws$process$LinuxProcessImpl;

    public Process create(CreationParams creationParams) throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create() : Calling for a process create.");
        }
        LinuxProcessImpl linuxProcessImpl = new LinuxProcessImpl();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Creation params are: " + creationParams.toString());
        }
        try {
            linuxProcessImpl.initializeProcess(new LinuxProcessSpawnerThread(creationParams));
        }
        catch (Exception exception) {
            ProcessOpException processOpException = new ProcessOpException(exception.toString());
            if (exception instanceof InvalidUsernameException) {
                String string = LinuxProcessImpl.getXFormattedString("PROC0001E", new Object[]{creationParams.getUserId()});
                processOpException = new InvalidUsernameException(string);
            } else if (exception instanceof InvalidGroupException) {
                String string = LinuxProcessImpl.getXFormattedString("PROC0002E", new Object[]{creationParams.getGroupId()});
                processOpException = new InvalidGroupException(string);
            } else if (exception instanceof InvalidDirectoryException) {
                String string = LinuxProcessImpl.getXFormattedString("PROC0003E", new Object[]{creationParams.getWorkingDirectory()});
                processOpException = new InvalidDirectoryException(string);
            } else if (exception instanceof InvalidExecutableException) {
                String string = LinuxProcessImpl.getXFormattedString("PROC0004E", new Object[]{creationParams.getExecutable()});
                processOpException = new InvalidExecutableException(string);
            } else if (exception instanceof InvalidPriorityException) {
                String string = LinuxProcessImpl.getXFormattedString("PROC0005E", new Object[]{new Integer(creationParams.getProcessPriority())});
                processOpException = new InvalidPriorityException(string);
            } else if (exception instanceof InvalidProcessGroupException) {
                String string = LinuxProcessImpl.getXFormattedString("PROC0006E", new Object[]{new Integer(creationParams.getProcessGroupId())});
                processOpException = new InvalidGroupException(string);
            } else if (exception instanceof InvalidFileException) {
                String string = LinuxProcessImpl.getXString("PROC0007E");
                processOpException = new InvalidFileException(string);
            } else if (exception instanceof OutOfFileHandlesException) {
                String string = LinuxProcessImpl.getXString("PROC0008E");
                processOpException = new OutOfFileHandlesException(string);
            } else if (exception instanceof OutOfMemoryException) {
                String string = LinuxProcessImpl.getXString("PROC0009E");
                processOpException = new OutOfMemoryException(string);
            }
            throw processOpException;
        }
        if (creationParams.getDetachProcess()) {
            linuxProcessImpl.reclaimSpawnerThread();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create() : Process created.");
        }
        return linuxProcessImpl;
    }

    public Process bindTo(String string) throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bindTo() : Rebinding to a running porcess.");
        }
        LinuxProcessImpl linuxProcessImpl = new LinuxProcessImpl();
        try {
            linuxProcessImpl.nativeHandle = UnixProcessGlue.recreate(string);
        }
        catch (Exception exception) {
            ProcessOpException processOpException = new ProcessOpException(exception.toString());
            if (exception instanceof ProcessHasExitedException) {
                String string2 = LinuxProcessImpl.getXFormattedString("PROC0010E", new Object[]{string});
                processOpException = new ProcessHasExitedException(string2);
            }
            throw processOpException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "bindTo() : Done with rebind.");
        }
        return linuxProcessImpl;
    }

    public Process createSelf() throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSelf() : Creating a process object to represent ourself.");
        }
        LinuxProcessImpl linuxProcessImpl = new LinuxProcessImpl();
        linuxProcessImpl.nativeHandle = UnixProcessGlue.createSelf();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSelf() : Done creating self-process object.");
        }
        return linuxProcessImpl;
    }

    public void waitForTermination() throws ProcessOpException {
        ProcessOpException processOpException = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "waitForTermination() : Requesting to wait for process termination");
        }
        if (!this.released) {
            this.checkNativeHandle();
            this.spawnerThreadMutex.lock();
            if (this.pSpawner != null && this.pSpawner.isAlive()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting PM thread operaton to WAIT_FOR_PROCESS");
                }
                this.pSpawner.setOperation(1, null);
                this.pSpawner.interrupt();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Halting this thread for results of PM thread operaton WAIT_FOR_PROCESS");
                }
                this.pSpawner.waitForCommandOutcome();
                processOpException = this.pSpawner.getException();
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Waiting for pSpawner thread to terminate.");
                    }
                    this.pSpawner.join();
                    this.pSpawner = null;
                    this.spawnerThreadMutex.unlock();
                }
                catch (InterruptedException interruptedException) {
                    FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.process.LinuxProcessImpl.waitForTermination", "135", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The wait was aborted due to some interruption, throwing exception.");
                    }
                    this.spawnerThreadMutex.unlock();
                    throw new ProcessOpException(interruptedException.toString());
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Checking to see if an operation exception occured in the PM thread.");
                }
                if (processOpException != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Operation exception occured, propagating the exception.");
                    }
                    throw processOpException;
                }
            } else {
                this.spawnerThreadMutex.unlock();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Either the PM thread is locked, doesn't exist, or has already terminated.  Calling old monitor method.");
                }
                UnixProcessGlue.waitForTermination(this.nativeHandle);
            }
        } else {
            throw new ProcessOpException("Process Object already released.  No further calls allowed.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "waitForTermination() : Done with waiting for process termination");
        }
    }

    public void waitForTermination(int n) throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "waitForTermination() : Requesting to wait for process termination over a set time.");
        }
        ProcessOpException processOpException = null;
        if (!this.released) {
            this.checkNativeHandle();
            int[] nArray = new int[]{n};
            boolean bl = this.spawnerThreadMutex.trylock();
            if (this.pSpawner != null && bl && this.pSpawner.isAlive()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting PM thread operaton to WAIT_FOR_PROCESS_WITH_TIMEOUT");
                }
                this.pSpawner.setOperation(2, nArray);
                this.pSpawner.interrupt();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Halting this thread for results of PM thread operaton WAIT_FOR_PROCESS_WITH_TIMEOUT");
                }
                this.pSpawner.waitForCommandOutcome();
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Waiting for pSpawner thread to terminate.");
                    }
                    processOpException = this.pSpawner.getException();
                    if (this.pSpawner != null && !this.pSpawner.isAlive()) {
                        this.pSpawner.join();
                        this.pSpawner = null;
                    }
                    this.spawnerThreadMutex.unlock();
                    bl = false;
                }
                catch (InterruptedException interruptedException) {
                    FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.process.LinuxProcessImpl.waitForTermination", "196", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "The wait was aborted due to some interruption, throwing exception.");
                    }
                    this.spawnerThreadMutex.unlock();
                    bl = false;
                    ProcessOpException processOpException2 = processOpException != null ? new ProcessOpException(interruptedException.toString() + processOpException) : new ProcessOpException(interruptedException.toString());
                    throw processOpException2;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Checking to see if an operation exception occured in the PM thread.");
                }
                if (processOpException != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Operation exception occured, propagating the exception.");
                    }
                    throw processOpException;
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Either the PM thread is locked, doesn't exist, or has already terminated.  Calling old monitor method.");
                }
                if (bl) {
                    this.spawnerThreadMutex.unlock();
                    bl = false;
                }
                UnixProcessGlue.waitForTerminationWithTimeout(this.nativeHandle, n);
            }
        } else {
            throw new ProcessOpException("Process Object already finalized.  No further calls allowed.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "waitForTermination() : Done with waiting for process termination");
        }
    }

    private void initializeProcess(LinuxProcessSpawnerThread linuxProcessSpawnerThread) throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeProcess() : Initializing process object.");
        }
        this.pSpawner = linuxProcessSpawnerThread;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Checking to see if the process spawned correctly.");
        }
        if (this.pSpawner.getException() != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Process spawn failure, throwing exception.");
            }
            ProcessOpException processOpException = this.pSpawner.getException();
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Process spawn failure, cleaning up spawner thread.");
                }
                this.pSpawner.join();
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.process.LinuxProcessImpl.initializeProcess", "258", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Process spawn failure, couldn't clean up spawner thread.");
                }
                processOpException = new ProcessOpException(processOpException.toString() + interruptedException.toString());
            }
            throw processOpException;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Process spawn success, setting pointer to native process structure.");
        }
        this.nativeHandle = this.pSpawner.getNativeHandle();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeProcess() : Done initializing process object.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAlive() throws ProcessOpException {
        int n = 0;
        ProcessOpException processOpException = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ping() : Checking to see if a process exists.");
        }
        if (this.released) throw new ProcessOpException("Process Object already released.  No further calls allowed.");
        this.checkNativeHandle();
        boolean bl = this.spawnerThreadMutex.trylock();
        if (this.pSpawner != null && bl && this.pSpawner.isAlive()) {
            this.pSpawner.setOperation(4, null);
            this.pSpawner.interrupt();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Pinging process through PM thread");
            }
            this.pSpawner.waitForCommandOutcome();
            processOpException = this.pSpawner.getException();
            if (this.pSpawner != null && !this.pSpawner.isAlive()) {
                try {
                    this.reclaimSpawnerThread();
                }
                catch (ProcessOpException processOpException2) {
                    this.spawnerThreadMutex.unlock();
                    throw processOpException2;
                }
            }
            this.spawnerThreadMutex.unlock();
            if (processOpException == null) {
                n = 1;
            } else {
                if (!(processOpException instanceof ProcessHasExitedException)) throw processOpException;
                n = 0;
            }
        } else {
            if (bl) {
                this.spawnerThreadMutex.unlock();
                bl = false;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Either the PM thread is locked, doesn't exist, or has already terminated.  Calling old monitor method.");
            }
            n = UnixProcessGlue.ping(this.nativeHandle);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ping() : Done with existance check");
        }
        if (n == 0) return false;
        return true;
    }

    public void stop() throws ProcessOpException {
        super.stop();
        this.waitForTermination();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void release() throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "release() : Doing finalization on process object.");
        }
        if (!this.released) {
            if (this.pSpawner != null) {
                if (this.pSpawner.getOperation() != 0) throw new ProcessOpException("Process object is in use.  Cannot finalize.");
                this.checkNativeHandle();
                if (this.pSpawner.isAlive()) {
                    this.pSpawner.setOperation(3, null);
                    this.pSpawner.interrupt();
                    try {
                        this.pSpawner.join();
                        this.pSpawner = null;
                    }
                    catch (InterruptedException interruptedException) {
                        FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.process.LinuxProcessImpl.release", "320", this);
                        throw new ProcessOpException("Could not wait for spawner thread to join");
                    }
                }
                super.release();
            } else {
                super.release();
            }
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "release() : Done with finalization on process object.");
    }

    private void reclaimSpawnerThread() throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reclaimSpawnerThread() : Join with the spawner thread.  Process spawned as 'detached'");
        }
        try {
            this.pSpawner.join();
            this.pSpawner = null;
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.process.LinuxProcessImpl.reclaimSpawnerThread", "371", this);
            throw new ProcessOpException("Could not wait for spawner thread to join");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reclaimSpawnerThread() : Joined with the spawner thread.");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

