/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.process;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.process.CreationParams;
import com.ibm.ws.process.NetwProcessGlue;
import com.ibm.ws.process.Process;
import com.ibm.ws.process.ProcessObjectFactory;
import com.ibm.ws.process.exception.ProcessOpException;

public class NetwProcessImpl
implements Process,
ProcessObjectFactory {
    private static TraceComponent tc;
    protected int nativeHandle = 0;
    protected boolean released = false;
    static /* synthetic */ Class class$com$ibm$ws$process$NetwProcessImpl;

    public Process create(CreationParams creationParams) throws ProcessOpException {
        NetwProcessImpl netwProcessImpl = new NetwProcessImpl();
        netwProcessImpl.nativeHandle = NetwProcessGlue.create(creationParams.getExecutable(), NetwProcessImpl.getCmdlineInBytes(creationParams), creationParams.getEnvironment(), creationParams.getWorkingDirectory(), creationParams.getProcessPriority(), creationParams.getStdFileNames());
        return netwProcessImpl;
    }

    static byte[] getCmdlineInBytes(CreationParams creationParams) {
        StringBuffer stringBuffer = new StringBuffer(4096);
        String[] stringArray = creationParams.getCommandLineArgs();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            stringBuffer.append(" \"");
            int n = stringArray[i].length();
            int n2 = 0;
            for (int j = 0; j < n; ++j) {
                char c = stringArray[i].charAt(j);
                if (c == '\\') {
                    ++n2;
                    if (stringArray[i].charAt(j + 1) == '\"') {
                        stringBuffer.append('\\');
                    }
                } else {
                    n2 = 0;
                }
                if (c == '\"') {
                    stringBuffer.append('\\');
                }
                stringBuffer.append(c);
            }
            while (n2-- > 0) {
                stringBuffer.append('\\');
            }
            stringBuffer.append('\"');
        }
        stringBuffer.append('\u0000');
        return stringBuffer.toString().getBytes();
    }

    public Process bindTo(String string) throws ProcessOpException {
        NetwProcessImpl netwProcessImpl = new NetwProcessImpl();
        netwProcessImpl.nativeHandle = NetwProcessGlue.recreate(string);
        return netwProcessImpl;
    }

    public Process createSelf() throws ProcessOpException {
        NetwProcessImpl netwProcessImpl = new NetwProcessImpl();
        netwProcessImpl.nativeHandle = NetwProcessGlue.createSelf();
        return netwProcessImpl;
    }

    public String id() throws ProcessOpException {
        if (!this.released) {
            this.checkNativeHandle();
            return NetwProcessGlue.id(this.nativeHandle);
        }
        throw new ProcessOpException("Process Object already released.  No further calls allowed.");
    }

    public void waitForTermination() throws ProcessOpException {
        if (this.released) {
            throw new ProcessOpException("Process Object already released.  No further calls allowed.");
        }
        this.checkNativeHandle();
        NetwProcessGlue.waitForTermination(this.nativeHandle);
    }

    public void waitForTermination(int n) throws ProcessOpException {
        if (this.released) {
            throw new ProcessOpException("Process Object already released.  No further calls allowed.");
        }
        this.checkNativeHandle();
        NetwProcessGlue.waitForTerminationWithTimeout(this.nativeHandle, n);
    }

    public int getExitCode() throws ProcessOpException {
        if (this.released) {
            throw new ProcessOpException("Process Object already released.  No further calls allowed.");
        }
        this.checkNativeHandle();
        int n = NetwProcessGlue.getExitCode(this.nativeHandle);
        return n;
    }

    public boolean ping() throws ProcessOpException {
        return this.isAlive();
    }

    public boolean isAlive() throws ProcessOpException {
        if (!this.released) {
            this.checkNativeHandle();
            int n = NetwProcessGlue.ping(this.nativeHandle);
            return n != 0;
        }
        throw new ProcessOpException("Process Object already released.  No further calls allowed.");
    }

    public void stop() throws ProcessOpException {
        if (this.released) {
            throw new ProcessOpException("Process Object already released.  No further calls allowed.");
        }
        this.checkNativeHandle();
        NetwProcessGlue.stop(this.nativeHandle);
    }

    public void release() throws ProcessOpException {
        if (this.released) {
            throw new ProcessOpException("Process Object already released.  No further calls allowed.");
        }
        this.checkNativeHandle();
        NetwProcessGlue.done(this.nativeHandle);
        this.released = true;
    }

    public void generateJVMDump() throws ProcessOpException {
        if (this.released) {
            throw new ProcessOpException("Process Object already released.  No further calls allowed.");
        }
        this.checkNativeHandle();
        NetwProcessGlue.pokeVMThreadDump(this.nativeHandle);
    }

    protected void finalize() throws Throwable {
        if (!this.released && this.nativeHandle != 0) {
            this.release();
        }
        super.finalize();
    }

    protected void checkNativeHandle() throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Checking validity of nativeHandle.");
        }
        if (this.nativeHandle == 0) {
            throw new ProcessOpException("Invalid process object.  nativeHandle (pointer) is 'null'");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Done checking validity of nativeHandle.  Appears valid.");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        System.loadLibrary("WsProc");
        tc = Tr.register(class$com$ibm$ws$process$NetwProcessImpl == null ? (class$com$ibm$ws$process$NetwProcessImpl = NetwProcessImpl.class$("com.ibm.ws.process.NetwProcessImpl")) : class$com$ibm$ws$process$NetwProcessImpl);
    }
}

