/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.process;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.process.CreationParams;
import com.ibm.ws.process.Process;
import com.ibm.ws.process.ProcessObjectFactory;
import com.ibm.ws.process.UnixProcessGlue;
import com.ibm.ws.process.exception.InvalidDirectoryException;
import com.ibm.ws.process.exception.InvalidExecutableException;
import com.ibm.ws.process.exception.InvalidFileException;
import com.ibm.ws.process.exception.InvalidGroupException;
import com.ibm.ws.process.exception.InvalidPriorityException;
import com.ibm.ws.process.exception.InvalidProcessGroupException;
import com.ibm.ws.process.exception.InvalidUsernameException;
import com.ibm.ws.process.exception.OutOfFileHandlesException;
import com.ibm.ws.process.exception.OutOfMemoryException;
import com.ibm.ws.process.exception.ProcessHasExitedException;
import com.ibm.ws.process.exception.ProcessOpException;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class UnixProcessImpl
implements Process,
ProcessObjectFactory {
    private static TraceComponent tc = Tr.register(class$com$ibm$ws$process$UnixProcessImpl == null ? (class$com$ibm$ws$process$UnixProcessImpl = UnixProcessImpl.class$("com.ibm.ws.process.UnixProcessImpl")) : class$com$ibm$ws$process$UnixProcessImpl);
    protected int nativeHandle = 0;
    private static String osName = System.getProperty("os.name");
    protected boolean released = false;
    private static final String resourceBundlePackage = "com.ibm.ws.process.processmessages";
    private static ResourceBundle resourceBundle = null;
    static /* synthetic */ Class class$com$ibm$ws$process$UnixProcessImpl;

    public Process create(CreationParams creationParams) throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create() : Calling for a process create.");
        }
        UnixProcessImpl unixProcessImpl = new UnixProcessImpl();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Creation params are: " + creationParams.toString());
        }
        try {
            unixProcessImpl.nativeHandle = UnixProcessGlue.create(creationParams.getExecutable(), creationParams.getCommandLineArgs(), creationParams.getEnvironment(), creationParams.getWorkingDirectory(), creationParams.getProcessPriority(), creationParams.getStdFileNames(), creationParams.getUmask(), creationParams.getGroupId(), creationParams.getUserId(), creationParams.getProcessGroupId(), creationParams.getProcessName(), creationParams.getInheritParentStreams(), creationParams.getDetachProcess());
        }
        catch (Exception exception) {
            ProcessOpException processOpException = new ProcessOpException(exception.toString());
            if (exception instanceof InvalidUsernameException) {
                String string = UnixProcessImpl.getXFormattedString("PROC0001E", new Object[]{creationParams.getUserId()});
                processOpException = new InvalidUsernameException(string);
            } else if (exception instanceof InvalidGroupException) {
                String string = UnixProcessImpl.getXFormattedString("PROC0002E", new Object[]{creationParams.getGroupId()});
                processOpException = new InvalidGroupException(string);
            } else if (exception instanceof InvalidDirectoryException) {
                String string = UnixProcessImpl.getXFormattedString("PROC0003E", new Object[]{creationParams.getWorkingDirectory()});
                processOpException = new InvalidDirectoryException(string);
            } else if (exception instanceof InvalidExecutableException) {
                String string = UnixProcessImpl.getXFormattedString("PROC0004E", new Object[]{creationParams.getExecutable()});
                processOpException = new InvalidExecutableException(string);
            } else if (exception instanceof InvalidPriorityException) {
                String string = UnixProcessImpl.getXFormattedString("PROC0005E", new Object[]{new Integer(creationParams.getProcessPriority())});
                processOpException = new InvalidPriorityException(string);
            } else if (exception instanceof InvalidProcessGroupException) {
                String string = UnixProcessImpl.getXFormattedString("PROC0006E", new Object[]{new Integer(creationParams.getProcessGroupId())});
                processOpException = new InvalidGroupException(string);
            } else if (exception instanceof InvalidFileException) {
                String string = UnixProcessImpl.getXString("PROC0007E");
                processOpException = new InvalidFileException(string);
            } else if (exception instanceof OutOfFileHandlesException) {
                String string = UnixProcessImpl.getXString("PROC0008E");
                processOpException = new OutOfFileHandlesException(string);
            } else if (exception instanceof OutOfMemoryException) {
                String string = UnixProcessImpl.getXString("PROC0009E");
                processOpException = new OutOfMemoryException(string);
            }
            throw processOpException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create() : Process created.");
        }
        return unixProcessImpl;
    }

    public Process bindTo(String string) throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "recreate() : Rebinding to a running process.");
        }
        UnixProcessImpl unixProcessImpl = new UnixProcessImpl();
        try {
            unixProcessImpl.nativeHandle = UnixProcessGlue.recreate(string);
        }
        catch (Exception exception) {
            ProcessOpException processOpException = new ProcessOpException(exception.toString());
            if (exception instanceof ProcessHasExitedException) {
                String string2 = UnixProcessImpl.getXFormattedString("PROC0010E", new Object[]{string});
                processOpException = new ProcessHasExitedException(string2);
            }
            throw processOpException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "recreate() : Done with rebind.");
        }
        return unixProcessImpl;
    }

    public Process createSelf() throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSelf() : Creating a process object to represent ourself.");
        }
        UnixProcessImpl unixProcessImpl = new UnixProcessImpl();
        unixProcessImpl.nativeHandle = UnixProcessGlue.createSelf();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSelf() : Done creating self-process object.");
        }
        return unixProcessImpl;
    }

    static byte[][] strArray2ByteArrArray(String[] stringArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "strArray2ByteArrArray() : Converting a string array to a byte array.");
        }
        if (stringArray != null) {
            byte[][] byArrayArray = new byte[stringArray.length][];
            for (int i = 0; i < stringArray.length; ++i) {
                byArrayArray[i] = stringArray[i].getBytes();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "strArray2ByteArrArray() : Done with converting a string array to a byte array.");
            }
            return byArrayArray;
        }
        byte[][] byArrayArray = new byte[1][];
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "strArray2ByteArrArray() : Done with converting a string array to a byte array.");
        }
        return byArrayArray;
    }

    public String id() throws ProcessOpException {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "id() : Obtaining process ID.");
        }
        if (!this.released) {
            try {
                this.checkNativeHandle();
                string = UnixProcessGlue.id(this.nativeHandle);
            }
            catch (ProcessOpException processOpException) {
                FFDCFilter.processException((Throwable)processOpException, "com.ibm.ws.process.UnixProcessImpl.id", "186", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Bad nativeHandle, returning PID: 0:");
                }
                return "0";
            }
        } else {
            throw new ProcessOpException("Process Object already released.  No further calls allowed.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "id() : Obtained process ID: " + string);
        }
        return string;
    }

    public void waitForTermination() throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "waitForTermination() : Requesting to wait for process termination");
        }
        if (this.released) {
            throw new ProcessOpException("Process Object already released.  No further calls allowed.");
        }
        this.checkNativeHandle();
        UnixProcessGlue.waitForTermination(this.nativeHandle);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "waitForTermination() : Done with waiting for process termination");
        }
    }

    public void waitForTermination(int n) throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "waitForTermination() : Requesting to wait for process termination over a set time.");
        }
        if (this.released) {
            throw new ProcessOpException("Process Object already released.  No further calls allowed.");
        }
        this.checkNativeHandle();
        UnixProcessGlue.waitForTerminationWithTimeout(this.nativeHandle, n);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "waitForTermination() : Done with waiting for process termination");
        }
    }

    public int getExitCode() throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getExitCode() : Getting process exitCode (Return code)");
        }
        if (this.released) {
            throw new ProcessOpException("Process Object already released.  No further calls allowed.");
        }
        this.checkNativeHandle();
        int n = UnixProcessGlue.getExitCode(this.nativeHandle);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getExitCode() : Got return code: " + n);
        }
        return n;
    }

    public boolean ping() throws ProcessOpException {
        return this.isAlive();
    }

    public boolean isAlive() throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ping() : Checking to see if a process exists.");
        }
        if (this.released) {
            throw new ProcessOpException("Process Object already released.  No further calls allowed.");
        }
        this.checkNativeHandle();
        int n = UnixProcessGlue.ping(this.nativeHandle);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ping() : Done with existance check");
        }
        return n != 0;
    }

    public void stop() throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop() : Requesting to kill a running process.");
        }
        if (this.released) {
            throw new ProcessOpException("Process Object already released.  No further calls allowed.");
        }
        this.checkNativeHandle();
        UnixProcessGlue.stop(this.nativeHandle);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop() : Done STOP_PROCESS operation.");
        }
    }

    public void release() throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "release() : Doing finalization on process object.");
        }
        if (this.released) {
            throw new ProcessOpException("Process Object already released.  No further calls allowed.");
        }
        this.checkNativeHandle();
        this.released = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "release() : Done with finalization on process object.");
        }
    }

    protected void checkNativeHandle() throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkNativeHandle() : Checking validity of nativeHandle.");
        }
        if (this.nativeHandle == 0) {
            throw new ProcessOpException("Invalid process object.  nativeHandle (pointer) is 'null'");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkNativeHandle() : Done checking validity of nativeHandle.  Appears valid.");
        }
    }

    public void generateJVMDump() throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateJVMDump() : Attempting to cause JVM Thread Dump.");
        }
        if (this.released) {
            throw new ProcessOpException("Process Object already released.  No further calls allowed.");
        }
        this.checkNativeHandle();
        UnixProcessGlue.pokeVMThreadDump(this.nativeHandle);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateJVMDump() : Done attempting to cause JVM Thread Dump.");
        }
    }

    protected void finalize() throws Throwable {
        if (!this.released && this.nativeHandle != 0) {
            this.release();
        }
        if (this.nativeHandle != 0) {
            UnixProcessGlue.done(this.nativeHandle);
            this.nativeHandle = 0;
        }
        super.finalize();
    }

    protected static String getXString(String string) {
        if (resourceBundle == null) {
            resourceBundle = ResourceBundle.getBundle(resourceBundlePackage);
        }
        String string2 = resourceBundle != null ? resourceBundle.getString(string) : string;
        return string2;
    }

    protected static String getXFormattedString(String string, Object[] objectArray) {
        String string2;
        if (resourceBundle == null) {
            resourceBundle = ResourceBundle.getBundle(resourceBundlePackage);
        }
        if (resourceBundle != null) {
            string2 = resourceBundle.getString(string);
            string2 = MessageFormat.format(string2, objectArray);
        } else {
            string2 = string;
        }
        return string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

