/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.process;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.process.CreationParams;
import com.ibm.ws.process.Process;
import com.ibm.ws.process.ProcessObjectFactory;
import com.ibm.ws.process.Win32ProcessGlue;
import com.ibm.ws.process.exception.InvalidDirectoryException;
import com.ibm.ws.process.exception.InvalidExecutableException;
import com.ibm.ws.process.exception.InvalidFileException;
import com.ibm.ws.process.exception.InvalidGroupException;
import com.ibm.ws.process.exception.InvalidPriorityException;
import com.ibm.ws.process.exception.InvalidProcessGroupException;
import com.ibm.ws.process.exception.InvalidUsernameException;
import com.ibm.ws.process.exception.OutOfFileHandlesException;
import com.ibm.ws.process.exception.OutOfMemoryException;
import com.ibm.ws.process.exception.ProcessHasExitedException;
import com.ibm.ws.process.exception.ProcessOpException;
import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class Win32ProcessImpl
implements Process,
ProcessObjectFactory {
    private static TraceComponent tc = Tr.register(class$com$ibm$ws$process$Win32ProcessImpl == null ? (class$com$ibm$ws$process$Win32ProcessImpl = Win32ProcessImpl.class$("com.ibm.ws.process.Win32ProcessImpl")) : class$com$ibm$ws$process$Win32ProcessImpl);
    protected int nativeHandle = 0;
    protected boolean released = false;
    private static ResourceBundle resourceBundle = null;
    private static final String resourceBundlePackage = "com.ibm.ws.process.processmessages";
    static /* synthetic */ Class class$com$ibm$ws$process$Win32ProcessImpl;

    public Process create(CreationParams creationParams) throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create() : Calling for a process create.");
        }
        Win32ProcessImpl win32ProcessImpl = new Win32ProcessImpl();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "create() : Creation params are: " + creationParams.toString());
        }
        try {
            win32ProcessImpl.nativeHandle = Win32ProcessGlue.create(Win32ProcessImpl.getCmdlineInBytes(creationParams), creationParams.getEnvironment(), Win32ProcessImpl.getWorkingDirectoryInBytes(creationParams), creationParams.getProcessPriority(), creationParams.getStdFileNames(), creationParams.getInheritParentStreams());
        }
        catch (Exception exception) {
            ProcessOpException processOpException = new ProcessOpException(exception.toString());
            if (exception instanceof InvalidUsernameException) {
                String string = Win32ProcessImpl.getXFormattedString("PROC0001E", new Object[]{creationParams.getUserId()});
                processOpException = new InvalidUsernameException(string);
            } else if (exception instanceof InvalidGroupException) {
                String string = Win32ProcessImpl.getXFormattedString("PROC0002E", new Object[]{creationParams.getGroupId()});
                processOpException = new InvalidGroupException(string);
            } else if (exception instanceof InvalidDirectoryException) {
                String string = Win32ProcessImpl.getXFormattedString("PROC0003E", new Object[]{creationParams.getWorkingDirectory()});
                processOpException = new InvalidDirectoryException(string);
            } else if (exception instanceof InvalidExecutableException) {
                String string = Win32ProcessImpl.getXFormattedString("PROC0004E", new Object[]{creationParams.getExecutable()});
                processOpException = new InvalidExecutableException(string);
            } else if (exception instanceof InvalidPriorityException) {
                String string = Win32ProcessImpl.getXFormattedString("PROC0005E", new Object[]{new Integer(creationParams.getProcessPriority())});
                processOpException = new InvalidPriorityException(string);
            } else if (exception instanceof InvalidProcessGroupException) {
                String string = Win32ProcessImpl.getXFormattedString("PROC0006E", new Object[]{new Integer(creationParams.getProcessGroupId())});
                processOpException = new InvalidGroupException(string);
            } else if (exception instanceof InvalidFileException) {
                String string = Win32ProcessImpl.getXString("PROC0007E");
                processOpException = new InvalidFileException(string);
            } else if (exception instanceof OutOfFileHandlesException) {
                String string = Win32ProcessImpl.getXString("PROC0008E");
                processOpException = new OutOfFileHandlesException(string);
            } else if (exception instanceof OutOfMemoryException) {
                String string = Win32ProcessImpl.getXString("PROC0009E");
                processOpException = new OutOfMemoryException(string);
            }
            throw processOpException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create() : Done with process create.");
        }
        return win32ProcessImpl;
    }

    public Process bindTo(String string) throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bindTo() : Calling for a process rebind.");
        }
        Win32ProcessImpl win32ProcessImpl = new Win32ProcessImpl();
        try {
            win32ProcessImpl.nativeHandle = Win32ProcessGlue.recreate(string);
        }
        catch (Exception exception) {
            ProcessOpException processOpException = new ProcessOpException(exception.toString());
            if (exception instanceof ProcessHasExitedException) {
                String string2 = Win32ProcessImpl.getXFormattedString("PROC0010E", new Object[]{string});
                processOpException = new ProcessHasExitedException(string2);
            }
            throw processOpException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "bindTo() : Done with process rebind.");
        }
        return win32ProcessImpl;
    }

    public Process createSelf() throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createSelf() : Calling for a process create of myself.");
        }
        Win32ProcessImpl win32ProcessImpl = new Win32ProcessImpl();
        win32ProcessImpl.nativeHandle = Win32ProcessGlue.createSelf();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createSelf() : Done with process create of myself.");
        }
        return win32ProcessImpl;
    }

    public String id() throws ProcessOpException {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "id() : Obtaining process ID.");
        }
        if (!this.released) {
            try {
                this.checkNativeHandle();
                string = Win32ProcessGlue.id(this.nativeHandle);
            }
            catch (ProcessOpException processOpException) {
                FFDCFilter.processException((Throwable)processOpException, "com.ibm.ws.process.Win32ProcessImpl.id", "199", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Bad nativeHandle, returning PID: 0:");
                }
                return "0";
            }
        } else {
            throw new ProcessOpException("Process Object already released.  No further calls allowed.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "id() : Obtained process ID: " + string);
        }
        return string;
    }

    public void waitForTermination() throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "waitForTermination() : Requesting to wait for process termination");
        }
        if (this.released) {
            throw new ProcessOpException("Process Object already released.  No further calls allowed.");
        }
        this.checkNativeHandle();
        Win32ProcessGlue.waitForTermination(this.nativeHandle);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "waitForTermination() : Done with waiting for process termination");
        }
    }

    public void waitForTermination(int n) throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "waitForTermination() : Requesting to wait for process termination over a set time.");
        }
        if (this.released) {
            throw new ProcessOpException("Process Object already released.  No further calls allowed.");
        }
        this.checkNativeHandle();
        Win32ProcessGlue.waitForTerminationWithTimeout(this.nativeHandle, n);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "waitForTermination() : Done with waiting for process termination");
        }
    }

    public int getExitCode() throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getExitCode() : Getting process exitCode (Return code)");
        }
        if (this.released) {
            throw new ProcessOpException("Process Object already released.  No further calls allowed.");
        }
        this.checkNativeHandle();
        int n = Win32ProcessGlue.getExitCode(this.nativeHandle);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getExitCode() : Got return code: " + n);
        }
        return n;
    }

    public boolean ping() throws ProcessOpException {
        return this.isAlive();
    }

    public boolean isAlive() throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ping() : Checking to see if a process exists.");
        }
        if (this.released) {
            throw new ProcessOpException("Process Object already released.  No further calls allowed.");
        }
        this.checkNativeHandle();
        int n = Win32ProcessGlue.ping(this.nativeHandle);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ping() : Done with existance check");
        }
        return n != 0;
    }

    public void stop() throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop() : Requesting to kill a running process.");
        }
        if (this.released) {
            throw new ProcessOpException("Process Object already released.  No further calls allowed.");
        }
        this.checkNativeHandle();
        Win32ProcessGlue.stop(this.nativeHandle);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop() : Done STOP_PROCESS operation.");
        }
    }

    public void release() throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "release() : Doing finalization on process object.");
        }
        if (!this.released) {
            try {
                this.checkNativeHandle();
                this.released = true;
            }
            catch (ProcessOpException processOpException) {
                FFDCFilter.processException((Throwable)processOpException, "com.ibm.ws.process.Win32ProcessImpl.done", "304", this);
            }
        } else {
            throw new ProcessOpException("Process Object already released.  No further calls allowed.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "release() : Done with finalization on process object.");
        }
    }

    public void generateJVMDump() throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateJVMDump() : Attempting to cause JVM Thread Dump.");
        }
        if (this.released) {
            throw new ProcessOpException("Process Object already released.  No further calls allowed.");
        }
        this.checkNativeHandle();
        Win32ProcessGlue.pokeVMThreadDump(this.nativeHandle);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateJVMDump() : Done attempting to cause JVM Thread Dump.");
        }
    }

    protected void checkNativeHandle() throws ProcessOpException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkNativeHandle() : Checking validity of nativeHandle.");
        }
        if (this.nativeHandle == 0) {
            throw new ProcessOpException("Invalid process object.  nativeHandle (pointer) is 'null'");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkNativeHandle() : Done checking validity of nativeHandle.  Appears valid.");
        }
    }

    protected void finalize() throws Throwable {
        if (!this.released && this.nativeHandle != 0) {
            this.release();
        }
        if (this.nativeHandle != 0) {
            Win32ProcessGlue.done(this.nativeHandle);
            this.nativeHandle = 0;
        }
        super.finalize();
    }

    static byte[] getCmdlineInBytes(CreationParams creationParams) {
        StringBuffer stringBuffer = new StringBuffer(4096);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCmdLineInBytes() : Commandline conversion.");
        }
        byte[] byArray = null;
        stringBuffer.append(Win32ProcessImpl.processArg(Win32ProcessImpl.trimQuotes(creationParams.getExecutable())));
        String[] stringArray = creationParams.getCommandLineArgs();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) continue;
                stringBuffer.append(" ");
                stringBuffer.append(Win32ProcessImpl.processArg(Win32ProcessImpl.trimQuotes(stringArray[i])));
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Commandline called was: " + stringBuffer.toString());
        }
        stringBuffer.append('\u0000');
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCmdLineInBytes() : Done with commandline conversion.");
        }
        byArray = stringBuffer.toString().getBytes();
        return byArray;
    }

    private static String trimQuotes(String string) {
        int n = string.length();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "trimQuotes() : Stripping begin and end quotes off of initial arg if necessary");
        }
        if (n > 0 && string.charAt(0) == '\"' && string.charAt(n - 1) == '\"') {
            string = string.substring(1, n - 1);
            string = Win32ProcessImpl.trimQuotes(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "trimQuotes() : Done processing");
        }
        return string;
    }

    private static String processArg(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        int n = string.length();
        int n2 = 0;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processArg() : Escaping and examining args.");
        }
        if (string.indexOf(" ") != -1) {
            bl = true;
            stringBuffer.append('\"');
        }
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                ++n2;
                if (i + 1 < n && string.charAt(i + 1) == '\"') {
                    stringBuffer.append('\\');
                }
            } else {
                n2 = 0;
            }
            if (c == '\"') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
        }
        while (n2-- > 0) {
            stringBuffer.append('\\');
        }
        if (bl) {
            stringBuffer.append('\"');
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processArg() : Done escaping and examining args.");
        }
        return stringBuffer.toString();
    }

    private static byte[] getWorkingDirectoryInBytes(CreationParams creationParams) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWorkingDirectoryInBytes() : Getting byte array of working directory.");
        }
        String string = creationParams.getWorkingDirectory();
        byte[] byArray = null;
        if (string != null) {
            File file = new File(string);
            byArray = (file.getAbsolutePath() + '\u0000').getBytes();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getWorkingDirectoryInBytes() : Directory is: " + file.getAbsolutePath());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWorkingDirectoryInBytes() : Got byte array of working directory.");
        }
        return byArray;
    }

    protected static String getXString(String string) {
        if (resourceBundle == null) {
            resourceBundle = ResourceBundle.getBundle(resourceBundlePackage);
        }
        String string2 = resourceBundle != null ? resourceBundle.getString(string) : string;
        return string2;
    }

    protected static String getXFormattedString(String string, Object[] objectArray) {
        String string2;
        if (resourceBundle == null) {
            resourceBundle = ResourceBundle.getBundle(resourceBundlePackage);
        }
        if (resourceBundle != null) {
            string2 = resourceBundle.getString(string);
            string2 = MessageFormat.format(string2, objectArray);
        } else {
            string2 = string;
        }
        return string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

