/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractMidiDevice;
import com.sun.media.sound.AbstractMidiDeviceProvider;
import com.sun.media.sound.FastShortMessage;
import com.sun.media.sound.FastSysexMessage;
import java.util.Vector;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;

class MidiOutDevice
extends AbstractMidiDevice {
    private Vector receivers = new Vector();

    MidiOutDevice(AbstractMidiDeviceProvider.Info info) {
        super(info);
    }

    synchronized void implOpen() throws MidiUnavailableException {
        this.id = this.nOpen(((AbstractMidiDeviceProvider.Info)this.getDeviceInfo()).getIndex());
        if (this.id == 0L) {
            throw new MidiUnavailableException("Unable to open native device");
        }
    }

    synchronized void implClose() {
        long l = this.id;
        this.id = 0L;
        for (int i = 0; i < this.receivers.size(); ++i) {
            ((Receiver)this.receivers.elementAt(i)).close();
        }
        this.receivers.removeAllElements();
        this.nClose(l);
    }

    public int getMaxReceivers() {
        return -1;
    }

    public synchronized Receiver getReceiver() throws MidiUnavailableException {
        MidiOutReceiver midiOutReceiver = new MidiOutReceiver();
        this.receivers.addElement(midiOutReceiver);
        return midiOutReceiver;
    }

    private native long nOpen(int var1) throws MidiUnavailableException;

    private native void nClose(long var1);

    private native void nSendShortMessage(long var1, int var3, long var4);

    private native void nSendLongMessage(long var1, byte[] var3, int var4, long var5);

    class MidiOutReceiver
    implements Receiver {
        private boolean open = true;

        MidiOutReceiver() {
        }

        public synchronized void send(MidiMessage midiMessage, long l) {
            if (this.open) {
                int n = midiMessage.getLength();
                if (n <= 3) {
                    int n2;
                    if (midiMessage instanceof ShortMessage) {
                        if (midiMessage instanceof FastShortMessage) {
                            n2 = ((FastShortMessage)midiMessage).getPackedMsg();
                        } else {
                            ShortMessage shortMessage = (ShortMessage)midiMessage;
                            n2 = shortMessage.getStatus() & 0xFF | (shortMessage.getData1() & 0xFF) << 8 | (shortMessage.getData2() & 0xFF) << 16;
                        }
                    } else {
                        n2 = 0;
                        byte[] byArray = midiMessage.getMessage();
                        if (n > 0) {
                            n2 = byArray[0] & 0xFF;
                            if (n > 1) {
                                n2 |= (byArray[1] & 0xFF) << 8;
                                if (n > 2) {
                                    n2 |= (byArray[2] & 0xFF) << 16;
                                }
                            }
                        }
                    }
                    MidiOutDevice.this.nSendShortMessage(MidiOutDevice.this.id, n2, l);
                } else if (midiMessage instanceof FastSysexMessage) {
                    MidiOutDevice.this.nSendLongMessage(MidiOutDevice.this.id, ((FastSysexMessage)midiMessage).getReadOnlyMessage(), n, l);
                } else {
                    MidiOutDevice.this.nSendLongMessage(MidiOutDevice.this.id, midiMessage.getMessage(), n, l);
                }
            }
        }

        public void close() {
            MidiOutDevice.this.receivers.removeElement(this);
            this.open = false;
        }
    }
}

