/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import com.ibm.jvm.io.LocalizedInputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import java.util.Properties;
import sun.awt.SunToolkit;
import sun.awt.font.NativeFontWrapper;
import sun.io.CharacterEncoding;

public abstract class FontProperties
extends Properties {
    protected static String osVersion;
    protected static String osName;
    private static boolean usesPlatformFont;
    private static final String[] fontNames;
    static final /* synthetic */ boolean $assertionsDisabled;

    public FontProperties() {
        super(FontProperties.getDefaultFontProperties());
        this.setOsNameAndVersion();
        this.initializeProperties();
    }

    private void initializeProperties() {
        Object object;
        try {
            usesPlatformFont = NativeFontWrapper.usePlatformFontMetrics();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string = System.getProperty("user.home");
        String string2 = System.getProperty("java.home");
        if (string2 == null) {
            throw new Error("java.home property not set");
        }
        Locale locale = SunToolkit.getStartupLocale();
        String string3 = locale.getLanguage();
        String string4 = locale.getCountry();
        string3 = string3.toLowerCase();
        String string5 = System.getProperty("file.encoding");
        String string6 = CharacterEncoding.aliasName((String)string5);
        if (string6 == null) {
            string6 = string5;
        }
        if (osVersion == null) {
            osVersion = System.getProperty("os.version");
        }
        String string7 = usesPlatformFont ? "native" + File.separator : "";
        String string8 = string2 + File.separator + "lib" + File.separator + string7 + "fprop.dir";
        File file = new File(string8);
        Properties properties = null;
        if (file.exists()) {
            properties = new Properties();
            try {
                object = new BufferedInputStream(LocalizedInputStream.localize((InputStream)new FileInputStream(file.getPath())));
                properties.load((InputStream)object);
                ((InputStream)object).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            object = null;
            object = this.tryOpeningFontProp((File)object, properties, string2, string3, string4, string6, osVersion);
            object = this.tryOpeningFontProp((File)object, properties, string2, string3, string4, string6, null);
            object = this.tryOpeningFontProp((File)object, properties, string2, string3, string4, null, osVersion);
            object = this.tryOpeningFontProp((File)object, properties, string2, string3, null, string6, osVersion);
            object = this.tryOpeningFontProp((File)object, properties, string2, string3, string4, null, null);
            if ("zh".equals(string3) && ("TW".equals(string4) || "MO".equals(string4))) {
                object = this.tryOpeningFontProp((File)object, properties, string2, string3, "TW", null, null);
            }
            object = this.tryOpeningFontProp((File)object, properties, string2, null, string4, null, null);
            object = this.tryOpeningFontProp((File)object, properties, string2, string3, null, string6, null);
            object = this.tryOpeningFontProp((File)object, properties, string2, string3, null, null, osVersion);
            object = this.tryOpeningFontProp((File)object, properties, string2, null, null, string6, osVersion);
            object = this.tryOpeningFontProp((File)object, properties, string2, string3, null, null, null);
            object = this.tryOpeningFontProp((File)object, properties, string2, null, null, string6, null);
            object = this.tryOpeningFontProp((File)object, properties, string2, null, null, null, osVersion);
            if ((object = this.tryOpeningFontProp((File)object, properties, string2, null, null, null, null)) != null) {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(LocalizedInputStream.localize((InputStream)new FileInputStream(((File)object).getPath())));
                this.load(bufferedInputStream);
                ((InputStream)bufferedInputStream).close();
                if (("ja".equals(string3) || "zh".equals(string3) || "ko".equals(string3) || "iw".equals(string3) || "th".equals(string3) || "hi".equals(string3)) && this.isOriginalFP((File)object)) {
                    this.put("_PLSF_LANGUAGE", string3);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private File tryOpeningFontProp(File file, Properties properties, String string, String string2, String string3, String string4, String string5) {
        if (file != null) {
            return file;
        }
        String string6 = usesPlatformFont ? "native" + File.separator : "";
        String string7 = "font.properties";
        String string8 = null;
        string8 = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("ibm.jvm.fontproperties.dir");
            }
        });
        String string9 = string8 != null ? string8 + File.separator : string + File.separator + "lib" + File.separator + string6;
        string7 = this.getPropsFilename(string7, string2, string3, string4, string5);
        if (properties != null) {
            string7 = properties.getProperty(string7);
        }
        if (string7 != null && (file = new File(string9 + string7)).canRead()) {
            return file;
        }
        return null;
    }

    private static Properties getDefaultFontProperties() {
        Properties properties = new Properties();
        properties.put("serif.0", "unknown");
        properties.put("sansserif.0", "unknown");
        properties.put("monospaced.0", "unknown");
        properties.put("dialog.0", "unknown");
        properties.put("dialoginput.0", "unknown");
        properties.put("default.0", "sansserif");
        properties.put("timesroman.0", "serif");
        properties.put("helvetica.0", "sansserif");
        properties.put("courier.0", "monospaced");
        properties.put("zapfdingbats.0", "unknown");
        return properties;
    }

    private String getPropsFilename(String string, String string2, String string3, String string4, String string5) {
        if (string2 != null) {
            string = string + "." + string2;
            if (string3 != null) {
                string = string + "_" + string3;
                if (string4 != null) {
                    string = string + "_" + string4;
                    if (string5 != null) {
                        string = string + "." + string5;
                    }
                } else if (string5 != null) {
                    string = string + "." + string5;
                }
            } else if (string4 != null) {
                string = string + "_" + string4;
                if (string5 != null) {
                    string = string + "." + string5;
                }
            } else if (string5 != null) {
                string = string + "." + string5;
            }
        } else {
            if (string3 != null) {
                string = string + "." + string3;
            }
            if (string4 != null) {
                string = string + "." + string4;
                if (string5 != null) {
                    string = string + "." + string5;
                }
            } else if (string5 != null) {
                string = string + "." + string5;
            }
        }
        return string;
    }

    protected void setOsNameAndVersion() {
        osName = System.getProperty("os.name");
        osVersion = System.getProperty("os.version");
    }

    public static boolean isLogicalFontFamilyName(String string) {
        string = string.toLowerCase(Locale.ENGLISH);
        for (int i = 0; i < fontNames.length; ++i) {
            if (!string.equals(fontNames[i])) continue;
            return true;
        }
        return false;
    }

    public String getAliasedFamilyName(String string) {
        if (!$assertionsDisabled && FontProperties.isLogicalFontFamilyName(string)) {
            throw new AssertionError();
        }
        string = string.toLowerCase(Locale.ENGLISH);
        String string2 = this.getProperty("alias." + string);
        if (string2 != null) {
            for (int i = 0; i < fontNames.length; ++i) {
                if (!string2.equals(fontNames[i])) continue;
                return string2;
            }
        }
        return null;
    }

    public abstract String getFallbackFamilyName(String var1, String var2);

    protected String getCompatibilityFamilyName(String string) {
        if ((string = string.toLowerCase(Locale.ENGLISH)).equals("timesroman")) {
            return "serif";
        }
        if (string.equals("helvetica")) {
            return "sansserif";
        }
        if (string.equals("courier")) {
            return "monospaced";
        }
        return null;
    }

    protected boolean isOriginalFP(File file) {
        return false;
    }

    public boolean supportPLSF() {
        return false;
    }

    public FontProperties applyPreferLocaleSpecificFonts(FontProperties fontProperties) {
        return this;
    }

    static {
        $assertionsDisabled = !FontProperties.class.desiredAssertionStatus();
        usesPlatformFont = false;
        fontNames = new String[]{"serif", "sansserif", "monospaced", "dialog", "dialoginput"};
    }
}

