/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import java.util.HashMap;
import sun.awt.DebugHelper;
import sun.awt.windows.WToolkit;

class WDesktopProperties {
    private static final DebugHelper dbg = DebugHelper.create(WDesktopProperties.class);
    private static final String PREFIX = "win.";
    private static final String PROP_NAMES = "win.propNames";
    private long pData;
    private PropertyChangeSupport prChgSupport = new PropertyChangeSupport(this);
    private WToolkit wToolkit;
    private HashMap map = new HashMap();

    private static native void initIDs();

    static boolean isWindowsProperty(String string) {
        return string.startsWith(PREFIX);
    }

    WDesktopProperties(WToolkit wToolkit) {
        this.wToolkit = wToolkit;
        this.init();
        this.getWindowsParameters();
    }

    protected native void finalize();

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        this.prChgSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        this.prChgSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    private native void init();

    synchronized Object getProperty(String string) {
        if (string.equals(PROP_NAMES)) {
            return this.getKeyNames();
        }
        return this.map.get(string);
    }

    private String[] getKeyNames() {
        Object[] objectArray = this.map.keySet().toArray();
        Object[] objectArray2 = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i] = objectArray[i].toString();
        }
        Arrays.sort(objectArray2);
        return objectArray2;
    }

    private native void getWindowsParameters();

    private synchronized void setBooleanProperty(String string, boolean bl) {
        this.map.put(string, new Boolean(bl));
    }

    private synchronized void setIntegerProperty(String string, int n) {
        this.map.put(string, new Integer(n));
    }

    private synchronized void setStringProperty(String string, String string2) {
        this.map.put(string, string2);
    }

    private synchronized void setColorProperty(String string, int n, int n2, int n3) {
        Color color = new Color(n, n2, n3);
        this.map.put(string, color);
    }

    private synchronized void setFontProperty(String string, String string2, int n, int n2) {
        Font font = new Font(string2, n, n2);
        this.map.put(string, font);
        String string3 = string + ".height";
        Integer n3 = new Integer(n2);
        this.map.put(string3, n3);
    }

    private synchronized void setSoundProperty(String string, String string2) {
        WinPlaySound winPlaySound = new WinPlaySound(string2);
        this.map.put(string, winPlaySound);
    }

    private native void playWindowsSound(String var1);

    synchronized void firePropertyChanges() {
        EventQueue.invokeLater(new DiffPropertyChanges());
    }

    private synchronized void diffPropertyChanges() {
        HashMap hashMap = this.map;
        this.map = new HashMap();
        this.getWindowsParameters();
        String[] stringArray = this.getKeyNames();
        for (int i = 0; i < stringArray.length; ++i) {
            Object v;
            String string = stringArray[i];
            Object v2 = hashMap.get(string);
            if (v2 == null == ((v = this.map.get(string)) == null) && (v2 == null || v2.equals(v))) continue;
            this.wToolkit.clearDesktopProperty(string);
            this.prChgSupport.firePropertyChange(string, v2, v);
        }
    }

    static {
        WDesktopProperties.initIDs();
    }

    class DiffPropertyChanges
    implements Runnable {
        DiffPropertyChanges() {
        }

        public void run() {
            WDesktopProperties.this.diffPropertyChanges();
        }
    }

    class WinPlaySound
    implements Runnable {
        String winEventName;

        WinPlaySound(String string) {
            this.winEventName = string;
        }

        public void run() {
            WDesktopProperties.this.playWindowsSound(this.winEventName);
        }

        public String toString() {
            return "WinPlaySound(" + this.winEventName + ")";
        }
    }
}

