/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.security.AccessController;
import sun.awt.Win32GraphicsConfig;
import sun.awt.Win32GraphicsDevice;
import sun.awt.windows.D3DBlitLoops;
import sun.awt.windows.WVolatileImage;
import sun.awt.windows.Win32BlitLoops;
import sun.awt.windows.Win32D3DRenderer;
import sun.awt.windows.Win32DDRenderer;
import sun.awt.windows.Win32OffScreenImage;
import sun.awt.windows.Win32PeerlessImage;
import sun.awt.windows.Win32ScaleLoops;
import sun.awt.windows.Win32SurfaceData;
import sun.java2d.InvalidPipeException;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.loops.RenderLoops;
import sun.java2d.loops.SurfaceType;
import sun.java2d.pipe.PixelToShapeConverter;
import sun.security.action.GetPropertyAction;

public class Win32OffScreenSurfaceData
extends SurfaceData {
    int width;
    int height;
    int transparency;
    private GraphicsConfiguration graphicsConfig;
    private Image image;
    private static boolean forceDDVram;
    private RenderLoops solidloops;
    private static boolean d3dEnabled;
    private boolean localD3dEnabled = true;
    protected boolean d3dClippingEnabled = false;
    private static boolean ddScaleEnabled;
    private boolean ddSurfacePunted = false;
    private static int textureBpp;
    static boolean directXInitialized;
    protected static Win32D3DRenderer d3dNoClipPipe;
    protected static Win32D3DRenderer d3dClipPipe;
    protected static Win32DDRenderer ddPipe;
    protected static PixelToShapeConverter d3dTxNoClipPipe;
    protected static PixelToShapeConverter d3dTxClipPipe;
    protected static PixelToShapeConverter ddTxPipe;
    protected Win32D3DRenderer d3dPipe = null;
    protected PixelToShapeConverter d3dTxPipe = null;

    private static native void initDDraw(boolean var0);

    private static native boolean enableD3D(boolean var0);

    private static native void initIDs();

    public static void initD3D() {
        if (!directXInitialized) {
            boolean bl = false;
            directXInitialized = true;
            String string = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.d3d"));
            String string2 = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.d3dtexbpp"));
            if (string != null) {
                if (string.equals("true") || string.equals("t")) {
                    bl = true;
                    d3dEnabled = true;
                } else if (string.equals("false") || string.equals("f")) {
                    d3dEnabled = false;
                }
            }
            if (string2 != null) {
                try {
                    int n = Integer.parseInt(string2);
                    if (n == 32 || n == 16) {
                        textureBpp = n;
                        System.out.println("Texture bpp is set to " + textureBpp);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (d3dEnabled && (d3dEnabled = Win32OffScreenSurfaceData.enableD3D(bl))) {
                D3DBlitLoops.register();
            }
        }
    }

    public static SurfaceType getSurfaceType(ColorModel colorModel, int n) {
        if (n == 3) {
            if (colorModel.getPixelSize() == 16) {
                return Win32SurfaceData.Ushort4444ArgbD3D;
            }
            return Win32SurfaceData.IntArgbD3D;
        }
        boolean bl = n == 2;
        switch (colorModel.getPixelSize()) {
            case 24: 
            case 32: {
                if (colorModel instanceof DirectColorModel) {
                    if (((DirectColorModel)colorModel).getRedMask() == 0xFF0000) {
                        return bl ? Win32SurfaceData.IntRgbDD_BM : Win32SurfaceData.IntRgbDD;
                    }
                    return bl ? Win32SurfaceData.IntRgbxDD_BM : Win32SurfaceData.IntRgbxDD;
                }
                return bl ? Win32SurfaceData.ThreeByteBgrDD_BM : Win32SurfaceData.ThreeByteBgrDD;
            }
            case 15: {
                return bl ? Win32SurfaceData.Ushort555RgbDD_BM : Win32SurfaceData.Ushort555RgbDD;
            }
            case 16: {
                if (colorModel instanceof DirectColorModel && ((DirectColorModel)colorModel).getBlueMask() == 62) {
                    return bl ? Win32SurfaceData.Ushort555RgbxDD_BM : Win32SurfaceData.Ushort555RgbxDD;
                }
                return bl ? Win32SurfaceData.Ushort565RgbDD_BM : Win32SurfaceData.Ushort565RgbDD;
            }
            case 8: {
                if (colorModel.getColorSpace().getType() == 6 && colorModel instanceof ComponentColorModel) {
                    return bl ? Win32SurfaceData.ByteGrayDD_BM : Win32SurfaceData.ByteGrayDD;
                }
                if (colorModel instanceof IndexColorModel && Win32OffScreenSurfaceData.isOpaqueGray((IndexColorModel)colorModel)) {
                    return bl ? Win32SurfaceData.Index8GrayDD_BM : Win32SurfaceData.Index8GrayDD;
                }
                return bl ? Win32SurfaceData.ByteIndexedDD_BM : Win32SurfaceData.ByteIndexedOpaqueDD;
            }
        }
        throw new InvalidPipeException("Unsupported bit depth: " + colorModel.getPixelSize());
    }

    public static Win32OffScreenSurfaceData createData(int n, int n2, ColorModel colorModel, GraphicsConfiguration graphicsConfiguration, Image image, int n3) {
        if (!((Win32GraphicsDevice)graphicsConfiguration.getDevice()).isOffscreenAccelerationEnabled()) {
            return null;
        }
        if (n3 == 3) {
            colorModel = ((Win32PeerlessImage)image).getDeviceColorModel();
        }
        Win32OffScreenSurfaceData win32OffScreenSurfaceData = new Win32OffScreenSurfaceData(n, n2, Win32OffScreenSurfaceData.getSurfaceType(colorModel, n3), colorModel, graphicsConfiguration, image, n3);
        Win32GraphicsDevice win32GraphicsDevice = (Win32GraphicsDevice)graphicsConfiguration.getDevice();
        win32OffScreenSurfaceData.initSurface(colorModel.getPixelSize(), n, n2, win32GraphicsDevice.getScreen(), image instanceof WVolatileImage, n3, forceDDVram);
        if (win32OffScreenSurfaceData.d3dClippingEnabled) {
            win32OffScreenSurfaceData.d3dPipe = d3dClipPipe;
            win32OffScreenSurfaceData.d3dTxPipe = d3dTxClipPipe;
        } else {
            win32OffScreenSurfaceData.d3dPipe = d3dNoClipPipe;
            win32OffScreenSurfaceData.d3dTxPipe = d3dTxNoClipPipe;
        }
        return win32OffScreenSurfaceData;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void validatePipe(SunGraphics2D sunGraphics2D) {
        if (sunGraphics2D.antialiasHint != 2) {
            if (sunGraphics2D.paintState == 0) {
                if (sunGraphics2D.compositeState == 0) {
                    if (sunGraphics2D.clipState != 2) {
                        Win32DDRenderer win32DDRenderer;
                        PixelToShapeConverter pixelToShapeConverter;
                        if (d3dEnabled && this.localD3dEnabled) {
                            pixelToShapeConverter = this.d3dTxPipe;
                            win32DDRenderer = this.d3dPipe;
                        } else {
                            pixelToShapeConverter = ddTxPipe;
                            win32DDRenderer = ddPipe;
                        }
                        sunGraphics2D.imagepipe = imagepipe;
                        if (sunGraphics2D.transformState > 1) {
                            sunGraphics2D.drawpipe = pixelToShapeConverter;
                            sunGraphics2D.fillpipe = pixelToShapeConverter;
                        } else if (sunGraphics2D.strokeState != 0) {
                            sunGraphics2D.drawpipe = pixelToShapeConverter;
                            sunGraphics2D.fillpipe = win32DDRenderer;
                        } else {
                            sunGraphics2D.drawpipe = win32DDRenderer;
                            sunGraphics2D.fillpipe = win32DDRenderer;
                        }
                        sunGraphics2D.shapepipe = win32DDRenderer;
                        sunGraphics2D.textpipe = sunGraphics2D.textAntialiasHint == 2 ? aaTextRenderer : solidTextRenderer;
                        sunGraphics2D.loops = this.solidloops;
                        return;
                    }
                }
            }
        }
        super.validatePipe(sunGraphics2D);
    }

    public void disableD3D() {
        this.localD3dEnabled = false;
    }

    public static boolean isDDScaleEnabled() {
        return ddScaleEnabled;
    }

    public Raster getRaster(int n, int n2, int n3, int n4) {
        throw new InternalError("not implemented yet");
    }

    public void lock() {
    }

    public void unlock() {
    }

    public RenderLoops getRenderLoops(SunGraphics2D sunGraphics2D) {
        if (sunGraphics2D.paintState == 0) {
            if (sunGraphics2D.compositeState == 0) {
                return this.solidloops;
            }
        }
        return super.getRenderLoops(sunGraphics2D);
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return this.graphicsConfig;
    }

    private native void initOps(int var1, int var2);

    public native void initSurface(int var1, int var2, int var3, int var4, boolean var5, int var6, boolean var7);

    public native void restoreSurface();

    protected Win32OffScreenSurfaceData(int n, int n2, SurfaceType surfaceType, ColorModel colorModel, GraphicsConfiguration graphicsConfiguration, Image image, int n3) {
        super(surfaceType, colorModel);
        this.width = n;
        this.height = n2;
        this.graphicsConfig = graphicsConfiguration;
        this.image = image;
        this.initOps(colorModel.getPixelSize(), n3);
        this.transparency = n3;
        this.solidloops = ((Win32GraphicsConfig)graphicsConfiguration).getSolidLoops(surfaceType);
    }

    public int getTransparency() {
        return this.transparency;
    }

    public static int getTextureBpp() {
        return textureBpp;
    }

    public SurfaceData getReplacement() {
        if (this.image instanceof Win32OffScreenImage) {
            return ((Win32OffScreenImage)this.image).restoreContents();
        }
        if (this.image instanceof WVolatileImage) {
            return ((WVolatileImage)this.image).restoreContents();
        }
        return null;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.width, this.height);
    }

    private native void nativeInvalidate();

    public void invalidate() {
        if (this.isValid()) {
            this.nativeInvalidate();
            super.invalidate();
        }
    }

    public native void setTransparentPixel(int var1);

    public native void flush();

    public boolean surfacePunted() {
        return this.ddSurfacePunted;
    }

    static {
        String string;
        boolean bl;
        d3dEnabled = true;
        ddScaleEnabled = false;
        textureBpp = 32;
        directXInitialized = false;
        Win32OffScreenSurfaceData.initIDs();
        String string2 = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.noddraw"));
        String string3 = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.ddoffscreen"));
        String string4 = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.ddforcevram"));
        String string5 = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.ddblit"));
        String string6 = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.ddscale"));
        String string7 = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.offscreenSharing"));
        boolean bl2 = string3 != null && (string3.equals("false") || string3.equals("f"));
        forceDDVram = string4 != null && (string4.equals("true") || string4.equals("t"));
        boolean bl3 = string5 != null && (string5.equals("false") || string5.equals("f"));
        boolean bl4 = string6 == null || string6.equals("false") || string6.equals("f");
        boolean bl5 = bl = string7 != null && !string7.equals("false") && !string7.equals("f");
        if (bl) {
            System.out.println("Warning: offscreenSharing has been enabled. The use of this capability will change in future releases and applications that depend on it may not work correctly");
        }
        Win32OffScreenSurfaceData.initD3D();
        if (!(string2 != null || bl2 || (string = AccessController.doPrivileged(new GetPropertyAction("javax.accessibility.screen_magnifier_present"))) != null && string.equals("true"))) {
            Win32OffScreenSurfaceData.initDDraw(bl);
            if (!bl3) {
                Win32BlitLoops.register();
            } else {
                System.out.println("DirectDraw Blits disabled");
            }
            if (!bl4) {
                Win32ScaleLoops.register();
                ddScaleEnabled = true;
                System.out.println("DirectDraw Scaling enabled");
            }
            if (forceDDVram) {
                System.out.println("DirectDraw surfaces constrained to use vram");
            }
        }
        d3dNoClipPipe = new Win32D3DRenderer(false);
        d3dClipPipe = new Win32D3DRenderer(true);
        ddPipe = new Win32DDRenderer();
        if (GraphicsPrimitive.tracingEnabled()) {
            d3dNoClipPipe = d3dNoClipPipe.traceWrapD3D();
            d3dClipPipe = d3dClipPipe.traceWrapD3D();
            ddPipe = ddPipe.traceWrapDD();
        }
        d3dTxNoClipPipe = new PixelToShapeConverter(d3dNoClipPipe);
        d3dTxClipPipe = new PixelToShapeConverter(d3dClipPipe);
        ddTxPipe = new PixelToShapeConverter(ddPipe);
    }
}

