/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.loops;

import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.lang.ref.WeakReference;
import sun.java2d.SurfaceData;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.loops.GraphicsPrimitiveMgr;
import sun.java2d.loops.MaskBlit;
import sun.java2d.loops.RenderCache;
import sun.java2d.loops.SurfaceType;
import sun.java2d.pipe.Region;
import sun.java2d.pipe.SpanIterator;

public class Blit
extends GraphicsPrimitive {
    public static final String methodSignature = "Blit(...)".toString();
    public static final int primTypeID = Blit.makePrimTypeID();
    private static RenderCache blitcache = new RenderCache(20);

    public static Blit locate(SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
        return (Blit)GraphicsPrimitiveMgr.locate(primTypeID, surfaceType, compositeType, surfaceType2);
    }

    public static synchronized Blit getFromCache(SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
        Object object = blitcache.get(surfaceType, compositeType, surfaceType2);
        if (object != null) {
            return (Blit)object;
        }
        Blit blit = Blit.locate(surfaceType, compositeType, surfaceType2);
        if (blit == null) {
            System.out.println("blit loop not found for:");
            System.out.println("src:  " + surfaceType);
            System.out.println("comp: " + compositeType);
            System.out.println("dst:  " + surfaceType2);
        } else {
            blitcache.put(surfaceType, compositeType, surfaceType2, blit);
        }
        return blit;
    }

    protected Blit(SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
        super(methodSignature, primTypeID, surfaceType, compositeType, surfaceType2);
    }

    public Blit(long l, SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
        super(l, methodSignature, primTypeID, surfaceType, compositeType, surfaceType2);
    }

    public native void Blit(SurfaceData var1, SurfaceData var2, Composite var3, Region var4, int var5, int var6, int var7, int var8, int var9, int var10);

    public GraphicsPrimitive makePrimitive(SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
        if (compositeType.isDerivedFrom(CompositeType.Xor)) {
            GeneralXorBlit generalXorBlit = new GeneralXorBlit(surfaceType, compositeType, surfaceType2);
            this.setupGeneralBinaryOp(generalXorBlit);
            return generalXorBlit;
        }
        if (compositeType.isDerivedFrom(CompositeType.AnyAlpha)) {
            return new GeneralMaskBlit(surfaceType, compositeType, surfaceType2);
        }
        return AnyBlit.instance;
    }

    public GraphicsPrimitive traceWrap() {
        return new TraceBlit(this);
    }

    static {
        GraphicsPrimitiveMgr.registerGeneral(new Blit(null, null, null));
    }

    private static class TraceBlit
    extends Blit {
        Blit target;

        public TraceBlit(Blit blit) {
            super(blit.getSourceType(), blit.getCompositeType(), blit.getDestType());
            this.target = blit;
        }

        public GraphicsPrimitive traceWrap() {
            return this;
        }

        public void Blit(SurfaceData surfaceData, SurfaceData surfaceData2, Composite composite, Region region, int n, int n2, int n3, int n4, int n5, int n6) {
            TraceBlit.tracePrimitive(this.target);
            this.target.Blit(surfaceData, surfaceData2, composite, region, n, n2, n3, n4, n5, n6);
        }
    }

    private static class GeneralXorBlit
    extends Blit
    implements GraphicsPrimitive.GeneralBinaryOp {
        Blit convertsrc;
        Blit convertdst;
        Blit performop;
        Blit convertresult;
        WeakReference srcTmp;
        WeakReference dstTmp;

        public GeneralXorBlit(SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
            super(surfaceType, compositeType, surfaceType2);
        }

        public void setPrimitives(Blit blit, Blit blit2, GraphicsPrimitive graphicsPrimitive, Blit blit3) {
            this.convertsrc = blit;
            this.convertdst = blit2;
            this.performop = (Blit)graphicsPrimitive;
            this.convertresult = blit3;
        }

        public synchronized void Blit(SurfaceData surfaceData, SurfaceData surfaceData2, Composite composite, Region region, int n, int n2, int n3, int n4, int n5, int n6) {
            Region region2;
            int n7;
            int n8;
            SurfaceData surfaceData3;
            SurfaceData surfaceData4;
            int n9;
            int n10;
            SurfaceData surfaceData5;
            if (this.convertsrc == null) {
                surfaceData5 = surfaceData;
                n10 = n;
                n9 = n2;
            } else {
                surfaceData4 = null;
                if (this.srcTmp != null) {
                    surfaceData4 = (SurfaceData)this.srcTmp.get();
                }
                surfaceData5 = GeneralXorBlit.convertFrom(this.convertsrc, surfaceData, n, n2, n5, n6, surfaceData4);
                n10 = 0;
                n9 = 0;
                if (surfaceData5 != surfaceData4) {
                    this.srcTmp = new WeakReference<SurfaceData>(surfaceData5);
                }
            }
            if (this.convertdst == null) {
                surfaceData3 = surfaceData2;
                n8 = n3;
                n7 = n4;
                region2 = region;
            } else {
                surfaceData4 = null;
                if (this.dstTmp != null) {
                    surfaceData4 = (SurfaceData)this.dstTmp.get();
                }
                surfaceData3 = GeneralXorBlit.convertFrom(this.convertdst, surfaceData2, n3, n4, n5, n6, surfaceData4);
                n8 = 0;
                n7 = 0;
                region2 = null;
                if (surfaceData3 != surfaceData4) {
                    this.dstTmp = new WeakReference<SurfaceData>(surfaceData3);
                }
            }
            this.performop.Blit(surfaceData5, surfaceData3, composite, region2, n10, n9, n8, n7, n5, n6);
            if (this.convertresult != null) {
                GeneralXorBlit.convertTo(this.convertresult, surfaceData3, surfaceData2, region, n3, n4, n5, n6);
            }
        }
    }

    private static class GeneralMaskBlit
    extends Blit {
        MaskBlit performop;

        public GeneralMaskBlit(SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
            super(surfaceType, compositeType, surfaceType2);
            this.performop = MaskBlit.locate(surfaceType, compositeType, surfaceType2);
        }

        public void Blit(SurfaceData surfaceData, SurfaceData surfaceData2, Composite composite, Region region, int n, int n2, int n3, int n4, int n5, int n6) {
            this.performop.MaskBlit(surfaceData, surfaceData2, composite, region, n, n2, n3, n4, n5, n6, null, 0, 0);
        }
    }

    private static class AnyBlit
    extends Blit {
        public static AnyBlit instance = new AnyBlit();

        public AnyBlit() {
            super(SurfaceType.Any, CompositeType.Any, SurfaceType.Any);
        }

        public void Blit(SurfaceData surfaceData, SurfaceData surfaceData2, Composite composite, Region region, int n, int n2, int n3, int n4, int n5, int n6) {
            ColorModel colorModel = surfaceData.getColorModel();
            ColorModel colorModel2 = surfaceData2.getColorModel();
            CompositeContext compositeContext = composite.createContext(colorModel, colorModel2, new RenderingHints(null));
            Raster raster = surfaceData.getRaster(n, n2, n5, n6);
            WritableRaster writableRaster = (WritableRaster)surfaceData2.getRaster(n3, n4, n5, n6);
            if (region == null) {
                region = Region.getInstanceXYWH(n3, n4, n5, n6);
            }
            int[] nArray = new int[]{n3, n4, n3 + n5, n4 + n6};
            SpanIterator spanIterator = region.getSpanIterator(nArray);
            n -= n3;
            n2 -= n4;
            while (spanIterator.nextSpan(nArray)) {
                int n7 = nArray[2] - nArray[0];
                int n8 = nArray[3] - nArray[1];
                raster = raster.createChild(n + nArray[0], n2 + nArray[1], n7, n8, 0, 0, null);
                writableRaster = writableRaster.createWritableChild(nArray[0], nArray[1], n7, n8, 0, 0, null);
                compositeContext.compose(raster, writableRaster, writableRaster);
            }
            compositeContext.dispose();
        }
    }
}

