/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.tty;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.tools.example.debug.tty.AmbiguousMethodException;
import com.sun.tools.example.debug.tty.Env;
import com.sun.tools.example.debug.tty.EventRequestSpec;
import com.sun.tools.example.debug.tty.LineNotFoundException;
import com.sun.tools.example.debug.tty.MalformedMemberNameException;
import com.sun.tools.example.debug.tty.MessageOutput;
import com.sun.tools.example.debug.tty.ReferenceTypeSpec;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class BreakpointSpec
extends EventRequestSpec {
    String methodId;
    List methodArgs;
    int lineNumber;

    BreakpointSpec(ReferenceTypeSpec referenceTypeSpec, int n) {
        super(referenceTypeSpec);
        this.methodId = null;
        this.methodArgs = null;
        this.lineNumber = n;
    }

    BreakpointSpec(ReferenceTypeSpec referenceTypeSpec, String string, List list) throws MalformedMemberNameException {
        super(referenceTypeSpec);
        this.methodId = string;
        this.methodArgs = list;
        this.lineNumber = 0;
        if (!this.isValidMethodName(string)) {
            throw new MalformedMemberNameException(string);
        }
    }

    EventRequest resolveEventRequest(ReferenceType referenceType) throws AmbiguousMethodException, AbsentInformationException, InvalidTypeException, NoSuchMethodException, LineNotFoundException {
        Location location = this.location(referenceType);
        if (location == null) {
            throw new InvalidTypeException();
        }
        EventRequestManager eventRequestManager = referenceType.virtualMachine().eventRequestManager();
        BreakpointRequest breakpointRequest = eventRequestManager.createBreakpointRequest(location);
        breakpointRequest.setSuspendPolicy(this.suspendPolicy);
        breakpointRequest.enable();
        return breakpointRequest;
    }

    String methodName() {
        return this.methodId;
    }

    int lineNumber() {
        return this.lineNumber;
    }

    List methodArgs() {
        return this.methodArgs;
    }

    boolean isMethodBreakpoint() {
        return this.methodId != null;
    }

    public int hashCode() {
        return ((Object)this.refSpec).hashCode() + this.lineNumber + (this.methodId != null ? this.methodId.hashCode() : 0) + (this.methodArgs != null ? ((Object)this.methodArgs).hashCode() : 0);
    }

    public boolean equals(Object object) {
        if (object instanceof BreakpointSpec) {
            BreakpointSpec breakpointSpec = (BreakpointSpec)object;
            return (this.methodId != null ? this.methodId.equals(breakpointSpec.methodId) : this.methodId == breakpointSpec.methodId) && (this.methodArgs != null ? ((Object)this.methodArgs).equals(breakpointSpec.methodArgs) : this.methodArgs == breakpointSpec.methodArgs) && ((Object)this.refSpec).equals(breakpointSpec.refSpec) && this.lineNumber == breakpointSpec.lineNumber;
        }
        return false;
    }

    String errorMessageFor(Exception exception) {
        if (exception instanceof AmbiguousMethodException) {
            return MessageOutput.format("Method is overloaded; specify arguments", this.methodName());
        }
        if (exception instanceof NoSuchMethodException) {
            return MessageOutput.format("No method in", new Object[]{this.methodName(), this.refSpec.toString()});
        }
        if (exception instanceof AbsentInformationException) {
            return MessageOutput.format("No linenumber information for", this.refSpec.toString());
        }
        if (exception instanceof LineNotFoundException) {
            return MessageOutput.format("No code at line", new Object[]{new Long(this.lineNumber()), this.refSpec.toString()});
        }
        if (exception instanceof InvalidTypeException) {
            return MessageOutput.format("Breakpoints can be located only in classes.", this.refSpec.toString());
        }
        return super.errorMessageFor(exception);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.refSpec.toString());
        if (this.isMethodBreakpoint()) {
            stringBuffer.append('.');
            stringBuffer.append(this.methodId);
            if (this.methodArgs != null) {
                Iterator iterator = this.methodArgs.iterator();
                boolean bl = true;
                stringBuffer.append('(');
                while (iterator.hasNext()) {
                    if (!bl) {
                        stringBuffer.append(',');
                    }
                    stringBuffer.append((String)iterator.next());
                    bl = false;
                }
                stringBuffer.append(")");
            }
        } else {
            stringBuffer.append(':');
            stringBuffer.append(this.lineNumber);
        }
        return MessageOutput.format("breakpoint", stringBuffer.toString());
    }

    private Location location(ReferenceType referenceType) throws AmbiguousMethodException, AbsentInformationException, NoSuchMethodException, LineNotFoundException {
        Location location = null;
        if (this.isMethodBreakpoint()) {
            Method method = this.findMatchingMethod(referenceType);
            location = method.location();
        } else {
            List list = referenceType.locationsOfLine(this.lineNumber());
            if (list.size() == 0) {
                throw new LineNotFoundException();
            }
            location = (Location)list.get(0);
            if (location.method() == null) {
                throw new LineNotFoundException();
            }
        }
        return location;
    }

    private boolean isValidMethodName(String string) {
        return this.isJavaIdentifier(string) || string.equals("<init>") || string.equals("<clinit>");
    }

    private boolean compareArgTypes(Method method, List list) {
        List list2 = method.argumentTypeNames();
        if (list2.size() != list.size()) {
            return false;
        }
        for (int i = 0; i < list2.size(); ++i) {
            String string;
            String string2 = (String)list2.get(i);
            if (string2.equals(string = (String)list.get(i))) continue;
            return false;
        }
        return true;
    }

    private String normalizeArgTypeName(String string) {
        char c;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        string = string.trim();
        for (n = 0; n < string.length() && !Character.isWhitespace(c = string.charAt(n)) && c != '['; ++n) {
            stringBuffer.append(c);
        }
        while (n < string.length()) {
            c = string.charAt(n);
            if (c == '[' || c == ']') {
                stringBuffer2.append(c);
            } else if (!Character.isWhitespace(c)) {
                throw new IllegalArgumentException(MessageOutput.format("Invalid argument type name"));
            }
            ++n;
        }
        string = stringBuffer.toString();
        if (string.indexOf(46) == -1 || string.startsWith("*.")) {
            try {
                ReferenceType referenceType = Env.getReferenceTypeFromToken(string);
                if (referenceType != null) {
                    string = referenceType.name();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        string = string + stringBuffer2.toString();
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Method findMatchingMethod(ReferenceType referenceType) throws AmbiguousMethodException, NoSuchMethodException {
        Object object;
        Object object2;
        Iterator iterator;
        ArrayList<String> arrayList = null;
        if (this.methodArgs() != null) {
            arrayList = new ArrayList<String>(this.methodArgs().size());
            iterator = this.methodArgs().iterator();
            while (iterator.hasNext()) {
                object2 = (String)iterator.next();
                object2 = this.normalizeArgTypeName((String)object2);
                arrayList.add((String)object2);
            }
        }
        iterator = referenceType.methods().iterator();
        object2 = null;
        Object object3 = null;
        int n = 0;
        while (iterator.hasNext()) {
            object = (Method)iterator.next();
            if (!object.name().equals(this.methodName())) continue;
            if (++n == 1) {
                object2 = object;
            }
            if (arrayList == null || !this.compareArgTypes((Method)object, arrayList)) continue;
            object3 = object;
            break;
        }
        object = null;
        if (object3 != null) {
            return object3;
        }
        if (arrayList != null) throw new NoSuchMethodException(this.methodName());
        if (n <= 0) throw new NoSuchMethodException(this.methodName());
        if (n != 1) throw new AmbiguousMethodException();
        return object2;
    }
}

