/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.v8.code;

import com.sun.tools.javac.v8.code.ClassFile;
import com.sun.tools.javac.v8.code.Code;
import com.sun.tools.javac.v8.code.Flags;
import com.sun.tools.javac.v8.code.Kinds;
import com.sun.tools.javac.v8.code.Pool;
import com.sun.tools.javac.v8.code.Scope;
import com.sun.tools.javac.v8.code.Symbol;
import com.sun.tools.javac.v8.code.Symtab;
import com.sun.tools.javac.v8.code.Target;
import com.sun.tools.javac.v8.code.Type;
import com.sun.tools.javac.v8.code.TypeTags;
import com.sun.tools.javac.v8.util.Context;
import com.sun.tools.javac.v8.util.Convert;
import com.sun.tools.javac.v8.util.FileEntry;
import com.sun.tools.javac.v8.util.Hashtable;
import com.sun.tools.javac.v8.util.List;
import com.sun.tools.javac.v8.util.ListBuffer;
import com.sun.tools.javac.v8.util.Log;
import com.sun.tools.javac.v8.util.Name;
import com.sun.tools.javac.v8.util.Options;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClassReader
extends ClassFile
implements Symbol.Completer,
Flags,
Kinds,
TypeTags {
    private static final Context.Key classReaderKey;
    public static final String pathSep;
    public boolean verbose;
    public boolean checkClassFile;
    public boolean readAllOfClassFile = false;
    private final Log log;
    private final Symtab syms;
    protected final Name.Table names;
    final Name completionFailureName;
    public String classPath;
    public String bootClassPath;
    public String sourceClassPath;
    public SourceCompleter sourceCompleter = null;
    private Hashtable classes;
    private Hashtable packages;
    Scope typevars = new Scope(null);
    String currentClassFileName = null;
    Symbol currentOwner = null;
    byte[] buf = new byte[65520];
    int bp;
    Object[] poolObj;
    int[] poolIdx;
    private static final int readAttempts = 10;
    private static final int sleepTime = 50;
    byte[] signature;
    int sigp;
    int siglimit;
    boolean sigEnterPhase = false;
    Hashtable archives = Hashtable.make();
    private boolean filling = false;
    private Symbol.CompletionFailure cachedCompletionFailure = new Symbol.CompletionFailure(null, null);
    static final boolean fileSystemIsCaseSensitive;
    static final String[] classOnly;
    static final String[] javaOnly;
    static final String[] classOrJava;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static ClassReader instance(Context context) {
        ClassReader classReader = (ClassReader)context.get(classReaderKey);
        if (classReader == null) {
            classReader = new ClassReader(context, true);
        }
        return classReader;
    }

    public void init(Symtab symtab) {
        this.init(symtab, true);
    }

    private void init(Symtab symtab, boolean bl) {
        if (this.classes != null) {
            return;
        }
        if (bl) {
            if (!$assertionsDisabled && this.packages != null && this.packages != symtab.packages) {
                throw new AssertionError();
            }
            this.packages = symtab.packages;
            if (!$assertionsDisabled && this.classes != null && this.classes != symtab.classes) {
                throw new AssertionError();
            }
            this.classes = symtab.classes;
        } else {
            this.packages = new Hashtable();
            this.classes = new Hashtable();
        }
        this.packages.put(symtab.rootPackage.fullname, symtab.rootPackage);
        symtab.rootPackage.completer = this;
        this.packages.put(symtab.emptyPackage.fullname, symtab.emptyPackage);
        symtab.emptyPackage.completer = this;
    }

    protected ClassReader(Context context, boolean bl) {
        if (bl) {
            context.put(classReaderKey, this);
        }
        this.names = Name.Table.instance(context);
        this.syms = Symtab.instance(context);
        this.init(this.syms, bl);
        this.log = Log.instance(context);
        Options options = Options.instance(context);
        this.verbose = options.get("-verbose") != null;
        this.checkClassFile = options.get("-checkclassfile") != null;
        this.setClassPaths(options);
        this.completionFailureName = options.get("failcomplete") != null ? this.names.fromString((String)options.get("failcomplete")) : null;
    }

    private void setClassPaths(Options options) {
        String string;
        String string2 = (String)options.get("-classpath");
        if (string2 == null) {
            string2 = System.getProperty("env.class.path");
        }
        if (string2 == null && System.getProperty("application.home") == null) {
            string2 = System.getProperty("java.class.path");
        }
        if (string2 == null) {
            string2 = ".";
        }
        this.classPath = this.terminate(string2);
        String string3 = (String)options.get("-bootclasspath");
        if (string3 == null) {
            string3 = System.getProperty("sun.boot.class.path");
            if (string3 == null) {
                string3 = System.getProperty("java.class.path");
            }
            if (string3 == null) {
                string3 = ".";
            }
        }
        if ((string = (String)options.get("-Xbootclasspath/p:")) != null) {
            string3 = string + System.getProperty("path.separator") + string3;
        }
        this.bootClassPath = this.terminate(string3);
        String string4 = (String)options.get("-extdirs");
        if (string4 == null) {
            string4 = System.getProperty("java.ext.dirs");
        }
        if (string4 == null) {
            string4 = "";
        }
        String string5 = this.terminate(string4);
        int n = 0;
        int n2 = string5.length();
        while (n < n2) {
            int n3 = string5.indexOf(pathSep, n);
            String string6 = string5.substring(n, n3);
            this.addArchives(string6);
            n = n3 + 1;
        }
        String string7 = (String)options.get("-sourcepath");
        this.sourceClassPath = string7 != null ? this.terminate(string7) : null;
    }

    private void addArchives(String string) {
        String[] stringArray = new File(string).list();
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            if (!stringArray[i].endsWith(".jar")) continue;
            String string2 = string.endsWith(File.separator) ? string : string + File.separator;
            this.bootClassPath = this.bootClassPath + string2 + stringArray[i] + pathSep;
        }
    }

    private String terminate(String string) {
        return string.endsWith(pathSep) ? string : string + pathSep;
    }

    private void enterMember(Symbol.ClassSymbol classSymbol, Symbol symbol) {
        if ((symbol.flags_field & 0x10000L) == 0L) {
            classSymbol.members_field.enter(symbol);
        }
    }

    public BadClassFile badClassFile(String string) {
        return new BadClassFile(this.currentOwner.enclClass(), this.currentClassFileName, Log.getLocalizedString(string));
    }

    public BadClassFile badClassFile(String string, String string2) {
        return new BadClassFile(this.currentOwner.enclClass(), this.currentClassFileName, Log.getLocalizedString(string, string2));
    }

    public BadClassFile badClassFile(String string, String string2, String string3) {
        return new BadClassFile(this.currentOwner.enclClass(), this.currentClassFileName, Log.getLocalizedString(string, string2, string3));
    }

    public BadClassFile badClassFile(String string, String string2, String string3, String string4) {
        return new BadClassFile(this.currentOwner.enclClass(), this.currentClassFileName, Log.getLocalizedString(string, string2, string3, string4));
    }

    public BadClassFile badClassFile(String string, String string2, String string3, String string4, String string5) {
        return new BadClassFile(this.currentOwner.enclClass(), this.currentClassFileName, Log.getLocalizedString(string, string2, string3, string4, string5));
    }

    char nextChar() {
        return (char)(((this.buf[this.bp++] & 0xFF) << 8) + (this.buf[this.bp++] & 0xFF));
    }

    int nextInt() {
        return ((this.buf[this.bp++] & 0xFF) << 24) + ((this.buf[this.bp++] & 0xFF) << 16) + ((this.buf[this.bp++] & 0xFF) << 8) + (this.buf[this.bp++] & 0xFF);
    }

    char getChar(int n) {
        return (char)(((this.buf[n] & 0xFF) << 8) + (this.buf[n + 1] & 0xFF));
    }

    int getInt(int n) {
        return ((this.buf[n] & 0xFF) << 24) + ((this.buf[n + 1] & 0xFF) << 16) + ((this.buf[n + 2] & 0xFF) << 8) + (this.buf[n + 3] & 0xFF);
    }

    long getLong(int n) {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(this.buf, n, 8));
        try {
            return dataInputStream.readLong();
        }
        catch (IOException iOException) {
            throw new AssertionError();
        }
    }

    float getFloat(int n) {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(this.buf, n, 4));
        try {
            return dataInputStream.readFloat();
        }
        catch (IOException iOException) {
            throw new AssertionError();
        }
    }

    double getDouble(int n) {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(this.buf, n, 8));
        try {
            return dataInputStream.readDouble();
        }
        catch (IOException iOException) {
            throw new AssertionError();
        }
    }

    void indexPool() {
        this.poolIdx = new int[this.nextChar()];
        this.poolObj = new Object[this.poolIdx.length];
        int n = 1;
        block6: while (n < this.poolIdx.length) {
            this.poolIdx[n++] = this.bp;
            byte by = this.buf[this.bp++];
            switch (by) {
                case 1: 
                case 2: {
                    char c = this.nextChar();
                    this.bp += c;
                    continue block6;
                }
                case 7: 
                case 8: {
                    this.bp += 2;
                    continue block6;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    this.bp += 4;
                    continue block6;
                }
                case 5: 
                case 6: {
                    this.bp += 8;
                    ++n;
                    continue block6;
                }
            }
            throw this.badClassFile("bad.const.pool.tag.at", Byte.toString(by), Integer.toString(this.bp - 1));
        }
    }

    Object readPool(int n) {
        Object object = this.poolObj[n];
        if (object != null) {
            return object;
        }
        int n2 = this.poolIdx[n];
        if (n2 == 0) {
            return null;
        }
        byte by = this.buf[n2];
        switch (by) {
            case 1: {
                this.poolObj[n] = this.names.fromUtf(this.buf, n2 + 3, this.getChar(n2 + 1));
                break;
            }
            case 2: {
                throw this.badClassFile("unicode.str.not.supported");
            }
            case 7: {
                this.poolObj[n] = this.readClassOrType(this.getChar(n2 + 1));
                break;
            }
            case 8: {
                this.poolObj[n] = this.readName(this.getChar(n2 + 1)).toString();
                break;
            }
            case 9: {
                Symbol.ClassSymbol classSymbol = this.readClassSymbol(this.getChar(n2 + 1));
                ClassFile.NameAndType nameAndType = (ClassFile.NameAndType)this.readPool(this.getChar(n2 + 3));
                this.poolObj[n] = new Symbol.VarSymbol(0L, nameAndType.name, nameAndType.type, classSymbol);
                break;
            }
            case 10: 
            case 11: {
                Symbol.ClassSymbol classSymbol = this.readClassSymbol(this.getChar(n2 + 1));
                ClassFile.NameAndType nameAndType = (ClassFile.NameAndType)this.readPool(this.getChar(n2 + 3));
                this.poolObj[n] = new Symbol.MethodSymbol(0L, nameAndType.name, nameAndType.type, classSymbol);
                break;
            }
            case 12: {
                this.poolObj[n] = new ClassFile.NameAndType(this.readName(this.getChar(n2 + 1)), this.readType(this.getChar(n2 + 3)));
                break;
            }
            case 3: {
                this.poolObj[n] = new Integer(this.getInt(n2 + 1));
                break;
            }
            case 4: {
                this.poolObj[n] = new Float(this.getFloat(n2 + 1));
                break;
            }
            case 5: {
                this.poolObj[n] = new Long(this.getLong(n2 + 1));
                break;
            }
            case 6: {
                this.poolObj[n] = new Double(this.getDouble(n2 + 1));
                break;
            }
            default: {
                throw this.badClassFile("bad.const.pool.tag", Byte.toString(by));
            }
        }
        return this.poolObj[n];
    }

    Type readType(int n) {
        int n2 = this.poolIdx[n];
        return this.sigToType(this.buf, n2 + 3, this.getChar(n2 + 1));
    }

    Object readClassOrType(int n) {
        int n2 = this.poolIdx[n];
        char c = this.getChar(n2 + 1);
        int n3 = n2 + 3;
        return this.buf[n3] == 91 || this.buf[n3 + c - 1] == 59 ? this.sigToType(this.buf, n3, c) : this.enterClass(this.names.fromUtf(ClassReader.internalize(this.buf, n3, c)));
    }

    Symbol.ClassSymbol readClassSymbol(int n) {
        return (Symbol.ClassSymbol)this.readPool(n);
    }

    Name readName(int n) {
        return (Name)this.readPool(n);
    }

    Type sigToType(Name name) {
        return name == null ? null : this.sigToType(name.table.names, name.index, name.len);
    }

    Type sigToType(byte[] byArray, int n, int n2) {
        this.signature = byArray;
        this.sigp = n;
        this.siglimit = n + n2;
        return this.sigToType();
    }

    Type sigToType() {
        switch ((char)this.signature[this.sigp]) {
            case 'B': {
                ++this.sigp;
                return this.syms.byteType;
            }
            case 'C': {
                ++this.sigp;
                return this.syms.charType;
            }
            case 'D': {
                ++this.sigp;
                return this.syms.doubleType;
            }
            case 'F': {
                ++this.sigp;
                return this.syms.floatType;
            }
            case 'I': {
                ++this.sigp;
                return this.syms.intType;
            }
            case 'J': {
                ++this.sigp;
                return this.syms.longType;
            }
            case 'L': {
                Type type = this.classSigToType(Type.noType);
                while (this.sigp < this.siglimit && this.signature[this.sigp] == 46) {
                    ++this.sigp;
                    type = this.classSigToType(type);
                }
                return type;
            }
            case 'S': {
                ++this.sigp;
                return this.syms.shortType;
            }
            case 'V': {
                ++this.sigp;
                return this.syms.voidType;
            }
            case 'Z': {
                ++this.sigp;
                return this.syms.booleanType;
            }
            case '[': {
                ++this.sigp;
                while (48 <= this.signature[this.sigp] && this.signature[this.sigp] <= 57) {
                    ++this.sigp;
                }
                return new Type.ArrayType(this.sigToType(), (Symbol.TypeSymbol)this.syms.arrayClass);
            }
            case '(': {
                List list = this.sigToTypes(')');
                Type type = this.sigToType();
                ListBuffer listBuffer = new ListBuffer();
                while (this.signature[this.sigp] == 94) {
                    ++this.sigp;
                    listBuffer.append(this.sigToType());
                }
                return new Type.MethodType(list, type, listBuffer.toList(), this.syms.methodClass);
            }
        }
        throw this.badClassFile("bad.signature", Convert.utf2string(this.signature, this.sigp, 10));
    }

    Type classSigToType(Type type) {
        if (this.signature[this.sigp] == 76) {
            ++this.sigp;
            int n = this.sigp;
            while (this.signature[this.sigp] != 59 && this.signature[this.sigp] != 60) {
                ++this.sigp;
            }
            Type.ClassType classType = (Type.ClassType)this.enterClass((Name)this.names.fromUtf((byte[])ClassReader.internalize((byte[])this.signature, (int)n, (int)(this.sigp - n)))).type;
            if (this.signature[this.sigp] == 60) {
                classType = new Type.ClassType(classType.outer_field, this.sigToTypes('>'), classType.tsym);
            } else if (classType.typarams().nonEmpty()) {
                classType = (Type.ClassType)classType.erasure();
            }
            if (type.isParameterized()) {
                classType = new Type.ClassType(type, classType.typarams(), classType.tsym);
            }
            ++this.sigp;
            return classType;
        }
        throw this.badClassFile("bad.class.signature", Convert.utf2string(this.signature, this.sigp, 10));
    }

    List sigToTypes(char c) {
        ++this.sigp;
        ListBuffer listBuffer = new ListBuffer();
        while (this.signature[this.sigp] != c) {
            listBuffer.append(this.sigToType());
        }
        ++this.sigp;
        return listBuffer.toList();
    }

    void unrecogized(Name name) {
        if (this.checkClassFile) {
            this.printCCF("ccf.unrecognized.attribute", name.toJava());
        }
    }

    void readMemberAttr(Symbol symbol, Name name, int n) {
        if (name == this.names.ConstantValue) {
            Object object = this.readPool(this.nextChar());
            if ((symbol.flags() & 0x10L) != 0L) {
                ((Symbol.VarSymbol)symbol).constValue = object;
            }
        } else if (name == this.names.Code) {
            if (this.readAllOfClassFile) {
                ((Symbol.MethodSymbol)symbol).code = this.readCode(symbol);
            } else {
                this.bp += n;
            }
        } else if (name == this.names.Exceptions) {
            int n2 = this.nextChar();
            ListBuffer listBuffer = new ListBuffer();
            for (int i = 0; i < n2; ++i) {
                listBuffer.append(this.readClassSymbol((int)this.nextChar()).type);
            }
            if (symbol.type.thrown().isEmpty()) {
                symbol.type.asMethodType().thrown = listBuffer.toList();
            }
        } else if (name == this.names.Synthetic) {
            symbol.flags_field |= 0x10000L;
        } else if (name == this.names.Deprecated) {
            symbol.flags_field |= 0x20000L;
        } else {
            this.unrecogized(name);
            this.bp += n;
        }
    }

    void readMemberAttrs(Symbol symbol) {
        int n = this.nextChar();
        for (int i = 0; i < n; ++i) {
            Name name = this.readName(this.nextChar());
            int n2 = this.nextInt();
            this.readMemberAttr(symbol, name, n2);
        }
    }

    void readClassAttr(Symbol.ClassSymbol classSymbol, Name name, int n) {
        if (name == this.names.SourceFile) {
            classSymbol.sourcefile = this.readName(this.nextChar());
        } else if (name == this.names.InnerClasses) {
            this.readInnerClasses(classSymbol);
        } else {
            this.readMemberAttr(classSymbol, name, n);
        }
    }

    void readClassAttrs(Symbol.ClassSymbol classSymbol) {
        int n = this.nextChar();
        for (int i = 0; i < n; ++i) {
            Name name = this.readName(this.nextChar());
            int n2 = this.nextInt();
            this.readClassAttr(classSymbol, name, n2);
        }
    }

    Code readCode(Symbol symbol) {
        return null;
    }

    Symbol.VarSymbol readField() {
        char c = this.nextChar();
        Name name = this.readName(this.nextChar());
        Type type = this.readType(this.nextChar());
        Symbol.VarSymbol varSymbol = new Symbol.VarSymbol(c, name, type, this.currentOwner);
        this.readMemberAttrs(varSymbol);
        return varSymbol;
    }

    Symbol.MethodSymbol readMethod() {
        char c = this.nextChar();
        Name name = this.readName(this.nextChar());
        Type type = this.readType(this.nextChar());
        if (name == this.names.init && this.currentOwner.hasOuterInstance()) {
            type = new Type.MethodType(type.argtypes().tail, type.restype(), type.thrown(), this.syms.methodClass);
        }
        Symbol.MethodSymbol methodSymbol = new Symbol.MethodSymbol(c, name, type, this.currentOwner);
        Symbol symbol = this.currentOwner;
        this.currentOwner = methodSymbol;
        this.readMemberAttrs(methodSymbol);
        this.currentOwner = symbol;
        return methodSymbol;
    }

    void skipMember() {
        this.bp += 6;
        int n = this.nextChar();
        for (int i = 0; i < n; ++i) {
            this.bp += 2;
            int n2 = this.nextInt();
            this.bp += n2;
        }
    }

    void enterTypevars(Type type) {
        if (type.outer().tag == 10) {
            this.enterTypevars(type.outer());
        }
        List list = type.typarams();
        while (list.nonEmpty()) {
            this.typevars.enter(((Type)list.head).tsym);
            list = list.tail;
        }
    }

    void readClass(Symbol.ClassSymbol classSymbol) {
        int n;
        int n2;
        int n3;
        Symbol.ClassSymbol classSymbol2;
        Type.ClassType classType = (Type.ClassType)classSymbol.type;
        classSymbol.members_field = new Scope(classSymbol);
        this.typevars = this.typevars.dup();
        if (classType.outer().tag == 10) {
            this.enterTypevars(classType.outer());
        }
        char c = this.nextChar();
        if (classSymbol.owner.kind == 1) {
            classSymbol.flags_field = c;
        }
        if (classSymbol != (classSymbol2 = this.readClassSymbol(this.nextChar()))) {
            throw this.badClassFile("class.file.wrong.class", classSymbol2.flatname.toJava());
        }
        int n4 = this.bp;
        this.nextChar();
        char c2 = this.nextChar();
        this.bp += c2 * 2;
        int n5 = this.nextChar();
        for (n3 = 0; n3 < n5; ++n3) {
            this.skipMember();
        }
        n3 = this.nextChar();
        for (n2 = 0; n2 < n3; ++n2) {
            this.skipMember();
        }
        this.readClassAttrs(classSymbol);
        if (this.readAllOfClassFile) {
            for (n2 = 1; n2 < this.poolObj.length; ++n2) {
                this.readPool(n2);
            }
            classSymbol.pool = new Pool(this.poolObj.length, this.poolObj);
        }
        this.bp = n4;
        n2 = this.nextChar();
        classType.supertype_field = n2 == 0 ? Type.noType : this.readClassSymbol((int)n2).type;
        n2 = this.nextChar();
        ListBuffer listBuffer = new ListBuffer();
        for (n = 0; n < n2; ++n) {
            listBuffer.append(this.readClassSymbol((int)this.nextChar()).type);
        }
        classType.interfaces_field = listBuffer.toList();
        if (n5 != this.nextChar() && !$assertionsDisabled) {
            throw new AssertionError();
        }
        for (n = 0; n < n5; ++n) {
            this.enterMember(classSymbol, this.readField());
        }
        if (n3 != this.nextChar() && !$assertionsDisabled) {
            throw new AssertionError();
        }
        for (n = 0; n < n3; ++n) {
            this.enterMember(classSymbol, this.readMethod());
        }
        this.typevars = this.typevars.leave();
    }

    void readInnerClasses(Symbol.ClassSymbol classSymbol) {
        int n = this.nextChar();
        for (int i = 0; i < n; ++i) {
            this.nextChar();
            Symbol.ClassSymbol classSymbol2 = this.readClassSymbol(this.nextChar());
            Name name = this.readName(this.nextChar());
            if (name == null) {
                name = this.names.empty;
            }
            char c = this.nextChar();
            if (classSymbol2 == null) continue;
            if (name == this.names.empty) {
                name = this.names.one;
            }
            Symbol.ClassSymbol classSymbol3 = this.enterClass(name, classSymbol2);
            if ((c & 8) == 0) {
                ((Type.ClassType)classSymbol3.type).outer_field = classSymbol2.type;
            }
            if (classSymbol != classSymbol2) continue;
            classSymbol3.flags_field = c;
            this.enterMember(classSymbol, classSymbol3);
        }
    }

    void readClassFile(Symbol.ClassSymbol classSymbol) throws IOException {
        int n = this.nextInt();
        if (n != -889275714) {
            throw this.badClassFile("illegal.start.of.class.file");
        }
        char c = this.nextChar();
        char c2 = this.nextChar();
        if (c2 > Target.MAX().majorVersion || c2 * 1000 + c < Target.MIN().majorVersion * 1000 + Target.MIN().minorVersion) {
            throw this.badClassFile("wrong.version", Integer.toString(c2), Integer.toString(c), Integer.toString(Target.MAX().majorVersion), Integer.toString(Target.MAX().minorVersion));
        }
        if (this.checkClassFile && c2 == Target.MAX().majorVersion && c > Target.MAX().minorVersion) {
            this.printCCF("found.later.version", Integer.toString(c));
        }
        this.indexPool();
        this.readClass(classSymbol);
    }

    boolean isZip(String string) {
        return new File(string).isFile();
    }

    Archive openArchive(String string) throws IOException {
        Archive archive = (Archive)this.archives.get(string);
        if (archive == null) {
            ZipFile zipFile = new ZipFile(string);
            ListBuffer listBuffer = new ListBuffer();
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                listBuffer.append(enumeration.nextElement());
            }
            archive = new Archive(zipFile, listBuffer.toList());
            this.archives.put(string, archive);
        }
        return archive;
    }

    public void close() {
        List list = this.archives.keys();
        while (list.nonEmpty()) {
            Archive archive = (Archive)this.archives.remove(list.head);
            try {
                archive.zdir.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            list = list.tail;
        }
    }

    public Symbol.ClassSymbol defineClass(Name name, Symbol symbol) {
        Symbol.ClassSymbol classSymbol = new Symbol.ClassSymbol(0L, name, symbol);
        classSymbol.completer = this;
        return classSymbol;
    }

    public Symbol.ClassSymbol enterClass(Name name, Symbol.TypeSymbol typeSymbol) {
        Name name2 = Symbol.TypeSymbol.formFlatName(name, typeSymbol);
        Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)this.classes.get(name2);
        if (classSymbol == null) {
            classSymbol = this.defineClass(name, typeSymbol);
            this.classes.put(name2, classSymbol);
        } else if ((classSymbol.name != name || classSymbol.owner != typeSymbol) && typeSymbol.kind == 2) {
            classSymbol.name = name;
            classSymbol.owner = typeSymbol;
            classSymbol.fullname = Symbol.ClassSymbol.formFullName(name, typeSymbol);
        }
        return classSymbol;
    }

    public Symbol.ClassSymbol enterClass(Name name) {
        Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)this.classes.get(name);
        if (classSymbol == null) {
            Name name2 = Convert.packagePart(name);
            if (name2 == this.names.empty) {
                name2 = this.names.emptyPackage;
            }
            classSymbol = this.defineClass(Convert.shortName(name), this.enterPackage(name2));
            this.classes.put(name, classSymbol);
        }
        return classSymbol;
    }

    public void complete(Symbol symbol) throws Symbol.CompletionFailure {
        if (symbol.kind == 2) {
            Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)symbol;
            classSymbol.members_field = new Scope.ErrorScope(classSymbol);
            classSymbol.owner.complete();
            this.fillIn(classSymbol);
        } else if (symbol.kind == 1) {
            Symbol.PackageSymbol packageSymbol = (Symbol.PackageSymbol)symbol;
            this.fillIn(packageSymbol);
        }
    }

    private void fillIn(Symbol.ClassSymbol classSymbol) {
        if (this.completionFailureName == classSymbol.fullname) {
            throw new Symbol.CompletionFailure(classSymbol, "user-selected completion failure by class name");
        }
        this.currentOwner = classSymbol;
        FileEntry fileEntry = classSymbol.classfile;
        if (fileEntry != null) {
            boolean bl = true;
            int n = 0;
            do {
                try {
                    if (!$assertionsDisabled && this.filling) {
                        throw new AssertionError();
                    }
                    InputStream inputStream = fileEntry.open();
                    this.currentClassFileName = fileEntry.getPath();
                    if (this.verbose) {
                        this.printVerbose("loading", this.currentClassFileName);
                    }
                    if (fileEntry.getName().endsWith(".class")) {
                        this.filling = true;
                        int n2 = (int)fileEntry.length();
                        if (this.buf.length < n2) {
                            this.buf = new byte[n2];
                        }
                        for (int i = 0; i < n2; i += inputStream.read(this.buf, i, n2 - i)) {
                        }
                        inputStream.close();
                        this.bp = 0;
                        this.readClassFile(classSymbol);
                        bl = true;
                        continue;
                    }
                    this.sourceCompleter.complete(classSymbol, this.currentClassFileName, inputStream);
                }
                catch (BadClassFile badClassFile) {
                    if (n < 10) {
                        try {
                            Thread.currentThread();
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        ++n;
                        bl = false;
                        continue;
                    }
                    throw badClassFile;
                }
                catch (IOException iOException) {
                    throw this.badClassFile("unable.to.access.file", iOException.getMessage());
                }
                finally {
                    this.filling = false;
                }
            } while (!bl);
            return;
        }
        String string = ClassReader.externalizeFileName(classSymbol.flatname);
        throw this.newCompletionFailure(classSymbol, Log.getLocalizedString("dot.class.not.found", string));
    }

    private Symbol.CompletionFailure newCompletionFailure(Symbol.ClassSymbol classSymbol, String string) {
        Symbol.CompletionFailure completionFailure = this.cachedCompletionFailure;
        completionFailure.sym = classSymbol;
        completionFailure.errmsg = string;
        return completionFailure;
    }

    public Symbol.ClassSymbol loadClass(Name name) throws Symbol.CompletionFailure {
        boolean bl = this.classes.get(name) == null;
        Symbol.ClassSymbol classSymbol = this.enterClass(name);
        if (classSymbol.members_field == null && classSymbol.completer != null) {
            try {
                classSymbol.complete();
            }
            catch (Symbol.CompletionFailure completionFailure) {
                if (bl) {
                    this.classes.remove(name);
                }
                throw completionFailure;
            }
        }
        return classSymbol;
    }

    public boolean packageExists(Name name) {
        return this.enterPackage(name).exists();
    }

    public Symbol.PackageSymbol enterPackage(Name name) {
        Symbol.PackageSymbol packageSymbol = (Symbol.PackageSymbol)this.packages.get(name);
        if (packageSymbol == null) {
            if (!$assertionsDisabled && name.length() == 0) {
                throw new AssertionError((Object)"rootPackage missing!");
            }
            packageSymbol = new Symbol.PackageSymbol(Convert.shortName(name), this.enterPackage(Convert.packagePart(name)));
            packageSymbol.completer = this;
            this.packages.put(name, packageSymbol);
        }
        return packageSymbol;
    }

    public Symbol.PackageSymbol enterPackage(Name name, Symbol.PackageSymbol packageSymbol) {
        return this.enterPackage(Symbol.TypeSymbol.formFullName(name, packageSymbol));
    }

    private void includeClassFile(Symbol.PackageSymbol packageSymbol, FileEntry fileEntry) {
        int n;
        int n2;
        Object object;
        if ((packageSymbol.flags_field & 0x800000L) == 0L) {
            object = packageSymbol;
            while (object != null && ((Symbol)object).kind == 1) {
                ((Symbol)object).flags_field |= 0x800000L;
                object = ((Symbol)object).owner;
            }
        }
        if (((String)(object = fileEntry.getName())).endsWith(".class")) {
            n2 = 0x2000000;
            n = 6;
        } else {
            n2 = 0x4000000;
            n = 5;
        }
        Name name = this.names.fromString(((String)object).substring(0, ((String)object).length() - n));
        Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)packageSymbol.members_field.lookup((Name)name).sym;
        if (classSymbol == null) {
            classSymbol = this.enterClass(name, packageSymbol);
            classSymbol.classfile = fileEntry;
            if (classSymbol.owner == packageSymbol) {
                packageSymbol.members_field.enter(classSymbol);
            }
        } else if (classSymbol.classfile != null && (classSymbol.flags_field & (long)n2) == 0L && (classSymbol.flags_field & 0x6000000L) != 0L) {
            long l = fileEntry.lastModified();
            long l2 = classSymbol.classfile.lastModified();
            if (l >= 0L && l2 >= 0L && l > l2) {
                classSymbol.classfile = fileEntry;
            }
        }
        classSymbol.flags_field |= (long)n2;
    }

    private void list(String string, String string2, String[] stringArray, Symbol.PackageSymbol packageSymbol) {
        try {
            if (this.isZip(string)) {
                Archive archive = this.openArchive(string);
                if (string2.length() != 0 && !(string2 = string2.replace('\\', '/')).endsWith("/")) {
                    string2 = string2 + "/";
                }
                int n = string2.length();
                List list = archive.entries;
                while (list.nonEmpty()) {
                    ZipEntry zipEntry = (ZipEntry)list.head;
                    String string3 = zipEntry.getName();
                    if (string3.startsWith(string2)) {
                        if (this.endsWith(string3, stringArray)) {
                            String string4 = string3.substring(n);
                            if (string4.length() > 0 && string4.indexOf(47) < 0) {
                                this.includeClassFile(packageSymbol, new FileEntry.Zipped(string4, archive.zdir, zipEntry));
                            }
                        } else {
                            this.extraZipFileActions(packageSymbol, string3, string2, string);
                        }
                    }
                    list = list.tail;
                }
            } else {
                File file = string2.length() != 0 ? new File(string, string2) : new File(string);
                String[] stringArray2 = file.list();
                if (stringArray2 != null && this.caseMapCheck(file, string2)) {
                    for (int i = 0; i < stringArray2.length; ++i) {
                        String string5 = stringArray2[i];
                        if (this.isValidFile(string5, stringArray)) {
                            this.includeClassFile(packageSymbol, new FileEntry.Regular(string5, new File(file, string5)));
                            continue;
                        }
                        this.extraFileActions(packageSymbol, string5, file);
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean endsWith(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.endsWith(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isValidFile(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (!string.endsWith(string2) || !this.isJavaIdentifier(string.substring(0, string.length() - string2.length()))) continue;
            return true;
        }
        return false;
    }

    private boolean isJavaIdentifier(String string) {
        if (string.length() < 1) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private boolean caseMapCheck(File file, String string) throws IOException {
        if (fileSystemIsCaseSensitive) {
            return true;
        }
        String string2 = file.getCanonicalPath();
        char[] cArray = string2.toCharArray();
        char[] cArray2 = string.toCharArray();
        int n = cArray.length - 1;
        int n2 = cArray2.length - 1;
        while (n >= 0 && n2 >= 0) {
            while (n >= 0 && cArray[n] == File.separatorChar) {
                --n;
            }
            while (n2 >= 0 && cArray2[n2] == File.separatorChar) {
                --n2;
            }
            if (n < 0 || n2 < 0) continue;
            if (cArray[n] != cArray2[n2]) {
                return false;
            }
            --n;
            --n2;
        }
        return n2 < 0;
    }

    protected void extraZipFileActions(Symbol.PackageSymbol packageSymbol, String string, String string2, String string3) {
    }

    protected void extraFileActions(Symbol.PackageSymbol packageSymbol, String string, File file) {
    }

    private void listAll(String string, String string2, String[] stringArray, Symbol.PackageSymbol packageSymbol) {
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            int n3 = string.indexOf(pathSep, n);
            String string3 = string.substring(n, n3);
            this.list(string3, string2, stringArray, packageSymbol);
            n = n3 + 1;
        }
    }

    private void fillIn(Symbol.PackageSymbol packageSymbol) {
        Name name;
        if (packageSymbol.members_field == null) {
            packageSymbol.members_field = new Scope(packageSymbol);
        }
        if ((name = packageSymbol.fullname) == this.names.emptyPackage) {
            name = this.names.empty;
        }
        String string = ClassReader.externalizeFileName(name);
        this.listAll(this.bootClassPath, string, classOnly, packageSymbol);
        if (this.sourceCompleter != null && this.sourceClassPath == null) {
            this.listAll(this.classPath, string, classOrJava, packageSymbol);
        } else {
            this.listAll(this.classPath, string, classOnly, packageSymbol);
            if (this.sourceCompleter != null) {
                this.listAll(this.sourceClassPath, string, javaOnly, packageSymbol);
            }
        }
    }

    private void printVerbose(String string, String string2) {
        Log.printLines(this.log.noticeWriter, Log.getLocalizedString("verbose." + string, string2));
    }

    private void printCCF(String string, String string2) {
        Log.printLines(this.log.noticeWriter, Log.getLocalizedString("verbose." + string, string2));
    }

    static {
        $assertionsDisabled = !ClassReader.class.desiredAssertionStatus();
        classReaderKey = new Context.Key();
        pathSep = System.getProperty("path.separator");
        fileSystemIsCaseSensitive = File.separatorChar == '/';
        classOnly = new String[]{".class"};
        javaOnly = new String[]{".java"};
        classOrJava = new String[]{".class", ".java"};
    }

    public static interface SourceCompleter {
        public void complete(Symbol.ClassSymbol var1, String var2, InputStream var3) throws Symbol.CompletionFailure;
    }

    static class Archive {
        ZipFile zdir;
        List entries;

        Archive(ZipFile zipFile, List list) {
            this.zdir = zipFile;
            this.entries = list;
        }
    }

    public static class BadClassFile
    extends Symbol.CompletionFailure {
        public BadClassFile(Symbol.ClassSymbol classSymbol, String string, String string2) {
            super(classSymbol, Log.getLocalizedString("bad.class.file.header", string, string2));
        }
    }
}

