/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.v8.code;

import com.sun.tools.javac.v8.code.CRTable;
import com.sun.tools.javac.v8.code.ClassFile;
import com.sun.tools.javac.v8.code.Code;
import com.sun.tools.javac.v8.code.Flags;
import com.sun.tools.javac.v8.code.Kinds;
import com.sun.tools.javac.v8.code.Pool;
import com.sun.tools.javac.v8.code.Scope;
import com.sun.tools.javac.v8.code.Symbol;
import com.sun.tools.javac.v8.code.Symtab;
import com.sun.tools.javac.v8.code.Target;
import com.sun.tools.javac.v8.code.Type;
import com.sun.tools.javac.v8.code.TypeTags;
import com.sun.tools.javac.v8.util.ByteBuffer;
import com.sun.tools.javac.v8.util.Context;
import com.sun.tools.javac.v8.util.Convert;
import com.sun.tools.javac.v8.util.List;
import com.sun.tools.javac.v8.util.ListBuffer;
import com.sun.tools.javac.v8.util.Log;
import com.sun.tools.javac.v8.util.Name;
import com.sun.tools.javac.v8.util.Options;
import com.sun.tools.javac.v8.util.Set;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ClassWriter
extends ClassFile
implements Flags,
Kinds,
TypeTags {
    private static final Context.Key classWriterKey;
    private final Symtab syms;
    public File outDir = null;
    private boolean verbose;
    private boolean scramble;
    private boolean scrambleAll;
    private boolean retrofit;
    private boolean emitSourceFile;
    private boolean genCrt;
    private Target target;
    static final int DATA_BUF_SIZE = 65520;
    static final int POOL_BUF_SIZE = 131056;
    ByteBuffer databuf = new ByteBuffer(65520);
    ByteBuffer poolbuf = new ByteBuffer(131056);
    ByteBuffer sigbuf = new ByteBuffer();
    Pool pool;
    Set innerClasses;
    ListBuffer innerClassesQueue;
    private final Log log;
    private final Name.Table names;
    private final boolean dumpClassModifiers;
    private final boolean dumpFieldModifiers;
    private final boolean dumpInnerClassModifiers;
    private final boolean dumpMethodModifiers;
    private static final String[] flagName;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static ClassWriter instance(Context context) {
        ClassWriter classWriter = (ClassWriter)context.get(classWriterKey);
        if (classWriter == null) {
            classWriter = new ClassWriter(context);
        }
        return classWriter;
    }

    private ClassWriter(Context context) {
        String string;
        context.put(classWriterKey, this);
        this.log = Log.instance(context);
        this.names = Name.Table.instance(context);
        this.syms = Symtab.instance(context);
        Options options = Options.instance(context);
        this.target = Target.instance(context);
        this.verbose = options.get("-verbose") != null;
        this.scramble = options.get("-scramble") != null;
        this.scrambleAll = options.get("-scrambleAll") != null;
        this.retrofit = options.get("-retrofit") != null;
        this.genCrt = options.get("-Xjcov") != null;
        this.emitSourceFile = options.get("-g:") == null || options.get("-g:source") != null;
        String string2 = (String)options.get("-d");
        if (string2 != null) {
            this.outDir = new File(string2);
        }
        this.dumpClassModifiers = (string = (String)options.get("dumpmodifiers")) != null && string.indexOf(99) != -1;
        this.dumpFieldModifiers = string != null && string.indexOf(102) != -1;
        this.dumpInnerClassModifiers = string != null && string.indexOf(105) != -1;
        this.dumpMethodModifiers = string != null && string.indexOf(109) != -1;
    }

    public static String flagNames(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        long l2 = l & 0xFFFL;
        while (l2 != 0L) {
            if ((l2 & 1L) != 0L) {
                stringBuffer.append(" " + flagName[n]);
            }
            l2 >>= 1;
            ++n;
        }
        return stringBuffer.toString();
    }

    void putChar(ByteBuffer byteBuffer, int n, int n2) {
        byteBuffer.elems[n] = (byte)(n2 >> 8 & 0xFF);
        byteBuffer.elems[n + 1] = (byte)(n2 & 0xFF);
    }

    void putInt(ByteBuffer byteBuffer, int n, int n2) {
        byteBuffer.elems[n] = (byte)(n2 >> 24 & 0xFF);
        byteBuffer.elems[n + 1] = (byte)(n2 >> 16 & 0xFF);
        byteBuffer.elems[n + 2] = (byte)(n2 >> 8 & 0xFF);
        byteBuffer.elems[n + 3] = (byte)(n2 & 0xFF);
    }

    void assembleSig(Type type) {
        switch (type.tag) {
            case 1: {
                this.sigbuf.appendByte(66);
                break;
            }
            case 3: {
                this.sigbuf.appendByte(83);
                break;
            }
            case 2: {
                this.sigbuf.appendByte(67);
                break;
            }
            case 4: {
                this.sigbuf.appendByte(73);
                break;
            }
            case 5: {
                this.sigbuf.appendByte(74);
                break;
            }
            case 6: {
                this.sigbuf.appendByte(70);
                break;
            }
            case 7: {
                this.sigbuf.appendByte(68);
                break;
            }
            case 8: {
                this.sigbuf.appendByte(90);
                break;
            }
            case 9: {
                this.sigbuf.appendByte(86);
                break;
            }
            case 10: {
                Type.ClassType classType = (Type.ClassType)type;
                Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)classType.tsym;
                this.enterInner(classSymbol);
                if (classType.outer().allparams().nonEmpty()) {
                    this.assembleSig(classType.outer());
                    this.sigbuf.appendByte(46);
                }
                this.sigbuf.appendByte(76);
                this.sigbuf.appendBytes(ClassWriter.externalize(classSymbol.flatname));
                this.sigbuf.appendByte(59);
                break;
            }
            case 11: {
                Type.ArrayType arrayType = (Type.ArrayType)type;
                this.sigbuf.appendByte(91);
                this.assembleSig(arrayType.elemtype);
                break;
            }
            case 12: {
                Type.MethodType methodType = (Type.MethodType)type;
                this.sigbuf.appendByte(40);
                this.assembleSig(methodType.argtypes);
                this.sigbuf.appendByte(41);
                this.assembleSig(methodType.restype);
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)("typeSig" + type.tag));
                }
                break;
            }
        }
    }

    void assembleSig(List list) {
        List list2 = list;
        while (list2.nonEmpty()) {
            this.assembleSig((Type)list2.head);
            list2 = list2.tail;
        }
    }

    Name typeSig(Type type) {
        if (!$assertionsDisabled && this.sigbuf.length != 0) {
            throw new AssertionError();
        }
        this.assembleSig(type);
        Name name = this.sigbuf.toName(this.names);
        this.sigbuf.reset();
        return name;
    }

    public Name xClassName(Type type) {
        if (type.tag == 10) {
            return this.names.fromUtf(ClassWriter.externalize(type.tsym.flatName()));
        }
        if (type.tag == 11) {
            return this.typeSig(type.erasure());
        }
        throw new AssertionError((Object)"xClassName");
    }

    void writePool(Pool pool) throws PoolOverflow, StringOverflow {
        int n = this.poolbuf.length;
        this.poolbuf.appendChar(0);
        for (int i = 1; i < pool.pp; ++i) {
            Object object;
            Object object2 = pool.pool[i];
            if (!$assertionsDisabled && object2 == null) {
                throw new AssertionError();
            }
            if (object2 instanceof Pool.Method) {
                object2 = ((Pool.Method)object2).m;
            } else if (object2 instanceof Pool.Variable) {
                object2 = ((Pool.Variable)object2).v;
            }
            if (object2 instanceof Symbol.MethodSymbol) {
                object = (Symbol.MethodSymbol)object2;
                this.poolbuf.appendByte((((Symbol.MethodSymbol)object).owner.flags() & 0x200L) != 0L ? 11 : 10);
                this.poolbuf.appendChar(pool.put(((Symbol.MethodSymbol)object).owner));
                this.poolbuf.appendChar(pool.put(this.nameType((Symbol)object)));
                continue;
            }
            if (object2 instanceof Symbol.VarSymbol) {
                object = (Symbol.VarSymbol)object2;
                this.poolbuf.appendByte(9);
                this.poolbuf.appendChar(pool.put(((Symbol.VarSymbol)object).owner));
                this.poolbuf.appendChar(pool.put(this.nameType((Symbol)object)));
                continue;
            }
            if (object2 instanceof Name) {
                this.poolbuf.appendByte(1);
                object = ((Name)object2).toUtf();
                this.poolbuf.appendChar(((Object)object).length);
                this.poolbuf.appendBytes((byte[])object, 0, ((Object)object).length);
                if (((Object)object).length <= 65535) continue;
                throw new StringOverflow(object2.toString());
            }
            if (object2 instanceof Symbol.ClassSymbol) {
                object = (Symbol.ClassSymbol)object2;
                if (((Symbol.ClassSymbol)object).owner.kind == 2) {
                    pool.put(((Symbol.ClassSymbol)object).owner);
                }
                this.poolbuf.appendByte(7);
                if (((Symbol.ClassSymbol)object).type.tag == 11) {
                    this.poolbuf.appendChar(pool.put(this.typeSig(((Symbol.ClassSymbol)object).type)));
                    continue;
                }
                this.poolbuf.appendChar(pool.put(this.names.fromUtf(ClassWriter.externalize(((Symbol.ClassSymbol)object).flatname))));
                this.enterInner((Symbol.ClassSymbol)object);
                continue;
            }
            if (object2 instanceof ClassFile.NameAndType) {
                object = (ClassFile.NameAndType)object2;
                this.poolbuf.appendByte(12);
                this.poolbuf.appendChar(pool.put(((ClassFile.NameAndType)object).name));
                this.poolbuf.appendChar(pool.put(this.typeSig(((ClassFile.NameAndType)object).type)));
                continue;
            }
            if (object2 instanceof Integer) {
                this.poolbuf.appendByte(3);
                this.poolbuf.appendInt((Integer)object2);
                continue;
            }
            if (object2 instanceof Long) {
                this.poolbuf.appendByte(5);
                this.poolbuf.appendLong((Long)object2);
                ++i;
                continue;
            }
            if (object2 instanceof Float) {
                this.poolbuf.appendByte(4);
                this.poolbuf.appendFloat(((Float)object2).floatValue());
                continue;
            }
            if (object2 instanceof Double) {
                this.poolbuf.appendByte(6);
                this.poolbuf.appendDouble((Double)object2);
                ++i;
                continue;
            }
            if (object2 instanceof String) {
                this.poolbuf.appendByte(8);
                this.poolbuf.appendChar(pool.put(this.names.fromString((String)object2)));
                continue;
            }
            if (object2 instanceof Type) {
                this.poolbuf.appendByte(7);
                this.poolbuf.appendChar(pool.put(this.xClassName((Type)object2)));
                continue;
            }
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)("writePool " + object2));
            }
        }
        if (pool.pp > 65535) {
            throw new PoolOverflow();
        }
        this.putChar(this.poolbuf, n, pool.pp);
    }

    Name fieldName(Symbol symbol) {
        if (this.scramble && (symbol.flags() & 2L) != 0L || this.scrambleAll && (symbol.flags() & 5L) == 0L) {
            return this.names.fromString("_$" + symbol.name.index);
        }
        return symbol.name;
    }

    ClassFile.NameAndType nameType(Symbol symbol) {
        return new ClassFile.NameAndType(this.fieldName(symbol), this.retrofit ? symbol.erasure() : symbol.externalType());
    }

    int writeAttr(Name name) {
        this.databuf.appendChar(this.pool.put(name));
        this.databuf.appendInt(0);
        return this.databuf.length;
    }

    void endAttr(int n) {
        this.putInt(this.databuf, n - 4, this.databuf.length - n);
    }

    int beginAttrs() {
        this.databuf.appendChar(0);
        return this.databuf.length;
    }

    void endAttrs(int n, int n2) {
        this.putChar(this.databuf, n - 2, n2);
    }

    int writeFlagAttrs(long l) {
        int n;
        int n2 = 0;
        if ((l & 0x20000L) != 0L) {
            n = this.writeAttr(this.names.Deprecated);
            this.endAttr(n);
            ++n2;
        }
        if ((l & 0x10000L) != 0L) {
            n = this.writeAttr(this.names.Synthetic);
            this.endAttr(n);
            ++n2;
        }
        return n2;
    }

    int writeMemberAttrs(Symbol symbol) {
        int n = this.writeFlagAttrs(symbol.flags());
        return n;
    }

    void enterInner(Symbol.ClassSymbol classSymbol) {
        if (!$assertionsDisabled && (classSymbol.flags() & 0x1000000L) != 0L) {
            throw new AssertionError();
        }
        if (classSymbol.type.tag != 10) {
            return;
        }
        if (!(this.pool == null || classSymbol.owner.kind == 1 || this.innerClasses != null && this.innerClasses.contains(classSymbol))) {
            if (classSymbol.owner.kind == 2) {
                this.enterInner((Symbol.ClassSymbol)classSymbol.owner);
            }
            this.pool.put(classSymbol);
            this.pool.put(classSymbol.name);
            if (this.innerClasses == null) {
                this.innerClasses = Set.make();
                this.innerClassesQueue = new ListBuffer();
                this.pool.put(this.names.InnerClasses);
            }
            this.innerClasses.put(classSymbol);
            this.innerClassesQueue.append(classSymbol);
        }
    }

    void writeInnerClasses() {
        int n = this.writeAttr(this.names.InnerClasses);
        this.databuf.appendChar(this.innerClassesQueue.length());
        List list = this.innerClassesQueue.toList();
        while (list.nonEmpty()) {
            Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)list.head;
            if (this.dumpInnerClassModifiers) {
                this.log.errWriter.println("INNERCLASS  " + classSymbol.name);
                this.log.errWriter.println("---" + ClassWriter.flagNames(classSymbol.flags_field));
            }
            this.databuf.appendChar(this.pool.get(classSymbol));
            this.databuf.appendChar(classSymbol.owner.kind == 2 ? this.pool.get(classSymbol.owner) : 0);
            this.databuf.appendChar(classSymbol.name.len != 0 ? this.pool.get(classSymbol.name) : 0);
            this.databuf.appendChar((int)classSymbol.flags_field);
            list = list.tail;
        }
        this.endAttr(n);
    }

    void writeField(Symbol.VarSymbol varSymbol) {
        this.databuf.appendChar((int)varSymbol.flags());
        if (this.dumpFieldModifiers) {
            this.log.errWriter.println("FIELD  " + this.fieldName(varSymbol));
            this.log.errWriter.println("---" + ClassWriter.flagNames(varSymbol.flags()));
        }
        this.databuf.appendChar(this.pool.put(this.fieldName(varSymbol)));
        this.databuf.appendChar(this.pool.put(this.typeSig(varSymbol.erasure())));
        int n = this.beginAttrs();
        int n2 = 0;
        if (varSymbol.constValue != null) {
            int n3 = this.writeAttr(this.names.ConstantValue);
            this.databuf.appendChar(this.pool.put(varSymbol.constValue));
            this.endAttr(n3);
            ++n2;
        }
        this.endAttrs(n, n2 += this.writeMemberAttrs(varSymbol));
    }

    void writeMethod(Symbol.MethodSymbol methodSymbol) {
        List list;
        this.databuf.appendChar((int)methodSymbol.flags());
        if (this.dumpMethodModifiers) {
            this.log.errWriter.println("METHOD  " + this.fieldName(methodSymbol));
            this.log.errWriter.println("---" + ClassWriter.flagNames(methodSymbol.flags()));
        }
        this.databuf.appendChar(this.pool.put(this.fieldName(methodSymbol)));
        this.databuf.appendChar(this.pool.put(this.typeSig(methodSymbol.externalType())));
        int n = this.beginAttrs();
        int n2 = 0;
        if (methodSymbol.code != null) {
            int n3 = this.writeAttr(this.names.Code);
            this.writeCode(methodSymbol.code);
            methodSymbol.code = null;
            this.endAttr(n3);
            ++n2;
        }
        if ((list = methodSymbol.erasure().thrown()).nonEmpty()) {
            int n4 = this.writeAttr(this.names.Exceptions);
            this.databuf.appendChar(list.length());
            List list2 = list;
            while (list2.nonEmpty()) {
                this.databuf.appendChar(this.pool.put(((Type)list2.head).tsym));
                list2 = list2.tail;
            }
            this.endAttr(n4);
            ++n2;
        }
        this.endAttrs(n, n2 += this.writeMemberAttrs(methodSymbol));
    }

    void writeCode(Code code) {
        int n;
        int n2;
        int n3;
        this.databuf.appendChar(code.max_stack);
        this.databuf.appendChar(code.max_locals);
        this.databuf.appendInt(code.cp);
        this.databuf.appendBytes(code.code, 0, code.cp);
        this.databuf.appendChar(code.catchInfo.length());
        List list = code.catchInfo.toList();
        while (list.nonEmpty()) {
            for (n3 = 0; n3 < ((char[])list.head).length; ++n3) {
                this.databuf.appendChar(((char[])list.head)[n3]);
            }
            list = list.tail;
        }
        int n4 = this.beginAttrs();
        n3 = 0;
        if (code.lineInfo.nonEmpty()) {
            n2 = this.writeAttr(this.names.LineNumberTable);
            this.databuf.appendChar(code.lineInfo.length());
            List list2 = code.lineInfo.reverse();
            while (list2.nonEmpty()) {
                for (n = 0; n < ((char[])list2.head).length; ++n) {
                    this.databuf.appendChar(((char[])list2.head)[n]);
                }
                list2 = list2.tail;
            }
            this.endAttr(n2);
            ++n3;
        }
        if (this.genCrt && code.crt != null) {
            CRTable cRTable = code.crt;
            int n5 = this.writeAttr(this.names.CharacterRangeTable);
            n = this.beginAttrs();
            int n6 = cRTable.writeCRT(this.databuf);
            this.endAttrs(n, n6);
            this.endAttr(n5);
            ++n3;
        }
        if (code.varBufferSize > 0) {
            n2 = this.writeAttr(this.names.LocalVariableTable);
            int n7 = code.varBufferSize;
            this.databuf.appendChar(n7);
            for (n = 0; n < n7; ++n) {
                Code.LocalVar localVar = code.varBuffer[n];
                if (!$assertionsDisabled && localVar.start_pc < '\u0000') {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && localVar.start_pc > code.cp) {
                    throw new AssertionError();
                }
                this.databuf.appendChar(localVar.start_pc);
                if (!$assertionsDisabled && localVar.length < '\u0000') {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && localVar.start_pc + localVar.length > code.cp) {
                    throw new AssertionError();
                }
                this.databuf.appendChar(localVar.length);
                Symbol.VarSymbol varSymbol = localVar.var;
                this.databuf.appendChar(this.pool.put(varSymbol.name));
                this.databuf.appendChar(this.pool.put(this.typeSig(varSymbol.erasure())));
                this.databuf.appendChar(localVar.reg);
            }
            this.endAttr(n2);
            ++n3;
        }
        this.endAttrs(n4, n3);
    }

    void writeFields(Scope.Entry entry) {
        List list = List.make();
        Scope.Entry entry2 = entry;
        while (entry2 != null) {
            if (entry2.sym.kind == 4) {
                list = list.prepend((Symbol.VarSymbol)entry2.sym);
            }
            entry2 = entry2.sibling;
        }
        while (list.nonEmpty()) {
            this.writeField((Symbol.VarSymbol)list.head);
            list = list.tail;
        }
    }

    void writeMethods(Scope.Entry entry) {
        List list = List.make();
        Scope.Entry entry2 = entry;
        while (entry2 != null) {
            if (entry2.sym.kind == 16) {
                list = list.prepend((Symbol.MethodSymbol)entry2.sym);
            }
            entry2 = entry2.sibling;
        }
        while (list.nonEmpty()) {
            this.writeMethod((Symbol.MethodSymbol)list.head);
            list = list.tail;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeClass(Symbol.ClassSymbol classSymbol) throws IOException, PoolOverflow, StringOverflow {
        File file = this.outputFile(classSymbol, ".class");
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            this.writeClassFile(fileOutputStream, classSymbol);
            if (this.verbose) {
                this.log.errWriter.println(Log.getLocalizedString("verbose.wrote.file", file.getPath()));
            }
            ((OutputStream)fileOutputStream).close();
            return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (fileOutputStream == null) throw throwable;
            ((OutputStream)fileOutputStream).close();
            file.delete();
            fileOutputStream = null;
            throw throwable;
        }
    }

    public void writeClassFile(OutputStream outputStream, Symbol.ClassSymbol classSymbol) throws IOException, PoolOverflow, StringOverflow {
        int n;
        if (!$assertionsDisabled && (classSymbol.flags() & 0x1000000L) != 0L) {
            throw new AssertionError();
        }
        this.databuf.reset();
        this.poolbuf.reset();
        this.sigbuf.reset();
        this.pool = classSymbol.pool;
        this.innerClasses = null;
        this.innerClassesQueue = null;
        Type type = classSymbol.type.supertype();
        List list = classSymbol.type.interfaces();
        long l = classSymbol.flags();
        if ((l & 4L) != 0L) {
            l |= 1L;
        }
        if (((l = l & 0xE11L & 0xFFFFFFFFFFFFF7FFL) & 0x200L) == 0L) {
            l |= 0x20L;
        }
        if (this.dumpClassModifiers) {
            this.log.errWriter.println();
            this.log.errWriter.println("CLASSFILE  " + classSymbol.fullName());
            this.log.errWriter.println("---" + ClassWriter.flagNames(l));
        }
        this.databuf.appendChar((int)l);
        this.databuf.appendChar(this.pool.put(classSymbol));
        this.databuf.appendChar(type.tag == 10 ? this.pool.put(type.tsym) : 0);
        this.databuf.appendChar(list.length());
        List list2 = list;
        while (list2.nonEmpty()) {
            this.databuf.appendChar(this.pool.put(((Type)list2.head).tsym));
            list2 = list2.tail;
        }
        int n2 = 0;
        int n3 = 0;
        Scope.Entry entry = classSymbol.members().elems;
        while (entry != null) {
            switch (entry.sym.kind) {
                case 4: {
                    ++n2;
                    break;
                }
                case 16: {
                    ++n3;
                    break;
                }
                case 2: {
                    this.enterInner((Symbol.ClassSymbol)entry.sym);
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
            entry = entry.sibling;
        }
        this.databuf.appendChar(n2);
        this.writeFields(classSymbol.members().elems);
        this.databuf.appendChar(n3);
        this.writeMethods(classSymbol.members().elems);
        int n4 = this.beginAttrs();
        int n5 = 0;
        if (classSymbol.sourcefile != null && this.emitSourceFile) {
            n = this.writeAttr(this.names.SourceFile);
            String string = classSymbol.sourcefile.toString();
            int n6 = string.lastIndexOf(File.separatorChar);
            int n7 = string.lastIndexOf(47);
            if (n7 > n6) {
                n6 = n7;
            }
            if (n6 >= 0) {
                string = string.substring(n6 + 1);
            }
            this.databuf.appendChar(classSymbol.pool.put(this.names.fromString(string)));
            this.endAttr(n);
            ++n5;
        }
        if (this.genCrt) {
            n = this.writeAttr(this.names.SourceID);
            this.databuf.appendChar(classSymbol.pool.put(this.names.fromString(Long.toString(this.getLastModified(classSymbol.sourcefile)))));
            this.endAttr(n);
            ++n5;
            n = this.writeAttr(this.names.CompilationID);
            this.databuf.appendChar(classSymbol.pool.put(this.names.fromString(Long.toString(System.currentTimeMillis()))));
            this.endAttr(n);
            ++n5;
        }
        n5 += this.writeFlagAttrs(classSymbol.flags());
        this.poolbuf.appendInt(-889275714);
        this.poolbuf.appendChar(this.target.minorVersion);
        this.poolbuf.appendChar(this.target.majorVersion);
        this.writePool(classSymbol.pool);
        if (this.innerClasses != null) {
            this.writeInnerClasses();
            ++n5;
        }
        this.endAttrs(n4, n5);
        this.poolbuf.appendBytes(this.databuf.elems, 0, this.databuf.length);
        outputStream.write(this.poolbuf.elems, 0, this.poolbuf.length);
        classSymbol.pool = null;
        this.pool = null;
    }

    long getLastModified(Name name) {
        long l = 0L;
        File file = new File(name.toString());
        try {
            l = file.lastModified();
        }
        catch (SecurityException securityException) {
            throw new AssertionError((Object)("CRT: couldn't get source file modification date: " + securityException.getMessage()));
        }
        return l;
    }

    public File outputFile(Symbol.ClassSymbol classSymbol, String string) throws IOException {
        if (this.outDir == null) {
            String string2 = Convert.shortName(classSymbol.flatname) + string;
            if (classSymbol.sourcefile == null) {
                return new File(string2);
            }
            String string3 = new File(classSymbol.sourcefile.toString()).getParent();
            if (string3 == null) {
                return new File(string2);
            }
            return new File(string3, string2);
        }
        return this.outputFile(this.outDir, classSymbol.flatname.toString(), string);
    }

    File outputFile(File file, String string, String string2) throws IOException {
        int n = 0;
        int n2 = string.indexOf(46);
        while (n2 >= n) {
            if (!(file = new File(file, string.substring(n, n2))).exists()) {
                file.mkdir();
            }
            n = n2 + 1;
            n2 = string.indexOf(46, n);
        }
        return new File(file, string.substring(n) + string2);
    }

    static {
        $assertionsDisabled = !ClassWriter.class.desiredAssertionStatus();
        classWriterKey = new Context.Key();
        flagName = new String[]{"PUBLIC", "PRIVATE", "PROTECTED", "STATIC", "FINAL", "SUPER", "VOLATILE", "TRANSIENT", "NATIVE", "INTERFACE", "ABSTRACT", "STRICTFP"};
    }

    public static class StringOverflow
    extends Exception {
        public final String value;

        public StringOverflow(String string) {
            this.value = string;
        }
    }

    public static class PoolOverflow
    extends Exception {
    }
}

