/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javadoc;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.SerialFieldTag;
import com.sun.tools.javadoc.Comment;
import com.sun.tools.javadoc.DocImpl;
import com.sun.tools.javadoc.FieldDocImpl;
import com.sun.tools.javadoc.MemberDocImpl;
import com.sun.tools.javadoc.TagImpl;

class SerialFieldTagImpl
extends TagImpl
implements SerialFieldTag,
Comparable {
    private String fieldName;
    private String fieldType;
    private String description;
    private ClassDoc containingClass;
    private ClassDoc fieldTypeDoc;
    private FieldDocImpl matchingField;

    SerialFieldTagImpl(DocImpl docImpl, String string, String string2) {
        super(docImpl, string, string2);
        this.parseSerialFieldString();
        if (docImpl instanceof MemberDoc) {
            this.containingClass = ((MemberDocImpl)docImpl).containingClass();
        }
    }

    private void parseSerialFieldString() {
        int n;
        int n2 = this.text.length();
        for (n = 0; n < n2 && Character.isWhitespace(this.text.charAt(n)); ++n) {
        }
        int n3 = n;
        int n4 = n;
        if (!Character.isJavaIdentifierStart(this.text.charAt(n))) {
            this.docenv().warning(this.holder, "tag.serialField.illegal_character", "" + this.text.charAt(n), this.text);
            return;
        }
        while (n < n2 && Character.isJavaIdentifierPart(this.text.charAt(n))) {
            ++n;
        }
        if (n < n2 && !Character.isWhitespace(this.text.charAt(n))) {
            this.docenv().warning(this.holder, "tag.serialField.illegal_character", "" + this.text.charAt(n), this.text);
            return;
        }
        n4 = n;
        this.fieldName = this.text.substring(n3, n4);
        while (n < n2 && Character.isWhitespace(this.text.charAt(n))) {
            ++n;
        }
        n3 = n;
        n4 = n;
        while (n < n2 && !Character.isWhitespace(this.text.charAt(n))) {
            ++n;
        }
        if (n < n2 && !Character.isWhitespace(this.text.charAt(n))) {
            this.docenv().warning(this.holder, "tag.serialField.illegal_character", "" + this.text.charAt(n), this.text);
            return;
        }
        n4 = n;
        this.fieldType = this.text.substring(n3, n4);
        while (n < n2 && Character.isWhitespace(this.text.charAt(n))) {
            ++n;
        }
        this.description = this.text.substring(n);
    }

    String key() {
        return this.fieldName;
    }

    void mapToFieldDocImpl(FieldDocImpl fieldDocImpl) {
        this.matchingField = fieldDocImpl;
    }

    public String fieldName() {
        return this.fieldName;
    }

    public String fieldType() {
        return this.fieldType;
    }

    public ClassDoc fieldTypeDoc() {
        if (this.fieldTypeDoc == null && this.containingClass != null) {
            this.fieldTypeDoc = this.containingClass.findClass(this.fieldType);
        }
        return this.fieldTypeDoc;
    }

    FieldDocImpl getMatchingField() {
        return this.matchingField;
    }

    public String description() {
        Comment comment;
        if (this.description.length() == 0 && this.matchingField != null && (comment = this.matchingField.comment()) != null) {
            return comment.commentText();
        }
        return this.description;
    }

    public String kind() {
        return "@serialField";
    }

    public String toString() {
        return this.name + ":" + this.text;
    }

    public int compareTo(Object object) {
        return this.key().compareTo(((SerialFieldTagImpl)object).key());
    }
}

