/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.crunch;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import sun.tools.crunch.Attribute;
import sun.tools.crunch.Constant;
import sun.tools.crunch.Field;
import sun.tools.crunch.GlobalTables;
import sun.tools.crunch.Method;
import sun.tools.crunch.OffsetInputStream;

public class ClassFile {
    private static boolean printConstants = false;
    private static int totalClassFiles;
    private static int totalConstants;
    private static int totalConstantsLength;
    private static int totalInterfaces;
    Constant[] constants;
    private String name;
    private int magic;
    private short majorVersion;
    private short minorVersion;
    private short flags;
    private short thisIndex;
    private short superIndex;
    private short[] interfaces;
    private Hashtable privates = new Hashtable();
    private int nextPrivateIndex;
    private Field[] fields;
    private Method[] methods;
    private Attribute[] attributes;

    public static ClassFile read(String string, InputStream inputStream) throws IOException {
        return new ClassFile(string, inputStream);
    }

    private ClassFile(String string, InputStream inputStream) throws IOException {
        int n;
        int n2;
        int n3;
        this.name = string;
        OffsetInputStream offsetInputStream = new OffsetInputStream(inputStream);
        DataInputStream dataInputStream = new DataInputStream(offsetInputStream);
        ++totalClassFiles;
        this.magic = dataInputStream.readInt();
        if (this.magic != -889275714) {
            throw new IOException("Bad classfile magic 0x" + Integer.toString(this.magic, 16));
        }
        this.minorVersion = dataInputStream.readShort();
        this.majorVersion = dataInputStream.readShort();
        if (this.minorVersion < 0 || this.minorVersion > 20) {
            throw new IOException(this.name + ": Unexpected classfile minor version " + this.minorVersion);
        }
        if (this.majorVersion < 45 || this.majorVersion > 50) {
            throw new IOException(this.name + ": Unexpected classfile major version " + this.majorVersion);
        }
        int n4 = dataInputStream.readShort();
        totalConstants += n4;
        int n5 = offsetInputStream.getOffset();
        this.constants = new Constant[n4];
        for (n3 = 1; n3 < n4; ++n3) {
            this.constants[n3] = Constant.read(this, dataInputStream);
            if (!this.constants[n3].takesTwoSlots()) continue;
            ++n3;
        }
        if (printConstants) {
            for (n3 = 0; n3 < n4; ++n3) {
                if (this.constants[n3] == null) continue;
                System.out.println("" + n3 + ": " + this.constants[n3].rawString());
            }
        }
        n3 = offsetInputStream.getOffset() - n5;
        totalConstantsLength += n3;
        this.flags = dataInputStream.readShort();
        this.thisIndex = dataInputStream.readShort();
        this.superIndex = dataInputStream.readShort();
        int n6 = dataInputStream.readShort();
        if (n6 > 255) {
            throw new Error("Too many interfaces in " + this);
        }
        totalInterfaces += n6;
        this.interfaces = new short[n6];
        for (n2 = 0; n2 < n6; ++n2) {
            this.interfaces[n2] = dataInputStream.readShort();
        }
        n2 = dataInputStream.readShort();
        this.fields = new Field[n2];
        for (n = 0; n < n2; ++n) {
            this.fields[n] = Field.read(this, dataInputStream);
        }
        n = dataInputStream.readShort();
        if (n > 255) {
            throw new Error("Too many methods in " + this);
        }
        this.methods = new Method[n];
        for (int i = 0; i < n; ++i) {
            this.methods[i] = Method.readMethod(this, dataInputStream);
        }
        this.attributes = Attribute.readAttributes(this, dataInputStream);
    }

    public short mapClass(short s) {
        if (s == 0) {
            return 0;
        }
        s = GlobalTables.findClass(this.constants[s].getClassName());
        return s;
    }

    public short mapUtf(short s) {
        if (s == 0) {
            return 0;
        }
        Constant constant = this.constants[s];
        if (constant.tag != 1) {
            throw new Error("constant isn't UTF");
        }
        s = GlobalTables.findUtf(constant.utf);
        return s;
    }

    public short mapType(short s) {
        Constant constant = this.constants[s];
        if (constant.tag != 1) {
            throw new Error("constant isn't UTF");
        }
        s = GlobalTables.findType(constant.utf);
        return s;
    }

    public short mapRef(short s) {
        Constant constant = this.constants[s];
        s = GlobalTables.findRef(constant.getRefClass(), constant.getRefName(), constant.getRefType());
        return s;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        int n;
        dataOutputStream.writeByte(this.minorVersion);
        dataOutputStream.writeByte(this.majorVersion);
        dataOutputStream.writeShort(this.flags);
        dataOutputStream.writeShort(this.mapClass(this.thisIndex));
        dataOutputStream.writeShort(this.mapClass(this.superIndex));
        dataOutputStream.writeByte(this.interfaces.length);
        for (n = 0; n < this.interfaces.length; ++n) {
            dataOutputStream.writeShort(this.mapClass(this.interfaces[n]));
        }
        dataOutputStream.writeShort(this.fields.length);
        for (n = 0; n < this.fields.length; ++n) {
            this.fields[n].write(dataOutputStream);
        }
        dataOutputStream.writeByte(this.methods.length);
        for (n = 0; n < this.methods.length; ++n) {
            this.methods[n].write(dataOutputStream);
        }
        dataOutputStream.writeByte(this.attributes.length);
        for (n = 0; n < this.attributes.length; ++n) {
            this.attributes[n].write(dataOutputStream);
        }
    }

    public String getString(short s) {
        if (s < 0 || s > this.constants.length) {
            throw new Error("bad constant index " + s);
        }
        return this.constants[s].toString();
    }

    public String getName() {
        return this.name;
    }

    public String getClassName() {
        return this.constants[this.thisIndex].getClassName();
    }

    public static void summarize() {
        System.out.println("Total number of classfiles = " + totalClassFiles);
        System.out.println("    Total number of constants = " + totalConstants);
        System.out.println("    Total length of constants = " + totalConstantsLength + " bytes");
        System.out.println("    Total number of interface refs = " + totalInterfaces);
        Method.summarize();
        Field.summarize();
        Attribute.summarize();
    }

    public String toString() {
        return this.name;
    }
}

