/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.crunch;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import sun.tools.crunch.ClassFile;
import sun.tools.crunch.GlobalTables;

public class Crunch {
    public static final int CRUNCH_MAGIC = 1262962738;
    public static final int CHUNK_MAGIC = 1194543154;
    public static final int CRUNCH_VERSION = 131073;
    private static File tfile;
    private static File ofile;
    private static String lastFileDir;
    private static int chunkCount;
    private static int totalFiles;
    private static int filesThisChunk;
    public static int Verbose;
    private static String Omask;

    private static String replaceName(String string, String string2) {
        int n = string2.indexOf(61);
        if (n < 0) {
            return string;
        }
        int n2 = string.lastIndexOf(46);
        int n3 = string.lastIndexOf(File.separatorChar);
        int n4 = string.lastIndexOf(58);
        if (n4 > n3) {
            n3 = n4;
        }
        if (n3 > n2 || n2 == -1 || n == string2.length() - 1) {
            n2 = string.length();
        }
        String string3 = n3 >= 0 ? string.substring(0, n3 + 1) : "";
        String string4 = string.substring(n3 + 1, n2);
        if (n == 0) {
            return string3 + string4 + string2.substring(1);
        }
        return string2.substring(0, n) + string4 + string2.substring(n + 1);
    }

    private static String mapFileName(String string) {
        int n = string.lastIndexOf("/");
        String string2 = string.substring(0, n + 1);
        String string3 = "";
        String string4 = string.substring(n + 1);
        if (string2.equals(lastFileDir)) {
            return string4;
        }
        while (!string2.startsWith(lastFileDir)) {
            n = lastFileDir.lastIndexOf("/", lastFileDir.length() - 2);
            lastFileDir = n >= 0 ? lastFileDir.substring(0, n + 1) : "";
            string3 = string3 + "../";
        }
        string2 = string2.substring(lastFileDir.length());
        string3 = string3 + string2 + string4;
        lastFileDir = lastFileDir + string2;
        return string3;
    }

    private static void writeFilename(DataOutputStream dataOutputStream, String string) throws IOException {
        if (string.length() > 255) {
            throw new Error("filename too long: " + string);
        }
        dataOutputStream.writeByte(string.length());
        for (int i = 0; i < string.length(); ++i) {
            short s = (short)string.charAt(i);
            if (s <= 0 || s >= 128) {
                throw new Error("Non-ascii character in writeFilename " + string);
            }
            dataOutputStream.writeByte(s);
        }
    }

    private static void writeChunk() throws IOException {
        int n;
        if (Verbose > 2) {
            System.out.println("================================================================");
            System.out.println("Writing chunk " + chunkCount);
        }
        ++chunkCount;
        int n2 = (int)ofile.length();
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(ofile, true)));
        dataOutputStream.writeInt(1194543154);
        dataOutputStream.writeInt(filesThisChunk);
        totalFiles += filesThisChunk;
        filesThisChunk = 0;
        dataOutputStream.writeInt(0);
        GlobalTables.write(dataOutputStream);
        dataOutputStream.close();
        GlobalTables.reset();
        int n3 = 22;
        int n4 = (int)(ofile.length() - (long)n2 - (long)n3);
        if (Verbose > 1) {
            System.out.println("Actual constant pool length = " + n4);
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(ofile, "rw");
        randomAccessFile.seek(n2 + 8);
        randomAccessFile.writeInt(n4);
        randomAccessFile.close();
        FileOutputStream fileOutputStream = new FileOutputStream(ofile, true);
        FileInputStream fileInputStream = new FileInputStream(tfile);
        byte[] byArray = new byte[8096];
        while ((n = fileInputStream.read(byArray)) > 0) {
            fileOutputStream.write(byArray, 0, n);
        }
        fileInputStream.close();
        fileOutputStream.close();
        tfile.delete();
    }

    private static void doit(String string) throws IOException {
        Object object;
        Object object2;
        FileInputStream fileInputStream = new FileInputStream(string);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        ZipInputStream zipInputStream = new ZipInputStream(bufferedInputStream);
        int n = 0;
        int n2 = 0;
        long l = System.currentTimeMillis();
        String string2 = Crunch.replaceName(string, Omask);
        String string3 = Crunch.replaceName(string2, "=.tmp");
        if (Verbose > 0) {
            System.out.println("crunch '" + string + "' to '" + string2 + "'.");
        }
        if (Verbose > 1) {
            System.out.println("Input file name  = " + string);
            System.out.println("Output file name = " + string2);
            System.out.println("Temp file nname  = " + string3);
        }
        tfile = new File(string3);
        ofile = new File(string2);
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(string2)));
        dataOutputStream.writeInt(1262962738);
        dataOutputStream.writeInt(131073);
        dataOutputStream.writeInt(0);
        dataOutputStream.close();
        FilterOutputStream filterOutputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(32000);
        byte[] byArray = new byte[8096];
        if (Verbose > 1) {
            System.err.println("Processing class files");
        }
        while ((object2 = zipInputStream.getNextEntry()) != null) {
            Object object3;
            String string4 = ((ZipEntry)object2).getName();
            if (string4.endsWith("/")) continue;
            ++filesThisChunk;
            string4 = Crunch.mapFileName(string4);
            if (filterOutputStream == null) {
                filterOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(string3)));
            }
            if (string4.endsWith(".class")) {
                object3 = ClassFile.read(string4, zipInputStream);
                DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
                ((ClassFile)object3).write(dataOutputStream2);
                dataOutputStream2.flush();
                object = byteArrayOutputStream.toByteArray();
                ((DataOutputStream)filterOutputStream).writeInt(((byte[])object).length);
                string4 = string4.substring(0, string4.length() - 6);
                Crunch.writeFilename((DataOutputStream)filterOutputStream, string4);
                n += 1 + string4.length();
                filterOutputStream.write((byte[])object);
                byteArrayOutputStream.reset();
            } else {
                int n3;
                while ((n3 = zipInputStream.read(byArray)) > 0) {
                    byteArrayOutputStream.write(byArray, 0, n3);
                    n2 += n3;
                }
                object3 = byteArrayOutputStream.toByteArray();
                ((DataOutputStream)filterOutputStream).writeInt(-((Object)object3).length);
                Crunch.writeFilename((DataOutputStream)filterOutputStream, string4);
                n += 1 + string4.length();
                filterOutputStream.write((byte[])object3);
                byteArrayOutputStream.reset();
            }
            if (GlobalTables.percentFull() <= 90) continue;
            filterOutputStream.close();
            filterOutputStream = null;
            Crunch.writeChunk();
        }
        zipInputStream.close();
        if (filterOutputStream != null) {
            filterOutputStream.close();
            Crunch.writeChunk();
        }
        object2 = new RandomAccessFile(ofile, "rw");
        ((RandomAccessFile)object2).seek(8L);
        ((RandomAccessFile)object2).writeInt(chunkCount);
        ((RandomAccessFile)object2).close();
        long l2 = System.currentTimeMillis();
        float f = (float)(l2 - l) / 1000.0f;
        if (Verbose >= 2) {
            System.out.println("================================================================");
            System.out.println("Across all processed files:");
            ClassFile.summarize();
            System.out.println("Total files = " + totalFiles);
            System.out.println("Total non-classfile data = " + n2);
            System.out.println("Total file name length = " + n);
            object = new File(string);
            System.out.println("Input Jar file size = " + ((File)object).length() + " bytes");
            object = new File(string2);
            System.out.println("Output Crunch file size = " + ((File)object).length() + " bytes");
            System.out.println("Time to process = " + f + " seconds");
            System.out.println("=================================================================");
        }
        if (Verbose == 1) {
            System.out.println("crunch completed OK. " + f + " seconds");
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("crunch - Crunch jar file");
            System.out.println("");
            System.out.println("syntax: crunch <options> infile.jar ...");
            System.out.println("");
            System.out.println("    The output is placed in a file of extension '.out' in the same");
            System.out.println("    directory as the input file.  Crunch is a compression designed for");
            System.out.println("    java class files and will expand other data types.");
            System.out.println("");
            System.out.println("Options:");
            System.out.println("-q      - Quiet (only error messages)");
            System.out.println("-v      - Verbose (show extra data)");
            System.out.println("-o name - Output name with '=' to substitute input file name");
            System.out.println("          Defaults to \"=.out\"");
            return;
        }
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (string.charAt(0) == '-') {
                    if (string.charAt(1) == 'v') {
                        Verbose = 2;
                        continue;
                    }
                    if (string.charAt(1) == 'q') {
                        Verbose = 0;
                        continue;
                    }
                    if (string.charAt(1) != 'o' || ++i >= stringArray.length) continue;
                    Omask = stringArray[i];
                    continue;
                }
                Crunch.doit(string);
            }
        }
        catch (Throwable throwable) {
            System.out.println("Caught: " + throwable);
            throwable.printStackTrace();
            System.exit(11);
        }
    }

    static {
        lastFileDir = "";
        Verbose = 1;
        Omask = "=.out";
    }
}

