/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.crunch;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import sun.tools.crunch.Attribute;
import sun.tools.crunch.ClassFile;

public class ExceptionsAttribute
extends Attribute {
    private ClassFile cfile;
    private short[] exceptions;
    private static int count;
    private static int totalLength;

    public static Attribute read(ClassFile classFile, DataInputStream dataInputStream) throws IOException {
        return new ExceptionsAttribute(classFile, dataInputStream);
    }

    private ExceptionsAttribute(ClassFile classFile, DataInputStream dataInputStream) throws IOException {
        this.cfile = classFile;
        dataInputStream.readInt();
        int n = dataInputStream.readShort();
        if (n > 255) {
            throw new Error("too many exceptions in exceptions attribute");
        }
        this.exceptions = new short[n];
        for (int i = 0; i < n; ++i) {
            this.exceptions[i] = dataInputStream.readShort();
        }
        ++count;
        totalLength += 2 + 2 * n;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(3);
        dataOutputStream.writeByte(this.exceptions.length);
        for (int i = 0; i < this.exceptions.length; ++i) {
            short s = this.exceptions[i];
            s = this.cfile.mapClass(s);
            dataOutputStream.writeShort(s);
        }
    }

    public static void summarize() {
        System.out.println("    " + count + " Exceptions attributes, written length = " + totalLength + " bytes");
    }
}

