/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.crunch;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import sun.tools.crunch.Crunch;

public class GlobalTables {
    public static final byte codeAttribute = 1;
    public static final byte valueAttribute = 2;
    public static final byte exceptionsAttribute = 3;
    public static final byte syntheticAttribute = 4;
    public static final byte innerClassesAttribute = 5;
    public static final byte deprecatedAttribute = 6;
    private static Pool utfPool;
    private static Pool classPool;
    private static Pool refPool;
    private static Pool typePool;
    private static Pool valuePool;

    public static void reset() {
        utfPool = new Pool();
        classPool = new Pool();
        refPool = new Pool();
        typePool = new Pool();
        valuePool = new Pool();
        GlobalTables.findUtf("Code");
        GlobalTables.findUtf("ConstantValue");
        GlobalTables.findUtf("Exceptions");
        GlobalTables.findUtf("Synthetic");
        GlobalTables.findUtf("InnerClasses");
        short s = GlobalTables.findUtf("Deprecated");
        if (s != 6) {
            throw new Error("trouble asigning attribute indexes");
        }
    }

    public static short findUtf(String string) {
        return utfPool.find(string);
    }

    public static short findClass(String string) {
        int n = string.lastIndexOf(47);
        if (n >= 0) {
            GlobalTables.findClass(string.substring(0, n));
        }
        return classPool.find(string);
    }

    public static boolean existsRef(String string, String string2, String string3) {
        String string4 = string + " " + string2 + " " + string3;
        Object v = GlobalTables.refPool.table.get(string4);
        return v != null;
    }

    public static short findRef(String string, String string2, String string3) {
        GlobalTables.findClass(string);
        GlobalTables.findUtf(string2);
        GlobalTables.findType(string3);
        String string4 = string + " " + string2 + " " + string3;
        return refPool.find(string4);
    }

    public static short findType(String string) {
        if (GlobalTables.typePool.table.get(string) == null) {
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                ++n;
                if (c != 'L') continue;
                int n2 = string.indexOf(59, n);
                String string2 = string.substring(n, n2);
                GlobalTables.findClass(string2);
                n = n2 + 1;
            }
        }
        return typePool.find(string);
    }

    public static short findValue(Object object) {
        return valuePool.find(object);
    }

    public static int writeEncodedType(DataOutputStream dataOutputStream, String string) throws IOException {
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            ++n2;
            dataOutputStream.writeByte((byte)c);
            ++n;
            if (c != 'L') continue;
            int n3 = string.indexOf(59, n2);
            String string2 = string.substring(n2, n3);
            n2 = n3 + 1;
            dataOutputStream.writeShort(GlobalTables.findClass(string2));
            n += 2;
        }
        dataOutputStream.writeByte(0);
        return ++n;
    }

    private static int writeUTF(DataOutputStream dataOutputStream, String string) throws IOException {
        int n;
        boolean bl = true;
        for (n = 0; n < string.length(); ++n) {
            short s = (short)string.charAt(n);
            if (s > 0 && s < 128) continue;
            bl = false;
            break;
        }
        if (bl) {
            for (n = 0; n < string.length(); ++n) {
                dataOutputStream.writeByte((byte)string.charAt(n));
            }
            dataOutputStream.writeByte(0);
            return string.length() + 1;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream2.writeUTF(string);
        dataOutputStream2.flush();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        dataOutputStream.write(byArray, 2, byArray.length - 2);
        dataOutputStream.writeByte(0);
        return byArray.length - 1;
    }

    public static void write(DataOutputStream dataOutputStream) throws IOException {
        int n;
        int n2;
        String string;
        int n3;
        dataOutputStream.writeShort(GlobalTables.utfPool.vector.size());
        dataOutputStream.writeShort(GlobalTables.classPool.vector.size());
        dataOutputStream.writeShort(GlobalTables.refPool.vector.size());
        dataOutputStream.writeShort(GlobalTables.typePool.vector.size());
        dataOutputStream.writeShort(GlobalTables.valuePool.vector.size());
        int n4 = 0;
        int n5 = 0;
        Hashtable hashtable = GlobalTables.utfPool.table;
        int n6 = 0;
        Vector vector = GlobalTables.utfPool.vector;
        for (n3 = 1; n3 < vector.size(); ++n3) {
            string = (String)vector.elementAt(n3);
            n6 += GlobalTables.writeUTF(dataOutputStream, string);
        }
        if (Crunch.Verbose > 1) {
            System.out.println("Wrote " + vector.size() + " entries in UTF pool," + " estimated length = " + n6);
        }
        n5 += n6;
        n4 += vector.size();
        n6 = 0;
        int n7 = 0;
        vector = GlobalTables.classPool.vector;
        for (n3 = 1; n3 < vector.size(); ++n3) {
            string = (String)vector.elementAt(n3);
            n2 = string.lastIndexOf(47);
            if (n2 >= 0) {
                n = classPool.find(string.substring(0, n2));
                dataOutputStream.writeByte(37);
                dataOutputStream.writeShort(n);
                n6 += 3;
                n6 += GlobalTables.writeUTF(dataOutputStream, string.substring(n2 + 1));
                continue;
            }
            n6 += GlobalTables.writeUTF(dataOutputStream, string);
        }
        if (Crunch.Verbose > 1) {
            System.out.println("Wrote " + vector.size() + " entries in Class pool," + " estimated length = " + n6);
        }
        n5 += n6;
        n4 += vector.size();
        n6 = 0;
        vector = GlobalTables.refPool.vector;
        for (n3 = 1; n3 < vector.size(); ++n3) {
            string = (String)vector.elementAt(n3);
            n2 = string.indexOf(" ");
            n = string.indexOf(" ", n2 + 1);
            String string2 = string.substring(0, n2);
            String string3 = string.substring(n2 + 1, n);
            String string4 = string.substring(n + 1);
            dataOutputStream.writeShort(GlobalTables.findClass(string2));
            dataOutputStream.writeShort(GlobalTables.findUtf(string3));
            dataOutputStream.writeShort(GlobalTables.findType(string4));
            n6 += 6;
        }
        if (Crunch.Verbose > 1) {
            System.out.println("Wrote " + vector.size() + " entries in Ref pool," + " estimated length = " + n6);
        }
        n5 += n6;
        n4 += vector.size();
        n6 = 0;
        n7 = 0;
        vector = GlobalTables.typePool.vector;
        for (n3 = 1; n3 < vector.size(); ++n3) {
            string = (String)vector.elementAt(n3);
            n2 = GlobalTables.writeEncodedType(dataOutputStream, string);
            n6 += n2;
        }
        if (Crunch.Verbose > 1) {
            System.out.println("Wrote " + vector.size() + " entries in Type pool," + " estimated length = " + n6);
        }
        n5 += n6;
        n4 += vector.size();
        n6 = 0;
        n7 = 0;
        n3 = 0;
        vector = GlobalTables.valuePool.vector;
        int n8 = 0;
        n2 = 0;
        n = 0;
        int n9 = 0;
        int n10 = 0;
        for (int i = 1; i < vector.size(); ++i) {
            Object e = vector.elementAt(i);
            if (e instanceof String) {
                String string5 = (String)e;
                dataOutputStream.writeByte(8);
                ++n6;
                n6 += GlobalTables.writeUTF(dataOutputStream, string5);
                if (hashtable.get(string5) != null) {
                    ++n7;
                    n3 += string5.length();
                }
                ++n8;
                continue;
            }
            if (e instanceof Integer) {
                dataOutputStream.writeByte(3);
                ++n6;
                dataOutputStream.writeInt((Integer)e);
                n6 += 4;
                ++n2;
                continue;
            }
            if (e instanceof Long) {
                dataOutputStream.writeByte(5);
                ++n6;
                dataOutputStream.writeLong((Long)e);
                n6 += 8;
                ++n;
                continue;
            }
            if (e instanceof Float) {
                dataOutputStream.writeByte(4);
                ++n6;
                dataOutputStream.writeFloat(((Float)e).floatValue());
                n6 += 4;
                ++n9;
                continue;
            }
            if (e instanceof Double) {
                dataOutputStream.writeByte(6);
                ++n6;
                dataOutputStream.writeDouble((Double)e);
                n6 += 8;
                ++n10;
                continue;
            }
            throw new Error("Unexpected type in value pool: " + e.getClass());
        }
        if (Crunch.Verbose > 1) {
            System.out.println("Wrote " + vector.size() + " entries in Value pool," + " estimated length = " + n6);
            System.out.println("        " + n8 + " were Strings");
            System.out.println("            " + n7 + " (" + n3 + " bytes) were also in UTF pool");
            System.out.println("        " + n2 + " were ints");
            System.out.println("        " + n + " were longs");
            System.out.println("        " + n9 + " were floats");
            System.out.println("        " + n10 + " were doubles");
            System.out.println("Total of " + (n4 += vector.size()) + " pool entries," + " estimated length = " + (n5 += n6));
        }
    }

    public static int percentFull() {
        int n = 0;
        if (utfPool.getMax() > n) {
            n = utfPool.getMax();
        }
        if (classPool.getMax() > n) {
            n = classPool.getMax();
        }
        if (refPool.getMax() > n) {
            n = refPool.getMax();
        }
        if (typePool.getMax() > n) {
            n = typePool.getMax();
        }
        if (valuePool.getMax() > n) {
            n = valuePool.getMax();
        }
        return n * 100 / 65536;
    }

    static {
        GlobalTables.reset();
    }

    private static class Pool {
        Vector vector = new Vector();
        Hashtable table = new Hashtable();

        Pool() {
            this.vector.addElement("");
        }

        short find(Object object) {
            Integer n = (Integer)this.table.get(object);
            if (n == null) {
                n = new Integer(this.vector.size());
                this.vector.addElement(object);
                this.table.put(object, n);
                if (n >= 65536) {
                    throw new Error("Ran out of 16 bit pool space");
                }
            }
            return n.shortValue();
        }

        int getMax() {
            return this.vector.size();
        }
    }
}

