/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.crunch;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import sun.tools.crunch.Attribute;
import sun.tools.crunch.ClassFile;

public class InnerClassesAttribute
extends Attribute {
    private ClassFile cfile;
    private short[] inners;
    private short[] outers;
    private short[] names;
    private short[] flags;
    private static int count;
    private static int totalLength;

    public static Attribute read(ClassFile classFile, DataInputStream dataInputStream) throws IOException {
        return new InnerClassesAttribute(classFile, dataInputStream);
    }

    private InnerClassesAttribute(ClassFile classFile, DataInputStream dataInputStream) throws IOException {
        this.cfile = classFile;
        dataInputStream.readInt();
        int n = dataInputStream.readShort();
        if (n > 255) {
            throw new Error("too many entries in InnerClasses attribute");
        }
        this.inners = new short[n];
        this.outers = new short[n];
        this.names = new short[n];
        this.flags = new short[n];
        for (int i = 0; i < n; ++i) {
            this.inners[i] = dataInputStream.readShort();
            this.outers[i] = dataInputStream.readShort();
            this.names[i] = dataInputStream.readShort();
            this.flags[i] = dataInputStream.readShort();
        }
        ++count;
        totalLength += 2 + 8 * n;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(5);
        dataOutputStream.writeByte(this.inners.length);
        for (int i = 0; i < this.inners.length; ++i) {
            dataOutputStream.writeShort(this.cfile.mapClass(this.inners[i]));
            dataOutputStream.writeShort(this.cfile.mapClass(this.outers[i]));
            dataOutputStream.writeShort(this.cfile.mapUtf(this.names[i]));
            dataOutputStream.writeShort(this.flags[i]);
        }
    }

    public static void summarize() {
        System.out.println("    " + count + " InnerClasses attributes, written length = " + totalLength + " bytes");
    }
}

