/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.javazic;

import sun.tools.javazic.Main;

class LatitudeAndLongitude {
    private float latitude;
    private float longitude;

    LatitudeAndLongitude(String string) {
        try {
            if (!string.startsWith("+") && !string.startsWith("-")) {
                Main.warning("Wrong latitude&longitude data: " + string);
                return;
            }
            int n = string.lastIndexOf("+");
            if (n <= 0 && (n = string.lastIndexOf("-")) <= 0) {
                Main.warning("Wrong latitude&longitude data: " + string);
                return;
            }
            this.latitude = (float)(string.startsWith("+") ? 1 : -1) * Float.parseFloat(string.substring(1, n));
            this.latitude = n > 5 ? (this.latitude /= 10000.0f) : (this.latitude /= 100.0f);
            this.longitude = (float)(string.charAt(n) == '+' ? 1 : -1) * Float.parseFloat(string.substring(n + 1));
            this.longitude = string.length() - n > 6 ? (this.longitude /= 10000.0f) : (this.longitude /= 100.0f);
        }
        catch (Exception exception) {
            Main.warning("LatitudeAndLongitude() Parse error: " + string);
        }
    }

    float getLatitude() {
        return this.latitude;
    }

    float getLongitude() {
        return this.longitude;
    }
}

