/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.javazic;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import sun.tools.javazic.Main;
import sun.tools.javazic.Zone;
import sun.tools.javazic.Zoneinfo;

class Mappings {
    private TreeMap aliases = new TreeMap();
    private LinkedList rawOffsetsIndex = new LinkedList();
    private LinkedList rawOffsetsIndexTable = new LinkedList();

    Mappings() {
    }

    void add(Zoneinfo zoneinfo) {
        HashMap hashMap = zoneinfo.getZones();
        Set set = hashMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            TreeSet<String> treeSet;
            int n;
            String string = (String)iterator.next();
            Zone zone = zoneinfo.getZone(string);
            String string2 = zone.getName();
            int n2 = zone.get(zone.size() - 1).getGmtOffset();
            if (!this.rawOffsetsIndex.contains(new Integer(n2))) {
                int n3 = this.rawOffsetsIndex.size();
                for (n = 0; n < n3 && (Integer)this.rawOffsetsIndex.get(n) <= n2; ++n) {
                }
                this.rawOffsetsIndex.add(n, new Integer(n2));
                treeSet = new TreeSet<String>();
                treeSet.add(string2);
                this.rawOffsetsIndexTable.add(n, treeSet);
            } else {
                n = this.rawOffsetsIndex.indexOf(new Integer(n2));
                treeSet = (TreeSet<String>)this.rawOffsetsIndexTable.get(n);
            }
            treeSet.add(string2);
        }
        this.aliases.putAll(zoneinfo.getAliases());
    }

    void resolve() {
        Object[] objectArray = this.aliases.keySet().toArray();
        int n = objectArray.length;
        int n2 = this.rawOffsetsIndexTable.size();
        for (int i = 0; i < n; ++i) {
            String string = objectArray[i].toString();
            boolean bl = false;
            for (int j = 0; j < n2; ++j) {
                TreeSet treeSet = (TreeSet)this.rawOffsetsIndexTable.get(j);
                if (!treeSet.contains(this.aliases.get(string)) || !Zone.isTargetZone(string)) continue;
                bl = true;
                treeSet.add(string);
                Main.info("Alias <" + string + "> added to the list.");
                break;
            }
            if (bl) continue;
            Main.info("Alias <" + string + "> removed from the list.");
            this.aliases.remove(string);
        }
    }

    TreeMap getAliases() {
        return this.aliases;
    }

    LinkedList getRawOffsetsIndex() {
        return this.rawOffsetsIndex;
    }

    LinkedList getRawOffsetsIndexTable() {
        return this.rawOffsetsIndexTable;
    }
}

