/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.javazic;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.TreeSet;
import sun.tools.javazic.BackEnd;
import sun.tools.javazic.Main;
import sun.tools.javazic.Mappings;
import sun.tools.javazic.Month;
import sun.tools.javazic.RuleRec;
import sun.tools.javazic.Time;
import sun.tools.javazic.Timezone;
import sun.tools.javazic.Zone;
import sun.tools.javazic.ZoneRec;

class Simple
extends BackEnd {
    private static HashMap lastZoneRecs;
    private static TreeMap lastRules;

    Simple() {
    }

    int processZoneinfo(Timezone timezone) {
        String string = timezone.getName();
        if (lastRules == null) {
            lastRules = new TreeMap();
            lastZoneRecs = new HashMap();
        }
        lastRules.put(string, timezone.getLastRules());
        lastZoneRecs.put(string, timezone.getLastZoneRec());
        return 0;
    }

    int generateSrc(Mappings mappings) {
        try {
            String string = Main.getOutputDir();
            File file = new File(string);
            if (!string.endsWith(File.separator)) {
                string = string + File.separator;
            }
            file.mkdirs();
            FileWriter fileWriter = new FileWriter(string + "TimeZoneData.java", false);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write("import java.util.SimpleTimeZone;\n\n");
            bufferedWriter.write("    static SimpleTimeZone zones[] = {\n");
            TreeMap treeMap = mappings.getAliases();
            LinkedList linkedList = mappings.getRawOffsetsIndexTable();
            int n = linkedList.size();
            for (int i = 0; i < n; ++i) {
                TreeSet treeSet = (TreeSet)linkedList.get(i);
                Iterator iterator = treeSet.iterator();
                while (iterator.hasNext()) {
                    Object object;
                    ZoneRec zoneRec;
                    ArrayList arrayList;
                    String string2 = (String)iterator.next();
                    String string3 = (String)treeMap.get(string2);
                    if (string3 != null) {
                        if (!Zone.isTargetZone(string2)) continue;
                        arrayList = (ArrayList)lastRules.get(string3);
                        zoneRec = (ZoneRec)lastZoneRecs.get(string3);
                    } else {
                        arrayList = (ArrayList)lastRules.get(string2);
                        zoneRec = (ZoneRec)lastZoneRecs.get(string2);
                    }
                    bufferedWriter.write("\t//--------------------------------------------------------------------\n");
                    int n2 = (Integer)mappings.getRawOffsetsIndex().get(i);
                    String string4 = Time.toFormedString(n2);
                    bufferedWriter.write("\tnew SimpleTimeZone(" + Time.toFormedString(n2) + ", \"" + string2 + "\"");
                    if (string3 != null) {
                        bufferedWriter.write(" /* " + string3 + " */");
                    }
                    if (arrayList == null) {
                        bufferedWriter.write("),\n");
                    } else {
                        object = (RuleRec)arrayList.get(0);
                        RuleRec ruleRec = (RuleRec)arrayList.get(1);
                        bufferedWriter.write(",\n\t  " + Month.toString(((RuleRec)object).getMonthNum()) + ", " + ((RuleRec)object).getDay().getDayForSimpleTimeZone() + ", " + ((RuleRec)object).getDay().getDayOfWeekForSimpleTimeZone() + ", " + Time.toFormedString((int)((RuleRec)object).getTime().getTime()) + ", " + ((RuleRec)object).getTime().getTypeForSimpleTimeZone() + ",\n" + "\t  " + Month.toString(ruleRec.getMonthNum()) + ", " + ruleRec.getDay().getDayForSimpleTimeZone() + ", " + ruleRec.getDay().getDayOfWeekForSimpleTimeZone() + ", " + Time.toFormedString((int)ruleRec.getTime().getTime()) + ", " + ruleRec.getTime().getTypeForSimpleTimeZone() + ",\n" + "\t  " + Time.toFormedString(((RuleRec)object).getSave()) + "),\n");
                        bufferedWriter.write("\t// " + ((RuleRec)object).getLine() + "\n");
                        bufferedWriter.write("\t// " + ruleRec.getLine() + "\n");
                    }
                    object = zoneRec.getLine();
                    if (((String)object).indexOf("Zone") == -1) {
                        object = "Zone " + string2 + "\t" + ((String)object).trim();
                    }
                    bufferedWriter.write("\t// " + (String)object + "\n");
                }
            }
            bufferedWriter.write("    };\n");
            bufferedWriter.close();
            fileWriter.close();
        }
        catch (IOException iOException) {
            Main.panic("IO error: " + iOException.getMessage());
            return 1;
        }
        return 0;
    }
}

