/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.javazic;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import sun.tools.javazic.Main;
import sun.tools.javazic.Month;
import sun.tools.javazic.Rule;
import sun.tools.javazic.RuleRec;
import sun.tools.javazic.Time;
import sun.tools.javazic.Timezone;
import sun.tools.javazic.Zone;
import sun.tools.javazic.ZoneRec;

class Zoneinfo {
    private static final int minYear = 1900;
    private static final int maxYear = 2037;
    private static int startYear = 1900;
    private static int endYear = 2037;
    static boolean isYearForTimeZoneDataSpecified = false;
    private HashMap zones = new HashMap();
    private HashMap rules = new HashMap();
    private HashMap aliases = new HashMap();
    private static String line;
    private static int lineNum;

    Zoneinfo() {
    }

    void add(Zone zone) {
        String string = zone.getName();
        this.zones.put(string, zone);
    }

    void add(Rule rule) {
        String string = rule.getName();
        this.rules.put(string, rule);
    }

    void putAlias(String string, String string2) {
        this.aliases.put(string, string2);
    }

    static void setYear(int n) {
        Zoneinfo.setStartYear(n);
        Zoneinfo.setEndYear(n);
        isYearForTimeZoneDataSpecified = true;
    }

    static void setStartYear(int n) {
        if (n < 1900 || n > endYear) {
            throw new IllegalArgumentException("invalid start year specified: " + n);
        }
        startYear = n;
    }

    static int getStartYear() {
        return startYear;
    }

    static void setEndYear(int n) {
        if (n < startYear || n > 2037) {
            throw new IllegalArgumentException();
        }
        endYear = n;
    }

    static int getEndYear() {
        return endYear;
    }

    static int getMinYear() {
        return 1900;
    }

    static int getMaxYear() {
        return 2037;
    }

    HashMap getAliases() {
        return this.aliases;
    }

    HashMap getZones() {
        return this.zones;
    }

    Zone getZone(String string) {
        return (Zone)this.zones.get(string);
    }

    Rule getRule(String string) {
        return (Rule)this.rules.get(string);
    }

    Iterator getZoneIterator() {
        return this.zones.keySet().iterator();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Zoneinfo parse(String string) {
        Object object;
        BufferedReader bufferedReader = null;
        try {
            object = new FileReader(string);
            bufferedReader = new BufferedReader((Reader)object);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Zoneinfo.panic("can't open file: " + string);
        }
        object = new Zoneinfo();
        boolean bl = false;
        Zone zone = null;
        try {
            while (true) {
                Object object2;
                Object object3;
                int n;
                String string2;
                StringTokenizer stringTokenizer;
                if ((line = bufferedReader.readLine()) == null) {
                    bufferedReader.close();
                    return object;
                }
                ++lineNum;
                if (line.length() == 0 || line.charAt(0) == '#' || !(stringTokenizer = new StringTokenizer(string2 = (n = line.lastIndexOf(35)) != -1 ? line.substring(0, n) : line)).hasMoreTokens()) continue;
                String string3 = stringTokenizer.nextToken();
                if (bl || "Zone".equals(string3)) {
                    if (zone == null) {
                        if (!stringTokenizer.hasMoreTokens()) {
                            Zoneinfo.panic("syntax error: zone no more token");
                        }
                        if ((string3 = stringTokenizer.nextToken()).startsWith("GMT+") || string3.startsWith("GMT-")) continue;
                        zone = new Zone(string3);
                    } else {
                        stringTokenizer = new StringTokenizer(string2);
                    }
                    object3 = ZoneRec.parse(stringTokenizer);
                    ((ZoneRec)object3).setLine(line);
                    zone.add((ZoneRec)object3);
                    bl = ((ZoneRec)object3).hasUntil();
                    if (bl) continue;
                    if (Zone.isTargetZone(zone.getName())) {
                        ((Zoneinfo)object).add(zone);
                    }
                    zone = null;
                    continue;
                }
                if ("Rule".equals(string3)) {
                    if (!stringTokenizer.hasMoreTokens()) {
                        Zoneinfo.panic("syntax error: rule no more token");
                    }
                    if ((object3 = ((Zoneinfo)object).getRule(string3 = stringTokenizer.nextToken())) == null) {
                        object3 = new Rule(string3);
                        ((Zoneinfo)object).add((Rule)object3);
                    }
                    object2 = RuleRec.parse(stringTokenizer);
                    ((RuleRec)object2).setLine(line);
                    ((Rule)object3).add((RuleRec)object2);
                    continue;
                }
                if (!"Link".equals(string3)) continue;
                try {
                    object3 = stringTokenizer.nextToken();
                    object2 = stringTokenizer.nextToken();
                    if (((String)object2).startsWith("GMT+") || ((String)object2).startsWith("GMT-") || "ROC".equals(object2)) continue;
                    ((Zoneinfo)object).putAlias((String)object2, (String)object3);
                }
                catch (Exception exception) {
                    Zoneinfo.panic("syntax error: no more token for Link");
                }
            }
        }
        catch (IOException iOException) {
            Zoneinfo.panic("IO error: " + iOException.getMessage());
        }
        return object;
    }

    Timezone phase2(String string) {
        int n;
        Timezone timezone = new Timezone(string);
        Zone zone = this.getZone(string);
        zone.resolve(this);
        if (isYearForTimeZoneDataSpecified) {
            ZoneRec zoneRec = zone.get(zone.size() - 1);
            timezone.setLastZoneRec(zoneRec);
            timezone.setRawOffset(zoneRec.getGmtOffset());
            if (zoneRec.hasRuleReference()) {
                ArrayList arrayList = zoneRec.getRuleRef().getRules(startYear);
                if (arrayList.size() == 2) {
                    RuleRec ruleRec = (RuleRec)arrayList.get(0);
                    RuleRec ruleRec2 = (RuleRec)arrayList.get(1);
                    if (ruleRec.getSave() == 0 && ruleRec2.getSave() > 0) {
                        arrayList.set(0, ruleRec2);
                        arrayList.set(1, ruleRec);
                    } else if (ruleRec.getSave() <= 0 || ruleRec2.getSave() != 0) {
                        arrayList = null;
                        Main.error(string + ": rules for " + startYear + " not found.");
                    }
                } else {
                    arrayList = null;
                }
                if (arrayList != null) {
                    timezone.setLastRules(arrayList);
                }
            }
            return timezone;
        }
        int n2 = n = 1900;
        long l = Time.getLocalTime(startYear, Month.parse("Jan"), 1, 0);
        ZoneRec zoneRec = zone.get(zone.size() - 1);
        timezone.getOffsetIndex(zoneRec.getGmtOffset());
        int n3 = 0;
        for (int i = 0; i < zone.size(); ++i) {
            zoneRec = zone.get(i);
            boolean bl = false;
            int n4 = zoneRec.getGmtOffset();
            int n5 = zoneRec.getDirectSave();
            if (!zoneRec.hasUntil()) {
                timezone.setRawOffset(n4, l);
                if (zoneRec.hasRuleReference()) {
                    timezone.setLastRules(zoneRec.getRuleRef().getLastRules());
                } else if (n5 != 0) {
                    timezone.setLastDSTSaving(n5);
                }
            }
            if (!zoneRec.hasRuleReference()) {
                if (!zoneRec.hasUntil() || zoneRec.getUntilTime(n5) >= l) {
                    timezone.addTransition(l, timezone.getOffsetIndex(n4 + n5), timezone.getDstOffsetIndex(n5));
                    bl = true;
                }
                n3 = n5;
                if (!zoneRec.hasUntil()) {
                    if (timezone.getNTransitions() > 0) {
                        if (n5 == 0) {
                            timezone.setDSTType(3);
                        } else {
                            timezone.setDSTType(2);
                        }
                        long l2 = Time.getLocalTime(2037, Month.parse("Jan"), 1, 0);
                        timezone.addTransition(l2 -= (long)zoneRec.getGmtOffset(), timezone.getOffsetIndex(n4 + n5), timezone.getDstOffsetIndex(n5));
                        timezone.addUsedRec(zoneRec);
                        break;
                    }
                    timezone.setDSTType(1);
                    break;
                }
            } else {
                Rule rule = zoneRec.getRuleRef();
                boolean bl2 = false;
                n3 = 0;
                block1: for (n = Zoneinfo.getMinYear(); !(n > endYear || zoneRec.hasUntil() && n > zoneRec.getUntilYear()); ++n) {
                    ArrayList arrayList = rule.getRules(n);
                    if (arrayList.size() > 0) {
                        for (int j = 0; j < arrayList.size(); ++j) {
                            RuleRec ruleRec = (RuleRec)arrayList.get(j);
                            long l3 = ruleRec.getTransitionTime(n, n4, n3);
                            if (zoneRec.hasUntil() && l3 >= zoneRec.getUntilTime(n3)) break block1;
                            if (!bl2) {
                                if (l <= l3) {
                                    ArrayList arrayList2;
                                    ZoneRec zoneRec2 = zone.get(i - 1);
                                    bl2 = true;
                                    int n6 = j > 0 ? ((RuleRec)arrayList.get(j - 1)).getSave() : ((arrayList2 = rule.getRules(n - 1)).size() > 0 ? ((RuleRec)arrayList2.get(arrayList2.size() - 1)).getSave() : 0);
                                    if (ruleRec.isSameTransition(zoneRec2, n6, n4)) {
                                        n3 = ruleRec.getSave();
                                        timezone.addTransition(l, timezone.getOffsetIndex(n4 + n3), timezone.getDstOffsetIndex(n3));
                                        bl = true;
                                        timezone.addUsedRec(ruleRec);
                                        continue;
                                    }
                                    if (!zoneRec2.hasRuleReference() || rule != zoneRec2.getRuleRef() || rule == zoneRec2.getRuleRef() && n4 != zoneRec2.getGmtOffset()) {
                                        int n7 = l == l3 ? ruleRec.getSave() : n3;
                                        timezone.addTransition(l, timezone.getOffsetIndex(n4 + n7), timezone.getDstOffsetIndex(n7));
                                        timezone.addUsedRec(ruleRec);
                                        bl = true;
                                    }
                                } else if (n == n2 && j == arrayList.size() - 1) {
                                    int n8 = ruleRec.getSave();
                                    timezone.addTransition(l, timezone.getOffsetIndex(n4 + n8), timezone.getDstOffsetIndex(n8));
                                }
                            }
                            n3 = ruleRec.getSave();
                            if (l >= l3) continue;
                            timezone.addTransition(l3, timezone.getOffsetIndex(n4 + n3), timezone.getDstOffsetIndex(n3));
                            timezone.addUsedRec(ruleRec);
                            bl = true;
                        }
                        continue;
                    }
                    if (n == n2) {
                        timezone.addTransition(l, timezone.getOffsetIndex(n4 + n3), timezone.getDstOffsetIndex(n3));
                        bl2 = true;
                    }
                    if (n != endYear || zoneRec.hasUntil()) continue;
                    if (timezone.getNTransitions() > 0) {
                        timezone.setDSTType(3);
                        long l4 = Time.getLocalTime(2037, Month.parse("Jan"), 1, 0);
                        timezone.addTransition(l4 -= (long)zoneRec.getGmtOffset(), timezone.getOffsetIndex(n4), timezone.getDstOffsetIndex(0));
                        bl = true;
                        continue;
                    }
                    timezone.setDSTType(1);
                }
            }
            if (bl) {
                timezone.addUsedRec(zoneRec);
            }
            if (!zoneRec.hasUntil() || zoneRec.getUntilTime(n3) <= l) continue;
            l = zoneRec.getUntilTime(n3);
            n2 = zoneRec.getUntilYear();
            n = zoneRec.getUntilYear();
        }
        if (timezone.getDSTType() == 0) {
            timezone.setDSTType(4);
        }
        timezone.optimize();
        timezone.checksum();
        return timezone;
    }

    private static void panic(String string) {
        Main.panic(string);
    }
}

