/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.jcache;

public class CacheKey {
    private ClassLoader _classLoader;
    private String _cacheName;

    public CacheKey(ClassLoader classLoader, String string) {
        this._classLoader = classLoader;
        this._cacheName = string;
    }

    public CacheKey(String string) {
        this._classLoader = Thread.currentThread().getContextClassLoader();
        if (this._classLoader == null) {
            this._classLoader = ClassLoader.getSystemClassLoader();
        }
        this._cacheName = string;
    }

    public String getCacheName() {
        return this._cacheName;
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public int hashCode() {
        return 31 * this._classLoader.hashCode() + this._cacheName.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof CacheKey) {
            CacheKey cacheKey = (CacheKey)object;
            return cacheKey._classLoader.equals(this._classLoader) && cacheKey._cacheName.equals(this._cacheName);
        }
        return false;
    }

    public String toString() {
        return "CacheKey: classLoader=" + this._classLoader + "; cacheName=" + this._cacheName;
    }
}

