/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.ldap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.naming.util.Helpers;
import java.io.FileOutputStream;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;

public class WsnLdapHelpers {
    private static final TraceComponent tc = Tr.register(class$com$ibm$ws$naming$ldap$WsnLdapHelpers == null ? (class$com$ibm$ws$naming$ldap$WsnLdapHelpers = WsnLdapHelpers.class$("com.ibm.ws.naming.ldap.WsnLdapHelpers")) : class$com$ibm$ws$naming$ldap$WsnLdapHelpers, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    static /* synthetic */ Class class$com$ibm$ws$naming$ldap$WsnLdapHelpers;

    private WsnLdapHelpers() {
    }

    protected static String getStringFromAttribute(Attributes attributes, String string, int n) throws NamingException {
        Object object;
        Attribute attribute = attributes.get(string);
        if (attribute != null && (object = attribute.get()) != null && object instanceof String) {
            return (String)object;
        }
        if (n == 2) {
            return null;
        }
        object = "Attribute " + string + " does not exist or doesw not contain a String";
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getStringFromAttribute - " + (String)object, new String[]{"Attribute Name = " + string, "Attributes     = " + attributes});
        }
        throw new NamingException((String)object);
    }

    protected static String singleEscapeEscapes(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\\", true);
        String string2 = "";
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.equals("\\")) {
                string2 = string2 + "\\";
            }
            string2 = string2 + string3;
        }
        return string2;
    }

    protected static String doubleEscapeEscapes(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\\", true);
        String string2 = "";
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.equals("\\")) {
                string2 = string2 + "\\\\";
            }
            string2 = string2 + string3;
        }
        return string2;
    }

    protected static String tripleEscapeEscapes(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\\", true);
        String string2 = "";
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.equals("\\")) {
                string2 = string2 + "\\\\\\";
            }
            string2 = string2 + string3;
        }
        return string2;
    }

    public static void setupLdapProtocolTracing(Hashtable hashtable) {
        block7: {
            try {
                String string = (String)hashtable.get("com.ibm.websphere.naming.ldapprotocoltrace");
                if (string == null) {
                    return;
                }
                if (string.equalsIgnoreCase("true")) {
                    FileOutputStream fileOutputStream = null;
                    String string2 = (String)hashtable.get("com.ibm.websphere.naming.ldapprotocoltracefile");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "setting protocol tracing to file >>" + string2);
                    }
                    if (string2 == null) {
                        hashtable.put("com.sun.jndi.ldap.trace.ber", System.out);
                    } else {
                        fileOutputStream = new FileOutputStream(string2, true);
                        hashtable.put("com.sun.jndi.ldap.trace.ber", fileOutputStream);
                    }
                    break block7;
                }
                return;
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws.naming.ldap.WsnLdapHelpers.setupLdapProtocolTracing", "236");
                Tr.warning(tc, "cannot set protocol tracing due to the following exception: " + exception);
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "stacktrace >>" + Helpers.getStackTrace(exception));
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

