/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.naming.HostnameNormalizer;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.naming.util.Helpers;
import java.net.InetAddress;
import java.util.Hashtable;
import javax.naming.NamingException;

public class DefaultHostnameNormalizer
implements HostnameNormalizer {
    private static final TraceComponent _tc = Tr.register(class$com$ibm$ws$naming$util$DefaultHostnameNormalizer == null ? (class$com$ibm$ws$naming$util$DefaultHostnameNormalizer = DefaultHostnameNormalizer.class$("com.ibm.ws.naming.util.DefaultHostnameNormalizer")) : class$com$ibm$ws$naming$util$DefaultHostnameNormalizer, "Naming");
    private static Hashtable _cachedNormalizedHostname;
    static /* synthetic */ Class class$com$ibm$ws$naming$util$DefaultHostnameNormalizer;

    public DefaultHostnameNormalizer() {
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, "DefaultHostnameNormalizer constructor ");
        }
    }

    public String normalizeHostname(boolean bl) throws NamingException {
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, "normalizeHostname(boolean)");
        }
        return this.normalizeHostname(bl, "localhost");
    }

    public String normalizeHostname(boolean bl, String string) throws NamingException {
        String string2;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "normalizeHostname(boolean, String) ");
        }
        if ((string2 = (String)_cachedNormalizedHostname.get(string)) != null) {
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "normalizeHostname(boolean, String) and cached returnHostname=" + string2);
            }
            if (bl) {
                string2 = this.doEscapeDots(string2);
            }
            return string2;
        }
        InetAddress inetAddress = null;
        try {
            inetAddress = string.equalsIgnoreCase("localhost") ? InetAddress.getLocalHost() : InetAddress.getByName(string);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.naming.util.DefaultHostnameNormalizer.normalizeHostname", "145", this);
            if (_tc.isEntryEnabled()) {
                Tr.debug(_tc, "Exception occurred while processing " + string);
                Tr.debug(_tc, Helpers.getStackTrace(exception));
            }
            NamingException namingException = new NamingException("The normalizeHostname operation failed. Please get the root cause Throwable contained in this NamingException for more information.");
            namingException.setRootCause(exception);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "normalizeHostname(boolean, String)");
            }
            throw namingException;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "normalizeHostname(boolean, String) ");
        }
        return this.normalizeHostname(bl, inetAddress, string);
    }

    public String normalizeHostname(boolean bl, InetAddress inetAddress) throws NamingException {
        if (_tc.isEventEnabled()) {
            Tr.event(_tc, "normalizeHostname(boolean, InetAddress");
        }
        return this.normalizeHostname(bl, inetAddress, null);
    }

    private String normalizeHostname(boolean bl, InetAddress inetAddress, String string) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "normalizeHostname(boolean, InetAddress, String)");
        }
        String string2 = null;
        String string3 = (String)_cachedNormalizedHostname.get(inetAddress);
        if (string3 == null) {
            try {
                String string4 = inetAddress.getHostAddress();
                string2 = InetAddress.getByName(string4).getHostName();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.naming.util.DefaultHostnameNormalizer.normalizeHostname", "232", this);
                if (_tc.isEntryEnabled()) {
                    Tr.debug(_tc, "Exception processing getHostName");
                    Tr.debug(_tc, Helpers.getStackTrace(exception));
                }
                NamingException namingException = new NamingException("The normalizeHostname operation failed. Please get the root cause Throwable contained in this NamingException for more information.");
                namingException.setRootCause(exception);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "normalizeHostname(boolean, InetAddress, String)");
                }
                throw namingException;
            }
            string3 = string2.toLowerCase();
            _cachedNormalizedHostname.put(inetAddress, string3);
            if (string != null) {
                _cachedNormalizedHostname.put(string, string3);
            }
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "get cached host name");
        }
        if (bl) {
            string3 = this.doEscapeDots(string3);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "normalizeHostname(boolean, InetAddress, String), returnHostname = " + string3);
        }
        return string3;
    }

    private String doEscapeDots(String string) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "doescapeDots(String), hostname=" + string);
        }
        String string2 = "";
        int n = 0;
        int n2 = -1;
        while ((n2 = string.indexOf(46, n)) != -1) {
            string2 = string2 + string.substring(n, n2) + "\\.";
            n = n2 + 1;
        }
        if (n < string.length()) {
            string2 = string2 + string.substring(n);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "doescapeDots(String), returnHostname=" + string2);
        }
        return string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: @(#) 1.11 ws/code/naming.client/src/com/ibm/ws/naming/util/DefaultHostnameNormalizer.java, WAS.naming.client, ASV51X, a0425.05 7/22/03 15:31:38 [6/24/04 12:12:03]");
        }
        _cachedNormalizedHostname = new Hashtable();
    }
}

