/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.rmi.util.Utility;
import org.omg.CORBA.DATA_CONVERSION;

public class URLNameHelpers {
    private static final TraceComponent _tc = Tr.register(class$com$ibm$ws$naming$util$URLNameHelpers == null ? (class$com$ibm$ws$naming$util$URLNameHelpers = URLNameHelpers.class$("com.ibm.ws.naming.util.URLNameHelpers")) : class$com$ibm$ws$naming$util$URLNameHelpers, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final String RFC2396 = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789;/:?@&=+$,-_.!~*'()";
    static /* synthetic */ Class class$com$ibm$ws$naming$util$URLNameHelpers;

    protected URLNameHelpers() {
    }

    public static String encodeCorbaURL(String string) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "encodeCorbaURL()", "inUrl = " + string);
        }
        int n = string.indexOf("#");
        String string2 = null;
        if (n > -1) {
            String string3 = URLNameHelpers.encodeString(string.substring(0, n), false);
            String string4 = URLNameHelpers.encodeString(string.substring(n + 1, string.length()), false);
            string2 = string3 + "#" + string4;
        } else {
            string2 = URLNameHelpers.encodeString(string.substring(0, string.length()), false);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "encodeCorbaURL()", "escapedUrl = " + string2);
        }
        return string2;
    }

    public static String encodeString(String string, boolean bl) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "encodeString()", new String[]{"inString = " + string, "interpretPercentSignLiterally = " + bl});
        }
        String string2 = string;
        if (!bl) {
            string2 = URLNameHelpers.decodeRFC2396(string);
        }
        String string3 = URLNameHelpers.encodeRFC2396(string2);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "encodeString()", "escapedString = " + string3);
        }
        return string3;
    }

    public static String decodeString(String string) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "decodeString()", "escaped = " + string);
        }
        String string2 = URLNameHelpers.decodeRFC2396(string);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "decodeString()", "unescaped= " + string2);
        }
        return string2;
    }

    private static String decodeRFC2396(String string) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "decodeRFC2396()", "name = " + string);
        }
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            int n = 0;
            char c = stringBuffer.charAt(i);
            if (c != '%') continue;
            if (i + 2 >= stringBuffer.length()) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "incomplete key_string escape sequence in a name", string);
                }
                throw new IllegalArgumentException("incomplete key_string escape sequence in a name: " + string);
            }
            try {
                n = Utility.hexOf((char)stringBuffer.charAt(i + 1)) * 16 + Utility.hexOf((char)stringBuffer.charAt(i + 2));
            }
            catch (DATA_CONVERSION dATA_CONVERSION) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Bad hex digit with a name", string + " : " + (Object)((Object)dATA_CONVERSION));
                }
                throw new IllegalArgumentException("Bad hex digit with a name " + string + " : " + (Object)((Object)dATA_CONVERSION));
            }
            stringBuffer.setCharAt(i, (char)n);
            stringBuffer.delete(i + 1, i + 3);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "decodeRFC2396()", "name after decoding = " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    private static String encodeRFC2396(String string) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "encodeRFC2396()", "name = " + string);
        }
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            char c = stringBuffer.charAt(i);
            if (RFC2396.indexOf(c) != -1) continue;
            stringBuffer.setCharAt(i, '%');
            char[] cArray = Integer.toHexString(c).toCharArray();
            if (cArray.length == 2) {
                stringBuffer.insert(i + 1, cArray);
            } else if (cArray.length == 1) {
                stringBuffer.insert(i + 1, '0');
                stringBuffer.insert(i + 2, cArray[0]);
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Invalid character '" + c + "' in " + string);
                throw new IllegalArgumentException("Invalid character '" + c + "' in " + string);
            }
            i += 2;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "encodeRFC2396()", "name = " + stringBuffer);
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: ws/code/naming.client/src/com/ibm/ws/naming/util/URLNameHelpers.java, WAS.naming.client, ASV51X, a0425.05, ver. 1.1");
        }
    }
}

