/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.naming.util;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.ObjectURL;
import com.ibm.WsnBootstrap.Prop;
import com.ibm.WsnBootstrap.WsnNameService;
import com.ibm.WsnBootstrap.WsnNameServiceHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.naming.JndiHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.naming.ipbase.ContextID;
import com.ibm.ws.naming.ipbase.StringContextID;
import com.ibm.ws.naming.jcache.Cache;
import com.ibm.ws.naming.jcache.CacheEntryNotFoundException;
import com.ibm.ws.naming.jcache.CacheInvalidPropertyValueException;
import com.ibm.ws.naming.jcache.CacheManager;
import com.ibm.ws.naming.jndicos.CNContextImpl;
import com.ibm.ws.naming.ldap.WsnLdapInitCtxFactory;
import com.ibm.ws.naming.util.BooleanWrapper;
import com.ibm.ws.naming.util.Helpers;
import com.ibm.ws.naming.util.URLNameHelpers;
import com.ibm.ws.naming.util.WsnInitCtx;
import com.ibm.ws.naming.util.WsnName;
import com.ibm.ws.naming.util.WsnNameParser;
import com.ibm.ws.security.util.AccessController;
import java.net.MalformedURLException;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Iterator;
import javax.naming.CommunicationException;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.NotContextException;
import javax.naming.ServiceUnavailableException;
import javax.naming.spi.InitialContextFactory;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NamingContext;

public class WsnInitCtxFactory
implements InitialContextFactory {
    private static final TraceComponent _tc = Tr.register(class$com$ibm$ws$naming$util$WsnInitCtxFactory == null ? (class$com$ibm$ws$naming$util$WsnInitCtxFactory = WsnInitCtxFactory.class$("com.ibm.ws.naming.util.WsnInitCtxFactory")) : class$com$ibm$ws$naming$util$WsnInitCtxFactory, "Naming", "com.ibm.ws.naming.util.WsnMessages");
    private static final String SERVER_ROOT_CACHE_LOOKUP_NAME = "SERVER_ROOT";
    private static final String NODE_ROOT_CACHE_LOOKUP_NAME = "NODE_ROOT";
    private static final String CELL_ROOT_CACHE_LOOKUP_NAME = "CELL_ROOT";
    private static final String CELL_PERSISTENT_ROOT_CACHE_LOOKUP_NAME = "CELL_PERSISTENT_ROOT";
    private static final String TREE_ROOT_CACHE_LOOKUP_NAME = "TREE_ROOT";
    private static final String TREE_ROOT_PRIMARY_BINDING_NAME = "TREE_ROOT_PRIMARY_BINDING";
    private static final String LEGACY_ROOT_CACHE_LOOKUP_NAME = "LEGACY_ROOT";
    private static final String RIR_DEFAULT_ROOT_CACHE_LOOKUP_NAME = "RIR_DEFAULT_ROOT";
    private static final String IIOP_DEFAULT_ROOT_CACHE_LOOKUP_NAME = "IIOP_DEFAULT_ROOT";
    private static Hashtable _insEnv;
    private WsnNameParser _nameParser = null;
    private ContextID[] _rootParentCtxIDs = null;
    private ContextID _rootCtxID = null;
    private Name _rootFullPrimaryNameForCaching = null;
    private String[] _rootCacheBindingNames = new String[0];
    static /* synthetic */ Class class$com$ibm$ws$naming$util$WsnInitCtxFactory;

    public WsnInitCtxFactory() {
        Tr.event(_tc, "WsnInitCtxFactory ctor");
    }

    public Context getInitialContext(Hashtable hashtable) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getInitialContext", Helpers.traceHashtable("starting env", hashtable));
        }
        WsnInitCtx wsnInitCtx = new WsnInitCtx(hashtable, this);
        Tr.exit(_tc, "getInitialContext", wsnInitCtx);
        return wsnInitCtx;
    }

    protected Context getInitialContextInternal(Hashtable hashtable) throws NamingException {
        java.lang.Object object;
        java.lang.Object object2;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getInitialContextInternal", Helpers.traceHashtable("starting env", hashtable));
        }
        CommonData commonData = new CommonData(hashtable);
        if (!(commonData._wsnNSRootTypeProp.equals("defaultroot") || commonData._wsnNSRootTypeProp.equals("bootstrapserverroot") || commonData._wsnNSRootTypeProp.equals("bootstrapnoderoot") || commonData._wsnNSRootTypeProp.equals("bootstraphostroot") || commonData._wsnNSRootTypeProp.equals("cellroot") || commonData._wsnNSRootTypeProp.equals("cellpersistentroot") || commonData._wsnNSRootTypeProp.equals("legacydomainroot") || commonData._wsnNSRootTypeProp.equals("treeinfrastructureroot"))) {
            throw new ConfigurationException("Property com.ibm.websphere.naming.namespaceroot=" + commonData._wsnNSRootTypeProp + " is not a valid value");
        }
        commonData._omgOrb = Helpers.getOrb(commonData._env);
        this.parseBootstrapURL(commonData);
        this._nameParser = WsnNameParser.getParser(commonData._env);
        String string = Cache.cacheObjectPropertyValue(commonData._env);
        commonData._cachingEnabled = !string.equals("none");
        java.lang.Object var4_4 = null;
        Iterator iterator = null;
        if (commonData._wsnNSRootType == null) {
            this.disableCaching(commonData);
        }
        if (commonData._cachingEnabled) {
            if (commonData._normalizedUrlObj == null) {
                this.setCache(null, -1, commonData);
            } else if (commonData._normalizedUrlObj.isRir()) {
                this.setCache(null, -1, commonData);
            } else {
                iterator = commonData._normalizedUrlObj.getIIOPList();
            }
        }
        Context context = null;
        boolean bl = false;
        Name name = null;
        if (commonData._cachingEnabled) {
            String string2 = IIOP_DEFAULT_ROOT_CACHE_LOOKUP_NAME;
            if (commonData._wsnNSRootType.equals("defaultroot") && commonData._normalizedUrlObj != null && commonData._normalizedUrlObj.isRir()) {
                string2 = RIR_DEFAULT_ROOT_CACHE_LOOKUP_NAME;
            } else if (commonData._wsnNSRootType.equals("cellroot")) {
                string2 = CELL_ROOT_CACHE_LOOKUP_NAME;
            } else if (commonData._wsnNSRootType.equals("bootstraphostroot") || commonData._wsnNSRootType.equals("bootstrapnoderoot")) {
                string2 = NODE_ROOT_CACHE_LOOKUP_NAME;
            } else if (commonData._wsnNSRootType.equals("treeinfrastructureroot")) {
                string2 = TREE_ROOT_CACHE_LOOKUP_NAME;
            } else if (commonData._wsnNSRootType.equals("bootstrapserverroot")) {
                string2 = SERVER_ROOT_CACHE_LOOKUP_NAME;
            } else if (commonData._wsnNSRootType.equals("cellpersistentroot") || commonData._wsnNSRootType.equals("legacydomainroot")) {
                string2 = CELL_PERSISTENT_ROOT_CACHE_LOOKUP_NAME;
            }
            do {
                if (iterator != null) {
                    object2 = (ObjectURL.IIOPAddr)iterator.next();
                    this.setCache(object2.getHost(), object2.getPort(), commonData);
                }
                try {
                    name = this._nameParser.parse(string2);
                    object2 = new BooleanWrapper(false);
                    object = (CNContextImpl)commonData._cache.lookup(null, name, (BooleanWrapper)object2);
                    context = new CNContextImpl(commonData._env, commonData._omgOrb, ((CNContextImpl)object).getCosContext(), ((CNContextImpl)object).getNameInNamespace(), ((CNContextImpl)object).isContextNamePrimary(), ((CNContextImpl)object).getContextID(), commonData._cache, this._nameParser);
                    bl = true;
                }
                catch (CacheEntryNotFoundException cacheEntryNotFoundException) {
                    FFDCFilter.processException((Throwable)cacheEntryNotFoundException, "com.ibm.ws.naming.util.WsnInitCtxFactory.getInitialContextInternal", "367", this);
                }
            } while (iterator != null && iterator.hasNext());
        }
        if (context == null) {
            context = this.getRootJndiContext(commonData);
        }
        if (commonData._cachingEnabled && !bl) {
            if (context instanceof CNContextImpl && this._rootParentCtxIDs != null) {
                commonData._cache.createSubcontext(null, this._rootFullPrimaryNameForCaching, this._rootParentCtxIDs, (CNContextImpl)context);
                for (int i = 0; i < this._rootCacheBindingNames.length; ++i) {
                    object2 = this._nameParser.parse(this._rootCacheBindingNames[i]);
                    commonData._cache.bind(null, (Name)object2, new ContextID[0], context, null, false);
                }
            } else {
                this.disableCaching(commonData);
            }
        }
        Context context2 = context;
        if (commonData._targetContextName != null && commonData._targetContextName.length() != 0) {
            try {
                object = new WsnName(commonData._targetContextName, _insEnv);
                WsnName wsnName = new WsnName(((WsnName)object).toCosName(), commonData._env);
                object2 = context.lookup(wsnName);
            }
            catch (NamingException namingException) {
                FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.naming.util.WsnInitCtxFactory.getInitialContextInternal", "416", this);
                Tr.exit(_tc, "getInitialContextInternal: NamingException", namingException);
                throw namingException;
            }
            if (object2 instanceof Context) {
                context2 = (Context)object2;
            } else {
                object = new NotContextException("The object bound to \"" + commonData._targetContextName + "\" is not a context.");
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "getInitialContextInternal: NotContext: ", object);
                }
                throw object;
            }
        }
        Tr.exit(_tc, "getInitialContextInternal", context2);
        return context2;
    }

    private Context getRootJndiContext(CommonData commonData) throws NamingException {
        Tr.entry(_tc, "getRootJndiContext");
        Context context = null;
        if (commonData._wsnNSRootType == null) {
            context = this.getRootContextFromServer(null, commonData._normalizedUrlObj, commonData);
        } else if (commonData._normalizedUrlObj == null || commonData._normalizedUrlObj.isRir()) {
            String string = "corbaloc:rir:/WsnNameService";
            ObjectURL objectURL = ORB.createObjectURL((String)string);
            context = this.getRootContextFromServer(objectURL, commonData._normalizedUrlObj, commonData);
        } else {
            Iterator iterator = commonData._normalizedUrlObj.getIIOPList();
            String string = commonData._normalizedUrlObj.getKeyString();
            String string2 = commonData._normalizedUrlObj.getStringName();
            NamingException namingException = null;
            while (context == null && iterator.hasNext()) {
                namingException = null;
                ObjectURL.IIOPAddr iIOPAddr = (ObjectURL.IIOPAddr)iterator.next();
                String string3 = "corbaloc:" + iIOPAddr + "/" + "WsnNameService";
                ObjectURL objectURL = ORB.createObjectURL((String)string3);
                string3 = "corbaloc:" + iIOPAddr + "/" + string;
                ObjectURL objectURL2 = ORB.createObjectURL((String)string3);
                try {
                    context = this.getRootContextFromServer(objectURL, objectURL2, commonData);
                }
                catch (NamingException namingException2) {
                    FFDCFilter.processException((Throwable)namingException2, "com.ibm.ws.naming.util.WsnInitCtxFactory.getRootJndiContext", "487", this);
                    namingException = namingException2;
                    Tr.debug(_tc, "getRootJndiContext", new java.lang.Object[]{"Could not connect to name server with URL=" + this.objToString(objectURL2), namingException2});
                }
                if (context != null) continue;
                commonData.clearWsnNSProperties();
            }
            if (namingException != null) {
                Tr.warning(_tc, "jndiUnavailCommErr");
                throw namingException;
            }
        }
        Tr.exit(_tc, "getRootJndiContext");
        return context;
    }

    private Context getRootContextFromServer(ObjectURL objectURL, ObjectURL objectURL2, CommonData commonData) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getRootContextFromServer", new java.lang.Object[]{"wsnUrl=" + objectURL, "irUrl=" + objectURL2});
        }
        Context context = null;
        commonData._cache = null;
        this.mergeWsnNSProperties(objectURL, commonData);
        if (commonData._wsnNSImplType == null || commonData._wsnNSImplType.equals("WsnRdbCos") || commonData._wsnNSImplType.equals("WsnIpCos")) {
            context = this.getCosRootContext(objectURL2, commonData);
        } else if (commonData._wsnNSImplType.equals("WsnLdap") || commonData._wsnNSImplType.equals("WsnLdapCos")) {
            if (commonData._wsnNSRootType == null) {
                String string = "Provider URL \"" + commonData._origUrlString + "\" contains an object key which is invalid for a WebSphere LDAP server.";
                ConfigurationException configurationException = new ConfigurationException(string);
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "getRootContextFromServer - " + string + ", throwing ConfigurationException", "Exception = " + configurationException);
                }
                throw configurationException;
            }
            context = this.getLdapRootContext(commonData);
        } else {
            String string = "Invalid implementation type specified: com.ibm.ws.naming.implementation=" + commonData._wsnNSImplType;
            ConfigurationException configurationException = new ConfigurationException(string);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "getRootContextFromServer - " + string + ", throwing ConfigurationException", "Exception = " + configurationException);
            }
            throw configurationException;
        }
        Tr.exit(_tc, "getRootContextFromServer");
        return context;
    }

    private Context getCosRootContext(ObjectURL objectURL, CommonData commonData) throws COMM_FAILURE, NamingException {
        java.lang.Object object;
        Tr.entry(_tc, "getCosRootContext");
        Object object2 = null;
        NamingContext namingContext = null;
        String string = null;
        boolean bl = true;
        String string2 = null;
        ContextID contextID = null;
        boolean bl2 = objectURL != null && objectURL.isRir();
        try {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "IDL Level: " + commonData._wsnIDLLevel);
            }
            if (commonData._wsnNSRootType != null) {
                Tr.debug(_tc, "provider URL has a recognized Wsn object key", commonData._wsnNSRootType);
                if ((commonData._wsnNSRootType.equals("defaultroot") && !bl2 && commonData._wsnIDLLevel == 1 || commonData._wsnNSRootType.equals("bootstrapserverroot")) && commonData._wsnServerRootIor != null) {
                    Tr.debug(_tc, "Converting server root IOR to object.");
                    object2 = this.stringToObject(commonData, commonData._wsnServerRootIor);
                    string2 = commonData._wsnServerRootName;
                    this._rootParentCtxIDs = commonData._wsnServerRootCtxIDs;
                    contextID = commonData._wsnServerRootCtxID;
                    string = "bootstrapserverroot";
                    this.setCache(objectURL, new String[]{SERVER_ROOT_CACHE_LOOKUP_NAME, IIOP_DEFAULT_ROOT_CACHE_LOOKUP_NAME}, commonData);
                } else if ((commonData._wsnNSRootType.equals("defaultroot") && bl2 && commonData._wsnIDLLevel == 1 || commonData._wsnNSRootType.equals("cellroot")) && commonData._wsnCellRootIor != null) {
                    Tr.debug(_tc, "Converting cell root IOR to object.");
                    object2 = this.stringToObject(commonData, commonData._wsnCellRootIor);
                    string2 = commonData._wsnCellRootName;
                    this._rootParentCtxIDs = commonData._wsnCellRootCtxIDs;
                    contextID = commonData._wsnCellRootCtxID;
                    string = "cellroot";
                    this.setCache(objectURL, new String[]{CELL_ROOT_CACHE_LOOKUP_NAME, RIR_DEFAULT_ROOT_CACHE_LOOKUP_NAME}, commonData);
                } else if ((commonData._wsnNSRootType.equals("defaultroot") && !bl2 && commonData._wsnIDLLevel == 0 || commonData._wsnNSRootType.equals("legacydomainroot") || commonData._wsnNSRootType.equals("cellpersistentroot")) && commonData._wsnCellPersistentRootIor != null) {
                    String[] stringArray;
                    Tr.debug(_tc, "Converting cell persistent root IOR to object.");
                    object2 = this.stringToObject(commonData, commonData._wsnCellPersistentRootIor);
                    string2 = commonData._wsnCellPersistentRootName;
                    this._rootParentCtxIDs = commonData._wsnCellPersistentRootCtxIDs;
                    contextID = commonData._wsnCellPersistentRootCtxID;
                    string = "legacydomainroot";
                    if (commonData._wsnIDLLevel == 0) {
                        String[] stringArray2 = new String[2];
                        stringArray2[0] = LEGACY_ROOT_CACHE_LOOKUP_NAME;
                        stringArray = stringArray2;
                        stringArray2[1] = IIOP_DEFAULT_ROOT_CACHE_LOOKUP_NAME;
                    } else {
                        String[] stringArray3 = new String[2];
                        stringArray3[0] = CELL_PERSISTENT_ROOT_CACHE_LOOKUP_NAME;
                        stringArray = stringArray3;
                        stringArray3[1] = LEGACY_ROOT_CACHE_LOOKUP_NAME;
                    }
                    this.setCache(objectURL, stringArray, commonData);
                } else if ((commonData._wsnNSRootType.equals("defaultroot") && bl2 && commonData._wsnIDLLevel == 0 || commonData._wsnNSRootType.equals("bootstraphostroot") || commonData._wsnNSRootType.equals("bootstrapnoderoot")) && commonData._wsnNodeRootIor != null) {
                    String[] stringArray;
                    Tr.debug(_tc, "Converting node root IOR to object.");
                    object2 = this.stringToObject(commonData, commonData._wsnNodeRootIor);
                    string2 = commonData._wsnNodeRootName;
                    this._rootParentCtxIDs = commonData._wsnNodeRootCtxIDs;
                    contextID = commonData._wsnNodeRootCtxID;
                    string = "bootstraphostroot";
                    if (commonData._wsnIDLLevel == 0) {
                        String[] stringArray4 = new String[2];
                        stringArray4[0] = NODE_ROOT_CACHE_LOOKUP_NAME;
                        stringArray = stringArray4;
                        stringArray4[1] = RIR_DEFAULT_ROOT_CACHE_LOOKUP_NAME;
                    } else {
                        String[] stringArray5 = new String[1];
                        stringArray = stringArray5;
                        stringArray5[0] = NODE_ROOT_CACHE_LOOKUP_NAME;
                    }
                    this.setCache(objectURL, stringArray, commonData);
                } else if (commonData._wsnNSRootType.equals("treeinfrastructureroot") && commonData._wsnTreeRootIor != null) {
                    Tr.debug(_tc, "Converting tree infrastructure root IOR to object.");
                    object2 = this.stringToObject(commonData, commonData._wsnTreeRootIor);
                    string2 = commonData._wsnTreeRootName;
                    this._rootParentCtxIDs = commonData._wsnTreeRootCtxIDs;
                    contextID = commonData._wsnTreeRootCtxID;
                    string = "treeinfrastructureroot";
                    this.setCache(objectURL, new String[]{TREE_ROOT_CACHE_LOOKUP_NAME}, commonData);
                } else if (!commonData._wsnNSRootType.equals("defaultroot") || commonData._gotWsnNameService) {
                    String string3 = commonData._origUrlString != null ? "Requested root type of \"" + commonData._wsnNSRootType + "\" is not available using the provider URL \"" + commonData._origUrlString + "\"." : "Requested root type of \"" + commonData._wsnNSRootType + "\" is not available. Since no provider URL was specified, " + "the default provider URL of \"" + this.objToString(commonData._normalizedUrlObj) + "\" was used.";
                    NoInitialContextException noInitialContextException = new NoInitialContextException(string3);
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "getCosRootContext: Throwing NoInitialContextException", string3);
                    }
                    throw noInitialContextException;
                }
            }
            if (object2 != null) {
                object = new WsnName(string2, _insEnv);
                if (((WsnName)object).size() == 0) {
                    this._rootFullPrimaryNameForCaching = new WsnName("", commonData._env);
                    string2 = "";
                } else {
                    this._rootFullPrimaryNameForCaching = new WsnName(((WsnName)object).toCosName(), commonData._env);
                    string2 = this._rootFullPrimaryNameForCaching.toString();
                }
                this._rootFullPrimaryNameForCaching.add(0, TREE_ROOT_PRIMARY_BINDING_NAME);
            } else {
                if (objectURL == null) {
                    object2 = commonData._omgOrb.resolve_initial_references("NameService");
                    string = "resolve_initial_references(NameService)";
                } else {
                    object = this.objToString(objectURL);
                    object2 = this.stringToObject(commonData, (String)object);
                    string = "string_to_object(" + (String)object + ")";
                }
                this.disableCaching(commonData);
                string2 = "";
                bl = false;
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "getCosRootContext - root context selected using " + string);
            }
            if (object2 instanceof NamingContext) {
                namingContext = (NamingContext)object2;
            } else {
                if (object2 == null) {
                    object = "NULL initial context was returned:" + string;
                    ServiceUnavailableException serviceUnavailableException = new ServiceUnavailableException((String)object);
                    Tr.exit(_tc, "getCosRootContext: ServiceUnavailableException: Null rootObj");
                    throw serviceUnavailableException;
                }
                namingContext = CNContextImpl.narrowToNamingContext(commonData._omgOrb, object2);
                if (namingContext == null) {
                    object = "NULL returned narrowing initial reference to a NamingContext.";
                    ServiceUnavailableException serviceUnavailableException = new ServiceUnavailableException((String)object);
                    Tr.exit(_tc, "getCosRootContext: ServiceUnavailableException: Null NC");
                    throw serviceUnavailableException;
                }
            }
        }
        catch (BAD_PARAM bAD_PARAM) {
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "getCosRootContext:  Caught BAD_PARAM.", (java.lang.Object)bAD_PARAM);
            }
            String string4 = commonData._origUrlString != null ? "Could not obtain initial context with the provider URL, \"" + commonData._origUrlString + "\"." : "Could not obtain initial context with the default provider URL, \"" + this.objToString(commonData._normalizedUrlObj) + "\".";
            ServiceUnavailableException serviceUnavailableException = new ServiceUnavailableException(string4);
            serviceUnavailableException.setRootCause(bAD_PARAM);
            Tr.exit(_tc, "getCosRootContext: Throwing ServiceUnavailableException", (java.lang.Object)bAD_PARAM);
            throw serviceUnavailableException;
        }
        catch (NamingException namingException) {
            FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.naming.util.WsnInitCtxFactory.getCosRootContext", "755", this);
            Tr.exit(_tc, "getCosRootContext: Rethrowing NamingException");
            throw namingException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.naming.util.WsnInitCtxFactory.getCosRootContext", "760", this);
            NamingException namingException = this.mapInitialReferenceFailure(exception, commonData);
            namingException.setRootCause(exception);
            Tr.exit(_tc, "getCosRootContext: Throwing NamingException", exception);
            throw namingException;
        }
        object = null;
        object = !bl ? new CNContextImpl(commonData._env, commonData._omgOrb, namingContext, string2, commonData._cache) : new CNContextImpl(commonData._env, commonData._omgOrb, namingContext, string2, true, contextID, commonData._cache, this._nameParser);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getCosRootContext returning --> " + object.toString());
        }
        return object;
    }

    private Context getLdapRootContext(CommonData commonData) throws NamingException {
        Tr.entry(_tc, "getLdapRootContext");
        WsnLdapInitCtxFactory wsnLdapInitCtxFactory = new WsnLdapInitCtxFactory();
        Context context = wsnLdapInitCtxFactory.getInitialContext(commonData._env);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getLdapRootContext: returning Context --> " + context.toString());
        }
        return context;
    }

    private void mergeWsnNSProperties(ObjectURL objectURL, CommonData commonData) throws NamingException {
        String string;
        Tr.entry(_tc, "mergeWsnNSProperties");
        WsnNameService wsnNameService = null;
        Prop[] propArray = null;
        if (commonData._ldapSkipBootstrap) {
            Tr.exit(_tc, "mergeWsnNSProperties - _ldapSkipBootstrap=true - no attempt made to access WsnNameService bootstrap object");
            return;
        }
        if (objectURL == null) {
            Tr.exit(_tc, "mergeWsnNSProperties - null URL.");
            return;
        }
        try {
            Object object = null;
            if (objectURL.isRir()) {
                object = commonData._omgOrb.resolve_initial_references("WsnNameService");
            } else {
                string = this.objToString(objectURL);
                Tr.debug(_tc, "mergeWsnNSProperties", "Attempting to connect to name server with URL=" + string);
                object = this.stringToObject(commonData, string);
            }
            if (object == null) {
                Tr.exit(_tc, "mergeWsnNSProperties: WsnNameService returned from objectToSTring is NULL");
                return;
            }
            wsnNameService = WsnNameServiceHelper.narrow(object);
            propArray = wsnNameService.getProperties();
        }
        catch (BAD_PARAM bAD_PARAM) {
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "MergeWsnNSProperties:  Ignoring BAD_PARAM.", (java.lang.Object)bAD_PARAM);
            }
            return;
        }
        catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "MergeWsnNSProperties:  Ignoring OBJECT_NOT_EXIST.", (java.lang.Object)oBJECT_NOT_EXIST);
            }
            return;
        }
        catch (Exception exception) {
            NamingException namingException = this.mapInitialReferenceFailure(exception, commonData);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "mergeWsnNSProperties: Throwing NamingException");
            }
            throw namingException;
        }
        commonData._gotWsnNameService = true;
        for (int i = 0; i < propArray.length; ++i) {
            string = propArray[i].key;
            boolean bl = true;
            if (string.equals("com.ibm.ws.naming.boot.treerootior")) {
                commonData._wsnTreeRootIor = propArray[i].value;
            } else if (string.equals("com.ibm.ws.naming.boot.noderootior")) {
                commonData._wsnNodeRootIor = propArray[i].value;
            } else if (string.equals("com.ibm.ws.naming.boot.domainrootior")) {
                commonData._wsnCellRootIor = propArray[i].value;
            } else if (string.equals("com.ibm.ws.naming.boot.legacyrootior")) {
                commonData._wsnCellPersistentRootIor = propArray[i].value;
            } else if (string.equals("com.ibm.ws.naming.boot.serverrootior")) {
                commonData._wsnServerRootIor = propArray[i].value;
            } else if (string.equals("com.ibm.ws.naming.boot.treerootname")) {
                commonData._wsnTreeRootName = propArray[i].value;
            } else if (string.equals("com.ibm.ws.naming.boot.noderootname")) {
                commonData._wsnNodeRootName = propArray[i].value;
            } else if (string.equals("com.ibm.ws.naming.boot.domainrootname")) {
                commonData._wsnCellRootName = propArray[i].value;
            } else if (string.equals("com.ibm.ws.naming.boot.legacyrootname")) {
                commonData._wsnCellPersistentRootName = propArray[i].value;
            } else if (string.equals("com.ibm.ws.naming.boot.serverrootname")) {
                commonData._wsnServerRootName = propArray[i].value;
            } else if (string.equals("com.ibm.ws.naming.boot.treerootctxids")) {
                commonData._wsnTreeRootCtxIDs = WsnInitCtxFactory.toContextIDs(Helpers.stringToContextIDs(propArray[i].value));
            } else if (string.equals("com.ibm.ws.naming.boot.noderootctxids")) {
                commonData._wsnNodeRootCtxIDs = WsnInitCtxFactory.toContextIDs(Helpers.stringToContextIDs(propArray[i].value));
            } else if (string.equals("com.ibm.ws.naming.boot.domainrootctxids")) {
                commonData._wsnCellRootCtxIDs = WsnInitCtxFactory.toContextIDs(Helpers.stringToContextIDs(propArray[i].value));
            } else if (string.equals("com.ibm.ws.naming.boot.legacyrootctxids")) {
                commonData._wsnCellPersistentRootCtxIDs = WsnInitCtxFactory.toContextIDs(Helpers.stringToContextIDs(propArray[i].value));
            } else if (string.equals("com.ibm.ws.naming.boot.serverrootctxids")) {
                commonData._wsnServerRootCtxIDs = WsnInitCtxFactory.toContextIDs(Helpers.stringToContextIDs(propArray[i].value));
            } else if (string.equals("com.ibm.ws.naming.boot.treerootctxid")) {
                commonData._wsnTreeRootCtxID = new StringContextID(propArray[i].value);
            } else if (string.equals("com.ibm.ws.naming.boot.noderootctxid")) {
                commonData._wsnNodeRootCtxID = new StringContextID(propArray[i].value);
            } else if (string.equals("com.ibm.ws.naming.boot.domainrootctxid")) {
                commonData._wsnCellRootCtxID = new StringContextID(propArray[i].value);
            } else if (string.equals("com.ibm.ws.naming.boot.legacyrootctxid")) {
                commonData._wsnCellPersistentRootCtxID = new StringContextID(propArray[i].value);
            } else if (string.equals("com.ibm.ws.naming.boot.serverrootctxid")) {
                commonData._wsnServerRootCtxID = new StringContextID(propArray[i].value);
            } else {
                bl = false;
                if (string.equals("com.ibm.ws.naming.wsnidl.level")) {
                    commonData._wsnIDLLevel = WsnInitCtxFactory.toInt(propArray[i].value);
                } else {
                    commonData._env.put(string, propArray[i].value);
                }
            }
            if (!_tc.isEventEnabled() || !bl) continue;
            Tr.event(_tc, "mergeWsnNSProperties: Root IOR returned from bootstrap host", string + " --> " + propArray[i].value);
        }
        if (commonData._wsnIDLLevel == -1) {
            commonData._wsnIDLLevel = 0;
        }
        commonData._wsnNSImplType = (String)commonData._env.get("com.ibm.ws.naming.implementation");
        if (commonData._wsnNSImplType == null) {
            commonData._wsnNSImplType = "";
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "mergeWsnNSProperties", Helpers.traceHashtable("Merged Environment Properties", commonData._env));
        }
    }

    private void clearWsnNSProperties(CommonData commonData) {
        commonData._wsnTreeRootIor = null;
        commonData._wsnNodeRootIor = null;
        commonData._wsnCellRootIor = null;
        commonData._wsnCellPersistentRootIor = null;
        commonData._wsnServerRootIor = null;
        commonData._wsnTreeRootName = null;
        commonData._wsnNodeRootName = null;
        commonData._wsnCellRootName = null;
        commonData._wsnCellPersistentRootName = null;
        commonData._wsnServerRootName = null;
        commonData._wsnTreeRootCtxIDs = null;
        commonData._wsnNodeRootCtxIDs = null;
        commonData._wsnCellRootCtxIDs = null;
        commonData._wsnCellPersistentRootCtxIDs = null;
        commonData._wsnServerRootCtxIDs = null;
        commonData._wsnTreeRootCtxID = null;
        commonData._wsnNodeRootCtxID = null;
        commonData._wsnCellRootCtxID = null;
        commonData._wsnCellPersistentRootCtxID = null;
        commonData._wsnServerRootCtxID = null;
        commonData._wsnIDLLevel = -1;
    }

    private Object stringToObject(CommonData commonData, String string) throws COMM_FAILURE {
        Object object;
        Tr.entry(_tc, "stringToObject", "Input to orb.string_to_object=" + string);
        try {
            object = commonData._omgOrb.string_to_object(string);
        }
        catch (COMM_FAILURE cOMM_FAILURE) {
            FFDCFilter.processException((Throwable)cOMM_FAILURE, "com.ibm.ws.naming.util.WsnInitCtxFactory.stringToObject", "1004", this);
            Tr.exit(_tc, "stringToObject", new java.lang.Object[]{"Exception:", cOMM_FAILURE});
            throw cOMM_FAILURE;
        }
        Tr.exit(_tc, "stringToObject");
        return object;
    }

    private void setCache(ObjectURL objectURL, String[] stringArray, CommonData commonData) throws NamingException {
        Iterator iterator;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setCache (ObjectUrl): RootCacheBindingNames=", stringArray);
        }
        if (!commonData._cachingEnabled) {
            Tr.exit(_tc, "setCache: Caching disabled");
            return;
        }
        String string = null;
        int n = -1;
        if (objectURL != null && !objectURL.isRir() && (iterator = objectURL.getIIOPList()).hasNext()) {
            ObjectURL.IIOPAddr iIOPAddr = (ObjectURL.IIOPAddr)iterator.next();
            string = iIOPAddr.getHost();
            n = iIOPAddr.getPort();
        }
        this._rootCacheBindingNames = stringArray;
        this.setCache(string, n, commonData);
        Tr.exit(_tc, "setCache (ObjectUrl)");
    }

    private void setCache(String string, int n, CommonData commonData) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setCache(String, int)", new java.lang.Object[]{"host=" + string, "port=" + n});
        }
        if (!commonData._cachingEnabled) {
            Tr.exit(_tc, "setCache: Caching disabled");
            return;
        }
        try {
            String string2 = Cache.cacheNamePropertyValue(commonData._env);
            if (string2.equals("providerURL")) {
                String string3 = this.createCacheName(string, n, commonData);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "setCache", "Getting cache: cacheName=" + string3);
                }
                commonData._cache = CacheManager.getCacheUsingName(string3, commonData._env);
            } else {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "setCache", "Getting cache: cacheName (from env)=" + string2);
                }
                commonData._cache = CacheManager.getCache(commonData._env);
            }
        }
        catch (CacheInvalidPropertyValueException cacheInvalidPropertyValueException) {
            FFDCFilter.processException((Throwable)cacheInvalidPropertyValueException, "com.ibm.ws.naming.util.WsnInitCtxFactory.setCache", "1086", this);
            NamingException namingException = new NamingException("Bad JNDI cache property value");
            namingException.setRootCause(cacheInvalidPropertyValueException);
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "setCache(String, int): CacheInvalidPropertyValueException", namingException);
            }
            throw namingException;
        }
        Tr.exit(_tc, "setCache(String, int)");
    }

    private void disableCaching(CommonData commonData) {
        commonData._cachingEnabled = false;
        commonData._cache = null;
    }

    private String createCacheName(String string, int n, CommonData commonData) {
        String string2;
        Tr.entry(_tc, "createCacheName");
        if (string == null && n == -1) {
            string2 = "rir:";
        } else {
            if (string == null || string.length() == 0) {
                string = "<HOSTNAME NOT SPECIFIED>";
            }
            if (n == -1) {
                n = 2809;
            }
            string2 = "iiop://" + string + ":" + n;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "createCacheName", "cacheName=" + string2);
        }
        return string2;
    }

    private void parseBootstrapURL(CommonData commonData) throws NamingException {
        String string;
        Tr.entry(_tc, "parseBootstrapURL");
        commonData._origUrlString = string = (String)commonData._env.get("java.naming.provider.url");
        String string2 = null;
        if (string == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "java.naming.provider.url not specified in environment. Defaulting to corbaloc:iiop:localhost");
            }
            string = "corbaloc:iiop:localhost";
            string2 = "corbaloc";
        } else {
            int n;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "java.naming.provider.url = " + string);
            }
            if ((n = string.indexOf(":")) <= 0) {
                throw new ConfigurationException("Malformed provider URL: " + string);
            }
            string2 = string.substring(0, n);
        }
        commonData._normalizedUrlScheme = string2;
        if (string2.equalsIgnoreCase("corbaloc") || string2.equalsIgnoreCase("corbaname")) {
            String string3 = null;
            try {
                string3 = URLNameHelpers.encodeCorbaURL(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String string4 = "Malformed provider URL: " + string;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, string4);
                }
                throw new ConfigurationException(string4);
            }
            try {
                commonData._normalizedUrlObj = ORB.createObjectURL((String)string3);
            }
            catch (BAD_PARAM bAD_PARAM) {
                ConfigurationException configurationException = new ConfigurationException("Malformed provider URL: " + string);
                configurationException.setRootCause(bAD_PARAM);
                Tr.exit(_tc, "parseBootstrapURL: Could not parse provider URL.", configurationException);
                throw configurationException;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.naming.util.WsnInitCtxFactory.parseBootstrapURL", "1447", this);
                ConfigurationException configurationException = new ConfigurationException("Unexpected error occurred while attempting to parse URL: " + string);
                configurationException.setRootCause(throwable);
                Tr.exit(_tc, "parseBootstrapURL: Could not parse provider URL.", configurationException);
                throw configurationException;
            }
        }
        if (string2.equalsIgnoreCase("iiop")) {
            try {
                commonData._normalizedUrlObj = this.parseIiopUrl(commonData, string);
            }
            catch (NamingException namingException) {
                FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.naming.util.WsnInitCtxFactory.parseBootstrapURL", "1184", this);
                Tr.exit(_tc, "parseBootstrapURL: Could not normalize iiop URL.");
                throw namingException;
            }
            commonData._normalizedUrlScheme = "corbaname";
        } else {
            throw new ConfigurationException("Bad protocol: " + string2);
        }
        this.normalizeUrl(commonData);
        if (commonData._normalizedUrlObj != null) {
            String string5 = commonData._normalizedUrlObj.getKeyString();
            commonData._wsnNSRootType = string5 == null || string5.length() == 0 || string5.equals("NameService") ? (commonData._normalizedUrlObj.isRir() ? "defaultroot" : commonData._wsnNSRootTypeProp) : (string5.equals("NameServiceHostRoot") ? "bootstraphostroot" : (string5.equals("NameServiceLegacyRoot") ? "legacydomainroot" : (string5.equals("NameServiceTreeRoot") ? "treeinfrastructureroot" : (string5.equals("NameServiceNodeRoot") ? "bootstrapnoderoot" : (string5.equals("NameServiceCellPersistentRoot") ? "cellpersistentroot" : (string5.equals("NameServiceCellRoot") ? "cellroot" : (string5.equals("NameServiceServerRoot") ? "bootstrapserverroot" : null)))))));
            commonData._wsnNSRootTypeProp = commonData._wsnNSRootType != null ? commonData._wsnNSRootType : "";
        } else {
            commonData._wsnNSRootType = commonData._wsnNSRootTypeProp;
        }
        if (_tc.isDebugEnabled()) {
            if (commonData._wsnNSRootType != null) {
                Tr.debug(_tc, "WsnRootType=" + commonData._wsnNSRootType);
            } else {
                Tr.debug(_tc, "WsnRootType=null");
            }
        }
        if (_tc.isEntryEnabled()) {
            if (commonData._normalizedUrlObj != null) {
                Tr.exit(_tc, "parseBootstrapURL: ", new String[]{"normalizedURL= " + this.objToString(commonData._normalizedUrlObj)});
            } else {
                Tr.exit(_tc, "parseBootstrapURL: ", "no provider URL");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ObjectURL parseIiopUrl(CommonData commonData, String string) throws NamingException {
        Tr.entry(_tc, "parseIiopUrl");
        if (string == null) {
            Tr.debug(_tc, "parseIiopUrl", "iiop URL is null");
            Tr.exit(_tc, "parseIiopUrl: returning NULL");
            return null;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "parseIiopUrl", "iiop URL=" + string);
        }
        try {
            java.lang.Object object;
            String string2 = null;
            String string3 = null;
            String string4 = "localhost";
            String string5 = null;
            Integer n = null;
            if (string.length() < 8 || !string.substring(5, 7).equals("//")) {
                throw new ConfigurationException("Malformed provider URL: " + string);
            }
            int n2 = string.indexOf("/", 7);
            if (n2 < 0) {
                string2 = string.substring(7, string.length()).toLowerCase();
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "No Prepend Specified. modifier=" + string2 + " context=" + string3);
                }
            } else {
                string2 = n2 == 7 ? "" : string.substring(7, n2).toLowerCase();
                string3 = string.substring(n2 + 1);
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "Prepend specified: modifier=" + string2 + ", context=" + string3);
                }
            }
            if (string2.length() > 0) {
                n2 = string2.indexOf(":");
                if (n2 < 0) {
                    string4 = string2;
                } else {
                    if (n2 == 0) {
                        throw new MalformedURLException("Host name expected in URL: " + string);
                    }
                    string4 = string2.substring(0, n2);
                    n = new Integer(string2.substring(n2 + 1));
                }
            }
            if (string3 != null) {
                int n3 = string3.indexOf("?");
                int n4 = string3.indexOf("TargetContext=");
                if (n3 >= 0) {
                    if (n4 <= 0) throw new MalformedURLException("Context lookup name expected in URL: " + string);
                    string5 = string3.substring(n4 + "TargetContext=".length());
                } else {
                    string5 = string3;
                }
                if (string5 != null && !string5.equals("")) {
                    WsnName wsnName = new WsnName(string5, commonData._env);
                    object = new WsnName(wsnName.toCosName(), _insEnv);
                    string5 = ((WsnName)object).toString();
                }
            }
            StringBuffer stringBuffer = new StringBuffer("corbaname:iiop:");
            stringBuffer.append(string4);
            if (n != null) {
                stringBuffer.append(":");
                stringBuffer.append(n);
            }
            stringBuffer.append("/");
            stringBuffer.append("NameService");
            if (string5 != null && string5.length() > 0) {
                String string6 = null;
                try {
                    string6 = URLNameHelpers.encodeString(string5, true);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    object = "Malformed provider URL: " + string;
                    if (!_tc.isDebugEnabled()) throw new MalformedURLException((String)object);
                    Tr.debug(_tc, (String)object);
                    throw new MalformedURLException((String)object);
                }
                stringBuffer.append("#" + string6);
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "parseIiopUrl", "corbaURLString=" + stringBuffer.toString());
            }
            ObjectURL objectURL = ORB.createObjectURL((String)stringBuffer.toString());
            Tr.exit(_tc, "parseIiopUrl");
            return objectURL;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.naming.util.WsnInitCtxFactory.parseIiopUrl", "1439", this);
            ConfigurationException configurationException = new ConfigurationException(exception.toString());
            configurationException.setRootCause(exception);
            if (!_tc.isEntryEnabled()) throw configurationException;
            Tr.exit(_tc, "parseIiopUrl", new java.lang.Object[]{"Throwing ConfigurationException.  Root exception:", configurationException});
            throw configurationException;
        }
    }

    private void normalizeUrl(CommonData commonData) {
        String string;
        block14: {
            Tr.entry(_tc, "normalizeUrl");
            string = null;
            try {
                java.lang.Object object;
                java.lang.Object object2;
                if (commonData._normalizedUrlObj == null) {
                    Tr.exit(_tc, "normalizeUrl", "No URL to normalize.");
                    return;
                }
                ObjectURL objectURL = commonData._normalizedUrlObj;
                StringBuffer stringBuffer = new StringBuffer(commonData._normalizedUrlScheme + ":");
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "normalizeUrl", "Normalizing URL=" + this.objToString(objectURL));
                }
                if (!objectURL.isRir()) {
                    object2 = objectURL.getIIOPList();
                    while (object2.hasNext()) {
                        object = (ObjectURL.IIOPAddr)object2.next();
                        String string2 = object.getHost();
                        String string3 = (String)commonData._env.get("com.ibm.websphere.naming.name.syntax");
                        try {
                            if (string3 != null && string3.equals("ins")) {
                                Hashtable hashtable = (Hashtable)commonData._env.clone();
                                hashtable.put("com.ibm.websphere.naming.name.syntax", "jndi");
                                string2 = JndiHelper.normalizeHostname(hashtable, string2);
                            } else {
                                string2 = JndiHelper.normalizeHostname(commonData._env, string2);
                            }
                        }
                        catch (Throwable throwable) {
                            FFDCFilter.processException(throwable, "com.ibm.ws.naming.util.WsnInitCtxFactory.normalizeUrl", "1490", this);
                            Tr.debug(_tc, "normalizeUrl", "Cannot normalize hostname: " + string2 + ". Exception: " + throwable);
                        }
                        int n = object.getPort();
                        byte by = object.getMajor();
                        byte by2 = object.getMinor();
                        stringBuffer.append("iiop:");
                        stringBuffer.append(by);
                        stringBuffer.append(".");
                        stringBuffer.append(by2);
                        stringBuffer.append("@");
                        stringBuffer.append(string2);
                        stringBuffer.append(":");
                        stringBuffer.append(n);
                    }
                } else {
                    stringBuffer.append("rir:");
                }
                if ((object2 = objectURL.getKeyString()) == null || ((String)object2).length() == 0) {
                    object2 = "NameService";
                }
                stringBuffer.append("/");
                stringBuffer.append((String)object2);
                if (objectURL.isCorbaname() && (object = objectURL.getStringName()) != null && ((String)object).length() > 0) {
                    commonData._targetContextName = URLNameHelpers.decodeString((String)object);
                }
                commonData._normalizedUrlObj = ORB.createObjectURL((String)stringBuffer.toString());
                string = this.objToString(commonData._normalizedUrlObj);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.naming.util.WsnInitCtxFactory.normalizeUrl", "1544", this);
                if (!_tc.isDebugEnabled()) break block14;
                Tr.debug(_tc, "normalizeUrl", "Cannot normalize URL. Exception: " + throwable);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "normalizeUrl", "normalizedURL=" + string);
        }
    }

    private NamingException mapInitialReferenceFailure(Exception exception, CommonData commonData) {
        NamingException namingException;
        String string = "";
        string = commonData._origUrlString != null ? "A communication failure occurred while attempting to obtain an initial context with the provider URL: \"" + commonData._origUrlString + "\".  " + "Make sure that any bootstrap address information in the URL is correct and " + "that the target name server is running.  A bootstrap address with no port " + "specification defaults to port 2809.  Possible causes other than an incorrect " + "bootstrap address or unavailable name server include the network environment " + "and workstation network configuration." : "Could not obtain an initial context due to a communication failure. Since no provider URL was specified, the default provider URL of \"" + this.objToString(commonData._normalizedUrlObj) + "\" was used.  " + "Make sure that any bootstrap address information in the URL is correct and " + "that the target name server is running.  Possible causes other than an " + "incorrect bootstrap address or unavailable name server include the network " + "environment and workstation network configuration.";
        if (exception instanceof COMM_FAILURE) {
            namingException = new CommunicationException(string);
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "Could not obtain initial reference. CommunicationException root exception: ", exception);
            }
        } else {
            namingException = new ServiceUnavailableException(string);
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "Could not obtain initial reference. ServiceUnavailableException root exception: ", exception);
            }
        }
        namingException.setRootCause(exception);
        return namingException;
    }

    private static ContextID[] toContextIDs(String[] stringArray) {
        ContextID[] contextIDArray = new ContextID[stringArray.length];
        for (int i = 0; i < contextIDArray.length; ++i) {
            contextIDArray[i] = new StringContextID(stringArray[i]);
        }
        return contextIDArray;
    }

    private static int toInt(String string) {
        int n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            FFDCFilter.processException(numberFormatException, "com.ibm.ws.naming.util.WsnInitCtxFactory.toInt", "1772");
        }
        return n;
    }

    private String objToString(java.lang.Object object) {
        final java.lang.Object object2 = object;
        String string = (String)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public java.lang.Object run() {
                return object2.toString();
            }
        });
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOURCE CODE INFO: ws/code/naming.client/src/com/ibm/ws/naming/util/WsnInitCtxFactory.java, WAS.naming.client, ASV51X, a0425.05, ver. 1.51.1.1");
        }
        _insEnv = new Hashtable();
        _insEnv.put("com.ibm.websphere.naming.name.syntax", "ins");
    }

    public class CommonData {
        Hashtable _env = null;
        String _wsnNSImplType = null;
        String _wsnNSRootType = null;
        String _wsnNSRootTypeProp = null;
        boolean _gotWsnNameService = false;
        String _wsnTreeRootIor = null;
        String _wsnNodeRootIor = null;
        String _wsnCellRootIor = null;
        String _wsnCellPersistentRootIor = null;
        String _wsnServerRootIor = null;
        String _wsnTreeRootName = null;
        String _wsnNodeRootName = null;
        String _wsnCellRootName = null;
        String _wsnCellPersistentRootName = null;
        String _wsnServerRootName = null;
        ContextID[] _wsnTreeRootCtxIDs = null;
        ContextID[] _wsnNodeRootCtxIDs = null;
        ContextID[] _wsnCellRootCtxIDs = null;
        ContextID[] _wsnCellPersistentRootCtxIDs = null;
        ContextID[] _wsnServerRootCtxIDs = null;
        ContextID _wsnTreeRootCtxID = null;
        ContextID _wsnNodeRootCtxID = null;
        ContextID _wsnCellRootCtxID = null;
        ContextID _wsnCellPersistentRootCtxID = null;
        ContextID _wsnServerRootCtxID = null;
        int _wsnIDLLevel = -1;
        public org.omg.CORBA.ORB _omgOrb = null;
        public String _origUrlString = null;
        public String _normalizedUrlScheme = null;
        public ObjectURL _normalizedUrlObj = null;
        public String _targetContextName = null;
        public boolean _cachingEnabled = false;
        public Cache _cache = null;
        public boolean _ldapSkipBootstrap = false;

        public CommonData(Hashtable hashtable) {
            String string;
            String string2;
            this._env = hashtable;
            this._wsnNSRootTypeProp = (String)this._env.get("com.ibm.websphere.naming.namespaceroot");
            if (this._wsnNSRootTypeProp == null) {
                this._wsnNSRootTypeProp = "defaultroot";
            }
            if ((string2 = (String)this._env.get("com.ibm.ws.naming.implementation")) != null && (string2.equals("WsnLdap") || string2.equals("WsnLdapCos")) && (string = (String)this._env.get("com.ibm.ws.naming.ldap.config")) != null && string.equals("local")) {
                this._ldapSkipBootstrap = true;
                this._wsnNSImplType = string2;
            }
        }

        public void clearWsnNSProperties() {
            this._gotWsnNameService = false;
            this._wsnTreeRootIor = null;
            this._wsnNodeRootIor = null;
            this._wsnCellRootIor = null;
            this._wsnCellPersistentRootIor = null;
            this._wsnServerRootIor = null;
            this._wsnTreeRootName = null;
            this._wsnNodeRootName = null;
            this._wsnCellRootName = null;
            this._wsnCellPersistentRootName = null;
            this._wsnServerRootName = null;
            this._wsnTreeRootCtxIDs = null;
            this._wsnNodeRootCtxIDs = null;
            this._wsnCellRootCtxIDs = null;
            this._wsnCellPersistentRootCtxIDs = null;
            this._wsnServerRootCtxIDs = null;
            this._wsnTreeRootCtxID = null;
            this._wsnNodeRootCtxID = null;
            this._wsnCellRootCtxID = null;
            this._wsnCellPersistentRootCtxID = null;
            this._wsnServerRootCtxID = null;
            this._wsnIDLLevel = -1;
        }
    }
}

