/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.misc.Debug;
import com.ibm.security.cert.CertPathUtil;
import com.ibm.security.cert.CompositeCRL;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.CRLReasonCodeExtension;
import com.ibm.security.x509.DeltaCRLIndicatorExtension;
import com.ibm.security.x509.DistributionPoint;
import com.ibm.security.x509.GeneralName;
import com.ibm.security.x509.GeneralNames;
import com.ibm.security.x509.GeneralNamesException;
import com.ibm.security.x509.IssuingDistributionPointExtension;
import com.ibm.security.x509.OIDMap;
import com.ibm.security.x509.ReasonFlags;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CRLEntryImpl;
import com.ibm.security.x509.X509CRLImpl;
import com.ibm.security.x509.X509CertImpl;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CRLSelector;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;

public class CRSChecker {
    private static final Debug debug = Debug.getInstance((String)"certpath");
    static final String[] myExtensions = new String[]{OIDMap.getOID((String)"x509.info.extensions.CRLDistributionPoints").toString()};
    static final String[] deltaCRLAttrIDArray = new String[]{"deltaRevocationList"};
    static final String[] baseCRLAttrIDArray = new String[]{"certificateRevocationList"};
    static final String[] baseARLAttrIDArray = new String[]{"authorityRevocationList"};
    static final String[] allCRLAttrIDArray = new String[]{"authorityRevocationList", "certificateRevocationList", "caCertificate"};
    private CertPath certPath;
    private Collection certStores;
    private boolean trustCertPathForCRLs;
    private boolean useDeltas;
    private Set trustBaseSet;
    private Date validationDate;
    private int numberOfCertsInCertPath;
    private String sigProvider;
    private Collection ibmCollectionCertStores = null;
    private int currentCertIndex;
    private Vector willBeTrustedCollection;
    private Hashtable CRLCache = new Hashtable();
    private boolean[] userReasons = new boolean[]{false, true, true, true, true, true, true};
    private TrustAnchor trustAnchor;

    public CRSChecker(CertPath certPath, Collection collection, boolean bl, boolean bl2, Set set, Date date, boolean bl3, String string) throws CertPathValidatorException {
        this.certPath = certPath;
        this.certStores = collection;
        this.trustCertPathForCRLs = bl;
        this.useDeltas = bl2;
        this.trustBaseSet = set;
        this.validationDate = date;
        this.sigProvider = string;
        List<? extends Certificate> list = certPath.getCertificates();
        this.numberOfCertsInCertPath = list.size();
        this.currentCertIndex = this.numberOfCertsInCertPath - 1;
        this.willBeTrustedCollection = new Vector();
        this.ibmCollectionCertStores = CRSChecker.getIBMCollectionCertStores(collection);
        this.CRLCache = this.setCRLCache(collection);
        X509Certificate x509Certificate = (X509Certificate)list.get(this.numberOfCertsInCertPath - 1);
        if (x509Certificate != null) {
            this.trustAnchor = null;
            try {
                this.trustAnchor = CertPathUtil.findIssuer(x509Certificate, set, string);
            }
            catch (CertPathValidatorException certPathValidatorException) {
                throw new CertPathValidatorException("The certificate issued by " + x509Certificate.getIssuerDN().toString() + " is not trusted", (Throwable)certPathValidatorException, certPath, this.numberOfCertsInCertPath - 1);
            }
        }
    }

    public void init(boolean bl) throws CertPathValidatorException {
        if (bl) {
            throw new CertPathValidatorException("The direction of forward is not supported");
        }
    }

    public Set getSupportedExtensions() {
        return null;
    }

    public boolean isForwardCheckingSupported() {
        return false;
    }

    public void check(Certificate certificate, Collection collection) throws CertPathValidatorException {
        Object object;
        Object var4_3 = null;
        X509Certificate x509Certificate = (X509Certificate)certificate;
        if (x509Certificate.getIssuerDN().equals(x509Certificate.getSubjectDN())) {
            try {
                this.trustAnchor = new TrustAnchor(x509Certificate, null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new CertPathValidatorException("Fail to instantiate trust anchor for certificate revocation status processing", (Throwable)illegalArgumentException, this.certPath, this.currentCertIndex);
            }
            --this.currentCertIndex;
            return;
        }
        boolean bl = true;
        Object[] objectArray = CertPathUtil.getBasicConstraints(x509Certificate);
        bl = (Boolean)objectArray[1];
        int n = 2001;
        if (this.trustCertPathForCRLs) {
            this.willBeTrustedCollection.add(x509Certificate);
        }
        if ((n = this.checkCRLCache(x509Certificate, this.trustAnchor, bl)) == 2001 && (object = CertPathUtil.getCRLDistributionPoints(x509Certificate)) != null) {
            n = CRSChecker.processDistributionPoints(object, x509Certificate, this.willBeTrustedCollection, this.certStores, this.useDeltas, this.trustBaseSet, bl, this.validationDate, this.userReasons, this.sigProvider);
        }
        object = x509Certificate.getSubjectDN().toString();
        String string = null;
        switch (n) {
            case 1000: {
                string = "The certificate with subject (" + (String)object + ") has been revoked for an unspecified reason.";
                break;
            }
            case 1001: {
                string = "The certificate with subject (" + (String)object + ") has been revoked because the key has been compromised.";
                break;
            }
            case 1002: {
                string = "The certificate with subject (" + (String)object + ") has been revoked because the CA key has been compromised.";
                break;
            }
            case 1003: {
                string = "The certificate with subject (" + (String)object + ") has been revoked because the owner's affiliation has changed.";
                break;
            }
            case 1004: {
                string = "The certificate with subject (" + (String)object + ") has been revoked because is is superseded.";
                break;
            }
            case 1005: {
                string = "The certificate with subject (" + (String)object + ") has been revoked because of cessation of operation.";
                break;
            }
            case 1006: {
                string = "The certificate with subject (" + (String)object + ") has been put on hold.";
                break;
            }
            case 2000: {
                break;
            }
            case 2001: {
                string = "The revocation status of the certificate with subject (" + (String)object + ") could not be determined.";
                break;
            }
            case 2002: {
                string = "The certificate with subject (" + (String)object + ") has been revoked, revocation reason unknown.";
                break;
            }
            default: {
                string = "An internal error has occurred in processing the certificate:" + n;
            }
        }
        if (string != null) {
            throw new CertPathValidatorException(string, null, this.certPath, this.currentCertIndex);
        }
        try {
            this.trustAnchor = new TrustAnchor(x509Certificate, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CertPathValidatorException("Fail to instantiate trust anchor for certificate revocation status processing", (Throwable)illegalArgumentException, this.certPath, this.currentCertIndex);
        }
        --this.currentCertIndex;
    }

    int checkCRLCache(X509Certificate x509Certificate, TrustAnchor trustAnchor, boolean bl) throws CertPathValidatorException {
        Principal principal = null;
        PublicKey publicKey = null;
        X509Certificate x509Certificate2 = null;
        boolean[] blArray = CertPathUtil.getKeyUsage(x509Certificate);
        if (this.currentCertIndex != 0 && bl && blArray != null && !blArray[6]) {
            return 2001;
        }
        x509Certificate2 = trustAnchor.getTrustedCert();
        if (x509Certificate2 != null) {
            if (!(x509Certificate2 instanceof X509CertImpl)) {
                try {
                    x509Certificate2 = new X509CertImpl(x509Certificate2.getEncoded());
                }
                catch (CertificateException certificateException) {
                    throw new CertPathValidatorException(certificateException.getMessage());
                }
            }
            principal = x509Certificate2.getSubjectDN();
            publicKey = x509Certificate2.getPublicKey();
        } else {
            try {
                principal = new X500Name(trustAnchor.getCAName());
            }
            catch (IOException iOException) {
                return 2001;
            }
            publicKey = trustAnchor.getCAPublicKey();
        }
        BigInteger bigInteger = x509Certificate.getSerialNumber();
        ArrayList arrayList = null;
        int n = 2001;
        boolean bl2 = false;
        arrayList = this.getCRLCache(principal);
        if (arrayList != null) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                DerValue derValue;
                Object object;
                DerValue derValue2;
                Object object2;
                X509CRL x509CRL;
                block27: {
                    x509CRL = (X509CRL)iterator.next();
                    Date date = x509CRL.getNextUpdate();
                    if (date != null && date.before((Date)(object2 = new Date()))) continue;
                    try {
                        x509CRL.verify(publicKey);
                        if (bl2) break block27;
                        bl2 = true;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
                object2 = x509CRL.getExtensionValue("2.5.29.28");
                if (object2 != null) {
                    try {
                        derValue2 = new DerValue((byte[])object2);
                        object2 = derValue2.getOctetString();
                        object = new IssuingDistributionPointExtension((byte[])object2);
                        if (bl) {
                            if (((Boolean)object.get("user_certs_only")).booleanValue()) {
                                bl2 = false;
                                continue;
                            }
                        } else if (((Boolean)object.get("ca_certs_only")).booleanValue()) {
                            bl2 = false;
                            continue;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                derValue2 = null;
                derValue2 = (X509CRLEntryImpl)x509CRL.getRevokedCertificate(bigInteger);
                if (derValue2 != null) {
                    object = derValue2.getExtensionValue("2.5.29.21");
                    if (object != null) {
                        try {
                            derValue = new CRLReasonCodeExtension(Boolean.FALSE, object);
                            int n2 = (Integer)derValue.get("reason");
                            n = 1000 + n2;
                        }
                        catch (IOException iOException) {
                            n = 2002;
                        }
                    } else {
                        n = 2002;
                    }
                    return n;
                }
                object = x509CRL.getExtensionValue("2.5.29.27");
                if (object == null) continue;
                try {
                    derValue = new DerValue(object);
                    object = derValue.getOctetString();
                    DeltaCRLIndicatorExtension deltaCRLIndicatorExtension = new DeltaCRLIndicatorExtension(Boolean.TRUE, object);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                bl2 = false;
            }
            if (bl2) {
                n = 2000;
            }
        }
        return n;
    }

    ArrayList getCRLCache(Principal principal) {
        ArrayList arrayList = null;
        arrayList = (ArrayList)this.CRLCache.get(principal);
        if (arrayList != null) {
            return arrayList;
        }
        Enumeration enumeration = this.CRLCache.keys();
        while (enumeration.hasMoreElements()) {
            Principal principal2 = (Principal)enumeration.nextElement();
            if (!principal2.equals(principal)) continue;
            return (ArrayList)this.CRLCache.get(principal2);
        }
        return arrayList;
    }

    static int processDistributionPoints(DistributionPoint[] distributionPointArray, X509Certificate x509Certificate, Collection collection, Collection collection2, boolean bl, Collection collection3, boolean bl2, Date date, boolean[] blArray, String string) throws CertPathValidatorException {
        CompositeCRL compositeCRL = null;
        boolean[] blArray2 = new boolean[]{false, false, false, false, false, false, false, false, false};
        boolean[] blArray3 = new boolean[]{true, true, true, true, true, true, true, true, true, true};
        int n = 2000;
        int n2 = 0;
        while (!(n2 >= distributionPointArray.length || CertPathUtil.allUserReasonsSatisfied(blArray, blArray2) || n != 2000 && n != 2001)) {
            block12: {
                Object object;
                ReasonFlags reasonFlags;
                try {
                    reasonFlags = distributionPointArray[n2].getReasons();
                    if (reasonFlags == null) {
                        blArray3 = new boolean[10];
                        Arrays.fill(blArray3, true);
                    } else {
                        object = reasonFlags.getReasonFlags();
                        blArray3 = object.toBooleanArray();
                    }
                }
                catch (IOException iOException) {
                    throw new CertPathValidatorException("An internal error has occurred in processing the certificate.", iOException);
                }
                compositeCRL = CRSChecker.getCompositeCRLFromDP(distributionPointArray[n2], x509Certificate, collection, collection2, bl, collection3, bl2, date, blArray3, string);
                if (compositeCRL != null) {
                    boolean[] blArray4 = compositeCRL.getReasons();
                    try {
                        CertPathUtil.intersectReasons(blArray4, blArray3);
                        if (CertPathUtil.interimContainMoreReasons(blArray4, blArray2)) {
                            reasonFlags = distributionPointArray[n2].getIssuer();
                            object = CertPathUtil.findDNCRLIssuer((GeneralNames)reasonFlags);
                            if (object != null ? object.equals(compositeCRL.getIssuerName()) : x509Certificate.getIssuerDN().equals(compositeCRL.getIssuerName())) {
                                n = compositeCRL.getStatus(x509Certificate.getSerialNumber(), date);
                                CertPathUtil.unionReasons(blArray2, blArray4);
                            }
                            break block12;
                        }
                        throw new CertPathValidatorException("Interim Reasons Mask did not contain more reaons than reasons mask ");
                    }
                    catch (IOException iOException) {
                    }
                    catch (GeneralNamesException generalNamesException) {
                        // empty catch block
                    }
                }
            }
            ++n2;
        }
        if (n == 2000 && !CertPathUtil.allUserReasonsSatisfied(blArray, blArray2)) {
            n = 2001;
        }
        return n;
    }

    static CompositeCRL getCompositeCRLFromDP(DistributionPoint distributionPoint, X509Certificate x509Certificate, Collection collection, Collection collection2, boolean bl, Collection collection3, boolean bl2, Date date, boolean[] blArray, String string) throws CertPathValidatorException {
        Object object;
        CompositeCRL compositeCRL = null;
        GeneralNames generalNames = null;
        try {
            generalNames = distributionPoint.getIssuer();
        }
        catch (IOException iOException) {
        }
        catch (GeneralNamesException generalNamesException) {
            // empty catch block
        }
        Principal principal = CertPathUtil.findDNCRLIssuer(generalNames);
        if (principal == null) {
            principal = x509Certificate.getIssuerDN();
        }
        GeneralName generalName = null;
        try {
            object = (GeneralNames)distributionPoint.getName();
            generalName = CertPathUtil.getSupportedNameObjectFromGeneralNames(object);
        }
        catch (IOException iOException) {
        }
        catch (GeneralNamesException generalNamesException) {
            // empty catch block
        }
        if (generalName != null) {
            if (generalName.getType() == 6) {
                boolean bl3;
                object = CertPathUtil.stripJunk(generalName.toString());
                compositeCRL = CRSChecker.getCompositeCRLByDPName((String)object, principal, collection2, bl, collection, collection3, bl2, date, string);
                if (compositeCRL != null && !(bl3 = CRSChecker.isIssuerTrusted(compositeCRL.getIssuerCertificate(), collection, collection3, string))) {
                    compositeCRL = null;
                }
            } else if (generalName.getType() == 4) {
                object = generalName.toString();
                compositeCRL = CRSChecker.getCompositeCRLByIssuerName((String)object, date, collection2, blArray, false, bl2, collection, collection3, bl, string);
            }
        }
        return compositeCRL;
    }

    static CompositeCRL getCompositeCRLByDPName(String string, Principal principal, Collection collection, boolean bl, Collection collection2, Collection collection3, boolean bl2, Date date, String string2) throws CertPathValidatorException {
        Hashtable hashtable = null;
        hashtable = bl2 ? CompositeCRL.CAcompositeCRLHashtable : CompositeCRL.EEcompositeCRLHashtable;
        String string3 = string;
        CompositeCRL compositeCRL = (CompositeCRL)hashtable.get(string3);
        CompositeCRL[] compositeCRLArray = null;
        if (compositeCRL != null) {
            Date date2 = compositeCRL.getNextUpdate();
            if (date2.compareTo(date) <= 0) {
                int n = 0;
                if (CertPathUtil.isHTTPURI(string)) {
                    X509CRL x509CRL = CRSChecker.getCRLWithHttp(string);
                    if (x509CRL != null) {
                        n = compositeCRL.update(x509CRL, date, string2);
                    }
                } else if (CertPathUtil.isLDAPURI(string)) {
                    n = CRSChecker.updateCompositeCRL(string, compositeCRL, bl, bl2, date, string2);
                }
                if (n != 1001 && n != 1002) {
                    compositeCRL = null;
                }
            }
        } else if (compositeCRL == null) {
            if (CertPathUtil.isHTTPURI(string)) {
                compositeCRLArray = new CompositeCRL[2];
                X509CRL x509CRL = CRSChecker.getCRLWithHttp(string);
                if (x509CRL != null) {
                    compositeCRL = new CompositeCRL(null);
                    compositeCRL.update(x509CRL);
                    X509Certificate x509Certificate = null;
                    try {
                        x509Certificate = CertPathUtil.findIssuerOfCRL(x509CRL, collection2, collection3, collection, string2);
                    }
                    catch (CertificateNotYetValidException certificateNotYetValidException) {
                        x509Certificate = null;
                    }
                    if (x509Certificate == null) {
                        compositeCRL = null;
                    } else {
                        compositeCRL.setIssuerCertificate(x509Certificate);
                        boolean bl3 = CRSChecker.isIssuerTrusted(x509Certificate, collection2, collection3, string2);
                        if (bl3) {
                            compositeCRLArray[0] = compositeCRL;
                            compositeCRLArray[1] = compositeCRL;
                        }
                    }
                }
            } else if (CertPathUtil.isLDAPURI(string)) {
                compositeCRLArray = CRSChecker.createCompositeCRLWithDPName(string, collection2, collection, string2);
            }
            if (compositeCRLArray[0] != null && bl2) {
                CompositeCRL.CAcompositeCRLHashtable.put(string3, compositeCRLArray[0]);
            }
            if (compositeCRLArray[1] != null && !bl2) {
                CompositeCRL.EEcompositeCRLHashtable.put(string3, compositeCRLArray[1]);
            }
            if (bl2) {
                compositeCRL = compositeCRLArray[0];
            } else if (!bl2) {
                compositeCRL = compositeCRLArray[1];
            }
        }
        return compositeCRL;
    }

    static CompositeCRL[] createCompositeCRLWithDPName(String string, Collection collection, Collection collection2, String string2) throws CertPathValidatorException {
        CompositeCRL[] compositeCRLArray = new CompositeCRL[2];
        String[] stringArray = CRSChecker.getLDAPURLAndDN(string);
        if (stringArray[0] != null & stringArray[1] != null) {
            DirContext dirContext = CertPathUtil.getDirContext(stringArray[0]);
            X509CRLImpl[] x509CRLImplArray = CertPathUtil.retrieveCRLs(dirContext, stringArray[1], allCRLAttrIDArray);
            X509CRLImpl x509CRLImpl = x509CRLImplArray[0];
            X509Certificate x509Certificate = (X509Certificate)x509CRLImplArray[2];
            CompositeCRL compositeCRL = CRSChecker.createOneCompositeCRL(stringArray[1], collection, collection2, x509CRLImpl, x509Certificate, string2);
            X509CRLImpl x509CRLImpl2 = x509CRLImplArray[1];
            CompositeCRL compositeCRL2 = CRSChecker.createOneCompositeCRL(stringArray[1], collection, collection2, x509CRLImpl2, x509Certificate, string2);
            compositeCRLArray[0] = compositeCRL;
            compositeCRLArray[1] = compositeCRL2;
        }
        return compositeCRLArray;
    }

    static X509CRL getCRLWithHttp(String string) {
        X509CRL x509CRL;
        block10: {
            URL uRL = null;
            HttpURLConnection httpURLConnection = null;
            x509CRL = null;
            try {
                uRL = new URL(string);
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "IBMCertPath");
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
                InputStream inputStream = httpURLConnection.getInputStream();
                x509CRL = (X509CRL)certificateFactory.generateCRL(inputStream);
            }
            catch (MalformedURLException malformedURLException) {
                if (debug != null) {
                    System.out.println("Failed to retrieve CRL from " + string);
                    malformedURLException.printStackTrace();
                }
            }
            catch (CRLException cRLException) {
                if (debug != null) {
                    System.out.println("Failed to retrieve CRL from " + string);
                    cRLException.printStackTrace();
                }
            }
            catch (CertificateException certificateException) {
                if (debug != null) {
                    System.out.println("Failed to retrieve CRL from " + string);
                    certificateException.printStackTrace();
                }
            }
            catch (IOException iOException) {
                if (debug != null) {
                    System.out.println("Failed to retrieve CRL from " + string);
                    iOException.printStackTrace();
                }
            }
            catch (NoSuchProviderException noSuchProviderException) {
                if (debug == null) break block10;
                System.out.println("Failed to retrieve CRL from " + string);
                noSuchProviderException.printStackTrace();
            }
        }
        return x509CRL;
    }

    static CompositeCRL createOneCompositeCRL(String string, Collection collection, Collection collection2, X509CRLImpl x509CRLImpl, X509Certificate x509Certificate, String string2) throws CertPathValidatorException {
        X509Certificate x509Certificate2 = null;
        CompositeCRL compositeCRL = null;
        if (x509CRLImpl != null) {
            if (x509Certificate != null) {
                int n;
                if (!(x509Certificate instanceof X509CertImpl)) {
                    try {
                        x509Certificate = new X509CertImpl(x509Certificate.getEncoded());
                    }
                    catch (CertificateException certificateException) {
                        throw new CertPathValidatorException(certificateException.getMessage());
                    }
                }
                try {
                    n = CertPathUtil.verifyCRLIssuer((X509CRL)x509CRLImpl, x509Certificate.getPublicKey(), x509Certificate.getIssuerDN(), string2);
                }
                catch (CertificateNotYetValidException certificateNotYetValidException) {
                    n = Integer.MAX_VALUE;
                }
                if (n == 0) {
                    x509Certificate2 = x509Certificate;
                }
            }
            if (x509Certificate2 == null) {
                try {
                    x509Certificate2 = CertPathUtil.findIssuerOfCRL((X509CRL)x509CRLImpl, collection, null, collection2, string2);
                }
                catch (CertificateNotYetValidException certificateNotYetValidException) {
                    x509Certificate2 = null;
                }
            }
            if (x509Certificate2 != null) {
                compositeCRL = new CompositeCRL(string);
                compositeCRL.update((X509CRL)x509CRLImpl);
                compositeCRL.setIssuerCertificate(x509Certificate2);
            }
        }
        return compositeCRL;
    }

    static int updateCompositeCRL(String string, CompositeCRL compositeCRL, boolean bl, boolean bl2, Date date, String string2) throws CertPathValidatorException {
        int n = 0;
        String[] stringArray = CRSChecker.getLDAPURLAndDN(string);
        if (stringArray[0] != null & stringArray[1] != null) {
            DirContext dirContext = CertPathUtil.getDirContext(stringArray[0]);
            if (bl2) {
                n = CRSChecker.retrieveBaseCRL(compositeCRL, dirContext, stringArray[1], baseARLAttrIDArray, date, string2);
            } else if (!bl2) {
                if (bl) {
                    n = CRSChecker.retrieveDeltaCRL(compositeCRL, dirContext, stringArray[1], deltaCRLAttrIDArray, date, string2);
                    if (n != 1001 && n != 1001) {
                        n = CRSChecker.retrieveBaseCRL(compositeCRL, dirContext, stringArray[1], baseCRLAttrIDArray, date, string2);
                    }
                } else {
                    n = CRSChecker.retrieveBaseCRL(compositeCRL, dirContext, stringArray[1], baseCRLAttrIDArray, date, string2);
                }
            }
        }
        return n;
    }

    static CompositeCRL getCompositeCRLByIssuerName(String string, Date date, Collection collection, boolean[] blArray, boolean bl, boolean bl2, Collection collection2, Collection collection3, boolean bl3, String string2) throws CertPathValidatorException {
        CompositeCRL compositeCRL = CRSChecker.getFirstFindFromCache(string, blArray, bl2);
        if (compositeCRL != null) {
            Object[] objectArray = CRSChecker.getStatusFromCertStores(string, bl2, date, collection, blArray, true, collection2, collection3, bl3, string2);
            compositeCRL = CRSChecker.getFirstFindFromCache(string, blArray, bl2);
        }
        return compositeCRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CompositeCRL getFirstFindFromCache(String string, boolean[] blArray, boolean bl) {
        Hashtable hashtable = null;
        CompositeCRL compositeCRL = null;
        hashtable = bl ? (Hashtable)CompositeCRL.CAcompositeCRLHashtable.get(string) : (Hashtable)CompositeCRL.CAcompositeCRLHashtable.get(string);
        if (hashtable != null) {
            Hashtable hashtable2 = hashtable;
            synchronized (hashtable2) {
                Enumeration enumeration = hashtable.elements();
                while (enumeration.hasMoreElements()) {
                    compositeCRL = (CompositeCRL)enumeration.nextElement();
                    if (CertPathUtil.minimalUserReasonsSatisfied(blArray, compositeCRL.getReasons())) break;
                    compositeCRL = null;
                }
            }
        }
        return compositeCRL;
    }

    static int processIssuerName(X509Certificate x509Certificate, Collection collection, Collection collection2, boolean bl, Collection collection3, boolean bl2, Date date, boolean[] blArray, String string) throws CertPathValidatorException {
        Hashtable hashtable = null;
        String string2 = x509Certificate.getIssuerDN().toString();
        int n = 2001;
        hashtable = bl2 ? (Hashtable)CompositeCRL.CAcompositeCRLHashtable.get(string2) : (Hashtable)CompositeCRL.EEcompositeCRLHashtable.get(string2);
        if (hashtable != null) {
            n = CRSChecker.getCRSFromCache(hashtable, date, x509Certificate.getSerialNumber(), blArray);
        }
        if (n == 2001) {
            Object[] objectArray = CRSChecker.getStatusFromCertStores(string2, bl2, date, collection2, blArray, true, collection, collection3, bl, string);
            hashtable = bl2 ? (Hashtable)objectArray[0] : (Hashtable)objectArray[1];
            n = CRSChecker.getCRSFromCache(hashtable, date, x509Certificate.getSerialNumber(), blArray);
        }
        return n;
    }

    static int getCRSFromCache(Hashtable hashtable, Date date, BigInteger bigInteger, boolean[] blArray) throws CertPathValidatorException {
        boolean[] blArray2 = new boolean[]{false, false, false, false, false, false, false, false, false};
        int n = 2001;
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            CompositeCRL compositeCRL = (CompositeCRL)enumeration.nextElement();
            n = compositeCRL.getStatus(bigInteger, date);
            if (n != 2001 && n != 2000) continue;
            CertPathUtil.unionReasons(blArray2, compositeCRL.getReasons());
            if (CertPathUtil.allUserReasonsSatisfied(blArray, blArray2)) break;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object[] getStatusFromCertStores(String string, boolean bl, Date date, Collection collection, boolean[] blArray, boolean bl2, Collection collection2, Collection collection3, boolean bl3, String string2) throws CertPathValidatorException {
        Hashtable hashtable = null;
        Hashtable hashtable2 = null;
        Hashtable hashtable3 = CompositeCRL.CAcompositeCRLHashtable;
        synchronized (hashtable3) {
            hashtable = (Hashtable)CompositeCRL.CAcompositeCRLHashtable.get(string);
            if (hashtable == null) {
                hashtable = new Hashtable();
                CompositeCRL.CAcompositeCRLHashtable.put(string, hashtable);
            }
        }
        Hashtable hashtable4 = CompositeCRL.EEcompositeCRLHashtable;
        synchronized (hashtable4) {
            hashtable2 = (Hashtable)CompositeCRL.EEcompositeCRLHashtable.get(string);
            if (hashtable2 == null) {
                hashtable2 = new Hashtable();
                CompositeCRL.EEcompositeCRLHashtable.put(string, hashtable2);
            }
        }
        CRSChecker.updateCachesFromCertStores(string, bl, date, collection, hashtable, hashtable2, blArray, bl2, collection2, collection3, bl3, string2);
        Object[] objectArray = new Object[]{hashtable, hashtable2};
        return objectArray;
    }

    static void updateCachesFromCertStores(String string, boolean bl, Date date, Collection collection, Hashtable hashtable, Hashtable hashtable2, boolean[] blArray, boolean bl2, Collection collection2, Collection collection3, boolean bl3, String string2) throws CertPathValidatorException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        boolean[] blArray2 = new boolean[]{false, false, false, false, false, false, false, false, false};
        X509CRLSelector x509CRLSelector = new X509CRLSelector();
        try {
            x509CRLSelector.addIssuerName(string);
        }
        catch (IOException iOException) {
            return;
        }
        Vector<Object> vector = new Vector<Object>();
        Iterator iterator = collection.iterator();
        block4: while (iterator.hasNext()) {
            object4 = (CertStore)iterator.next();
            object3 = null;
            try {
                object3 = ((CertStore)object4).getCRLs(x509CRLSelector);
            }
            catch (CertStoreException certStoreException) {
                // empty catch block
            }
            if (object3 == null) continue;
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (X509CRL)object2.next();
                if (CompositeCRL.isDeltaCRL((X509CRL)object)) {
                    vector.add(object);
                    continue;
                }
                CompositeCRL compositeCRL = CRSChecker.createCompositeCRL(hashtable2, hashtable, (X509CRL)object, collection, collection2, collection3, string2);
                if (compositeCRL == null || (!bl || !compositeCRL.isTypeCA()) && (bl || !compositeCRL.isTypeEE())) continue;
                CertPathUtil.unionReasons(blArray2, compositeCRL.getReasons());
                if (bl2) {
                    if (!CertPathUtil.allUserReasonsSatisfied(blArray, blArray2)) continue;
                    Date date2 = compositeCRL.getNextUpdate();
                    int n = date2.compareTo(date);
                    if (n > 0) break block4;
                    if (n > 0) continue;
                    continue;
                }
                if (CertPathUtil.minimalUserReasonsSatisfied(blArray, blArray2)) break block4;
            }
        }
        object4 = bl ? hashtable : hashtable2;
        object3 = vector.iterator();
        while (object3.hasNext()) {
            object2 = (X509CRL)object3.next();
            object = (CompositeCRL)((Hashtable)object4).get(CompositeCRL.getCRLNumber((X509CRL)object2));
            if (object == null) continue;
            ((CompositeCRL)object).refresh((X509CRL)object2);
        }
    }

    static CompositeCRL createCompositeCRL(Hashtable hashtable, Hashtable hashtable2, X509CRL x509CRL, Collection collection, Collection collection2, Collection collection3, String string) throws CertPathValidatorException {
        Object object;
        CompositeCRL compositeCRL = null;
        CompositeCRL compositeCRL2 = new CompositeCRL(null);
        compositeCRL2.update(x509CRL);
        BigInteger bigInteger = compositeCRL2.getNumber();
        boolean bl = false;
        boolean bl2 = false;
        if (compositeCRL2.isTypeEE() && (object = hashtable.get(bigInteger)) == null) {
            bl = true;
        }
        if (compositeCRL2.isTypeCA() && (object = hashtable2.get(bigInteger)) == null) {
            bl2 = true;
        }
        if (bl || bl2) {
            object = null;
            try {
                object = CertPathUtil.findIssuerOfCRL(x509CRL, collection2, collection3, collection, string);
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                object = null;
            }
            if (object != null) {
                compositeCRL2.setIssuerCertificate((X509Certificate)object);
                boolean bl3 = CRSChecker.isIssuerTrusted(object, collection2, collection3, string);
                compositeCRL = compositeCRL2;
                if (bl3) {
                    if (bl) {
                        hashtable.put(bigInteger, compositeCRL2);
                    }
                    if (bl2) {
                        hashtable2.put(bigInteger, compositeCRL2);
                    }
                }
            }
        }
        return compositeCRL;
    }

    static boolean isIssuerTrusted(X509Certificate x509Certificate, Collection collection, Collection collection2, String string) {
        boolean bl = false;
        if (!bl) {
            TrustAnchor trustAnchor = null;
            try {
                trustAnchor = CertPathUtil.findIssuer(x509Certificate, collection, string);
            }
            catch (CertPathValidatorException certPathValidatorException) {
                // empty catch block
            }
            if (trustAnchor == null) {
                try {
                    trustAnchor = CertPathUtil.findIssuer(x509Certificate, collection2, string);
                }
                catch (CertPathValidatorException certPathValidatorException) {
                    // empty catch block
                }
                if (trustAnchor != null) {
                    bl = true;
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }

    static int retrieveBaseCRL(CompositeCRL compositeCRL, DirContext dirContext, String string, String[] stringArray, Date date, String string2) throws CertPathValidatorException {
        int n = 0;
        X509CRLImpl[] x509CRLImplArray = CertPathUtil.retrieveCRLs(dirContext, string, stringArray);
        n = compositeCRL.updateBase((X509CRL)x509CRLImplArray[0], date, string2);
        return n;
    }

    static int retrieveDeltaCRL(CompositeCRL compositeCRL, DirContext dirContext, String string, String[] stringArray, Date date, String string2) throws CertPathValidatorException {
        int n = 0;
        X509CRLImpl[] x509CRLImplArray = CertPathUtil.retrieveCRLs(dirContext, string, stringArray);
        n = compositeCRL.updateDelta((X509CRL)x509CRLImplArray[0], date, string2);
        return n;
    }

    static String[] getLDAPURLAndDN(String string) {
        String[] stringArray;
        block4: {
            stringArray = new String[2];
            try {
                CompositeName compositeName = new CompositeName(string);
                stringArray[0] = compositeName.get(0) + "//" + compositeName.get(2);
                stringArray[1] = compositeName.getSuffix(3).toString();
            }
            catch (InvalidNameException invalidNameException) {
                if (debug != null) {
                    System.out.println("Failed to retrieve CRL from " + string);
                    invalidNameException.printStackTrace();
                }
            }
            catch (NamingException namingException) {
                if (debug == null) break block4;
                System.out.println("Failed to retrieve CRL from " + string);
                namingException.printStackTrace();
            }
        }
        return stringArray;
    }

    private static Collection getIBMCollectionCertStores(Collection collection) {
        Vector<CertStore> vector = new Vector<CertStore>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            CertStore certStore = (CertStore)iterator.next();
            if (!certStore.getType().equals("Collection")) continue;
            vector.add(certStore);
        }
        if (vector.size() <= 0) {
            vector = null;
        }
        return vector;
    }

    private Hashtable setCRLCache(Collection collection) {
        if (!collection.isEmpty()) {
            CertStore certStore = null;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object object;
                Object object2;
                Object object3;
                ArrayList<Object> arrayList;
                Collection<? extends CRL> collection2 = null;
                certStore = (CertStore)iterator.next();
                if (certStore.getType().equals("Collection")) {
                    try {
                        collection2 = certStore.getCRLs(null);
                    }
                    catch (CertStoreException certStoreException) {
                        collection2 = null;
                    }
                } else if (certStore.getType().equals("LDAP") && !(arrayList = this.certPath.getCertificates()).isEmpty()) {
                    object3 = new X509CRLSelector();
                    object2 = null;
                    object = null;
                    Iterator<? extends Certificate> iterator2 = arrayList.iterator();
                    while (iterator2.hasNext()) {
                        object2 = (X509Certificate)iterator2.next();
                        object = ((X509Certificate)object2).getIssuerDN().toString();
                        try {
                            ((X509CRLSelector)object3).addIssuerName((String)object);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    try {
                        collection2 = certStore.getCRLs((CRLSelector)object3);
                    }
                    catch (CertStoreException certStoreException) {
                        collection2 = null;
                    }
                }
                if (collection2 == null) continue;
                arrayList = null;
                object3 = null;
                object2 = null;
                object = collection2.iterator();
                while (object.hasNext()) {
                    object3 = (X509CRL)object.next();
                    if (!(object3 instanceof X509CRLImpl)) {
                        try {
                            object3 = new X509CRLImpl(((X509CRL)object3).getEncoded());
                        }
                        catch (CRLException cRLException) {
                            continue;
                        }
                    }
                    object2 = ((X509CRL)object3).getIssuerDN();
                    arrayList = (ArrayList<Object>)this.CRLCache.get(object2);
                    if (arrayList != null) {
                        arrayList.add(object3);
                        this.CRLCache.put(object2, arrayList);
                        continue;
                    }
                    arrayList = new ArrayList<Object>();
                    arrayList.add(object3);
                    this.CRLCache.put(object2, arrayList);
                }
            }
        }
        return this.CRLCache;
    }
}

