/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.security.cert.CertPathUtil;
import com.ibm.security.util.BitArray;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.CRLNumberExtension;
import com.ibm.security.x509.CRLReasonCodeExtension;
import com.ibm.security.x509.DeltaCRLIndicatorExtension;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.IssuingDistributionPointExtension;
import com.ibm.security.x509.OIDMap;
import com.ibm.security.x509.PKIXExtensions;
import com.ibm.security.x509.ReasonFlags;
import java.io.IOException;
import java.math.BigInteger;
import java.security.Principal;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;

class CompositeCRL {
    static final int CERTIFICATE_REVOCATION_STATUS_UNSPECIFIED = 1000;
    static final int CERTIFICATE_REVOCATION_STATUS_KEY_COMPROMISE = 1001;
    static final int CERTIFICATE_REVOCATION_STATUS_CA_COMPROMISE = 1002;
    static final int CERTIFICATE_REVOCATION_STATUS_AFFILIATION_CHANGED = 1003;
    static final int CERTIFICATE_REVOCATION_STATUS_SUPERSEDED = 1004;
    static final int CERTIFICATE_REVOCATION_STATUS_CESSATION_OF_OPERATION = 1005;
    static final int CERTIFICATE_REVOCATION_STATUS_CERTIFICATE_HOLD = 1006;
    static final int CERTIFICATE_REVOCATION_STATUS_UNREVOKED = 2000;
    static final int CERTIFICATE_REVOCATION_STATUS_UNDETERMINED = 2001;
    static final int CERTIFICATE_REVOCATION_STATUS_REVOKED_NOREASONS = 2002;
    static final BigInteger BI_NEG_ONE = new BigInteger("-1");
    static final int COMPOSITE_UPDATED = 1001;
    static final int COMPOSITE_OUT_OF_DATE = 1002;
    static final int COMPOSITE_IS_CURRENT = 1003;
    static final int CRL_NOT_FOUND = 1004;
    static final int DELTA_OUT_OF_SEQUENCE = 1005;
    static final int COMPOSITE_IS_BACK_LEVEL = 1006;
    static final int CERTIFICATE_SETS_DO_NOT_MATCH = 1007;
    static final int REASONS_DO_NOT_MATCH = 1008;
    static final int DELTA_NOT_FOUND = 1009;
    static final int UPDATE_BASE_WITH_DELTA = 1010;
    static final int UPDATE_DELTA_WITH_BASE = 1011;
    static final int FAIL = Integer.MAX_VALUE;
    private int BASE_CRL_INDEX = 0;
    private int DELTA_CRL_INDEX = 1;
    private int NUMBER_INDEX = 2;
    private int REASONS_INDEX = 3;
    private int ONLY_CONTAINS_CA_INDEX = 4;
    private int ONLY_CONTAINS_EE_INDEX = 5;
    static Hashtable CAcompositeCRLHashtable = new Hashtable();
    static Hashtable EEcompositeCRLHashtable = new Hashtable();
    private X509Certificate issuerCertificate = null;
    private Principal issuerName = null;
    private String distributionPoint = null;
    private Object[] crlInfo = new Object[]{null, null, null, null, null, null};

    CompositeCRL(String string) {
        this.distributionPoint = string;
    }

    int getStatus(BigInteger bigInteger, Date date) throws CertPathValidatorException {
        int n;
        int n2 = 2000;
        Object[] objectArray = this.crlInfo;
        X509CRLEntry x509CRLEntry = null;
        Date date2 = null;
        X509CRL x509CRL = (X509CRL)objectArray[this.BASE_CRL_INDEX];
        date2 = x509CRL.getNextUpdate();
        if (objectArray[this.DELTA_CRL_INDEX] != null) {
            X509CRL x509CRL2 = (X509CRL)objectArray[this.DELTA_CRL_INDEX];
            x509CRLEntry = x509CRL2.getRevokedCertificate(bigInteger);
            date2 = x509CRL2.getNextUpdate();
        }
        if (x509CRLEntry == null) {
            x509CRLEntry = x509CRL.getRevokedCertificate(bigInteger);
        }
        if (x509CRLEntry != null) {
            n2 = CompositeCRL.getCRLEntryReasonCode(x509CRLEntry);
        }
        if ((n2 == 2000 || n2 == 1006) && (n = date2.compareTo(date)) <= 0) {
            n2 = 2001;
        }
        return n2;
    }

    void update(X509CRL x509CRL) throws CertPathValidatorException {
        Object[] objectArray = new Object[this.crlInfo.length];
        objectArray[this.BASE_CRL_INDEX] = x509CRL;
        objectArray[this.DELTA_CRL_INDEX] = null;
        objectArray[this.NUMBER_INDEX] = CompositeCRL.getCRLNumber(x509CRL);
        Object[] objectArray2 = CompositeCRL.getIssuingDistributionPoint(x509CRL);
        objectArray[this.ONLY_CONTAINS_CA_INDEX] = (Boolean)objectArray2[2];
        objectArray[this.ONLY_CONTAINS_EE_INDEX] = (Boolean)objectArray2[1];
        objectArray[this.REASONS_INDEX] = (boolean[])objectArray2[3];
        this.crlInfo = objectArray;
    }

    int update(X509CRL x509CRL, Date date, String string) throws CertPathValidatorException {
        int n = this.updateBase(x509CRL, date, string);
        if (n == 1010) {
            n = this.updateDelta(x509CRL, date, string);
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int updateBase(X509CRL x509CRL, Date date, String string) throws CertPathValidatorException {
        int n = 0;
        if (x509CRL != null) {
            if (CompositeCRL.isDeltaCRL(x509CRL)) {
                return 1010;
            }
            try {
                CertPathUtil.verifySignature(x509CRL, this.getIssuerCertificate().getPublicKey(), string);
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                throw new CertPathValidatorException(certificateNotYetValidException);
            }
            BigInteger bigInteger = CompositeCRL.getCRLNumber(x509CRL);
            int n2 = bigInteger.compareTo(this.getNumber());
            if (n2 <= 0) {
                Date date2 = this.getNextUpdate();
                n2 = date2.compareTo(date);
                if (n2 > 0) {
                    return 1003;
                }
                if (n2 > 0) return n;
                return 1002;
            }
            if (n2 <= 0) return n;
            this.update(x509CRL);
            Date date3 = this.getNextUpdate();
            n2 = date3.compareTo(date);
            if (n2 > 0) {
                return 1001;
            }
            if (n2 > 0) return n;
            return 1002;
        }
        if (x509CRL != null) return n;
        return 1004;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int updateDelta(X509CRL x509CRL, Date date, String string) throws CertPathValidatorException {
        int n = 0;
        if (x509CRL != null) {
            if (!CompositeCRL.isDeltaCRL(x509CRL)) return 1011;
            try {
                CertPathUtil.verifySignature(x509CRL, this.getIssuerCertificate().getPublicKey(), string);
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                throw new CertPathValidatorException(certificateNotYetValidException);
            }
            BigInteger bigInteger = CompositeCRL.getCRLNumber(x509CRL);
            int n2 = bigInteger.compareTo(this.getNumber());
            if (n2 < 0) {
                return 1005;
            }
            if (n2 > 0) {
                return 1006;
            }
            if (n2 != 0) return n;
            Object[] objectArray = CompositeCRL.getIssuingDistributionPoint(x509CRL);
            if (!CertPathUtil.isEqualReasons(this.getReasons(), (boolean[])objectArray[3])) return 1008;
            if (!this.isTypeEE() || !((Boolean)objectArray[1]).booleanValue()) {
                if (!this.isTypeCA()) return 1007;
                if ((Boolean)objectArray[2] == false) return 1007;
            }
            this.refresh(x509CRL);
            Date date2 = this.getNextUpdate();
            n2 = date2.compareTo(date);
            if (n2 > 0) {
                return 1001;
            }
            if (n2 > 0) return n;
            return 1002;
        }
        if (x509CRL != null) return n;
        return 1009;
    }

    void refresh(X509CRL x509CRL) throws CertPathValidatorException {
        Object[] objectArray = new Object[this.crlInfo.length];
        objectArray[this.DELTA_CRL_INDEX] = x509CRL;
        objectArray[this.BASE_CRL_INDEX] = this.crlInfo[this.BASE_CRL_INDEX];
        objectArray[this.NUMBER_INDEX] = CompositeCRL.getCRLNumber(x509CRL);
        objectArray[this.REASONS_INDEX] = this.crlInfo[this.REASONS_INDEX];
        this.crlInfo = objectArray;
    }

    boolean[] getReasons() {
        boolean[] blArray = (boolean[])this.crlInfo[this.REASONS_INDEX];
        boolean[] blArray2 = new boolean[blArray.length];
        System.arraycopy(blArray, 0, blArray2, 0, blArray2.length);
        return blArray2;
    }

    Date getNextUpdate() {
        Object[] objectArray = this.crlInfo;
        if (objectArray[this.DELTA_CRL_INDEX] != null) {
            return ((X509CRL)objectArray[this.DELTA_CRL_INDEX]).getNextUpdate();
        }
        return ((X509CRL)objectArray[this.BASE_CRL_INDEX]).getNextUpdate();
    }

    Date getThisUpdate() {
        Object[] objectArray = this.crlInfo;
        if (objectArray[this.DELTA_CRL_INDEX] != null) {
            return ((X509CRL)objectArray[this.DELTA_CRL_INDEX]).getThisUpdate();
        }
        return ((X509CRL)objectArray[this.BASE_CRL_INDEX]).getThisUpdate();
    }

    BigInteger getNumber() {
        return (BigInteger)this.crlInfo[this.NUMBER_INDEX];
    }

    Principal getIssuerName() {
        Object[] objectArray = this.crlInfo;
        return ((X509CRL)objectArray[this.BASE_CRL_INDEX]).getIssuerDN();
    }

    X509Certificate getIssuerCertificate() {
        return this.issuerCertificate;
    }

    boolean isTypeCA() {
        return !((Boolean)this.crlInfo[this.ONLY_CONTAINS_EE_INDEX]).equals(Boolean.TRUE);
    }

    boolean isTypeEE() {
        return !((Boolean)this.crlInfo[this.ONLY_CONTAINS_CA_INDEX]).equals(Boolean.TRUE);
    }

    void setIssuerCertificate(X509Certificate x509Certificate) {
        this.issuerCertificate = x509Certificate;
    }

    public String toString() {
        return super.toString();
    }

    static BigInteger getCRLNumber(X509CRL x509CRL) throws CertPathValidatorException {
        BigInteger bigInteger = null;
        byte[] byArray = x509CRL.getExtensionValue(OIDMap.getOID((String)"x509.info.extensions.CRLNumber").toString());
        if (byArray != null) {
            try {
                Extension extension = new Extension(PKIXExtensions.CRLNumber_Id, false, byArray);
                CRLNumberExtension cRLNumberExtension = new CRLNumberExtension(new Boolean(extension.isCritical()), (Object)extension.getExtensionValue());
                bigInteger = (BigInteger)cRLNumberExtension.get("value");
            }
            catch (IOException iOException) {
                throw new CertPathValidatorException("An internal error has occurred when processing the CRLNumber extension.", iOException);
            }
        }
        return bigInteger;
    }

    static BigInteger getBaseNumber(X509CRL x509CRL) throws CertPathValidatorException {
        BigInteger bigInteger = null;
        byte[] byArray = x509CRL.getExtensionValue(PKIXExtensions.DeltaCRLIndicator_Id.toString());
        if (byArray != null) {
            try {
                Extension extension = new Extension(PKIXExtensions.DeltaCRLIndicator_Id, false, byArray);
                DeltaCRLIndicatorExtension deltaCRLIndicatorExtension = new DeltaCRLIndicatorExtension(new Boolean(extension.isCritical()), (Object)extension.getExtensionValue());
                bigInteger = (BigInteger)deltaCRLIndicatorExtension.get("value");
            }
            catch (IOException iOException) {
                throw new CertPathValidatorException("An internal error has occurred when processing the DeltaCRLIndicator extension.", iOException);
            }
        }
        return bigInteger;
    }

    static boolean isDeltaCRL(X509CRL x509CRL) throws CertPathValidatorException {
        boolean bl = false;
        BigInteger bigInteger = CompositeCRL.getBaseNumber(x509CRL);
        if (bigInteger != null && bigInteger.compareTo(BI_NEG_ONE) != 0) {
            bl = true;
        }
        return bl;
    }

    static Object[] getIssuingDistributionPoint(X509CRL x509CRL) throws CertPathValidatorException {
        Object[] objectArray = new Object[5];
        boolean[] blArray = new boolean[9];
        Arrays.fill(blArray, true);
        blArray[7] = false;
        objectArray[1] = new Boolean(false);
        objectArray[2] = new Boolean(false);
        objectArray[3] = blArray;
        objectArray[4] = new Boolean(false);
        byte[] byArray = x509CRL.getExtensionValue(OIDMap.getOID((String)"x509.info.extensions.IssuingDistributionPoint").toString());
        if (byArray != null) {
            try {
                BitArray bitArray;
                ReasonFlags reasonFlags;
                Extension extension = new Extension(PKIXExtensions.IssuingDistributionPoint_Id, true, byArray);
                IssuingDistributionPointExtension issuingDistributionPointExtension = new IssuingDistributionPointExtension(new Boolean(extension.isCritical()), (Object)extension.getExtensionValue());
                Boolean bl = (Boolean)issuingDistributionPointExtension.get("ca_certs_only");
                if (bl != null && bl.equals(Boolean.TRUE)) {
                    objectArray[2] = Boolean.TRUE;
                }
                if ((bl = (Boolean)issuingDistributionPointExtension.get("user_certs_only")) != null && bl.equals(Boolean.TRUE)) {
                    objectArray[1] = Boolean.TRUE;
                }
                if ((reasonFlags = (ReasonFlags)issuingDistributionPointExtension.get("limited_reasons")) != null && (bitArray = reasonFlags.getReasonFlags()) != null) {
                    int n = Math.min(bitArray.length(), blArray.length);
                    int n2 = 0;
                    while (n2 < n) {
                        blArray[n2] = bitArray.get(n2);
                        ++n2;
                    }
                }
                objectArray[4] = (Boolean)issuingDistributionPointExtension.get("indirect_crl");
            }
            catch (IOException iOException) {
                throw new CertPathValidatorException("An internal error has occurred when processing the IssuingDistributionPoint extension.", iOException);
            }
        }
        return objectArray;
    }

    static int getCRLEntryReasonCode(X509CRLEntry x509CRLEntry) throws CertPathValidatorException {
        int n = 1000;
        ObjectIdentifier objectIdentifier = OIDMap.getOID((String)"x509.info.extensions.CRLReasonCode");
        byte[] byArray = x509CRLEntry.getExtensionValue(objectIdentifier.toString());
        if (byArray != null) {
            try {
                Extension extension = new Extension(objectIdentifier, false, byArray);
                CRLReasonCodeExtension cRLReasonCodeExtension = new CRLReasonCodeExtension(new Boolean(extension.isCritical()), (Object)extension.getExtensionValue());
                Integer n2 = (Integer)cRLReasonCodeExtension.get("reason");
                int n3 = n2;
                switch (n3) {
                    case 1: {
                        n = 1001;
                        break;
                    }
                    case 2: {
                        n = 1002;
                        break;
                    }
                    case 3: {
                        n = 1003;
                        break;
                    }
                    case 4: {
                        n = 1004;
                        break;
                    }
                    case 5: {
                        n = 1005;
                        break;
                    }
                    case 6: {
                        n = 1006;
                        break;
                    }
                    case 8: {
                        n = 2000;
                        break;
                    }
                    default: {
                        n = 1000;
                        break;
                    }
                }
            }
            catch (IOException iOException) {
                throw new CertPathValidatorException("An internal error has occurred when processing the CRLReasonsCode extension.", iOException);
            }
        }
        return n;
    }
}

