/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.security.cert.BasicChecker;
import com.ibm.security.cert.CRSChecker;
import com.ibm.security.cert.NameChecker;
import com.ibm.security.cert.PolicyChecker;
import com.ibm.security.cert.PolicyTree;
import java.io.Serializable;
import java.security.InvalidAlgorithmParameterException;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertPathValidatorSpi;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.PolicyNode;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class PKIXCertPathValidatorImpl
extends CertPathValidatorSpi {
    public CertPathValidatorResult engineValidate(CertPath certPath, CertPathParameters certPathParameters) throws CertPathValidatorException, InvalidAlgorithmParameterException {
        Object object;
        PKIXCertPathValidatorResult pKIXCertPathValidatorResult = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        HashSet<String> hashSet = null;
        boolean bl = true;
        List<? extends Certificate> list = certPath.getCertificates();
        int n4 = list.size();
        PKIXParameters pKIXParameters = null;
        CertSelector certSelector = null;
        Set<TrustAnchor> set = null;
        Date date = null;
        List<CertStore> list2 = null;
        boolean bl2 = true;
        List<PKIXCertPathChecker> list3 = null;
        String string = null;
        if (!certPath.getType().equals("X.509") && !certPath.getType().equals("X509")) {
            throw new InvalidAlgorithmParameterException("inappropriate certification path type specified, must be X.509 or X509");
        }
        if (certPathParameters instanceof PKIXParameters) {
            pKIXParameters = (PKIXParameters)certPathParameters;
            hashSet = new HashSet<String>(pKIXParameters.getInitialPolicies());
            if (hashSet.isEmpty()) {
                hashSet.add("2.5.29.32.0");
            }
            set = pKIXParameters.getTrustAnchors();
            certSelector = pKIXParameters.getTargetCertConstraints();
            bl2 = pKIXParameters.isRevocationEnabled();
            n = pKIXParameters.isPolicyMappingInhibited() ? 0 : n4 + 1;
            n2 = pKIXParameters.isAnyPolicyInhibited() ? 0 : n4 + 1;
            n3 = pKIXParameters.isExplicitPolicyRequired() ? 0 : n4 + 1;
            date = pKIXParameters.getDate();
            if (date == null) {
                date = new Date();
            }
        } else {
            throw new InvalidAlgorithmParameterException("Parameter type unsupported - " + certPathParameters.getClass().getName());
        }
        list2 = pKIXParameters.getCertStores();
        list3 = pKIXParameters.getCertPathCheckers();
        bl = pKIXParameters.getPolicyQualifiersRejected();
        string = pKIXParameters.getSigProvider();
        if (certSelector != null && list.size() > 0 && !certSelector.match((Certificate)(object = (X509Certificate)list.get(0)))) {
            throw new CertPathValidatorException("Certain certificate select criteria don't match", null, certPath, n4);
        }
        object = new BasicChecker(certPath, set, date, string);
        CRSChecker cRSChecker = null;
        if (bl2) {
            cRSChecker = new CRSChecker(certPath, list2, true, false, set, date, true, string);
        }
        PolicyChecker policyChecker = new PolicyChecker(certPath, pKIXParameters.getPolicyQualifiersRejected(), hashSet, n3, n, n2);
        NameChecker nameChecker = new NameChecker(certPath, string);
        ((BasicChecker)object).init(false);
        if (bl2) {
            cRSChecker.init(false);
        }
        policyChecker.init(false);
        nameChecker.init(false);
        PKIXCertPathValidatorImpl.initCheckers(list3);
        if (n4 == 0) {
            Iterator<TrustAnchor> iterator = set.iterator();
            TrustAnchor trustAnchor = iterator.next();
            PublicKey publicKey = trustAnchor.getCAPublicKey();
            if (publicKey == null) {
                publicKey = trustAnchor.getTrustedCert().getPublicKey();
            }
            pKIXCertPathValidatorResult = new PKIXCertPathValidatorResult(trustAnchor, policyChecker.getPolicyTree().getRoot(), publicKey);
            return pKIXCertPathValidatorResult;
        }
        int n5 = n4 - 1;
        while (n5 >= 0) {
            Object object2;
            Serializable serializable;
            X509Certificate x509Certificate = (X509Certificate)list.get(n5);
            Set<String> set2 = x509Certificate.getCriticalExtensionOIDs();
            if (set2 == null) {
                set2 = new HashSet<String>();
            }
            ((BasicChecker)object).check((Certificate)x509Certificate, set2);
            if (bl2) {
                cRSChecker.check(x509Certificate, set2);
            }
            policyChecker.check((Certificate)x509Certificate, set2);
            nameChecker.check((Certificate)x509Certificate, set2);
            PKIXCertPathValidatorImpl.moreChecks(x509Certificate, list3, set2);
            if (!set2.isEmpty()) {
                serializable = new StringBuffer();
                object2 = set2.iterator();
                while (object2.hasNext()) {
                    ((StringBuffer)serializable).append((String)object2.next());
                }
                throw new CertPathValidatorException(" The following critical extensions were not processed: " + serializable, null, certPath, n5);
            }
            if (n5 == 0) {
                serializable = x509Certificate.getPublicKey();
                object2 = ((BasicChecker)object).getTrustAnchor();
                PolicyTree policyTree = policyChecker.getPolicyTree();
                PolicyNode policyNode = null;
                if (policyTree.isValid()) {
                    policyNode = policyTree.getRoot();
                }
                pKIXCertPathValidatorResult = new PKIXCertPathValidatorResult((TrustAnchor)object2, policyNode, (PublicKey)serializable);
            }
            --n5;
        }
        return pKIXCertPathValidatorResult;
    }

    static void initCheckers(Collection collection) throws CertPathValidatorException {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            PKIXCertPathChecker pKIXCertPathChecker = (PKIXCertPathChecker)iterator.next();
            pKIXCertPathChecker.init(false);
        }
    }

    static void moreChecks(X509Certificate x509Certificate, List list, Collection collection) throws CertPathValidatorException {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            PKIXCertPathChecker pKIXCertPathChecker = (PKIXCertPathChecker)iterator.next();
            pKIXCertPathChecker.check(x509Certificate, collection);
        }
    }
}

