/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.plugincfg.generator;

import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBinding;
import com.ibm.ejs.models.base.extensions.webappext.WebAppExtension;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.application.Application;
import com.ibm.etools.application.EjbModule;
import com.ibm.etools.application.Module;
import com.ibm.etools.application.WebModule;
import com.ibm.etools.archive.impl.ArchiveOptions;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.webapplication.WebApp;
import com.ibm.websphere.models.config.appcfg.ApplicationConfig;
import com.ibm.websphere.models.config.appcfg.DeployedObjectConfig;
import com.ibm.websphere.models.config.appcfg.WebModuleConfig;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.appdeployment.DeploymentTarget;
import com.ibm.websphere.models.config.appdeployment.DeploymentTargetMapping;
import com.ibm.websphere.models.config.appdeployment.ModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.WebModuleDeployment;
import com.ibm.websphere.models.config.applicationserver.ApplicationServer;
import com.ibm.websphere.models.config.applicationserver.webcontainer.SessionManager;
import com.ibm.websphere.models.config.applicationserver.webcontainer.WebContainer;
import com.ibm.websphere.models.config.pmirm.PMIRequestMetrics;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.topology.cluster.ClusterMember;
import com.ibm.websphere.models.config.topology.cluster.ServerCluster;
import com.ibm.websphere.plugincfg.exception.PluginConfigException;
import com.ibm.websphere.plugincfg.generator.PluginConfigGenerator;
import com.ibm.websphere.plugincfg.generator.PluginConfigHelperIntf;
import com.ibm.websphere.plugincfg.generator.VariableManager;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.component.ContainerImpl;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.RepositoryImpl;
import com.ibm.ws.webcontainer.util.EncodeCloneID;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;

public class ConfigurationParser
extends ContainerImpl {
    protected static TraceComponent tc = Tr.register(class$com$ibm$websphere$plugincfg$generator$ConfigurationParser == null ? (class$com$ibm$websphere$plugincfg$generator$ConfigurationParser = ConfigurationParser.class$("com.ibm.websphere.plugincfg.generator.ConfigurationParser")) : class$com$ibm$websphere$plugincfg$generator$ConfigurationParser);
    public static final String CELLSDIR = "cells";
    public static final String CLUSTERSDIR = "clusters";
    public static final String NODESDIR = "nodes";
    public static final String SERVERSDIR = "servers";
    public static final String CLUSTERFILE = "cluster.xml";
    public static final String SERVERINDEX = "serverindex.xml";
    public static final String VIRTUALHOST = "virtualhosts.xml";
    public static final String REQUEST_METRICS_FILE = "pmirm.xml";
    public static final String NOT_DEFINED = "notDefined";
    private static ResourceBundle nls;
    private List _vHosts = new ArrayList();
    private List _clusters = new ArrayList();
    private List _serverRemoveList = new ArrayList();
    private List _foundCells = new ArrayList();
    private String _appServerRoot;
    private String _appServerConfigRoot;
    String _cellName;
    private String _nodeNameList;
    private String _serverNameList;
    private String _clusterNameList;
    private int listSize = 0;
    private int nbrOfClusters = 0;
    boolean _singleServerConfig = false;
    boolean _dmgrFound = false;
    private HashMap _definedServers = new HashMap();
    private VariableManager _vMgr = new VariableManager();
    protected PMIRequestMetrics pmirm = null;
    private Class pluginCfgHelperClass = null;
    private Class lotusCfgHelperClass = null;
    private PluginConfigHelperIntf lotusCfgHelper = null;
    HashMap _siToHostName = new HashMap();
    static /* synthetic */ Class class$com$ibm$websphere$plugincfg$generator$ConfigurationParser;
    static /* synthetic */ Class class$com$ibm$etools$commonarchive$EARFile;
    static /* synthetic */ Class class$com$ibm$etools$application$EjbModule;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$com$ibm$etools$application$Module;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;

    public ConfigurationParser(String string, String string2, String string3, String string4, String string5, String string6) throws PluginConfigException {
        this._appServerRoot = string;
        this._appServerConfigRoot = string2 != null ? string2 : string + "config";
        this._cellName = string3;
        this._clusterNameList = string4;
        this._nodeNameList = string5;
        this._serverNameList = string6;
        this.checkConfigurationForDMGR(string3);
        this.parseConfiguration();
        this.setClusterServerData();
        this.setClusterDeployedModuleInfo();
    }

    public String getAppServerRoot() {
        return this._appServerRoot;
    }

    public String getAppServerConfigRoot() {
        return this._appServerConfigRoot;
    }

    public boolean isSingleServerConfig() {
        return this._singleServerConfig;
    }

    public List getServerClusters() {
        return this._clusters;
    }

    public List getVHosts() {
        return this._vHosts;
    }

    private void parseConfiguration() throws PluginConfigException {
        String string;
        int n;
        StringTokenizer stringTokenizer;
        if (this._clusterNameList != null && this._cellName != null) {
            if (this._clusterNameList.equalsIgnoreCase("ALL")) {
                this.readCellConfiguration(this._cellName, true);
            } else {
                stringTokenizer = new StringTokenizer(this._clusterNameList, ",");
                if (PluginConfigGenerator._debugEnabled) {
                    System.out.println("Number of clusters in the list - " + stringTokenizer.countTokens());
                }
                n = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                    System.out.println("\nPLGC0039I: Generating server plugin configuration file using the cluster definition " + string + ".");
                    this.readClusterConfiguration(string, this._cellName);
                    ++n;
                }
            }
        }
        if (this._serverNameList != null) {
            StringTokenizer stringTokenizer2;
            stringTokenizer = new StringTokenizer(this._serverNameList, ",");
            if (stringTokenizer.countTokens() == 1) {
                this._singleServerConfig = true;
            }
            if (PluginConfigGenerator._debugEnabled) {
                System.out.println("Number of servers in the list - " + stringTokenizer.countTokens());
                System.out.println("Single server definition      - " + this._singleServerConfig);
            }
            if ((stringTokenizer2 = new StringTokenizer(this._nodeNameList, ",")).countTokens() > 1) {
                System.out.println("\nPLGC0040I: More than one node is specified in the list. Only the first node is selected.");
            }
            string = stringTokenizer2.nextToken();
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                System.out.println("\n" + PluginConfigGenerator.nls.getString("single.server.gen") + " " + this._cellName + ", " + PluginConfigGenerator.nls.getString("string.node") + " " + string + ", " + PluginConfigGenerator.nls.getString("string.server") + " " + string2 + ".");
                this.addServer(string2, string, this._cellName, null);
                ++n2;
            }
            this._foundCells.add(this._cellName);
        } else if (this._nodeNameList != null) {
            stringTokenizer = new StringTokenizer(this._nodeNameList, ",");
            if (PluginConfigGenerator._debugEnabled) {
                System.out.println("Number of nodes in the list : " + stringTokenizer.countTokens());
            }
            n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                System.out.println("\n" + PluginConfigGenerator.nls.getString("single.node.gen") + " " + this._cellName + ", " + PluginConfigGenerator.nls.getString("string.node") + " " + string + ".");
                this.readNodeConfiguration(string, this._cellName);
                ++n;
            }
            this._foundCells.add(this._cellName);
        } else if (this._cellName != null) {
            if (this._clusterNameList == null) {
                this.readCellConfiguration(this._cellName, false);
            }
            this._foundCells.add(this._cellName);
        } else {
            System.out.println("\n" + PluginConfigGenerator.nls.getString("no.cell.name"));
        }
        if (this._cellName != null) {
            this.readLotusConfiguration();
        }
        if (this._cellName != null) {
            this.pmirm = this.readPMIRMConfiguration(this._cellName);
        }
        this.setVHosts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PMIRequestMetrics readPMIRMConfiguration(String string) throws PluginConfigException {
        PMIRequestMetrics pMIRequestMetrics = null;
        try {
            RepositoryImpl repositoryImpl = new RepositoryImpl(this._appServerConfigRoot, this._cellName, null, null);
            Resource resource = repositoryImpl.getConfigRoot().getResource(0, REQUEST_METRICS_FILE);
            EList eList = resource.getContents();
            if (eList.size() > 0) {
                pMIRequestMetrics = (PMIRequestMetrics)eList.get(0);
            }
            if (pMIRequestMetrics == null) {
                System.out.println("\n" + PluginConfigGenerator.nls.getString("no.def.for.pmirm"));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            FFDCFilter.processException((Throwable)fileNotFoundException, "com.ibm.websphere.plugincfg.generator.ConfigurationParser.getPMIRMConfig", "235", this);
            System.out.println("\n" + PluginConfigGenerator.nls.getString("no.def.for.pmirm"));
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.websphere.plugincfg.generator.ConfigurationParser.getPMIRMConfig", "239", this);
            System.out.println("\n" + PluginConfigGenerator.nls.getString("no.def.for.pmirm"));
            if (PluginConfigGenerator._debugEnabled) {
                throwable.printStackTrace();
            }
            System.out.println("\n" + PluginConfigGenerator.nls.getString("rerun.with.debug"));
        }
        finally {
            return pMIRequestMetrics;
        }
    }

    private void addServer(String string, String string2, String string3, String string4) throws PluginConfigException {
        ServerClusterData serverClusterData = new ServerClusterData(string + "_" + string2 + "_Cluster");
        ++this.nbrOfClusters;
        ServerData serverData = new ServerData(string);
        serverData.nodeName = string2;
        serverData.cellName = string3;
        if (string4 == null) {
            this.setServerType(serverData);
        } else {
            serverData.serverType = string4;
        }
        this._definedServers.put(string + string2, string + string2);
        serverData.wlmWeight = new Integer(-1);
        serverClusterData.clusterServers = new ArrayList();
        serverClusterData.clusterServers.add(serverData);
        this._clusters.add(serverClusterData);
    }

    private void readNodeConfiguration(String string, String string2) throws PluginConfigException {
        Resource resource = null;
        RepositoryImpl repositoryImpl = null;
        try {
            repositoryImpl = new RepositoryImpl(this._appServerConfigRoot, string2, string, null);
            resource = repositoryImpl.getConfigRoot().getResource(3, SERVERINDEX);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.websphere.plugincfg.generator.ConfigurationParser.readNodeConfiguration", "709", this);
            throw new PluginConfigException(PluginConfigGenerator.nls.getString("no.server.index") + " " + string + ".", throwable);
        }
        ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
        EList eList = serverIndex.getServerEntries();
        for (int i = 0; i < eList.size(); ++i) {
            String string3;
            ServerEntry serverEntry = (ServerEntry)eList.get(i);
            String string4 = serverEntry.getServerType();
            if (!string4.equals("APPLICATION_SERVER") && !string4.equals("DEPLOYMENT_MANAGER") || this._definedServers.get((string3 = serverEntry.getServerName()) + string) != null) continue;
            this.addServer(string3, string, string2, string4);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readCellConfiguration(String string, boolean bl) throws PluginConfigException {
        File[] fileArray;
        boolean bl2 = false;
        String string2 = this._appServerConfigRoot + File.separator + CELLSDIR + File.separator + string + File.separator + CLUSTERSDIR;
        File file = new File(string2);
        if (file.exists() && (fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        })) != null && fileArray.length > 0) {
            for (int i = 0; i < fileArray.length; ++i) {
                this.readClusterConfiguration(fileArray[i].getName(), string);
            }
            System.out.println("\n" + PluginConfigGenerator.nls.getString("gen.for.clusters") + " " + string + ".");
            bl2 = true;
        }
        if (bl) return;
        String string3 = this._appServerConfigRoot + File.separator + CELLSDIR + File.separator + string + File.separator + NODESDIR;
        File file2 = new File(string3);
        File[] fileArray2 = file2.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        if (fileArray2 == null) throw new PluginConfigException(PluginConfigGenerator.nls.getString("no.server.defs.for.cell") + " " + string + ".");
        if (fileArray2.length <= 0) throw new PluginConfigException(PluginConfigGenerator.nls.getString("no.clusters.or.nodes"));
        for (int i = 0; i < fileArray2.length; ++i) {
            this.readNodeConfiguration(fileArray2[i].getName(), string);
        }
        if (bl2) return;
        System.out.println("\n" + PluginConfigGenerator.nls.getString("gen.for.all.cell.servers") + " " + string + ".");
    }

    private void readClusterConfiguration(String string, String string2) throws PluginConfigException {
        try {
            ServerClusterData serverClusterData;
            RepositoryImpl repositoryImpl = new RepositoryImpl(this._appServerConfigRoot, this._cellName, null, null);
            Resource resource = repositoryImpl.getConfigRoot().getResource(0, CLUSTERSDIR + File.separator + string + File.separator + CLUSTERFILE);
            EList eList = resource.getContents();
            if (eList.size() > 0) {
                ++this.nbrOfClusters;
                ServerCluster serverCluster = (ServerCluster)eList.get(0);
                serverClusterData = new ServerClusterData(serverCluster.getName());
                serverClusterData.backupClusters = serverCluster.getBackupClusters();
                EList eList2 = serverCluster.getMembers();
                this.listSize = eList2.size();
                serverClusterData.clusterServers = new ArrayList();
                ServerData serverData = null;
                String string3 = null;
                for (int i = 0; i < this.listSize; ++i) {
                    ClusterMember clusterMember = (ClusterMember)eList2.get(i);
                    if (clusterMember.getMemberName() == null) {
                        throw new PluginConfigException(PluginConfigGenerator.nls.getString("server.name.not.set") + " " + serverCluster.getName() + ".");
                    }
                    serverData = new ServerData(clusterMember.getMemberName());
                    serverData.wlmWeight = new Integer(clusterMember.getWeight());
                    serverData.serverID = clusterMember.getUniqueId() != null ? EncodeCloneID.encodeString(clusterMember.getUniqueId()) : "";
                    serverData.cellName = string2;
                    serverData.nodeName = clusterMember.getNodeName();
                    if (string3 == null) {
                        this.setServerType(serverData);
                        string3 = serverData.serverType;
                    } else {
                        serverData.serverType = string3;
                    }
                    serverClusterData.clusterServers.add(serverData);
                    this._definedServers.put(serverData.serverName + serverData.nodeName, serverData.serverName + serverData.nodeName);
                }
            } else {
                throw new PluginConfigException(PluginConfigGenerator.nls.getString("error.parsing.cluster") + " " + string + " " + PluginConfigGenerator.nls.getString("in.cell.string") + " " + string2 + ".");
            }
            this._clusters.add(serverClusterData);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.websphere.plugincfg.generator.ConfigurationParser.readClusterConfiguration", "380", this);
            System.out.println("\n" + PluginConfigGenerator.nls.getString("exception.parsing.cluster") + " " + string + " " + PluginConfigGenerator.nls.getString("in.cell.string") + " " + string2 + ".");
            if (PluginConfigGenerator._debugEnabled) {
                throwable.printStackTrace();
            }
            System.out.println("\n" + PluginConfigGenerator.nls.getString("rerun.with.debug"));
        }
    }

    private void setClusterServerData() throws PluginConfigException {
        for (int i = 0; i < this.nbrOfClusters; ++i) {
            ServerClusterData serverClusterData = (ServerClusterData)this._clusters.get(i);
            int n = serverClusterData.clusterServers.size();
            for (int j = 0; j < n; ++j) {
                ServerData serverData = (ServerData)serverClusterData.clusterServers.get(j);
                Server server = this.getServerConfig(serverData);
                if (server == null) {
                    if (this._singleServerConfig) {
                        throw new PluginConfigException(PluginConfigGenerator.nls.getString("no.def.for.server") + " " + serverData.serverName + ".  " + PluginConfigGenerator.nls.getString("no.file.generated"));
                    }
                    this.removeClusterServer(serverClusterData, serverData.serverName, serverData.nodeName);
                    if (--n == 0) break;
                    --j;
                    continue;
                }
                this.setServerData(server, serverData);
                serverClusterData.fileServingEnabled = serverData.fileServingEnabled;
                serverClusterData.serveServletsByClassnameEnabled = serverData.serveServletsByClassnameEnabled;
            }
            if (n >= 1) continue;
            this._clusters.remove(i);
            System.out.println("\n" + PluginConfigGenerator.nls.getString("no.valid.servers.for.cluster") + " " + serverClusterData.clusterName + ".\n  " + PluginConfigGenerator.nls.getString("ignore.string"));
            --this.nbrOfClusters;
            if (this.nbrOfClusters < 1) {
                throw new PluginConfigException(PluginConfigGenerator.nls.getString("no.server.for.any.cluster"));
            }
            --i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Server getServerConfig(ServerData serverData) throws PluginConfigException {
        RepositoryImpl repositoryImpl = new RepositoryImpl(this._appServerConfigRoot, serverData.cellName, serverData.nodeName, serverData.serverName);
        Server server = null;
        try {
            Resource resource = repositoryImpl.getConfigRoot().getResource(4, "server.xml");
            EList eList = resource.getContents();
            if (eList.size() > 0) {
                server = (Server)eList.get(0);
            }
            if (server == null) {
                System.out.println("\n" + PluginConfigGenerator.nls.getString("no.def.for.server") + " " + serverData.serverName + ".  " + PluginConfigGenerator.nls.getString("server.ignored"));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            FFDCFilter.processException((Throwable)fileNotFoundException, "com.ibm.websphere.plugincfg.generator.ConfigurationParser.getServerConfig", "551", this);
            System.out.println("\n" + PluginConfigGenerator.nls.getString("no.def.for.server") + " " + serverData.serverName + ".  " + PluginConfigGenerator.nls.getString("server.ignored"));
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.websphere.plugincfg.generator.ConfigurationParser.getServerConfig", "556", this);
            System.out.println("\n" + PluginConfigGenerator.nls.getString("exception.reading.server") + " " + serverData.serverName + ".  " + PluginConfigGenerator.nls.getString("server.ignored"));
            if (PluginConfigGenerator._debugEnabled) {
                throwable.printStackTrace();
            }
            System.out.println("\n" + PluginConfigGenerator.nls.getString("rerun.with.debug"));
        }
        finally {
            return server;
        }
    }

    private void setServerData(Server server, ServerData serverData) throws PluginConfigException {
        ApplicationServer applicationServer;
        Object object;
        Object object2;
        int n;
        EList eList;
        WebContainer webContainer = null;
        EClass eClass = server.eClass();
        try {
            eList = server.getComponents();
            this.listSize = eList.size();
            for (n = 0; n < this.listSize; ++n) {
                EObject eObject = (EObject)eList.get(n);
                object2 = eObject.eClass();
                object = object2.getName();
                if (!((String)object).equals("ApplicationServer")) continue;
                applicationServer = (ApplicationServer)eObject;
                serverData.appServerName = applicationServer.getName();
                EList eList2 = applicationServer.getComponents();
                int n2 = eList2.size();
                for (int i = 0; i < n2; ++i) {
                    if (!(eList2.get(i) instanceof WebContainer)) continue;
                    webContainer = (WebContainer)eList2.get(i);
                }
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.websphere.plugincfg.generator.ConfigurationParser.setServerData", "625", this);
            throw new PluginConfigException(PluginConfigGenerator.nls.getString("exception.reading.web.con") + " " + server.getName() + ".", throwable);
        }
        if (webContainer != null) {
            EList eList3;
            serverData.transports = webContainer.getTransports();
            eList = webContainer.getServices();
            n = eList.size();
            for (int i = 0; i < n; ++i) {
                object2 = eList.get(i);
                if (!(object2 instanceof SessionManager)) continue;
                object = (SessionManager)object2;
                serverData.sessionManagerCookieName = object.getDefaultCookieSettings().getName();
                break;
            }
            if ((eList3 = webContainer.getProperties()) != null) {
                object2 = eList3.listIterator();
                object = new Properties();
                while (object2.hasNext()) {
                    applicationServer = (Property)object2.next();
                    if (applicationServer.getName().equals("HttpSessionCloneId")) {
                        serverData.serverID = applicationServer.getValue();
                        continue;
                    }
                    if (applicationServer.getName().equals("SessionRewriteIdentifier")) {
                        serverData.sessionURLIdentifier = applicationServer.getValue();
                        continue;
                    }
                    if (applicationServer.getName().equals("CloneSeparatorChange")) {
                        serverData.cloneSeparator = "true";
                        continue;
                    }
                    if (applicationServer.getName().equals("fileServingEnabled")) {
                        serverData.fileServingEnabled = applicationServer.getValue();
                        continue;
                    }
                    if (!applicationServer.getName().equals("serveServletsByClassnameEnabled")) continue;
                    serverData.serveServletsByClassnameEnabled = applicationServer.getValue();
                }
            }
        } else {
            throw new PluginConfigException(PluginConfigGenerator.nls.getString("error.reading.web.con") + " " + server.getName() + ".");
        }
        if (serverData.serverType.equals("WORKPLACE_SERVER")) {
            serverData.transports = this.getLotusTransportList(serverData.nodeName, serverData.serverName);
        }
    }

    private void setServerType(ServerData serverData) throws PluginConfigException {
        Resource resource = null;
        RepositoryImpl repositoryImpl = null;
        try {
            repositoryImpl = new RepositoryImpl(this._appServerConfigRoot, serverData.cellName, serverData.nodeName, null);
            resource = repositoryImpl.getConfigRoot().getResource(3, SERVERINDEX);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.websphere.plugincfg.generator.ConfigurationParser.setServerType", "709", this);
            throw new PluginConfigException(PluginConfigGenerator.nls.getString("no.server.index") + " " + serverData.nodeName + ".", throwable);
        }
        ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
        EList eList = serverIndex.getServerEntries();
        for (int i = 0; i < eList.size(); ++i) {
            ServerEntry serverEntry = (ServerEntry)eList.get(i);
            if (!serverEntry.getServerName().equals(serverData.serverName)) continue;
            serverData.serverType = serverEntry.getServerType();
            break;
        }
    }

    private void removeClusterServer(ServerClusterData serverClusterData, String string, String string2) {
        int n = serverClusterData.clusterServers.size();
        for (int i = 0; i < n; ++i) {
            ServerData serverData = (ServerData)serverClusterData.clusterServers.get(i);
            if (!serverData.serverName.equals(string) || !serverData.nodeName.equals(string2)) continue;
            serverClusterData.clusterServers.remove(i);
            return;
        }
    }

    private void setClusterDeployedModuleInfo() throws PluginConfigException {
        for (int i = 0; i < this.nbrOfClusters; ++i) {
            ServerClusterData serverClusterData = (ServerClusterData)this._clusters.get(i);
            int n = serverClusterData.clusterServers.size();
            if (n > 0) {
                ServerData serverData = (ServerData)serverClusterData.clusterServers.get(0);
                if (!serverData.serverType.equals("APPLICATION_SERVER") && !serverData.serverType.equals("DEPLOYMENT_MANAGER")) continue;
                serverClusterData.deployedModules = this.getDeployedModules(serverData, serverClusterData.clusterName);
                this._siToHostName.put(serverData.cellName + serverData.nodeName, serverData.hostName);
                if (n <= 1) continue;
                for (int j = 1; j < n; ++j) {
                    serverData = (ServerData)serverClusterData.clusterServers.get(j);
                    serverData.hostName = (String)this._siToHostName.get(serverData.cellName + serverData.nodeName);
                    if (serverData.hostName != null) continue;
                    this.setHostName(serverData);
                    this._siToHostName.put(serverData.cellName + serverData.nodeName, serverData.hostName);
                }
                continue;
            }
            System.out.println("\n" + PluginConfigGenerator.nls.getString("no.valid.servers.for.cluster") + " " + serverClusterData.clusterName + ".");
        }
    }

    private List getDeployedModules(ServerData serverData, String string) throws PluginConfigException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            Resource resource = null;
            RepositoryImpl repositoryImpl = null;
            ConfigRoot configRoot = null;
            try {
                repositoryImpl = new RepositoryImpl(this._appServerConfigRoot, serverData.cellName, serverData.nodeName, serverData.serverName);
                configRoot = repositoryImpl.getConfigRoot();
                resource = configRoot.getResource(3, SERVERINDEX);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.websphere.plugincfg.generator.ConfigurationParser.getDeployedModules", "709", this);
                throw new PluginConfigException(PluginConfigGenerator.nls.getString("no.server.index") + " " + serverData.serverName + ".", throwable);
            }
            this._vMgr.setVariableMap(configRoot, 2);
            ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
            String string2 = serverIndex.getHostName();
            serverData.hostName = string2.equals("") || string2.equals("*") || string2.equalsIgnoreCase("localhost") ? serverData.nodeName : string2;
            EList eList = serverIndex.getServerEntries();
            for (int i = 0; i < eList.size(); ++i) {
                ServerEntry serverEntry = (ServerEntry)eList.get(i);
                if (!serverEntry.getServerName().equals(serverData.serverName)) continue;
                EList eList2 = serverEntry.getDeployedApplications();
                EARFile eARFile = null;
                for (int j = 0; j < eList2.size(); ++j) {
                    configRoot.setValue(1, (String)eList2.get(j));
                    resource = configRoot.getResource(1, "deployment.xml");
                    Deployment deployment = (Deployment)resource.getContents().get(0);
                    ApplicationDeployment applicationDeployment = (ApplicationDeployment)deployment.getDeployedObject();
                    String string3 = null;
                    if (applicationDeployment.isUseMetadataFromBinaries() && !this._dmgrFound) {
                        string3 = applicationDeployment.getBinariesURL();
                        string3 = this._vMgr.substitute(string3);
                    } else {
                        string3 = configRoot.getAbsolutePath(1, "");
                    }
                    eARFile = this.getEAR(string3);
                    Application application = eARFile.getDeploymentDescriptor();
                    EList eList3 = applicationDeployment.getModules();
                    for (int k = 0; k < eList3.size(); ++k) {
                        Object object;
                        Object object2;
                        Object object3;
                        ModuleDeployment moduleDeployment = (ModuleDeployment)eList3.get(k);
                        Module module = moduleDeployment.getAltDD() != null ? application.getModuleHavingAltDD(moduleDeployment.getAltDD()) : application.getModule(moduleDeployment.getUri());
                        boolean bl = false;
                        EList eList4 = moduleDeployment.getTargetMappings();
                        Iterator iterator = eList4.iterator();
                        while (iterator.hasNext()) {
                            object3 = (DeploymentTargetMapping)iterator.next();
                            object2 = object3.getTarget().getName();
                            if (!((String)object2).equals(string) && !((String)object2).equals(serverData.serverName)) continue;
                            bl = true;
                        }
                        if (module == null || !bl) continue;
                        if (module.isWebModule()) {
                            object3 = applicationDeployment.getBinariesURL() + ":" + moduleDeployment.getUri();
                            object2 = this.getDeployedModule(arrayList, (String)object3);
                            boolean bl2 = false;
                            if (object2 == null) {
                                object2 = new DeployedModuleData();
                                bl2 = true;
                            }
                            ((DeployedModuleData)object2).moduleUri = object3;
                            object = this.getWebServicesUrlPatterns(eARFile, (List)eList3, module);
                            if (!object.isEmpty()) {
                                ((DeployedModuleData)object2).additionalPatterns = object;
                            }
                            ((DeployedModuleData)object2).deployedApplication = applicationDeployment;
                            ((DeployedModuleData)object2).deployedModule = moduleDeployment;
                            ((DeployedModuleData)object2).moduleConfig = (WebModule)module;
                            ((DeployedModuleData)object2).deploymentDescriptor = (WebApp)eARFile.getDeploymentDescriptor(module);
                            ((DeployedModuleData)object2).moduleBindings = (WebAppBinding)eARFile.getBindings(module);
                            ((DeployedModuleData)object2).moduleExtensions = (WebAppExtension)eARFile.getExtensions(module);
                            ((DeployedModuleData)object2).cookieName = this.getAppCookieName((WebModuleDeployment)moduleDeployment, serverEntry.getServerName());
                            if (((DeployedModuleData)object2).cookieName == null) {
                                ((DeployedModuleData)object2).cookieName = this.getAppCookieName((WebModuleDeployment)moduleDeployment, string);
                            }
                            if (((DeployedModuleData)object2).cookieName == null) {
                                ((DeployedModuleData)object2).cookieName = serverData.sessionManagerCookieName;
                            }
                            ((DeployedModuleData)object2).urlCookieName = serverData.sessionURLIdentifier;
                            if (!bl2) continue;
                            arrayList.add(object2);
                            continue;
                        }
                        if (!module.isEjbModule() || (object3 = this.getRouterModuleName(eARFile, (EjbModule)module)) == null || (object2 = this.getWebServicesUrlPatterns(eARFile, (List)eList3, module)).isEmpty()) continue;
                        String string4 = applicationDeployment.getBinariesURL() + ":" + (String)object3;
                        object = this.getDeployedModule(arrayList, string4);
                        boolean bl3 = false;
                        if (object == null) {
                            object = new DeployedModuleData();
                            bl3 = true;
                        }
                        ((DeployedModuleData)object).additionalPatterns = object2;
                        ((DeployedModuleData)object).moduleUri = string4;
                        if (!bl3) continue;
                        arrayList.add(object);
                    }
                    eARFile.close();
                }
                break;
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.websphere.plugincfg.generator.ConfigurationParser.getDeployedModules", "771", this);
            throw new PluginConfigException(PluginConfigGenerator.nls.getString("exception.reading.app") + " " + serverData.serverName + ".", throwable);
        }
        return arrayList;
    }

    private void setHostName(ServerData serverData) throws PluginConfigException {
        try {
            Resource resource = null;
            RepositoryImpl repositoryImpl = null;
            ConfigRoot configRoot = null;
            try {
                repositoryImpl = new RepositoryImpl(this._appServerConfigRoot, serverData.cellName, serverData.nodeName, serverData.serverName);
                configRoot = repositoryImpl.getConfigRoot();
                resource = configRoot.getResource(3, SERVERINDEX);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.websphere.plugincfg.generator.ConfigurationParser.getDeployedModules", "709", this);
                throw new PluginConfigException(PluginConfigGenerator.nls.getString("no.server.index") + " " + serverData.serverName + ".", throwable);
            }
            ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
            String string = serverIndex.getHostName();
            serverData.hostName = string.equals("") || string.equals("*") || string.equalsIgnoreCase("localhost") ? serverData.nodeName : string;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.websphere.plugincfg.generator.ConfigurationParser.setHostName", "771", this);
            throw new PluginConfigException(PluginConfigGenerator.nls.getString("exception.reading.app") + " " + serverData.serverName + ".", throwable);
        }
    }

    private String getAppCookieName(WebModuleDeployment webModuleDeployment, String string) {
        String string2 = null;
        EList eList = webModuleDeployment.getTargetMappings();
        WebModuleConfig webModuleConfig = (WebModuleConfig)this.getConfig((List)eList, string);
        if (webModuleConfig != null) {
            if (webModuleConfig.getSessionManagement() != null) {
                return webModuleConfig.getSessionManagement().getDefaultCookieSettings().getName();
            }
        } else {
            ApplicationDeployment applicationDeployment = webModuleDeployment.getApplicationDeployment();
            eList = applicationDeployment.getTargetMappings();
            ApplicationConfig applicationConfig = (ApplicationConfig)this.getConfig((List)eList, string);
            if (applicationConfig != null && applicationConfig.getSessionManagement() != null) {
                return applicationConfig.getSessionManagement().getDefaultCookieSettings().getName();
            }
        }
        return string2;
    }

    private EARFile getEAR(String string) throws PluginConfigException {
        EARFile eARFile = null;
        try {
            CommonarchiveFactory commonarchiveFactory = (CommonarchiveFactory)EPackage.Registry.INSTANCE.getEPackage("commonarchive.xmi").getEFactoryInstance();
            ArchiveOptions archiveOptions = new ArchiveOptions();
            archiveOptions.setIsReadOnly(true);
            archiveOptions.setUseJavaReflection(false);
            eARFile = commonarchiveFactory.openEARFile(archiveOptions, string);
            eARFile.getDeploymentDescriptor();
            eARFile.getBindings();
            eARFile.getExtensions();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.websphere.plugincfg.generator.ConfigurationParser.getEAR", "805", this);
            if (eARFile != null) {
                eARFile.close();
            }
            throw new PluginConfigException(PluginConfigGenerator.nls.getString("exception.reading.ear") + " " + string + ".", throwable);
        }
        return eARFile;
    }

    private void setVHosts() {
        for (int i = 0; i < this._foundCells.size(); ++i) {
            RepositoryImpl repositoryImpl = new RepositoryImpl(this._appServerConfigRoot, (String)this._foundCells.get(i), null, null);
            try {
                this.addVirtualHost(repositoryImpl.getConfigRoot().getResource(0, VIRTUALHOST));
                continue;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.websphere.plugincfg.generator.ConfigurationParser.setVHosts", "865", this);
            }
        }
    }

    private void addVirtualHost(Resource resource) {
        EList eList = resource.getContents();
        for (int i = 0; i < eList.size(); ++i) {
            this._vHosts.add(eList.get(i));
        }
    }

    private DeployedObjectConfig getConfig(List list, String string) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            DeploymentTargetMapping deploymentTargetMapping = (DeploymentTargetMapping)iterator.next();
            if (deploymentTargetMapping == null) continue;
            DeploymentTarget deploymentTarget = deploymentTargetMapping.getTarget();
            String string2 = null;
            if (deploymentTarget != null) {
                string2 = deploymentTarget.getName();
            }
            if (string2 == null || !string2.equalsIgnoreCase(string)) continue;
            return deploymentTargetMapping.getConfig();
        }
        return null;
    }

    private DeployedModuleData getDeployedModule(List list, String string) {
        DeployedModuleData deployedModuleData = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            DeployedModuleData deployedModuleData2 = (DeployedModuleData)iterator.next();
            if (!deployedModuleData2.moduleUri.equals(string)) continue;
            deployedModuleData = deployedModuleData2;
            break;
        }
        return deployedModuleData;
    }

    private Class getPluginCfgHelperClass() throws PluginConfigException {
        if (this.pluginCfgHelperClass == null) {
            try {
                this.pluginCfgHelperClass = Class.forName("com.ibm.ws.webservices.deploy.PluginCfgHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                FFDCFilter.processException((Throwable)classNotFoundException, "com.ibm.websphere.plugincfg.generator.ConfigurationParser.getPluginCfgHelperClass", "1337", this);
                throw new PluginConfigException(PluginConfigGenerator.nls.getString("error.loading.plugincfghelper"), classNotFoundException);
            }
        }
        return this.pluginCfgHelperClass;
    }

    private String getRouterModuleName(EARFile eARFile, EjbModule ejbModule) throws PluginConfigException {
        String string = null;
        try {
            Class clazz = this.getPluginCfgHelperClass();
            Class[] classArray = new Class[]{class$com$ibm$etools$commonarchive$EARFile == null ? (class$com$ibm$etools$commonarchive$EARFile = ConfigurationParser.class$("com.ibm.etools.commonarchive.EARFile")) : class$com$ibm$etools$commonarchive$EARFile, class$com$ibm$etools$application$EjbModule == null ? (class$com$ibm$etools$application$EjbModule = ConfigurationParser.class$("com.ibm.etools.application.EjbModule")) : class$com$ibm$etools$application$EjbModule};
            Method method = clazz.getMethod("getRouterModuleName", classArray);
            string = (String)method.invoke(null, eARFile, ejbModule);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.websphere.plugincfg.generator.ConfigurationParser.getRouterModuleName", "1341", this);
            throw new PluginConfigException(PluginConfigGenerator.nls.getString("error.reading.routermodule"), exception);
        }
        return string;
    }

    private List getWebServicesUrlPatterns(EARFile eARFile, List list, Module module) throws PluginConfigException {
        List list2 = new ArrayList();
        try {
            Class clazz = this.getPluginCfgHelperClass();
            Class[] classArray = new Class[]{class$com$ibm$etools$commonarchive$EARFile == null ? (class$com$ibm$etools$commonarchive$EARFile = ConfigurationParser.class$("com.ibm.etools.commonarchive.EARFile")) : class$com$ibm$etools$commonarchive$EARFile, class$java$util$List == null ? (class$java$util$List = ConfigurationParser.class$("java.util.List")) : class$java$util$List, class$com$ibm$etools$application$Module == null ? (class$com$ibm$etools$application$Module = ConfigurationParser.class$("com.ibm.etools.application.Module")) : class$com$ibm$etools$application$Module};
            Method method = clazz.getMethod("getWebServicesUrlPatterns", classArray);
            list2 = (List)method.invoke(null, eARFile, list, module);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.websphere.plugincfg.generator.ConfigurationParser.getWebServicesUrlPatterns", "1359", this);
            throw new PluginConfigException(PluginConfigGenerator.nls.getString("error.getting.urlpatterns"), exception);
        }
        return list2;
    }

    private void checkConfigurationForDMGR(String string) {
        if (string == null) {
            return;
        }
        String string2 = this._appServerConfigRoot + File.separator + CELLSDIR + File.separator + string + File.separator + NODESDIR;
        File file = new File(string2);
        File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        if (fileArray != null && fileArray.length > 0) {
            for (int i = 0; i < fileArray.length; ++i) {
                this.checkNodeConfigurationForDMGR(fileArray[i].getName(), string);
                if (this._dmgrFound) break;
            }
        }
    }

    private void checkNodeConfigurationForDMGR(String string, String string2) {
        int n;
        Resource resource = null;
        RepositoryImpl repositoryImpl = null;
        if (string == null) {
            return;
        }
        try {
            repositoryImpl = new RepositoryImpl(this._appServerConfigRoot, string2, string, null);
            resource = repositoryImpl.getConfigRoot().getResource(3, SERVERINDEX);
        }
        catch (Throwable throwable) {
            return;
        }
        ServerIndex serverIndex = (ServerIndex)resource.getContents().get(0);
        EList eList = serverIndex.getServerEntries();
        String string3 = "";
        try {
            string3 = InetAddress.getLocalHost().getHostName();
            n = string3.indexOf(".");
            if (n > 0) {
                string3 = string3.substring(0, n);
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        for (n = 0; n < eList.size(); ++n) {
            ServerEntry serverEntry = (ServerEntry)eList.get(n);
            String string4 = serverEntry.getServerType();
            if (!string4.equals("DEPLOYMENT_MANAGER")) continue;
            EList eList2 = serverEntry.getSpecialEndpoints();
            NamedEndPoint namedEndPoint = (NamedEndPoint)eList2.get(1);
            String string5 = namedEndPoint.getEndPoint().getHost();
            int n2 = string5.indexOf(".");
            if (n2 > 0) {
                string5 = string5.substring(0, n2);
            }
            if (!string5.equalsIgnoreCase(string3)) continue;
            this._dmgrFound = true;
            break;
        }
    }

    private Class getLotusCfgHelperClass() {
        if (this.lotusCfgHelperClass == null) {
            try {
                this.lotusCfgHelperClass = Class.forName("com.ibm.wkplc.generator.LotusCfgHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                FFDCFilter.processException((Throwable)classNotFoundException, "com.ibm.websphere.plugincfg.generator.ConfigurationParser.getLotusCfgHelperClass", "1725", this);
                System.out.println("\nPLGC0041W: Unable to load the helper class: com.ibm.wkplc.generator.LotusCfgHelper. No action required if lotus workplace servers are not defined.");
            }
        }
        return this.lotusCfgHelperClass;
    }

    private void getLotusCfgHelper() {
        if (this.lotusCfgHelper == null) {
            try {
                Class clazz = this.getLotusCfgHelperClass();
                Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ConfigurationParser.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = ConfigurationParser.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = ConfigurationParser.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Boolean == null ? (class$java$lang$Boolean = ConfigurationParser.class$("java.lang.Boolean")) : class$java$lang$Boolean};
                if (clazz != null) {
                    Method method = clazz.getMethod("getInstance", classArray);
                    this.lotusCfgHelper = (PluginConfigHelperIntf)method.invoke(null, this._appServerRoot, this._appServerConfigRoot, this._cellName, new Boolean(PluginConfigGenerator._debugEnabled));
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.websphere.plugincfg.generator.ConfigurationParser.getLotusCfgHelper", "1748", this);
                if (PluginConfigGenerator._debugEnabled) {
                    exception.printStackTrace();
                    System.out.println("Exception is " + exception.toString());
                }
                System.out.println("\nPLGC0045W: Exception caught while getting the lotus config helper class.");
            }
        }
    }

    private void readLotusConfiguration() {
        List list = null;
        try {
            this.getLotusCfgHelper();
            if (this.lotusCfgHelper != null) {
                list = this.lotusCfgHelper.getClusterList();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ServerClusterData serverClusterData = (ServerClusterData)iterator.next();
                    System.out.println("\nPLGC0039I: Generating server plugin configuration file using the cluster definition " + serverClusterData.clusterName + ".");
                    this._clusters.add(serverClusterData);
                    ++this.nbrOfClusters;
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.websphere.plugincfg.generator.ConfigurationParser.readLotusConfiguration", "1756", this);
            System.out.println("\nPLGC0042W: Exception caught while getting the lotus workplace clusters.");
        }
    }

    public List getLotusTransportList(String string, String string2) {
        List list = null;
        try {
            if (this.lotusCfgHelper != null) {
                list = this.lotusCfgHelper.getTransportList(string, string2);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.websphere.plugincfg.generator.ConfigurationParser.getLotusTransportList", "1780", this);
            System.out.println("\nPLGC0043W: Exception caught while getting the transports for lotus workplace servers.");
        }
        return list;
    }

    public List getLotusURIList() {
        List list = null;
        try {
            if (this.lotusCfgHelper != null) {
                list = this.lotusCfgHelper.getURIList();
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.websphere.plugincfg.generator.ConfigurationParser.getLotusURIList", "1805", this);
            System.out.println("\nPLGC0044W: Exception caught while getting the URI lists for lotus workplace clusters.");
        }
        return list;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class DeployedModuleData {
        public ApplicationDeployment deployedApplication;
        public ModuleDeployment deployedModule;
        public WebApp deploymentDescriptor;
        public WebModule moduleConfig;
        public WebAppExtension moduleExtensions;
        public WebAppBinding moduleBindings;
        public String cookieName;
        public String urlCookieName;
        public String moduleUri;
        public List additionalPatterns;
    }

    public static class TransportData {
        public String host;
        public int port;
        public boolean isSslEnabled;

        public TransportData(String string, int n, boolean bl) {
            this.host = string;
            this.port = n;
            this.isSslEnabled = bl;
        }
    }

    public static class ServerData {
        public String serverType;
        public String serverName;
        public String appServerName;
        public String serverID = "";
        public String cellName;
        public String nodeName;
        public String hostName;
        public List transports;
        public Integer wlmWeight;
        public Integer connectTimeout = new Integer(0);
        public Boolean waitForContinue = new Boolean(false);
        public Integer maxConnections = new Integer(-1);
        public Boolean extendedHandshake = new Boolean(false);
        public String sessionManagerCookieName = "JSESSIONID";
        public String sessionURLIdentifier = "jsessionid";
        public String cloneSeparator = null;
        public String fileServingEnabled = "notDefined";
        public String serveServletsByClassnameEnabled = "notDefined";

        public ServerData(String string) {
            this.serverName = string;
            this.nodeName = null;
        }
    }

    public static class ServerClusterData {
        public String clusterName;
        public String loadBalance = "Round Robin";
        public Integer retryInterval = new Integer(60);
        public Boolean removeSpecialHeaders = new Boolean(true);
        public Boolean cloneSeparatorChange = new Boolean(false);
        public Integer postSizeLimit = new Integer(-1);
        public List backupClusters;
        public List clusterServers;
        public List primaryServers;
        public List backupServers;
        public List deployedModules;
        public String fileServingEnabled = "notDefined";
        public String serveServletsByClassnameEnabled = "notDefined";

        public ServerClusterData(String string) {
            this.clusterName = string;
        }
    }
}

