/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.plugincfg.generator;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.plugincfg.exception.PluginConfigException;
import com.ibm.websphere.plugincfg.generator.ConfigurationParser;
import com.ibm.websphere.plugincfg.generator.PluginDocumentGenerator;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webcontainer.srt.SRTRequestUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PluginConfigGenerator {
    protected static TraceComponent tc = Tr.register(class$com$ibm$websphere$plugincfg$generator$PluginConfigGenerator == null ? (class$com$ibm$websphere$plugincfg$generator$PluginConfigGenerator = PluginConfigGenerator.class$("com.ibm.websphere.plugincfg.generator.PluginConfigGenerator")) : class$com$ibm$websphere$plugincfg$generator$PluginConfigGenerator);
    public static boolean _debugEnabled = false;
    public static ResourceBundle nls;
    public static final String styleSheet = " <xsl:stylesheet version=\"1.0\"                                   \n     xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">           \n   <xsl:output method=\"xml\"/>                                    \n   <xsl:param name=\"indent-increment\" select=\"'   '\" />        \n   <xsl:template match=\"*\">                                      \n      <xsl:param name=\"indent\" select=\"'&#xA;'\"/>              \n      <xsl:value-of select=\"$indent\"/>                           \n      <xsl:copy>                                                   \n        <xsl:copy-of select=\"@*\" />                              \n        <xsl:apply-templates>                                      \n          <xsl:with-param name=\"indent\"                          \n               select=\"concat($indent, $indent-increment)\"/>     \n        </xsl:apply-templates>                                     \n        <xsl:if test=\"*\">                                        \n          <xsl:value-of select=\"$indent\"/>                       \n        </xsl:if>                                                  \n      </xsl:copy>                                                  \n   </xsl:template>                                                 \n   <xsl:template match=\"comment()|processing-instruction()\">     \n      <xsl:copy />                                                 \n   </xsl:template>                                                 \n   <xsl:template match=\"text()[normalize-space(.)='']\"/>         \n </xsl:stylesheet>                                                 \n";
    static /* synthetic */ Class class$com$ibm$websphere$plugincfg$generator$PluginConfigGenerator;

    public PluginConfigGenerator() throws PluginConfigException {
        try {
            nls = ResourceBundle.getBundle("com.ibm.websphere.plugincfg.generator.PluginConfigGeneratorNLS");
        }
        catch (MissingResourceException missingResourceException) {
            FFDCFilter.processException(missingResourceException, "com.ibm.websphere.plugincfg.generator.PluginConfigGenerator.main", "201");
            throw new PluginConfigException("Unable to Find NLS Resources: " + missingResourceException.getMessage());
        }
    }

    public void generate(String string, String string2, String string3, String string4) throws PluginConfigException {
        String string5 = System.getProperty("server.root");
        if (string5 == null) {
            string5 = System.getProperty("user.install.root");
        }
        this.generate(string5, null, string, string2, string3, string4, null, null);
    }

    public void generate(String string, String string2, String string3, String string4, String string5, String string6) throws PluginConfigException {
        this.generate(string, string2, string3, null, string4, string5, string6, null, null);
    }

    public void generate(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) throws PluginConfigException {
        this.generate(string, string2, string3, null, string4, string5, string6, string7, string8);
    }

    public void generate(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) throws PluginConfigException {
        if (string != null) {
            if (!string.endsWith(File.separator)) {
                string = string + File.separator;
            }
        } else {
            throw new PluginConfigException(nls.getString("app.server.root.missing"));
        }
        ConfigurationParser configurationParser = new ConfigurationParser(string, string2, string3, string4, string5, string6);
        this.outputPluginConfigFile(configurationParser, this.determineOutputFileName(string, string7), string8, string9);
    }

    private void outputPluginConfigFile(ConfigurationParser configurationParser, String string, String string2, String string3) throws PluginConfigException {
        PluginDocumentGenerator pluginDocumentGenerator = new PluginDocumentGenerator(string2, string3);
        try {
            Document document = pluginDocumentGenerator.createPluginConfigDocument(configurationParser);
            if (document != null) {
                File file = new File(string);
                System.out.println("\n" + nls.getString("config.file.name") + " " + file);
                String string4 = SRTRequestUtils.getEncodingFromLocale(Locale.getDefault());
                document = this.replaceOldValues(document, string, string2);
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), string4));
                StreamSource streamSource = new StreamSource(new StringReader(styleSheet));
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer(streamSource);
                Properties properties = new Properties();
                properties.put("method", "xml");
                properties.put("omit-xml-declaration", "no");
                properties.put("version", "1.0");
                properties.put("encoding", string4);
                properties.put("indent", "true");
                transformer.setOutputProperties(properties);
                transformer.transform(new DOMSource(document), new StreamResult(bufferedWriter));
                bufferedWriter.flush();
                bufferedWriter.close();
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.websphere.plugincfg.generator.PluginConfigGenerator.generatePluginConfigFile", "170", this);
            throw new PluginConfigException(nls.getString("doc.output.exception"), throwable);
        }
    }

    private Document replaceOldValues(Document document, String string, String string2) {
        File file = new File(string);
        if (!file.exists()) {
            return document;
        }
        Document document2 = null;
        try {
            Object object;
            Node node;
            Element element;
            Node node2;
            int n;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            DocumentBuilder documentBuilder = null;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Object var9_13 = null;
            document2 = documentBuilder.parse(new InputSource(bufferedReader));
            bufferedReader.close();
            NodeList nodeList = document2.getElementsByTagName("Log");
            NodeList nodeList2 = document.getElementsByTagName("Log");
            if (nodeList.item(0) != null && nodeList2.item(0) != null) {
                object6 = (Element)nodeList.item(0);
                object5 = (Element)nodeList2.item(0);
                if (string2 == null && !object6.getAttribute("Name").equals("")) {
                    object5.setAttribute("Name", object6.getAttribute("Name"));
                }
                if (!object6.getAttribute("LogLevel").equals("")) {
                    object5.setAttribute("LogLevel", object6.getAttribute("LogLevel"));
                }
            }
            object6 = document2.getElementsByTagName("Config");
            object5 = document.getElementsByTagName("Config");
            Object object7 = null;
            Object object8 = null;
            if (object6.item(0) != null && object5.item(0) != null) {
                object7 = object4 = (Element)object6.item(0);
                object8 = object3 = (Element)object5.item(0);
                if (!object4.getAttribute("RefreshInterval").equals("")) {
                    object3.setAttribute("RefreshInterval", object4.getAttribute("RefreshInterval"));
                }
                if (!object4.getAttribute("IgnoreDNSFailures").equals("")) {
                    object3.setAttribute("IgnoreDNSFailures", object4.getAttribute("IgnoreDNSFailures"));
                }
                if (!object4.getAttribute("ResponseChunkSize").equals("")) {
                    object3.setAttribute("ResponseChunkSize", object4.getAttribute("ResponseChunkSize"));
                }
                if (!object4.getAttribute("ASDisableNagle").equals("")) {
                    object3.setAttribute("ASDisableNagle", object4.getAttribute("ASDisableNagle"));
                }
                if (!object4.getAttribute("IISDisableNagle").equals("")) {
                    object3.setAttribute("IISDisableNagle", object4.getAttribute("IISDisableNagle"));
                }
                if (!object4.getAttribute("AcceptAllContent").equals("")) {
                    object3.setAttribute("AcceptAllContent", object4.getAttribute("AcceptAllContent"));
                }
                if (!object4.getAttribute("VHostMatchingCompat").equals("")) {
                    object3.setAttribute("VHostMatchingCompat", object4.getAttribute("VHostMatchingCompat"));
                }
                if (!object4.getAttribute("AppServerPortPreference").equals("")) {
                    object3.setAttribute("AppServerPortPreference", object4.getAttribute("AppServerPortPreference"));
                }
                if (!object4.getAttribute("ChunkedResponse").equals("")) {
                    object3.setAttribute("ChunkedResponse", object4.getAttribute("ChunkedResponse"));
                }
                if (!object4.getAttribute("IISPluginPriority").equals("")) {
                    object3.setAttribute("IISPluginPriority", object4.getAttribute("IISPluginPriority"));
                }
            }
            object4 = document2.getElementsByTagName("Property");
            object3 = document.getElementsByTagName("Property");
            for (int i = 0; i < object4.getLength(); ++i) {
                if (object4.item(i) == null) continue;
                object2 = (Element)object4.item(i);
                if (object2.getParentNode() == object7) {
                    for (n = 0; n < object3.getLength(); ++n) {
                        Element element2 = (Element)object3.item(n);
                        if (!element2.getAttribute("Name").equals(object2.getAttribute("Name")) || object2.getAttribute("Value").equals("")) continue;
                        element2.setAttribute("Value", object2.getAttribute("Value"));
                    }
                    continue;
                }
                n = 0;
                for (int j = 0; j < object3.getLength(); ++j) {
                    String string3;
                    boolean bl;
                    Element element3 = (Element)object3.item(j);
                    node2 = element3.getParentNode();
                    Node node3 = object2.getParentNode();
                    if (node3 == null || node2 == null || node3.getNodeType() != 1 || node2.getNodeType() != 1) continue;
                    element = (Element)node3;
                    node = (Element)node2;
                    object = element.getAttribute("Hostname");
                    String string4 = element.getAttribute("Port");
                    String string5 = element.getAttribute("Protocol");
                    String string6 = node.getAttribute("Hostname");
                    String string7 = node.getAttribute("Port");
                    String string8 = node.getAttribute("Protocol");
                    boolean bl2 = bl = ((String)object).equals(string6) && string4.equals(string7) && string5.equals(string8);
                    if (!bl) continue;
                    String string9 = object2.getAttribute("name");
                    if (string9 == null || string9.equals("")) {
                        string9 = object2.getAttribute("Name");
                    }
                    if ((string3 = object2.getAttribute("value")) == null || string3.equals("")) {
                        string3 = object2.getAttribute("Value");
                    }
                    if (element3.getAttribute("Name").equals(string9)) {
                        if (string3 == null || string3.equals("")) continue;
                        boolean bl3 = true;
                        if (string2 != null && (string9.equals("keyring") || string9.equals("stashfile"))) {
                            bl3 = false;
                        }
                        if (!bl3) continue;
                        element3.setAttribute("Value", string3);
                        continue;
                    }
                    if (!string9.equalsIgnoreCase("certLabel") || n != 0) continue;
                    n = 1;
                    Element element4 = document.createElement("Property");
                    element4.setAttribute("Name", "certLabel");
                    element4.setAttribute("Value", string3);
                    node.appendChild(element4);
                }
            }
            NodeList nodeList3 = document2.getElementsByTagName("ServerCluster");
            object2 = document.getElementsByTagName("ServerCluster");
            for (n = 0; n < object2.getLength(); ++n) {
                if (object2.item(n) == null) continue;
                Element element5 = (Element)object2.item(n);
                for (int i = 0; i < nodeList3.getLength(); ++i) {
                    if (nodeList3.item(i) == null) continue;
                    node2 = (Element)nodeList3.item(i);
                    if (!element5.getAttribute("Name").equals(node2.getAttribute("Name"))) continue;
                    if (!node2.getAttribute("LoadBalance").equals("")) {
                        element5.setAttribute("LoadBalance", node2.getAttribute("LoadBalance"));
                    }
                    if (!node2.getAttribute("RetryInterval").equals("")) {
                        element5.setAttribute("RetryInterval", node2.getAttribute("RetryInterval"));
                    }
                    if (!node2.getAttribute("RemoveSpecialHeaders").equals("")) {
                        element5.setAttribute("RemoveSpecialHeaders", node2.getAttribute("RemoveSpecialHeaders"));
                    }
                    if (!node2.getAttribute("CloneSeparatorChange").equals("")) {
                        element5.setAttribute("CloneSeparatorChange", node2.getAttribute("CloneSeparatorChange"));
                    }
                    if (node2.getAttribute("PostSizeLimit").equals("")) continue;
                    element5.setAttribute("PostSizeLimit", node2.getAttribute("PostSizeLimit"));
                }
            }
            NodeList nodeList4 = document2.getElementsByTagName("Server");
            NodeList nodeList5 = document.getElementsByTagName("Server");
            for (int i = 0; i < nodeList5.getLength(); ++i) {
                if (nodeList5.item(i) == null) continue;
                node2 = (Element)nodeList5.item(i);
                for (int j = 0; j < nodeList4.getLength(); ++j) {
                    if (nodeList4.item(j) == null) continue;
                    element = (Element)nodeList4.item(j);
                    node = node2.getParentNode();
                    object = element.getParentNode();
                    if (!object.getNodeName().equals("ServerCluster") || !node.getNodeName().equals("ServerCluster") || !node2.getAttribute("CloneID").equals(element.getAttribute("CloneID"))) continue;
                    if (!element.getAttribute("WaitForContinue").equals("")) {
                        node2.setAttribute("WaitForContinue", element.getAttribute("WaitForContinue"));
                    }
                    if (!element.getAttribute("ConnectTimeout").equals("")) {
                        node2.setAttribute("ConnectTimeout", element.getAttribute("ConnectTimeout"));
                    }
                    if (!element.getAttribute("MaxConnections").equals("")) {
                        node2.setAttribute("MaxConnections", element.getAttribute("MaxConnections"));
                    }
                    if (element.getAttribute("ExtendedHandshake").equals("")) continue;
                    node2.setAttribute("ExtendedHandshake", element.getAttribute("ExtendedHandshake"));
                }
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Tr.warning(tc, "Problem in replacing Old Values " + parserConfigurationException.getMessage());
        }
        catch (SAXException sAXException) {
            Tr.warning(tc, "Problem in replacing Old Values " + sAXException.getMessage());
        }
        catch (IOException iOException) {
            Tr.warning(tc, "Problem in replacing Old Values" + iOException.getMessage());
        }
        return document;
    }

    private String determineOutputFileName(String string, String string2) {
        if (string2 == null) {
            string2 = "plugin-cfg.xml";
        }
        if (string2.indexOf(File.separator) >= 0) {
            File file;
            File file2 = new File(string2);
            String string3 = file2.getParent();
            if (string3 != null && !(file = new File(string3)).exists()) {
                file.mkdirs();
            }
            return string2;
        }
        String string4 = System.getProperty("user.install.root");
        if (string4 == null) {
            string4 = string;
        }
        if (!string4.endsWith(File.separator)) {
            string4 = string4 + File.separator;
        }
        String string5 = string4 + "config" + File.separator + "cells" + File.separator + string2;
        return string5;
    }

    public static void main(String[] stringArray) {
        try {
            PluginConfigGenerator pluginConfigGenerator = new PluginConfigGenerator();
            String string = stringArray[1];
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            String string8 = null;
            if (stringArray.length > 4) {
                String string9 = stringArray[4];
                string9.toLowerCase();
                if (string9.indexOf("?") != -1 || string9.indexOf("help") != -1) {
                    PluginConfigGenerator.usage();
                    System.exit(0);
                }
                if (stringArray.length % 2 != 0) {
                    PluginConfigGenerator.usage();
                    System.exit(-1);
                } else {
                    int n = 4;
                    while (n < stringArray.length) {
                        String string10;
                        if ((string10 = stringArray[n++]).equalsIgnoreCase("-config.root")) {
                            string = stringArray[n++];
                            continue;
                        }
                        if (string10.equalsIgnoreCase("-cell.name")) {
                            string2 = stringArray[n++];
                            continue;
                        }
                        if (string10.equalsIgnoreCase("-cluster.name")) {
                            string3 = stringArray[n++];
                            continue;
                        }
                        if (string10.equalsIgnoreCase("-node.name")) {
                            string4 = stringArray[n++];
                            continue;
                        }
                        if (string10.equalsIgnoreCase("-server.name")) {
                            string5 = stringArray[n++];
                            continue;
                        }
                        if (string10.equalsIgnoreCase("-output.file.name")) {
                            string6 = stringArray[n++];
                            continue;
                        }
                        if (string10.equalsIgnoreCase("-destination.root")) {
                            string7 = stringArray[n++];
                            continue;
                        }
                        if (string10.equalsIgnoreCase("-destination.operating.system")) {
                            if (stringArray[n++].equalsIgnoreCase("windows")) {
                                string8 = "windows";
                                continue;
                            }
                            string8 = "unix";
                            continue;
                        }
                        if (string10.equalsIgnoreCase("-debug")) {
                            if (stringArray[n++].equalsIgnoreCase("yes")) {
                                _debugEnabled = true;
                                continue;
                            }
                            _debugEnabled = false;
                            continue;
                        }
                        System.out.println("\n" + nls.getString("unknown.parameter") + " " + string10);
                        PluginConfigGenerator.usage();
                        System.exit(-1);
                    }
                }
            }
            if (string2 == null) {
                string2 = stringArray[2];
            }
            if (string5 != null && string4 == null) {
                string4 = stringArray[3];
            }
            PluginConfigGenerator.copyright();
            pluginConfigGenerator.generate(stringArray[0], string, string2, string3, string4, string5, string6, string7, string8);
        }
        catch (PluginConfigException pluginConfigException) {
            Throwable throwable;
            System.out.println("\n==========================================================================");
            System.out.println("\n" + nls.getString("exception.while.generating") + "\n\n" + pluginConfigException.getMessage());
            if (_debugEnabled) {
                System.out.println("\n");
                pluginConfigException.printStackTrace();
            }
            if ((throwable = pluginConfigException.getRootException()) != null) {
                System.out.println("\n==========================================================================");
                System.out.println("\n" + nls.getString("root.exception") + "\n " + throwable.getMessage());
                if (_debugEnabled) {
                    System.out.println("\n");
                    throwable.printStackTrace();
                }
            }
            System.out.println("\n==========================================================================");
            if (!_debugEnabled) {
                System.out.println("\n" + nls.getString("rerun.with.debug"));
            }
            System.exit(-1);
        }
        catch (Throwable throwable) {
            System.out.println("/n" + nls.getString("runtime.exception.while.generating") + "\n   " + throwable.getMessage() + "\n");
            throwable.printStackTrace();
            System.exit(-1);
        }
    }

    protected static void copyright() {
        System.out.println("\n" + nls.getString("product.header"));
        System.out.println(nls.getString("product.name"));
        System.out.println(nls.getString("ibm.copyright"));
    }

    protected static void usage() {
        System.out.println("\n" + nls.getString("usage.1") + "\n");
        System.out.println(nls.getString("usage.2"));
        System.out.println(nls.getString("usage.separator") + "\n");
        System.out.println("     " + nls.getString("usage.3"));
        System.out.println("         " + nls.getString("usage.4"));
        System.out.println("     " + nls.getString("usage.5"));
        System.out.println("         " + nls.getString("usage.6"));
        System.out.println("     " + nls.getString("usage.7"));
        System.out.println("         " + nls.getString("usage.8"));
        boolean bl = true;
        try {
            String string = nls.getString("usage.9.1");
        }
        catch (MissingResourceException missingResourceException) {
            bl = false;
        }
        if (bl) {
            System.out.println("     " + nls.getString("usage.9.1"));
            System.out.println("         " + nls.getString("usage.9.2"));
            System.out.println("     " + nls.getString("usage.9.3"));
            System.out.println("         " + nls.getString("usage.9.4"));
        } else {
            System.out.println("     -cluster.name cluster1,cluster2 | ALL");
            System.out.println("         (optional list of clusters)");
            System.out.println("     -server.name server1,server2");
            System.out.println("         (optional list of servers)");
        }
        System.out.println("         " + nls.getString("usage.10"));
        System.out.println("     " + nls.getString("usage.11"));
        System.out.println("         " + nls.getString("usage.12"));
        System.out.println("     " + nls.getString("usage.20"));
        System.out.println("         " + nls.getString("usage.21"));
        System.out.println("     " + nls.getString("usage.22"));
        System.out.println("         " + nls.getString("usage.23"));
        System.out.println("     " + nls.getString("usage.13"));
        System.out.println("         " + nls.getString("usage.14") + "\n");
        System.out.println(nls.getString("usage.separator") + "\n");
        System.out.println(nls.getString("usage.15") + "\n");
        System.out.println("     " + nls.getString("usage.16"));
        System.out.println("        " + nls.getString("usage.17") + "\n");
        System.out.println("     " + nls.getString("usage.18"));
        System.out.println("        " + nls.getString("usage.19") + "\n");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

