/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.plugincfg.generator;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webapplication.ServletMapping;
import com.ibm.websphere.models.config.host.HostAlias;
import com.ibm.websphere.models.config.host.VirtualHost;
import com.ibm.websphere.models.config.ipc.Transport;
import com.ibm.websphere.models.config.pmirm.PMIRMFilter;
import com.ibm.websphere.models.config.pmirm.PMIRMFilterValue;
import com.ibm.websphere.plugincfg.exception.PluginConfigException;
import com.ibm.websphere.plugincfg.generator.ConfigurationParser;
import com.ibm.websphere.plugincfg.generator.PluginConfigGenerator;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PluginDocumentGenerator {
    private Vector adminPorts = new Vector();
    private Document _pluginConfigDocument = null;
    private String _destRoot = null;
    private String _separator = null;
    protected static TraceComponent tc = Tr.register(class$com$ibm$websphere$plugincfg$generator$PluginDocumentGenerator == null ? (class$com$ibm$websphere$plugincfg$generator$PluginDocumentGenerator = PluginDocumentGenerator.class$("com.ibm.websphere.plugincfg.generator.PluginDocumentGenerator")) : class$com$ibm$websphere$plugincfg$generator$PluginDocumentGenerator);
    static /* synthetic */ Class class$com$ibm$websphere$plugincfg$generator$PluginDocumentGenerator;

    public PluginDocumentGenerator() {
        this._separator = File.separator;
    }

    public PluginDocumentGenerator(String string, String string2) {
        this._destRoot = string;
        this._separator = string2 != null ? (string2.equalsIgnoreCase("windows") ? "\\" : "/") : File.separator;
    }

    public String getLabel() {
        return "Generate Plugin Configuration from WCCM Model";
    }

    public String getDescription() {
        return "Generate Plugin Configuration from WCCM Model";
    }

    private boolean isAdminTransport(String string) {
        int n = this.adminPorts.size();
        for (int i = 0; i < n; ++i) {
            String string2 = (String)this.adminPorts.elementAt(i);
            if (string2.indexOf(string) == -1) continue;
            return true;
        }
        return false;
    }

    public Document createPluginConfigDocument(ConfigurationParser configurationParser) throws PluginConfigException {
        int n = 0;
        HashMap hashMap = new HashMap();
        try {
            Object object;
            String string;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Vector<String> vector;
            HashMap hashMap2;
            Object object6;
            Object object7;
            Object object8;
            Object object9;
            this._pluginConfigDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element element = this._pluginConfigDocument.createElement("Config");
            element.setAttribute("RefreshInterval", "60");
            element.setAttribute("IgnoreDNSFailures", "false");
            element.setAttribute("ResponseChunkSize", "64");
            element.setAttribute("ASDisableNagle", "false");
            element.setAttribute("IISDisableNagle", "false");
            element.setAttribute("AcceptAllContent", "false");
            element.setAttribute("VHostMatchingCompat", "false");
            element.setAttribute("AppServerPortPreference", "HostHeader");
            element.setAttribute("ChunkedResponse", "false");
            element.setAttribute("IISPluginPriority", "High");
            this._pluginConfigDocument.appendChild(element);
            Element element2 = this._pluginConfigDocument.createElement("Log");
            String string2 = null;
            if (this._destRoot != null) {
                string2 = this._destRoot;
            } else {
                string2 = System.getProperty("user.install.root");
                if (string2 == null) {
                    string2 = configurationParser.getAppServerRoot();
                }
            }
            if (!string2.endsWith(this._separator)) {
                string2 = string2 + this._separator;
            }
            string2 = string2 + "logs" + this._separator + "http_plugin.log";
            element2.setAttribute("Name", string2);
            element2.setAttribute("LogLevel", "Error");
            element.appendChild(element2);
            Element element3 = this._pluginConfigDocument.createElement("Property");
            element3.setAttribute("Name", "ESIEnable");
            element3.setAttribute("Value", "true");
            element.appendChild(element3);
            Element element4 = this._pluginConfigDocument.createElement("Property");
            element4.setAttribute("Name", "ESIMaxCacheSize");
            element4.setAttribute("Value", "1024");
            element.appendChild(element4);
            Element element5 = this._pluginConfigDocument.createElement("Property");
            element5.setAttribute("Name", "ESIInvalidationMonitor");
            element5.setAttribute("Value", "false");
            element.appendChild(element5);
            HashMap<String, Object> hashMap3 = new HashMap<String, Object>();
            Object var13_12 = null;
            Iterator<Object> iterator = configurationParser.getVHosts().iterator();
            while (iterator.hasNext()) {
                String string3;
                object9 = (VirtualHost)iterator.next();
                object8 = object9.getName();
                if (((String)object8).equals("admin_host")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Not including virtual host \"" + (String)object8 + "\" in plugin-cfg.xml");
                    }
                    object7 = object9.getAliases().iterator();
                    while (object7.hasNext()) {
                        object6 = (HostAlias)object7.next();
                        string3 = object6.getHostname();
                        hashMap2 = String.valueOf(object6.getPort());
                        this.adminPorts.addElement(string3 + ":" + (String)((Object)hashMap2));
                    }
                    continue;
                }
                hashMap3.put(object9.getName(), object9);
                object7 = this._pluginConfigDocument.createElement("VirtualHostGroup");
                object7.setAttribute("Name", object9.getName());
                element.appendChild((Node)object7);
                object6 = object9.getAliases().iterator();
                while (object6.hasNext()) {
                    string3 = (HostAlias)object6.next();
                    hashMap2 = this._pluginConfigDocument.createElement("VirtualHost");
                    hashMap2.setAttribute("Name", string3.getHostname() + ":" + String.valueOf(string3.getPort()));
                    object7.appendChild((Node)((Object)hashMap2));
                }
            }
            object9 = configurationParser.getServerClusters().iterator();
            object8 = null;
            while (object9.hasNext()) {
                Object object10;
                object7 = (ConfigurationParser.ServerClusterData)object9.next();
                object6 = this._pluginConfigDocument.createElement("ServerCluster");
                object6.setAttribute("Name", ((ConfigurationParser.ServerClusterData)object7).clusterName);
                object6.setAttribute("LoadBalance", ((ConfigurationParser.ServerClusterData)object7).loadBalance);
                object6.setAttribute("RetryInterval", ((ConfigurationParser.ServerClusterData)object7).retryInterval.toString());
                object6.setAttribute("RemoveSpecialHeaders", ((ConfigurationParser.ServerClusterData)object7).removeSpecialHeaders.toString());
                object6.setAttribute("CloneSeparatorChange", ((ConfigurationParser.ServerClusterData)object7).cloneSeparatorChange.toString());
                object6.setAttribute("PostSizeLimit", ((ConfigurationParser.ServerClusterData)object7).postSizeLimit.toString());
                if (!configurationParser.isSingleServerConfig()) {
                    object8 = this._pluginConfigDocument.createElement("PrimaryServers");
                }
                boolean bl = false;
                n = ((ConfigurationParser.ServerClusterData)object7).clusterServers.size();
                for (int i = 0; i < n; ++i) {
                    vector = (ConfigurationParser.ServerData)((ConfigurationParser.ServerClusterData)object7).clusterServers.get(i);
                    if (((ConfigurationParser.ServerData)((Object)vector)).serverType.equals("WORKPLACE_SERVER")) {
                        bl = true;
                    }
                    object5 = this._pluginConfigDocument.createElement("Server");
                    object5.setAttribute("Name", ((ConfigurationParser.ServerData)((Object)vector)).nodeName + "_" + ((ConfigurationParser.ServerData)((Object)vector)).serverName);
                    if (((ConfigurationParser.ServerData)((Object)vector)).cloneSeparator != null) {
                        object5.setAttribute("CloneSeparatorChange", ((ConfigurationParser.ServerData)((Object)vector)).cloneSeparator);
                    }
                    if (!configurationParser.isSingleServerConfig()) {
                        if (((ConfigurationParser.ServerData)((Object)vector)).wlmWeight != -1) {
                            object5.setAttribute("LoadBalanceWeight", ((ConfigurationParser.ServerData)((Object)vector)).wlmWeight.toString());
                        }
                        if (!((ConfigurationParser.ServerData)((Object)vector)).serverID.equals("")) {
                            object5.setAttribute("CloneID", ((ConfigurationParser.ServerData)((Object)vector)).serverID);
                        }
                    }
                    object5.setAttribute("ConnectTimeout", ((ConfigurationParser.ServerData)((Object)vector)).connectTimeout.toString());
                    object5.setAttribute("WaitForContinue", ((ConfigurationParser.ServerData)((Object)vector)).waitForContinue.toString());
                    object5.setAttribute("MaxConnections", ((ConfigurationParser.ServerData)((Object)vector)).maxConnections.toString());
                    object5.setAttribute("ExtendedHandshake", ((ConfigurationParser.ServerData)((Object)vector)).extendedHandshake.toString());
                    object6.appendChild((Node)object5);
                    iterator = ((ConfigurationParser.ServerData)((Object)vector)).transports.iterator();
                    object4 = null;
                    while (iterator.hasNext()) {
                        object3 = iterator.next();
                        if (object3 instanceof Transport) {
                            object2 = ((Transport)object3).getAddress();
                            object4 = new ConfigurationParser.TransportData(object2.getHost(), object2.getPort(), ((Transport)object3).isSslEnabled());
                        } else {
                            object4 = (ConfigurationParser.TransportData)object3;
                        }
                        object2 = this._pluginConfigDocument.createElement("Transport");
                        string = ((ConfigurationParser.TransportData)object4).host;
                        if (string.equals("") || string.equals("*") || string.equalsIgnoreCase("localhost")) {
                            string = ((ConfigurationParser.ServerData)((Object)vector)).hostName;
                        }
                        object2.setAttribute("Hostname", string);
                        String string4 = Integer.toString(((ConfigurationParser.TransportData)object4).port);
                        object2.setAttribute("Port", string4);
                        if (((ConfigurationParser.TransportData)object4).isSslEnabled) {
                            object2.setAttribute("Protocol", "https");
                            String string5 = null;
                            if (this._destRoot != null) {
                                string5 = this._destRoot;
                            } else {
                                string5 = System.getProperty("user.install.root");
                                if (string5 == null) {
                                    string5 = configurationParser.getAppServerRoot();
                                }
                            }
                            if (!string5.endsWith(this._separator)) {
                                string5 = string5 + this._separator;
                            }
                            object = this._pluginConfigDocument.createElement("Property");
                            object.setAttribute("Name", "keyring");
                            object.setAttribute("Value", string5 + "etc" + this._separator + "plugin-key.kdb");
                            object2.appendChild((Node)object);
                            object10 = this._pluginConfigDocument.createElement("Property");
                            object10.setAttribute("Name", "stashfile");
                            object10.setAttribute("Value", string5 + "etc" + this._separator + "plugin-key.sth");
                            object2.appendChild((Node)object10);
                        } else {
                            object2.setAttribute("Protocol", "http");
                        }
                        if (this.isAdminTransport(string4)) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "Admin transport -->" + string + ": " + string4 + "<-- will not be added to plugin-cfg.xml");
                            continue;
                        }
                        object5.appendChild((Node)object2);
                    }
                    element.appendChild((Node)object6);
                    if (configurationParser.isSingleServerConfig()) continue;
                    object3 = this._pluginConfigDocument.createElement("Server");
                    object3.setAttribute("Name", ((ConfigurationParser.ServerData)((Object)vector)).nodeName + "_" + ((ConfigurationParser.ServerData)((Object)vector)).serverName);
                    object8.appendChild((Node)object3);
                }
                if (!configurationParser.isSingleServerConfig()) {
                    object6.appendChild((Node)object8);
                }
                hashMap2 = new HashMap();
                vector = new Vector<String>();
                if (((ConfigurationParser.ServerClusterData)object7).deployedModules != null) {
                    iterator = ((ConfigurationParser.ServerClusterData)object7).deployedModules.iterator();
                    while (iterator.hasNext()) {
                        Object object11;
                        object5 = (ConfigurationParser.DeployedModuleData)iterator.next();
                        object4 = ((ConfigurationParser.DeployedModuleData)object5).moduleConfig.getContextRoot();
                        if (!((String)object4).startsWith("/")) {
                            object4 = "/" + (String)object4;
                        }
                        if ((object3 = ((ConfigurationParser.DeployedModuleData)object5).moduleBindings.getVirtualHostName()) == null || ((String)object3).equals("")) {
                            object3 = "default_host";
                        }
                        if (!hashMap2.containsKey(object3)) {
                            hashMap2.put(object3, new Vector());
                        }
                        object2 = (Vector)hashMap2.get(object3);
                        string = (String)object3 + (String)object4;
                        if (vector.contains(string)) {
                            Tr.warning(tc, "duplicate.context.root", object4);
                        }
                        vector.addElement(string);
                        boolean bl2 = true;
                        if (((ConfigurationParser.DeployedModuleData)object5).moduleExtensions.isSetFileServingEnabled()) {
                            bl2 = ((ConfigurationParser.DeployedModuleData)object5).moduleExtensions.isFileServingEnabled();
                        } else if (!((ConfigurationParser.ServerClusterData)object7).fileServingEnabled.equals("notDefined")) {
                            bl2 = new Boolean(((ConfigurationParser.ServerClusterData)object7).fileServingEnabled);
                        }
                        if (!bl2) {
                            boolean bl3;
                            if (((String)object4).equals("/")) {
                                object4 = "";
                            } else if (((String)object4).endsWith("/")) {
                                object4 = ((String)object4).substring(0, ((String)object4).length() - 1);
                            }
                            object11 = ((ConfigurationParser.DeployedModuleData)object5).deploymentDescriptor.getServletMappings().iterator();
                            while (object11.hasNext()) {
                                object = (ServletMapping)object11.next();
                                object10 = object.getUrlPattern();
                                boolean bl4 = false;
                                bl3 = ((String)object10).startsWith("/");
                                if (bl3) {
                                    bl4 = ((String)object10).equals("/");
                                }
                                if (bl4) {
                                    ((Vector)object2).addElement(new URIData((String)object4 + (String)object10 + "*", ((ConfigurationParser.DeployedModuleData)object5).cookieName, ((ConfigurationParser.DeployedModuleData)object5).urlCookieName));
                                    continue;
                                }
                                if (bl3) {
                                    ((Vector)object2).addElement(new URIData((String)object4 + (String)object10, ((ConfigurationParser.DeployedModuleData)object5).cookieName, ((ConfigurationParser.DeployedModuleData)object5).urlCookieName));
                                    continue;
                                }
                                ((Vector)object2).addElement(new URIData((String)object4 + "/" + (String)object10, ((ConfigurationParser.DeployedModuleData)object5).cookieName, ((ConfigurationParser.DeployedModuleData)object5).urlCookieName));
                            }
                            object = ((ConfigurationParser.DeployedModuleData)object5).additionalPatterns;
                            if (object != null) {
                                object10 = object.iterator();
                                while (object10.hasNext()) {
                                    String string6 = (String)object10.next();
                                    bl3 = false;
                                    boolean bl5 = string6.startsWith("/");
                                    if (bl5) {
                                        bl3 = string6.equals("/");
                                    }
                                    if (bl3) {
                                        ((Vector)object2).addElement(new URIData((String)object4 + string6 + "*", ((ConfigurationParser.DeployedModuleData)object5).cookieName, ((ConfigurationParser.DeployedModuleData)object5).urlCookieName));
                                        continue;
                                    }
                                    if (bl5) {
                                        ((Vector)object2).addElement(new URIData((String)object4 + string6, ((ConfigurationParser.DeployedModuleData)object5).cookieName, ((ConfigurationParser.DeployedModuleData)object5).urlCookieName));
                                        continue;
                                    }
                                    ((Vector)object2).addElement(new URIData((String)object4 + "/" + string6, ((ConfigurationParser.DeployedModuleData)object5).cookieName, ((ConfigurationParser.DeployedModuleData)object5).urlCookieName));
                                }
                            }
                            if (!((String)object4).equals("")) {
                                object4 = (String)object4 + "/";
                            }
                            ((Vector)object2).addElement(new URIData((String)object4 + "*.jsp", ((ConfigurationParser.DeployedModuleData)object5).cookieName, ((ConfigurationParser.DeployedModuleData)object5).urlCookieName));
                            ((Vector)object2).addElement(new URIData((String)object4 + "*.jsv", ((ConfigurationParser.DeployedModuleData)object5).cookieName, ((ConfigurationParser.DeployedModuleData)object5).urlCookieName));
                            ((Vector)object2).addElement(new URIData((String)object4 + "*.jsw", ((ConfigurationParser.DeployedModuleData)object5).cookieName, ((ConfigurationParser.DeployedModuleData)object5).urlCookieName));
                            if (((String)object4).equals("")) {
                                object4 = (String)object4 + "/";
                            }
                            ((Vector)object2).addElement(new URIData((String)object4 + "j_security_check", ((ConfigurationParser.DeployedModuleData)object5).cookieName, ((ConfigurationParser.DeployedModuleData)object5).urlCookieName));
                            ((Vector)object2).addElement(new URIData((String)object4 + "ibm_security_logout", ((ConfigurationParser.DeployedModuleData)object5).cookieName, ((ConfigurationParser.DeployedModuleData)object5).urlCookieName));
                        } else {
                            object11 = this.appendWildCardString((String)object4);
                            ((Vector)object2).addElement(new URIData((String)object11, ((ConfigurationParser.DeployedModuleData)object5).cookieName, ((ConfigurationParser.DeployedModuleData)object5).urlCookieName));
                        }
                        boolean bl6 = false;
                        if (((ConfigurationParser.DeployedModuleData)object5).moduleExtensions.isSetServeServletsByClassnameEnabled()) {
                            bl6 = ((ConfigurationParser.DeployedModuleData)object5).moduleExtensions.isServeServletsByClassnameEnabled();
                        } else if (!((ConfigurationParser.ServerClusterData)object7).serveServletsByClassnameEnabled.equals("notDefined")) {
                            bl6 = new Boolean(((ConfigurationParser.ServerClusterData)object7).serveServletsByClassnameEnabled);
                        }
                        if (!bl6) continue;
                        ((Vector)object2).addElement(new URIData((String)object4 + "servlet/*", ((ConfigurationParser.DeployedModuleData)object5).cookieName, ((ConfigurationParser.DeployedModuleData)object5).urlCookieName));
                    }
                }
                if (bl) {
                    object5 = "default_host";
                    if (!hashMap2.containsKey(object5)) {
                        hashMap2.put(object5, new Vector());
                    }
                    object4 = (Vector)hashMap2.get(object5);
                    object3 = configurationParser.getLotusURIList();
                    object2 = object3.iterator();
                    while (object2.hasNext()) {
                        ((Vector)object4).addElement((URIData)object2.next());
                    }
                }
                hashMap.put(((ConfigurationParser.ServerClusterData)object7).clusterName, hashMap2);
            }
            object9 = hashMap.keySet().iterator();
            while (object9.hasNext()) {
                object7 = (String)object9.next();
                object6 = (HashMap)hashMap.get(object7);
                iterator = ((HashMap)object6).keySet().iterator();
                while (iterator.hasNext()) {
                    String string7 = (String)iterator.next();
                    if (string7.equals("admin_host")) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Not adding admin_host uri information.");
                        continue;
                    }
                    hashMap2 = (Vector)((HashMap)object6).get(string7);
                    vector = this._pluginConfigDocument.createElement("UriGroup");
                    vector.setAttribute("Name", string7 + "_" + (String)object7 + "_URIs");
                    element.appendChild((Node)((Object)vector));
                    object5 = ((Vector)((Object)hashMap2)).iterator();
                    while (object5.hasNext()) {
                        object4 = (URIData)object5.next();
                        object3 = this._pluginConfigDocument.createElement("Uri");
                        object3.setAttribute("Name", ((URIData)object4).uriName);
                        if (!((URIData)object4).cookieName.equals("")) {
                            object3.setAttribute("AffinityCookie", ((URIData)object4).cookieName);
                        }
                        object3.setAttribute("AffinityURLIdentifier", ((URIData)object4).urlCookieName);
                        vector.appendChild((Node)object3);
                    }
                    object4 = this._pluginConfigDocument.createElement("Route");
                    object4.setAttribute("VirtualHostGroup", string7);
                    object4.setAttribute("UriGroup", string7 + "_" + (String)object7 + "_URIs");
                    object4.setAttribute("ServerCluster", (String)object7);
                    element.appendChild((Node)object4);
                }
            }
            object7 = System.getProperty("com.ibm.websphere.pmi.reqmetrics.loggingEnabled");
            object7 = object7 == null ? "true" : (((String)object7).equalsIgnoreCase("true") ? "true" : "false");
            object6 = configurationParser.pmirm;
            if (object6 != null) {
                Element element6 = this._pluginConfigDocument.createElement("RequestMetrics");
                element6.setAttribute("armEnabled", object6.isEnableARM() ? "true" : "false");
                element6.setAttribute("rmEnabled", object6.isEnable() ? "true" : "false");
                element6.setAttribute("loggingEnabled", (String)object7);
                element6.setAttribute("traceLevel", object6.getTraceLevel().toString());
                element.appendChild(element6);
                hashMap2 = object6.getFilters();
                for (int i = 0; i < hashMap2.size(); ++i) {
                    object5 = (PMIRMFilter)hashMap2.get(i);
                    object4 = object5.getType().getName();
                    Tr.debug(tc, "filter type: " + (String)object4);
                    if (((String)object4).equals("EJB")) continue;
                    boolean bl = object5.isEnable();
                    Tr.debug(tc, "\tenabled: " + bl);
                    object2 = this._pluginConfigDocument.createElement("filters");
                    object2.setAttribute("enable", bl ? "true" : "false");
                    object2.setAttribute("type", (String)object4);
                    element6.appendChild((Node)object2);
                    string = object5.getFilterValues();
                    for (int j = 0; j < string.size(); ++j) {
                        PMIRMFilterValue pMIRMFilterValue = (PMIRMFilterValue)string.get(j);
                        object = this._pluginConfigDocument.createElement("filterValues");
                        object.setAttribute("enable", pMIRMFilterValue.isEnable() ? "true" : "false");
                        object.setAttribute("value", pMIRMFilterValue.getValue());
                        object2.appendChild((Node)object);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.websphere.plugincfg.generator.PluginDocumentGenerator.createPluginConfigDocument", "378", this);
            throw new PluginConfigException(PluginConfigGenerator.nls.getString("doc.gen.exception"), throwable);
        }
        return this._pluginConfigDocument;
    }

    public void redo() {
        System.out.println("Redo not Supported");
    }

    public boolean canUndo() {
        return false;
    }

    protected boolean prepare() {
        return true;
    }

    private String appendWildCardString(String string) {
        if (!string.startsWith("*.")) {
            if (string.endsWith("/")) {
                string = string + "*";
            } else if (!string.endsWith("/*")) {
                string = string + "/*";
            }
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class URIData {
        public String uriName;
        public String cookieName;
        public String urlCookieName;

        public URIData(String string, String string2, String string3) {
            this.uriName = string;
            this.cookieName = string2;
            this.urlCookieName = string3;
        }
    }
}

