/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.finder;

import com.ibm.ejs.container.finder.CollectionCannotBeFurtherAccessedException;
import com.ibm.ejs.container.finder.FinderResultClientIterator;
import com.ibm.ejs.container.finder.FinderResultServer;
import com.ibm.ws.ejb.portable.Constants;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.ejb.FinderException;

public class FinderResultClientCollection
extends AbstractCollection
implements Serializable,
Set {
    static final byte[] eyecatcher = Constants.FINDER_RESULT_CLIENT_COLLECTION_EYE_CATCHER;
    static final short platform = 1;
    static final short versionID = 1;
    private static final long serialVersionUID = 96031000330697159L;
    public transient FinderResultServer server;
    public transient Vector allWrappers;
    private transient boolean hasAllWrappers;
    public transient int chunkSize;

    public FinderResultClientCollection(Vector vector) throws FinderException, RemoteException {
        this.chunkSize = Integer.MAX_VALUE;
        this.allWrappers = vector;
    }

    public FinderResultClientCollection(FinderResultServer finderResultServer, int n) throws FinderException, RemoteException {
        this.chunkSize = n;
        this.server = finderResultServer;
        this.allWrappers = finderResultServer.getNextWrapperCollection(0, n);
        try {
            Class<?> clazz = Class.forName("com.ibm.ejs.container.finder.FinderResultServerImpl");
            Method method = clazz.getMethod("exhaustedCollection", null);
            boolean bl = (Boolean)method.invoke((Object)finderResultServer, null);
            if (bl) {
                this.server = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int size() {
        try {
            return this.server != null && !this.hasAllWrappers ? this.server.size() : this.allWrappers.size();
        }
        catch (Throwable throwable) {
            throw new CollectionCannotBeFurtherAccessedException("Caught exception in size() method call:" + throwable.getMessage());
        }
    }

    public Iterator iterator() {
        return new FinderResultClientIterator(this.server, this.allWrappers, this, this.chunkSize);
    }

    void allWrappersCached() {
        this.hasAllWrappers = true;
    }

    boolean hasAllWrappers() {
        return this.hasAllWrappers;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.write(eyecatcher);
        objectOutputStream.writeShort(1);
        objectOutputStream.writeShort(1);
        objectOutputStream.writeObject(this.server);
        objectOutputStream.writeObject(this.allWrappers);
        objectOutputStream.writeInt(this.chunkSize);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n;
        objectInputStream.defaultReadObject();
        byte[] byArray = new byte[4];
        int n2 = 0;
        for (n = 0; n < 4; n += n2) {
            n2 = objectInputStream.read(byArray, n, 4 - n);
            if (n2 != -1) continue;
            throw new IOException("end of input stream while reading eye catcher");
        }
        for (n = 0; n < eyecatcher.length; ++n) {
            if (eyecatcher[n] == byArray[n]) continue;
            throw new IOException("Invalid eye catcher '" + eyecatcher + "' in FinderResultClientCollection input stream");
        }
        short s = objectInputStream.readShort();
        short s2 = objectInputStream.readShort();
        this.server = (FinderResultServer)objectInputStream.readObject();
        this.allWrappers = (Vector)objectInputStream.readObject();
        this.chunkSize = objectInputStream.readInt();
    }

    public String toString() {
        return this.getClass().getName() + " : collection increment= " + this.chunkSize + " : local wrapper collection size= " + this.allWrappers.size();
    }
}

