/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejb.portable;

import com.ibm.ws.ejb.portable.Constants;
import com.ibm.ws.ejb.portable.HomeHandleImpl;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.EJBMetaData;
import javax.ejb.HomeHandle;
import javax.rmi.PortableRemoteObject;

public class EJBMetaDataImpl
implements EJBMetaData,
Serializable {
    static final long serialVersionUID = 4092588565014573628L;
    static final boolean DEBUG_ON = false;
    static final int EYECATCHER_LENGTH = 4;
    static final byte[] EYECATCHER = Constants.EJB_META_DATA_EYE_CATCHER;
    static final short PLATFORM = 1;
    static final short VERSION_ID = 1;
    public static final int STATEFUL_SESSION = 1;
    public static final int STATELESS_SESSION = 2;
    public static final int NON_SESSION_BEAN = 3;
    private transient EJBHome ivEjbHome;
    private transient HomeHandle ivHomeHandle;
    private transient Class ivBeanClass;
    private transient Class ivHomeClass;
    private transient Class ivRemoteClass;
    private transient boolean ivSession;
    private transient boolean ivStatelessSession;
    private transient Class ivPKClass;

    public EJBMetaDataImpl(int n, EJBHome eJBHome, Class clazz, Class clazz2, Class clazz3, Class clazz4) {
        this.ivEjbHome = eJBHome;
        this.ivHomeHandle = new HomeHandleImpl(eJBHome);
        this.ivBeanClass = clazz;
        this.ivHomeClass = clazz2;
        this.ivRemoteClass = clazz3;
        this.ivPKClass = null;
        if (n == 1) {
            this.ivSession = true;
            this.ivStatelessSession = false;
        } else if (n == 2) {
            this.ivSession = true;
            this.ivStatelessSession = true;
        } else {
            this.ivSession = false;
            this.ivStatelessSession = false;
            this.ivPKClass = clazz4;
        }
    }

    public EJBHome getEJBHome() {
        return this.ivEjbHome;
    }

    public Class getHomeInterfaceClass() {
        return this.ivHomeClass;
    }

    public Class getPrimaryKeyClass() {
        if (this.ivPKClass == null) {
            throw new EJBException("Session beans do not have a primary key class");
        }
        return this.ivPKClass;
    }

    public Class getRemoteInterfaceClass() {
        return this.ivRemoteClass;
    }

    public String getBeanClassName() {
        return this.ivBeanClass.getName();
    }

    public boolean isSession() {
        return this.ivSession;
    }

    public boolean isStatelessSession() {
        return this.ivStatelessSession;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            int n;
            objectInputStream.defaultReadObject();
            byte[] byArray = new byte[4];
            int n2 = 0;
            for (n = 0; n < 4; n += n2) {
                n2 = objectInputStream.read(byArray, n, 4 - n);
                if (n2 != -1) continue;
                throw new IOException("end of input stream while reading eye catcher");
            }
            for (n = 0; n < 4; ++n) {
                if (EYECATCHER[n] == byArray[n]) continue;
                String string = new String(byArray);
                throw new IOException("Invalid eye catcher '" + string + "' in EJBMetaData input stream");
            }
            n = objectInputStream.readShort();
            short s = objectInputStream.readShort();
            this.ivSession = objectInputStream.readBoolean();
            this.ivStatelessSession = objectInputStream.readBoolean();
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            this.ivBeanClass = classLoader.loadClass(objectInputStream.readUTF());
            this.ivHomeClass = classLoader.loadClass(objectInputStream.readUTF());
            this.ivRemoteClass = classLoader.loadClass(objectInputStream.readUTF());
            if (!this.ivSession) {
                this.ivPKClass = classLoader.loadClass(objectInputStream.readUTF());
            }
            this.ivHomeHandle = (HomeHandle)objectInputStream.readObject();
            EJBHome eJBHome = this.ivHomeHandle.getEJBHome();
            this.ivEjbHome = (EJBHome)PortableRemoteObject.narrow((Object)eJBHome, (Class)this.ivHomeClass);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw classNotFoundException;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.write(EYECATCHER);
        objectOutputStream.writeShort(1);
        objectOutputStream.writeShort(1);
        objectOutputStream.writeBoolean(this.ivSession);
        objectOutputStream.writeBoolean(this.ivStatelessSession);
        objectOutputStream.writeUTF(this.ivBeanClass.getName());
        objectOutputStream.writeUTF(this.ivHomeClass.getName());
        objectOutputStream.writeUTF(this.ivRemoteClass.getName());
        if (!this.ivSession) {
            objectOutputStream.writeUTF(this.ivPKClass.getName());
        }
        objectOutputStream.writeObject(this.ivHomeHandle);
    }
}

