/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejb.portable;

import com.ibm.ws.ejb.portable.Constants;
import com.ibm.ws.ejb.portable.KeyHelper;
import com.ibm.ws.ejb.portable.LegacyHandleDelegateImpl;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.ejb.HomeHandle;
import javax.ejb.spi.HandleDelegate;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class HandleImpl
implements Handle,
Serializable {
    static final long serialVersionUID = -4496370801878254926L;
    static final int EYECATCHER_LENGTH = 4;
    static final byte[] EYECATCHER = Constants.HANDLE_EYE_CATCHER;
    static final short PLATFORM = 1;
    static final boolean DEBUG_ON = false;
    private transient EJBObject ivEjbObject;
    private transient short ivActualVersion;
    private transient Serializable ivKey = null;
    private transient HomeHandle ivHomeHandle = null;
    private static Class cvOutputStreamClass = null;

    public HandleImpl(EJBObject eJBObject) {
        this.ivEjbObject = eJBObject;
        this.ivActualVersion = (short)2;
    }

    private Method findFindByPrimaryKey(Class clazz) {
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().equals("findByPrimaryKey")) continue;
            return methodArray[i];
        }
        return null;
    }

    private EJBObject getReference() throws RemoteException {
        EJBObject eJBObject = null;
        EJBHome eJBHome = this.ivHomeHandle.getEJBHome();
        Class<?> clazz = eJBHome.getClass();
        try {
            Method method = this.findFindByPrimaryKey(clazz);
            eJBObject = (EJBObject)method.invoke((Object)eJBHome, this.ivKey);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RemoteException) {
                throw (RemoteException)throwable;
            }
            throw new RemoteException("Could not find bean", throwable);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RemoteException("Bad home interface definition", illegalAccessException);
        }
        return eJBObject;
    }

    public EJBObject getEJBObject() throws RemoteException {
        if (this.ivEjbObject == null) {
            this.ivEjbObject = this.getReference();
        }
        return this.ivEjbObject;
    }

    private HandleDelegate lookupHandleDelegate() {
        HandleDelegate handleDelegate = null;
        try {
            InitialContext initialContext = new InitialContext();
            handleDelegate = (HandleDelegate)initialContext.lookup("java:comp/HandleDelegate");
        }
        catch (NamingException namingException) {
            handleDelegate = LegacyHandleDelegateImpl.getInstance();
        }
        return handleDelegate;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.write(EYECATCHER);
        objectOutputStream.writeShort(1);
        objectOutputStream.writeShort(this.ivActualVersion);
        this.lookupHandleDelegate().writeEJBObject(this.ivEjbObject, objectOutputStream);
        if (this.ivActualVersion == 1) {
            objectOutputStream.writeObject(this.ivHomeHandle);
            if (cvOutputStreamClass == null || cvOutputStreamClass.isInstance(objectOutputStream)) {
                objectOutputStream.writeObject(this.ivKey);
            } else {
                objectOutputStream.writeObject(KeyHelper.serialize(this.ivKey));
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        block6: {
            int n;
            objectInputStream.defaultReadObject();
            byte[] byArray = new byte[4];
            int n2 = 0;
            for (n = 0; n < 4; n += n2) {
                n2 = objectInputStream.read(byArray, n, 4 - n);
                if (n2 != -1) continue;
                throw new IOException("end of input stream while reading eye catcher");
            }
            for (n = 0; n < EYECATCHER.length; ++n) {
                if (byArray[n] == EYECATCHER[n]) continue;
                String string = new String(byArray);
                throw new IOException("Invalid eye catcher '" + string + "' in handle input stream");
            }
            n = objectInputStream.readShort();
            this.ivActualVersion = objectInputStream.readShort();
            if (this.ivActualVersion != 1 && this.ivActualVersion != 2) {
                throw new InvalidObjectException("Handle data stream is not of the correct version, this client should be updated.");
            }
            try {
                this.ivEjbObject = this.lookupHandleDelegate().readEJBObject(objectInputStream);
            }
            catch (IOException iOException) {
                if (this.ivActualVersion == 1) break block6;
                throw iOException;
            }
        }
        if (this.ivActualVersion == 1) {
            this.ivEjbObject = null;
            this.ivHomeHandle = (HomeHandle)objectInputStream.readObject();
            this.ivKey = (Serializable)objectInputStream.readObject();
        }
    }

    static {
        try {
            cvOutputStreamClass = Class.forName("com.ibm.rmi.io.IIOPOutputStream");
        }
        catch (Throwable throwable) {
            cvOutputStreamClass = null;
        }
    }
}

