/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting;

import com.ibm.bsf.BSFException;
import com.ibm.bsf.BSFManager;
import com.ibm.bsf.util.IOUtils;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.exception.WsException;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.scripting.AdminControlClient;
import com.ibm.ws.scripting.ExceptionSupport;
import com.ibm.ws.scripting.JaclUtilities;
import com.ibm.ws.scripting.JythonUtilities;
import com.ibm.ws.scripting.LanguageUtilities;
import com.ibm.ws.scripting.ReconnectSupport;
import com.ibm.ws.scripting.ScriptingException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;

public abstract class AbstractShell {
    private static TraceComponent tc = Tr.register(class$com$ibm$ws$scripting$AbstractShell == null ? (class$com$ibm$ws$scripting$AbstractShell = AbstractShell.class$("com.ibm.ws.scripting.AbstractShell")) : class$com$ibm$ws$scripting$AbstractShell, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    private static final String CONN_TYPE_PROP = "com.ibm.ws.scripting.connectionType";
    private static final String HOST_PROP = "com.ibm.ws.scripting.host";
    private static final String PORT_PROP = "com.ibm.ws.scripting.port";
    private static final String DEFAULT_LANG_PROP = "com.ibm.ws.scripting.defaultLang";
    private static final String CLASSPATH_PROP = "com.ibm.ws.scripting.classpath";
    protected static int returnCode = 0;
    protected ArrayList commands = new ArrayList(3);
    protected ArrayList propfiles = new ArrayList(3);
    protected ArrayList loadedPropfiles = new ArrayList();
    protected ArrayList scriptParms = new ArrayList();
    protected String lang = null;
    protected String connectionType = null;
    protected String argHost = null;
    protected String argPort = null;
    protected String argUser = null;
    protected String argPassword = null;
    protected String argClasspath = null;
    protected String saveClasspath = null;
    protected boolean inScript = false;
    protected ResourceBundle bundle = null;
    protected String prompt = null;
    protected LanguageUtilities langUtils = null;
    protected Vector reconnectors = new Vector();
    Properties connProps = null;
    protected Exception _lastException = null;
    protected BSFManager mgr = null;
    static /* synthetic */ Class class$com$ibm$ws$scripting$AbstractShell;

    public static AbstractShell getShell() {
        return null;
    }

    protected abstract boolean parseAndValidateInput(String[] var1);

    protected abstract boolean declareBeans(Object var1);

    protected abstract void executeProfiles();

    protected abstract void showHelp();

    protected abstract String getTargetScript();

    protected abstract void initializePropFileSet();

    protected abstract int retcodeFromMessage(String var1);

    protected abstract void setTrace();

    protected abstract void welcome();

    public abstract Object executeCommand(String var1);

    protected abstract boolean timeToGo();

    protected abstract void leaving(boolean var1);

    public String getUser() {
        return this.argUser;
    }

    public void registerForReconnect(ReconnectSupport reconnectSupport) {
        this.reconnectors.add(reconnectSupport);
    }

    public void manageReconnect() {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "manageReconnect");
        }
        Enumeration enumeration = this.reconnectors.elements();
        boolean bl = false;
        Vector<String> vector = new Vector<String>();
        WsException wsException = null;
        while (enumeration.hasMoreElements()) {
            object = (ReconnectSupport)enumeration.nextElement();
            if (tc.isEventEnabled()) {
                Tr.event(tc, "about to request reconnect for object with class: " + object.getClass().getName());
            }
            try {
                object.doReconnect();
            }
            catch (ConnectorException connectorException) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "caught ConnectorException for reconnect; object: " + object.getClass().getName());
                }
                bl = true;
                wsException = connectorException;
                vector.add(object.getClass().getName());
            }
            catch (AdminException adminException) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "caught AdminException for reconnect; object: " + object.getClass().getName());
                }
                bl = true;
                wsException = adminException;
                vector.add(object.getClass().getName());
            }
        }
        if (bl) {
            object = new StringBuffer();
            for (int i = 0; i < vector.size(); ++i) {
                ((StringBuffer)object).append((String)vector.get(i));
                if (i >= vector.size() - 1) continue;
                ((StringBuffer)object).append(", ");
            }
            returnCode = this.logAndIssueMessage(new Object[]{((StringBuffer)object).toString()}, "RECONNECT_FAILED", "Attempt to reconnect to the server failed for the following objects: " + ((StringBuffer)object).toString() + "; server may no longer be running.", (Exception)wsException);
        } else {
            object = this.connProps.getProperty("type");
            String string = this.connProps.getProperty("host");
            this.issueMessage(new Object[]{object, string}, "RECONNECT_COMPLETE", "Reconnect of " + (String)object + " connector to host " + string + " completed.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "manageReconnect");
        }
    }

    public LanguageUtilities getLangUtils() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLangUtils");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLangUtils");
        }
        return this.langUtils;
    }

    public ResourceBundle getBundle() {
        return this.bundle;
    }

    public String getConnectionType() {
        return this.connectionType;
    }

    public String getLang() {
        return this.lang;
    }

    protected void determineLanguage() {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "determineLanguage");
        }
        if (this.lang == null && (string = System.getProperty(DEFAULT_LANG_PROP)) != null) {
            if (!string.equalsIgnoreCase("jacl") && !string.equalsIgnoreCase("jython")) {
                returnCode = this.issueMessage(new Object[]{string}, "LANGUAGE_NOT_SUPPORTED", "Language \"" + string + "\" is not supported.");
            } else if (BSFManager.isLanguageRegistered((String)string)) {
                this.lang = string;
            } else {
                returnCode = this.issueMessage(new Object[]{string}, "LANGUAGE_NOT_REGISTERED", "Language \"" + string + "\" is not registered to BSF.");
            }
        }
        if (this.lang == null) {
            string = this.getTargetScript();
            try {
                if (string != null) {
                    this.lang = BSFManager.getLangFromFilename((String)string);
                }
            }
            catch (BSFException bSFException) {
                returnCode = this.issueMessage(new Object[]{string}, "CANNOT_FIND_LANG", "Cannot determine scripting language for file: \"" + string + "\" -- please specify \"-lang\" option on the command line.");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "determineLanguage -- lang not found");
                }
                return;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "determineLanguage");
        }
    }

    protected LanguageUtilities getUtilitiesForLanguage() {
        if (this.lang == null) {
            return new LanguageUtilities(this.bundle);
        }
        if (this.lang.equals("jacl")) {
            return new JaclUtilities(this.bundle);
        }
        if (this.lang.equals("jython")) {
            return new JythonUtilities(this.bundle);
        }
        return new LanguageUtilities(this.bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadPropertiesFiles() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadPropertiesFiles");
        }
        this.initializePropFileSet();
        int i = 0;
        while (true) {
            block12: {
                Object var5_6;
                if (i >= this.propfiles.size()) {
                    return;
                }
                String string = (String)this.propfiles.get(i);
                try {
                    try {
                        File file = new File(string);
                        System.getProperties().load(new FileInputStream(file));
                        this.loadedPropfiles.add(string);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        returnCode = this.issueMessage(new Object[]{string}, "FILE_NOT_FOUND", "Cannot find file " + string);
                        var5_6 = null;
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "loadPropertiesFiles");
                        }
                        break block12;
                    }
                    catch (Exception exception) {
                        returnCode = this.issueMessage(new Object[]{string, exception}, "EXCEPTION_LOADING_PROPERTIES_FILE", "Exception received while loading properties file " + string + "; exception information: " + exception);
                        var5_6 = null;
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "loadPropertiesFiles");
                        }
                        break block12;
                    }
                    var5_6 = null;
                }
                catch (Throwable throwable) {
                    var5_6 = null;
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "loadPropertiesFiles");
                    }
                    throw throwable;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "loadPropertiesFiles");
                }
            }
            ++i;
        }
    }

    protected void logPropertiesFilesLoaded() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logPropertiesFilesLoaded");
        }
        for (int i = 0; i < this.loadedPropfiles.size(); ++i) {
            String string = (String)this.loadedPropfiles.get(i);
            Tr.audit(tc, "WASX7326I", new Object[]{string});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logPropertiesFilesLoaded");
        }
    }

    protected void setClasspath() {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setClasspath");
        }
        if (this.argClasspath == null) {
            this.argClasspath = System.getProperty(CLASSPATH_PROP);
        }
        if (this.lang != null && this.lang.equals("jython")) {
            string = System.getProperty("ws.ext.dirs");
            System.setProperty("java.ext.dirs", string);
            if (this.argClasspath != null) {
                this.saveClasspath = System.getProperty("java.class.path");
                String string2 = this.saveClasspath + System.getProperty("path.separator") + this.argClasspath;
                System.setProperty("java.class.path", string2);
            }
        }
        if (this.argClasspath != null) {
            this.argClasspath = this.normalizeFQPathName(this.argClasspath);
            string = (ExtClassLoader)Thread.currentThread().getContextClassLoader();
            string.addPath(this.argClasspath);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setClasspath");
        }
    }

    protected void setupConnectionType() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setupConnectionType");
        }
        if (this.connectionType == null) {
            this.connectionType = System.getProperty(CONN_TYPE_PROP);
        }
        if (this.connectionType == null) {
            this.connectionType = "SOAP";
        }
        if (this.connectionType.equals("NONE")) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setupConnectionType - NONE");
            }
            System.out.println(this.getString("WASX7357I", "The scripting client is not connected to any server. Operations will be available in local mode"));
            Tr.audit(tc, "WASX7357I");
        }
        if (this.connectionType.equals("SOAP")) {
            if (this.argHost == null) {
                this.argHost = System.getProperty(HOST_PROP);
            }
            if (this.argHost == null) {
                try {
                    this.argHost = AdminHelper.getInstance().getHostName();
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
            if (this.argHost == null) {
                returnCode = this.issueMessage(new Object[]{"SOAP"}, "CONN_REQUIRES_HOST", "The \"SOAP\" connection type requires that a host be specified in a properties file or with \"-host\" on the command line.");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "setupConnectionType");
                }
                return;
            }
            if (this.argPort == null) {
                this.argPort = System.getProperty(PORT_PROP);
            }
            if (this.argPort == null) {
                returnCode = this.issueMessage(new Object[]{"SOAP"}, "CONN_REQUIRES_PORT", "The \"SOAP\" connection type requires that a port be specified in a properties file or with \"-port\" on the command line.");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "setupConnectionType");
                }
                return;
            }
            try {
                this.connProps = new Properties();
                int n = Integer.parseInt(this.argPort);
                this.connProps.setProperty("type", "SOAP");
                this.connProps.setProperty("host", this.argHost);
                this.connProps.setProperty("port", Integer.toString(n));
            }
            catch (NumberFormatException numberFormatException) {
                returnCode = this.logAndIssueMessage(new Object[]{"SOAP", this.argPort}, "CONN_REQUIRES_INTEGER_PORT", "SOAP connection type requires an integer port; found: \"" + this.argPort + "\"", numberFormatException);
            }
            if (this.argUser != null) {
                this.connProps.setProperty("username", this.argUser);
            }
            if (this.argPassword != null) {
                this.connProps.setProperty("password", this.argPassword);
            }
            if (this.argUser != null || this.argPassword != null) {
                this.connProps.setProperty("securityEnabled", "true");
            }
        } else if (this.connectionType.equals("RMI")) {
            if (this.argHost == null) {
                this.argHost = System.getProperty(HOST_PROP);
            }
            if (this.argHost == null) {
                try {
                    this.argHost = AdminHelper.getInstance().getHostName();
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
            if (this.argHost == null) {
                returnCode = this.issueMessage(new Object[]{"RMI"}, "CONN_REQUIRES_HOST", "The \"RMI\" connection type requires that a host be specified in a properties file or with \"-host\" on the command line.");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "setupConnectionType");
                }
                return;
            }
            if (this.argPort == null) {
                this.argPort = System.getProperty(PORT_PROP);
            }
            if (this.argPort == null) {
                returnCode = this.issueMessage(new Object[]{"RMI"}, "CONN_REQUIRES_PORT", "The \"RMI\" connection type requires that a port be specified in a properties file or with \"-port\" on the command line.");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "setupConnectionType");
                }
                return;
            }
            int n = 0;
            try {
                n = Integer.parseInt(this.argPort);
            }
            catch (NumberFormatException numberFormatException) {
                returnCode = this.logAndIssueMessage(new Object[]{"RMI", this.argPort}, "CONN_REQUIRES_INTEGER_PORT", "RMI connection type requires an integer port; found: \"" + this.argPort + "\"", numberFormatException);
            }
            this.connProps = new Properties();
            this.connProps.setProperty("type", "RMI");
            this.connProps.setProperty("host", this.argHost);
            this.connProps.setProperty("port", Integer.toString(n));
            if (this.argUser != null || this.argPassword != null) {
                this.connProps.setProperty("securityEnabled", "true");
                this.connProps.setProperty("username", this.argUser);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "user: " + this.argUser);
                }
                if (this.argPassword == null) {
                    this.argPassword = "";
                }
                this.connProps.setProperty("password", this.argPassword);
            }
        } else if (this.connectionType.equals("JMS")) {
            // empty if block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setupConnectionType");
        }
    }

    protected void executeCommands() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "executeCommands");
        }
        if (this.commands.size() == 0) {
            return;
        }
        if (this.lang == null) {
            returnCode = this.issueMessage(new Object[0], "CANNOT_FIND_LANG_FOR_COMMANDS", "Cannot determine scripting language for command invocation -- please specify \"-lang\" option on the command line.");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "executeCommands -- lang not found");
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "using language: " + this.lang);
        }
        if (this.scriptParms.size() > 0) {
            Tr.audit(tc, "WASX7303I", new Object[]{this.scriptParms});
        }
        for (int i = 0; i < this.commands.size(); ++i) {
            String string = (String)this.commands.get(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "processing command: " + string);
            }
            try {
                if (string.toLowerCase().indexOf("password") >= 0) {
                    Tr.audit(tc, "WASX7092I");
                } else {
                    Tr.audit(tc, "WASX7090I", new Object[]{string});
                }
                if (this.lang.equals("jacl") && string.startsWith("source ")) {
                    this.inScript = true;
                }
                this._lastException = null;
                if (this.lang.equals("jython")) {
                    this.mgr.iexec(this.lang, string, 0, 0, (Object)string);
                } else {
                    Object object = this.mgr.eval(this.lang, string, 0, 0, (Object)string);
                    if (object != null) {
                        System.out.println(object.toString());
                    }
                }
                this.inScript = false;
                continue;
            }
            catch (BSFException bSFException) {
                String string2 = this.getStringFromException(bSFException);
                this.logException(bSFException, string2);
                returnCode = this.issueMessage(new Object[]{string, string2}, "ERROR_RUNNING_COMMAND", "Problem running command \"" + string + "\" -- exception information: " + (Object)((Object)bSFException));
                int n = this.retcodeFromMessage(string2);
                if (n <= 0) continue;
                returnCode = n;
            }
        }
        this.leaving(true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "executeCommands");
        }
    }

    protected void executeScript(String string) {
        block15: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "executeScript");
            }
            FileReader fileReader = null;
            String string2 = null;
            try {
                string2 = BSFManager.getLangFromFilename((String)string);
            }
            catch (BSFException bSFException) {
                if (this.lang == null) {
                    String string3 = this.getStringFromException(bSFException);
                    this.logException(bSFException, string3);
                    returnCode = this.issueMessage(new Object[]{string}, "CANNOT_FIND_LANG", "Cannot determine scripting language for file: \"" + string + "\" -- please specify \"-lang\" option on the command line.");
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "executeScript -- lang not found");
                    }
                    return;
                }
                string2 = this.lang;
            }
            if (this.lang == null) {
                this.lang = string2;
            } else if (!this.lang.equals(string2)) {
                returnCode = this.issueMessage(new Object[]{string, this.lang}, "WASX7227E", "Script file " + string + " is in the wrong language and will not be executed; language used is " + this.lang);
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "using language: " + this.lang);
            }
            try {
                if (this.scriptParms.size() > 0) {
                    Tr.audit(tc, "WASX7303I", new Object[]{this.scriptParms});
                }
                fileReader = new FileReader(string);
                this._lastException = null;
                Tr.audit(tc, "WASX7091I", new Object[]{string});
                String string4 = this.getSanitizedScriptString(fileReader);
                this.mgr.exec(this.lang, string, 0, 0, (Object)string4);
                this.leaving(false);
            }
            catch (FileNotFoundException fileNotFoundException) {
                returnCode = this.logAndIssueMessage(new Object[]{string}, "FILE_NOT_FOUND", "Cannot find file \"" + string + "\"", fileNotFoundException);
            }
            catch (IOException iOException) {
                returnCode = this.logAndIssueMessage(new Object[]{string, iOException}, "ERROR_READING_FILE", "Cannot read file \"" + string + "\"", iOException);
            }
            catch (BSFException bSFException) {
                String string5 = this.getStringFromException(bSFException);
                returnCode = this.issueMessage(new Object[]{string, string5}, "ERROR_RUNNING_FILE", "Problem running file \"" + string + "\"");
                int n = this.retcodeFromMessage(string5);
                if (n <= 0) break block15;
                returnCode = n;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "executeScript");
        }
    }

    protected String getSanitizedScriptString(Reader reader) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSanitizedScriptString");
        }
        String string = IOUtils.getStringFromReader((Reader)reader);
        String string2 = System.getProperty("os.name");
        if (this.lang.equals("jacl") && string2 != null && string2.startsWith("Windows")) {
            int n;
            if (tc.isEventEnabled()) {
                Tr.event(tc, "fixing up Windows CRLF");
            }
            while ((n = string.indexOf("\r\n")) != -1) {
                StringBuffer stringBuffer = new StringBuffer(string);
                stringBuffer.replace(n, n + 2, "\n");
                string = stringBuffer.toString();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSanitizedScriptString");
        }
        return string;
    }

    protected AdminControlClient createControlClient() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createControlClient");
        }
        AdminControlClient adminControlClient = null;
        adminControlClient = new AdminControlClient(this, this.connProps);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createControlClient");
        }
        return adminControlClient;
    }

    protected void interactive() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "interactive");
        }
        InputStreamReader inputStreamReader = null;
        inputStreamReader = new InputStreamReader(System.in);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String string = null;
        if (this.lang == null) {
            returnCode = this.issueMessage(new Object[0], "CANNOT_FIND_LANG_INTERACTIVE", "Cannot determine scripting language to use in interactive mode -- please specify \"-lang\" option on the command line.");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "interactive -- no language");
            }
            return;
        }
        String string2 = null;
        while (true) {
            Object object;
            if (string2 == null) {
                string = this.getCommand(bufferedReader, System.out);
            } else {
                string = string2;
                string2 = null;
            }
            if (string == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "interactive -- null");
                }
                return;
            }
            if (!string.equals("quit")) {
                try {
                    if (string.length() > 0 || string.length() == 0 && this.lang.equals("jython")) {
                        this._lastException = null;
                        if (string.toLowerCase().indexOf("password") >= 0) {
                            Tr.audit(tc, "WASX7092I");
                        } else {
                            Tr.audit(tc, "WASX7090I", new Object[]{string});
                        }
                        if (this.lang.equals("jacl") && string.startsWith("source ")) {
                            this.inScript = true;
                        }
                        if (this.lang.equals("jython")) {
                            this.mgr.iexec(this.lang, string, 0, 0, (Object)string);
                        } else {
                            object = this.mgr.eval(this.lang, string, 0, 0, (Object)string);
                            if (object != null) {
                                System.out.println(object.toString());
                            }
                        }
                        this.inScript = false;
                    }
                }
                catch (BSFException bSFException) {
                    String string3 = this.getStringFromException(bSFException);
                    this.logException(bSFException, string3);
                    returnCode = this.issueMessage(new Object[]{string, string3}, "EXCEPTION_RUNNING_COMMAND", "Exception running command: " + string + "; exception information: " + (Object)((Object)bSFException));
                }
                catch (Exception exception) {
                    returnCode = this.issueMessage(new Object[]{string, exception}, "EXCEPTION_RUNNING_COMMAND", "Exception running command: " + string + "; exception information: " + exception);
                }
                string = null;
                continue;
            }
            if (this.timeToGo()) break;
            object = this.getFormattedMessage("WASX7118I", new Object[0], "Unsaved changes exist: enter \"quit\" or \"exit\" to quit without save.");
            System.out.println((String)object);
            string = this.getCommand(bufferedReader, System.out);
            if (string.equals("quit")) break;
            string2 = new String(string);
        }
        this.leaving(false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "interactive");
        }
    }

    protected String getCommand(BufferedReader bufferedReader, PrintStream printStream) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommand");
        }
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = System.getProperty("line.separator");
        if (printStream != null) {
            printStream.print(this.prompt);
        }
        try {
            string = bufferedReader.readLine();
            if (string != null) {
                stringBuffer.append(string + string2);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (string == null) {
            stringBuffer.setLength(0);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCommand -- null");
            }
            return null;
        }
        if (string.equals("exit") || string.equals("quit")) {
            stringBuffer.setLength(0);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCommand -- " + string);
            }
            return "quit";
        }
        string = stringBuffer.toString();
        if (this.lang.equals("jython")) {
            while (string.endsWith(" ") || string.endsWith("\n") || string.endsWith("\r")) {
                string = string.substring(0, string.length() - 1);
            }
        } else {
            string = string.trim();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommand -- " + string);
        }
        return string;
    }

    public String getFormattedMessage(String string, Object[] objectArray, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFormattedMessage");
        }
        if (string == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getFormattedMessage - default");
            }
            return string2;
        }
        try {
            String string3 = this.bundle.getString(string);
            string3 = this.escapeSingleQuotes(string3);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getFormattedMessage");
            }
            return MessageFormat.format(string3, objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getFormattedMessage - default");
            }
            return MessageFormat.format(string2, objectArray);
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getFormattedMessage - default");
            }
            return string2;
        }
    }

    protected String escapeSingleQuotes(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "escapeSingleQuotes");
        }
        if (string == null || string.indexOf(39) < 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "escapeSingleQuotes");
            }
            return string;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\'') {
                stringBuffer.append('\'');
            }
            stringBuffer.append(c);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "escapeSingleQuotes");
        }
        return stringBuffer.toString();
    }

    public String getString(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getString");
        }
        try {
            String string3 = this.bundle.getString(string);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getString");
            }
            return string3;
        }
        catch (MissingResourceException missingResourceException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getString - default");
            }
            return string2;
        }
        catch (NullPointerException nullPointerException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getString - default");
            }
            return string2;
        }
    }

    protected int issueMessage(Object[] objectArray, String string, String string2) {
        String string3 = this.getFormattedMessage(string, objectArray, string2);
        System.out.println(string3);
        Tr.audit(tc, "WASX7093I", new Object[]{string3});
        return this.retcodeFromMessage(string3);
    }

    protected int logAndIssueMessage(Object[] objectArray, String string, String string2, Exception exception) {
        int n = this.issueMessage(objectArray, string, string2);
        this.logException(exception);
        return n;
    }

    protected int processConnType(String[] stringArray, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processConnType");
        }
        if (stringArray[n].regionMatches(true, 0, "SOAP", 0, stringArray[n].length())) {
            Tr.event(tc, "Processing SOAP connection type.");
            this.connectionType = "SOAP";
        } else if (stringArray[n].regionMatches(true, 0, "RMI", 0, stringArray[n].length())) {
            Tr.event(tc, "Processing RMI connection type.");
            this.connectionType = "RMI";
        } else if (stringArray[n].regionMatches(true, 0, "NONE", 0, stringArray[n].length())) {
            Tr.event(tc, "Processing no connection type.");
            this.connectionType = "NONE";
        } else {
            returnCode = this.issueMessage(new Object[]{stringArray[n]}, "INVALID_CONNECTION_TYPE", "Invalid connection type " + stringArray[n]);
            n = -1;
        }
        return n;
    }

    public void setLastException(Exception exception) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setLastException");
        }
        if (this.inScript) {
            String string;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "in script mode; not saving exception");
            }
            if (exception == null) {
                return;
            }
            String string2 = ExceptionSupport.getMessage(exception, "WASX");
            if (string2 == null) {
                string2 = exception.toString();
            }
            if ((string = ExceptionSupport.getDiagnosticInfo(exception)) == null) {
                StringWriter stringWriter = new StringWriter();
                exception.printStackTrace(new PrintWriter(stringWriter));
                string = stringWriter.toString();
            }
            this._lastException = exception;
            Tr.error(tc, "WASX7120E", new Object[]{string2, string});
        } else {
            this._lastException = exception;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setLastException");
        }
    }

    public void setAndThrowScriptingException(String string, String string2, Object[] objectArray) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAndThrowScriptingException", new Object[]{string, string2});
        }
        String string3 = this.getFormattedMessage(string, objectArray, string2);
        ScriptingException scriptingException = new ScriptingException(string3);
        this.setLastException((Exception)((Object)scriptingException));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAndThrowScriptingException");
        }
        throw scriptingException;
    }

    protected String getStringFromException(BSFException bSFException) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStringFromException");
        }
        String string = null;
        string = ExceptionSupport.getMessage(this._lastException, "WASX");
        try {
            if (string == null && bSFException != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "using message from BSFException");
                }
                string = bSFException.toString();
                Throwable throwable = bSFException.getTargetException();
                if (throwable != null && string != null && throwable.getMessage() != null) {
                    if (string.indexOf(throwable.getMessage()) >= 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "target exception redundant");
                        }
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "using message from BSFException.getTargetException()");
                        }
                        string = string + "; " + throwable.getMessage();
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStringFromException");
        }
        return string;
    }

    protected void logException(BSFException bSFException, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logException");
        }
        String string2 = null;
        string2 = ExceptionSupport.getDiagnosticInfo(this._lastException);
        if (string2 == null && bSFException != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "using message from BSFException");
            }
            StringWriter stringWriter = new StringWriter();
            bSFException.printStackTrace(new PrintWriter(stringWriter));
            string2 = stringWriter.toString();
        }
        Tr.error(tc, "WASX7120E", new Object[]{string, string2});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logException");
        }
    }

    public void logException(Exception exception) {
        String string;
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logException");
        }
        if ((string2 = ExceptionSupport.getMessage(exception, "WASX")) == null) {
            string2 = exception.toString();
        }
        if ((string = ExceptionSupport.getDiagnosticInfo(this._lastException)) == null) {
            StringWriter stringWriter = new StringWriter();
            exception.printStackTrace(new PrintWriter(stringWriter));
            string = stringWriter.toString();
        }
        Tr.error(tc, "WASX7120E", new Object[]{string2, string});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logException");
        }
    }

    protected void setupCmdLineArgs() {
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setupCmdLineArgs");
            }
            if (this.lang == null) {
                returnCode = this.issueMessage(new Object[0], "CANNOT_FIND_LANG_FOR_COMMANDS", "Cannot determine scripting language for command invocation -- please specify \"-lang\" option on the command line.");
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "setupCmdLineArgs -- lang not found");
                }
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "using language: " + this.lang);
            }
            String[] stringArray = this.langUtils.createArgSettingCommands(this.scriptParms);
            int n = 0;
            try {
                for (int i = 0; i < stringArray.length; ++i) {
                    this._lastException = null;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "processing command: " + stringArray[i]);
                    }
                    n = i;
                    this.mgr.exec(this.lang, stringArray[i], 0, 0, (Object)stringArray[i]);
                }
            }
            catch (BSFException bSFException) {
                String string = this.getStringFromException(bSFException);
                this.logException(bSFException, string);
                returnCode = this.issueMessage(new Object[]{stringArray[n], string}, "ERROR_RUNNING_COMMAND", "Problem running command \"" + stringArray[n] + "\" -- exception information: " + (Object)((Object)bSFException));
                int n2 = this.retcodeFromMessage(string);
                if (n2 <= 0) break block9;
                returnCode = n2;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setupCmdLineArgs");
        }
    }

    public String normalizeFQPathName(String string) {
        char c;
        char c2;
        char c3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "normalizeFQPathName - " + string);
        }
        String string2 = string;
        char c4 = File.separatorChar;
        char c5 = c3 = c4 == '/' ? (char)'\\' : '/';
        if (string.indexOf(c3) >= 0) {
            string2 = string.replace(c3, c4);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "path after converting separator: " + string2);
        }
        char c6 = c2 = (c = File.pathSeparatorChar) == ';' ? (char)':' : ';';
        if (string2.indexOf(c2) >= 0) {
            String string3;
            if (c == ';') {
                StringBuffer stringBuffer = new StringBuffer();
                int n = 0;
                while (n != -1) {
                    int n2 = string2.indexOf(c2, n);
                    if (n2 > -1) {
                        if (n2 + 2 < string.length() && string2.substring(n2, n2 + 2).equals(":\\")) {
                            if (n2 - 2 < 0 || string2.substring(n2 - 2, n2 - 1).equals(":") || string2.substring(n2 - 2, n2 - 1).equals(";")) {
                                stringBuffer.append(string2.substring(n, n2 + 2));
                                n = n2 + 2;
                            } else {
                                stringBuffer.append(string2.substring(n, n2));
                                stringBuffer.append(c);
                                n = n2 + 1;
                            }
                        } else {
                            stringBuffer.append(string2.substring(n, n2));
                            stringBuffer.append(c);
                            n = n2 + 1;
                        }
                        if (n < string2.length()) continue;
                        n = -1;
                        continue;
                    }
                    stringBuffer.append(string2.substring(n, string2.length()));
                    n = -1;
                }
                string3 = stringBuffer.toString();
            } else {
                string3 = string2.replace(c2, c);
            }
            string2 = string3;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "normalizeFQPathName - " + string2);
        }
        return string2;
    }

    public void run(String[] stringArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "run", stringArray);
        }
        ExceptionSupport.setBundle(this.bundle);
        if (this.parseAndValidateInput(stringArray)) {
            this.loadPropertiesFiles();
            this.setTrace();
            if (returnCode == 0) {
                this.setClasspath();
            }
            if (returnCode == 0) {
                this.setupConnectionType();
            }
            if (returnCode == 0) {
                this.determineLanguage();
            }
            if (returnCode != 0) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "run -> " + returnCode);
                }
                return;
            }
            this.langUtils = this.getUtilitiesForLanguage();
            this.logPropertiesFilesLoaded();
            this.mgr = new BSFManager();
            AdminControlClient adminControlClient = this.createControlClient();
            if (!this.declareBeans(adminControlClient)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "run -> " + returnCode);
                }
                return;
            }
            this.setupCmdLineArgs();
            this.executeProfiles();
            this.executeCommands();
            if (this.getTargetScript() != null) {
                this.inScript = true;
                this.executeScript(this.getTargetScript());
            } else if (this.commands.isEmpty()) {
                if (this.scriptParms.size() > 0) {
                    String string = this.getFormattedMessage("WASX7303I", new Object[]{this.scriptParms}, "The following unrecognized options are passed to the scripting environment and are available as argv: ." + this.scriptParms);
                    System.out.println(string);
                    Tr.audit(tc, "WASX7303I", new Object[]{this.scriptParms});
                }
                this.welcome();
                this.interactive();
            }
        } else if (returnCode == 0) {
            returnCode = -1;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "run -> " + returnCode);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

