/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.scripting;

import com.ibm.ejs.ras.MalformedTraceStringException;
import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.ObjectNameHelper;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.scripting.StringHandler;
import com.ibm.ws.scripting.AbstractShell;
import com.ibm.ws.scripting.AdminConfigClient;
import com.ibm.ws.scripting.CommonScriptingObject;
import com.ibm.ws.scripting.DefaultStringHandler;
import com.ibm.ws.scripting.ExtensionHelper;
import com.ibm.ws.scripting.HandlerRegistry;
import com.ibm.ws.scripting.ScriptingException;
import com.ibm.ws.scripting.StartServerCommand;
import com.ibm.ws.scripting.StopServerCommand;
import com.ibm.ws.scripting.TestConnectionCommand;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.QueryExp;

public class AdminControlClient
extends CommonScriptingObject {
    private static TraceComponent tc = Tr.register(class$com$ibm$ws$scripting$AdminControlClient == null ? (class$com$ibm$ws$scripting$AdminControlClient = AdminControlClient.class$("com.ibm.ws.scripting.AdminControlClient")) : class$com$ibm$ws$scripting$AdminControlClient, "Scripting", "com.ibm.ws.scripting.resources.wscpMessage");
    private static AdminControlClient _self = null;
    private StringHandler defaultHandler = null;
    public static String KEY_FILE_NAME = "keyFileName";
    public static String TRUST_FILE_NAME = "trustFileName";
    public static String PRIVATE_KEY = "private";
    public static String PUBLIC_KEY = "public";
    public static String SHARED_KEY = "shared";
    private final String waitObject = "waitObject";
    private Vector waitTarget = null;
    static /* synthetic */ Class class$com$ibm$ws$scripting$AdminControlClient;
    static /* synthetic */ Class class$java$lang$String;

    public static AdminControlClient getInstance() {
        return _self;
    }

    public AdminControlClient(AbstractShell abstractShell, Properties properties) {
        super(abstractShell, properties);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AdminControlClient");
        }
        if (_client == null) {
            Tr.warning(tc, "CONTROL_SERVICE_NOT_AVAILABLE", null);
        }
        _self = this;
        this.defaultHandler = new DefaultStringHandler(this._shell);
        ExtensionHelper.processRegisterHandlersInExtensions(this._shell);
        if (connectedServer != null) {
            String string = _client.getType();
            String string2 = ObjectNameHelper.getNodeName(connectedServer);
            String string3 = ObjectNameHelper.getProcessName(connectedServer);
            String string4 = this._shell.getFormattedMessage("WASX7209I", new Object[]{string3, string2, string, processType}, "Connected to process \"" + string3 + "\" on node " + string2 + " using " + string + " connector;  The type of process is: " + processType);
            System.out.println(string4);
        } else {
            Object object;
            String string = ManagerAdmin.getTraceFileName();
            String string5 = null;
            if (string != null) {
                object = new File(ManagerAdmin.getTraceFileName());
                string5 = ((File)object).getAbsolutePath();
            } else {
                string5 = "<stdout>";
            }
            object = this._shell.getFormattedMessage("WASX7213I", new Object[]{string5}, "Not connected to server.");
            if (properties != null) {
                System.out.println((String)object);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AdminControlClient");
        }
    }

    public void checkService() throws ScriptingException {
        if (_client == null) {
            this._shell.setAndThrowScriptingException("CONTROL_NOT_AVAIL", "AdminControl service not available", new Object[0]);
        }
    }

    public String getType() throws ScriptingException {
        this._shell.setLastException(null);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getType");
        }
        this.checkService();
        String string = _client.getType();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getType");
        }
        return string;
    }

    public String getHost() throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getHost");
        }
        this._shell.setLastException(null);
        this.checkService();
        Properties properties = _client.getConnectorProperties();
        String string = properties.getProperty("host");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getHost");
        }
        return string;
    }

    public String getNode() throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNode");
        }
        this._shell.setLastException(null);
        this.checkService();
        String string = ObjectNameHelper.getNodeName(connectedServer);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNode");
        }
        return string;
    }

    public String getCell() throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCell");
        }
        this._shell.setLastException(null);
        this.checkService();
        String string = ObjectNameHelper.getCellName(connectedServer);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCell");
        }
        return string;
    }

    public String getPort() throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPort");
        }
        this.checkService();
        Properties properties = _client.getConnectorProperties();
        String string = properties.getProperty("port");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPort");
        }
        return string;
    }

    public String getProcessName() throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProcessName");
        }
        this.checkService();
        String string = ObjectNameHelper.getProcessName(connectedServer);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProcessName");
        }
        return string;
    }

    public String reconnect() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reconnect");
        }
        this._shell.manageReconnect();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reconnect");
        }
        return new String();
    }

    public void doReconnect() throws ConnectorException, AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doReconnect");
        }
        this.checkService();
        _client.isAlive();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doReconnect");
        }
    }

    public Session isAlive() throws ScriptingException {
        this._shell.setLastException(null);
        this.checkService();
        Session session = null;
        try {
            session = _client.isAlive();
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            throw new ScriptingException(exception.toString());
        }
        return session;
    }

    public Set queryNames_jmx(ObjectName objectName, QueryExp queryExp) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "queryNames_jmx - ", new Object[]{objectName, queryExp});
        }
        this._shell.setLastException(null);
        this.checkService();
        try {
            return _client.queryNames(objectName, queryExp);
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            throw new ScriptingException(exception.toString());
        }
    }

    public Integer getMBeanCount() throws ScriptingException {
        Integer n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMBeanCount");
        }
        this._shell.setLastException(null);
        this.checkService();
        try {
            n = _client.getMBeanCount();
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            throw new ScriptingException(exception.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMBeanCount");
        }
        return n;
    }

    public String getDomainName() throws ScriptingException {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDomainName");
        }
        this._shell.setLastException(null);
        this.checkService();
        try {
            string = _client.getDomainName();
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            throw new ScriptingException(exception.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDomainName");
        }
        return string;
    }

    public String getDefaultDomain() throws ScriptingException {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultDomain");
        }
        this._shell.setLastException(null);
        this.checkService();
        try {
            string = _client.getDefaultDomain();
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            throw new ScriptingException(exception.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultDomain");
        }
        return string;
    }

    public MBeanInfo getMBeanInfo_jmx(ObjectName objectName) throws ScriptingException {
        this._shell.setLastException(null);
        this.checkService();
        MBeanInfo mBeanInfo = null;
        try {
            mBeanInfo = _client.getMBeanInfo(objectName);
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            throw new ScriptingException(exception.toString());
        }
        return mBeanInfo;
    }

    public boolean isInstanceOf_jmx(ObjectName objectName, String string) throws ScriptingException {
        this._shell.setLastException(null);
        this.checkService();
        boolean bl = false;
        try {
            bl = _client.isInstanceOf(objectName, string);
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            throw new ScriptingException(exception.toString());
        }
        return bl;
    }

    public boolean isRegistered_jmx(ObjectName objectName) throws ScriptingException {
        this._shell.setLastException(null);
        this.checkService();
        boolean bl = false;
        try {
            bl = _client.isRegistered(objectName);
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            throw new ScriptingException(exception.toString());
        }
        return bl;
    }

    public Object getAttribute_jmx(ObjectName objectName, String string) throws ScriptingException {
        this._shell.setLastException(null);
        this.checkService();
        Object object = null;
        try {
            object = _client.getAttribute(objectName, string);
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            throw new ScriptingException(exception.toString());
        }
        return object;
    }

    public AttributeList getAttributes_jmx(ObjectName objectName, String[] stringArray) throws ScriptingException {
        this._shell.setLastException(null);
        this.checkService();
        AttributeList attributeList = null;
        try {
            attributeList = _client.getAttributes(objectName, stringArray);
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            throw new ScriptingException(exception.toString());
        }
        return attributeList;
    }

    public String setAttribute_jmx(ObjectName objectName, Attribute attribute) throws ScriptingException {
        this._shell.setLastException(null);
        this.checkService();
        try {
            _client.setAttribute(objectName, attribute);
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            throw new ScriptingException(exception.toString());
        }
        return new String();
    }

    public AttributeList setAttributes_jmx(ObjectName objectName, AttributeList attributeList) throws ScriptingException {
        this._shell.setLastException(null);
        this.checkService();
        try {
            return _client.setAttributes(objectName, attributeList);
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            throw new ScriptingException(exception.toString());
        }
    }

    public Object invoke_jmx(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws ScriptingException {
        this._shell.setLastException(null);
        this.checkService();
        try {
            return _client.invoke(objectName, string, objectArray, stringArray);
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            throw new ScriptingException(exception.toString());
        }
    }

    public ObjectName makeObjectName(String string) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "makeObjectName");
        }
        this._shell.setLastException(null);
        ObjectName objectName = null;
        try {
            if (string == null || string.trim().equals("")) {
                throw new MalformedObjectNameException();
            }
            if (string.startsWith("\"") && string.endsWith("\"")) {
                string = string.substring(1, string.length() - 1);
            }
            if (string != null && string.indexOf(":") < 0) {
                string = "WebSphere:" + string;
            }
            objectName = new ObjectName(string);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            this._shell.setAndThrowScriptingException("MALFORMED_OBJECT_NAME", "String \"" + string + "\" is malformed; cannot create ObjectName", new Object[]{string});
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            throw new ScriptingException(exception.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "makeObjectName");
        }
        return objectName;
    }

    public String completeObjectName(String string) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeObjectName - " + string);
        }
        this._shell.setLastException(null);
        Object[] objectArray = null;
        try {
            ObjectName objectName = this.makeObjectName(string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "objName - " + objectName);
            }
            Set set = null;
            set = this.queryNames_jmx(objectName, null);
            if (set == null || set.size() == 0) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "completeObjectName - null");
                }
                return new String();
            }
            if (set.size() > 1) {
                String string2 = this._shell.getFormattedMessage("WARNING_MULTIPLE_MATCHES", new Object[]{string, new Integer(set.size())}, "String \"" + string + "\" corresponds to " + set.size() + " MBeans; returning first one");
                System.out.println(string2);
            }
            objectArray = set.toArray();
        }
        catch (ScriptingException scriptingException) {
            throw scriptingException;
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            throw new ScriptingException(exception.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completeObjectName");
        }
        return ((ObjectName)objectArray[0]).toString();
    }

    public String queryNames(String string) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "queryNames");
        }
        this._shell.setLastException(null);
        Set set = null;
        String string2 = null;
        ObjectName objectName = this.makeObjectName(string);
        set = this.queryNames_jmx(objectName, null);
        string2 = this._langutils.setToString(set);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "queryNames");
        }
        return string2;
    }

    public boolean isInstanceOf(String string, String string2) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isInstanceOf");
        }
        this._shell.setLastException(null);
        boolean bl = false;
        ObjectName objectName = this.makeObjectName(string);
        bl = this.isInstanceOf_jmx(objectName, string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isInstanceOf returns " + bl);
        }
        return bl;
    }

    public boolean isRegistered(String string) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isRegistered");
        }
        this._shell.setLastException(null);
        boolean bl = false;
        ObjectName objectName = this.makeObjectName(string);
        bl = this.isRegistered_jmx(objectName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isRegistered returns " + bl);
        }
        return bl;
    }

    public String getAttribute(String string, String string2) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttribute");
        }
        this._shell.setLastException(null);
        Object object = null;
        String string3 = new String();
        try {
            ObjectName objectName = this.makeObjectName(string);
            object = this.getAttribute_jmx(objectName, string2);
            if (object != null) {
                Class<?> clazz = object.getClass();
                StringHandler stringHandler = HandlerRegistry.getHandler(clazz);
                if (stringHandler == null) {
                    stringHandler = this.defaultHandler;
                }
                string3 = this.formDisplayString(object);
            }
        }
        catch (ScriptingException scriptingException) {
            throw scriptingException;
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            throw new ScriptingException(exception.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttribute");
        }
        return string3;
    }

    public String getAttributes(String string) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributes");
        }
        this._shell.setLastException(null);
        String string2 = this.getAttributes(string, (String)null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributes");
        }
        return string2;
    }

    public String getAttributes(String string, Object[] objectArray) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributes");
        }
        this._shell.setLastException(null);
        String string2 = this._langutils.objectArrayToString(objectArray);
        String string3 = this.getAttributes(string, string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributes");
        }
        return string3;
    }

    public String getAttributes(String string, String string2) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributes");
        }
        this._shell.setLastException(null);
        ObjectName objectName = this.makeObjectName(string);
        String string3 = null;
        try {
            String[] stringArray = null;
            stringArray = string2 == null || string2.length() == 0 ? this.attributes(objectName) : this._langutils.stringToStringArray(string2);
            AttributeList attributeList = this.getAttributes_jmx(objectName, stringArray);
            for (int i = 0; i < attributeList.size(); ++i) {
                String string4 = ((Attribute)attributeList.get(i)).getName();
                Object object = ((Attribute)attributeList.get(i)).getValue();
                if (object != null) {
                    Class<?> clazz = object.getClass();
                    StringHandler stringHandler = HandlerRegistry.getHandler(clazz);
                    if (stringHandler == null) {
                        stringHandler = this.defaultHandler;
                    }
                    attributeList.set(i, new Attribute(string4, this.formDisplayString(object)));
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "attribute name " + string4 + " has no value");
                }
                attributeList.set(i, new Attribute(string4, new String()));
            }
            string3 = this._langutils.attributeListToString(attributeList);
        }
        catch (ScriptingException scriptingException) {
            throw scriptingException;
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            throw new ScriptingException(exception.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributes");
        }
        return string3;
    }

    public String setAttribute(String string, String string2, String string3) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAttribute");
        }
        this._shell.setLastException(null);
        ObjectName objectName = this.makeObjectName(string);
        try {
            Object object;
            Object object2 = this.getAttribute_jmx(objectName, string2);
            Attribute attribute = null;
            Class<Serializable> clazz = null;
            if (object2 != null) {
                clazz = object2.getClass();
            } else {
                object = this.attributeType(objectName, string2);
                try {
                    clazz = ((String)object).equals("int") ? Integer.TYPE : (((String)object).equals("boolean") ? Boolean.TYPE : (((String)object).equals("char") ? Character.TYPE : (((String)object).equals("byte") ? Byte.TYPE : (((String)object).equals("short") ? Short.TYPE : (((String)object).equals("long") ? Long.TYPE : (((String)object).equals("float") ? Float.TYPE : (((String)object).equals("double") ? Double.TYPE : Class.forName((String)object))))))));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    String string4 = this._shell.getFormattedMessage("WASX7237W", new Object[]{string2, object}, "Type " + (String)object + " for attribute " + string2 + " is not supported.");
                    System.out.println(string4);
                    clazz = class$java$lang$String == null ? (class$java$lang$String = AdminControlClient.class$("java.lang.String")) : class$java$lang$String;
                }
            }
            object = HandlerRegistry.getHandler(clazz);
            if (object == null) {
                object = this.defaultHandler;
            }
            Object object3 = null;
            object3 = object.formValidObject(string3, clazz, this._shell.getLang());
            attribute = new Attribute(string2, object3);
            this.setAttribute_jmx(objectName, attribute);
        }
        catch (ScriptingException scriptingException) {
            throw scriptingException;
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            throw new ScriptingException(exception.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAttribute");
        }
        return new String();
    }

    public String setAttributes(String string, Object[] objectArray) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAttributes");
        }
        this._shell.setLastException(null);
        String string2 = this._langutils.objectArrayToString(objectArray);
        String string3 = this.setAttributes(string, string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAttributes");
        }
        return string3;
    }

    public String setAttributes(String string, String string2) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAttributes");
        }
        this._shell.setLastException(null);
        ObjectName objectName = this.makeObjectName(string);
        String string3 = null;
        try {
            Object object;
            string2 = this._langutils.cleanAttributeString(string2);
            AttributeList attributeList = this._langutils.stringToAttributeList(string2);
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < attributeList.size(); ++i) {
                object = ((Attribute)attributeList.get(i)).getName();
                stringBuffer.append((String)object);
                stringBuffer.append(" ");
            }
            String[] stringArray = this._langutils.stringToStringArray(stringBuffer.toString());
            object = this.getAttributes_jmx(objectName, stringArray);
            for (int i = 0; i < attributeList.size(); ++i) {
                String string4 = ((Attribute)attributeList.get(i)).getName();
                boolean bl = false;
                Object object2 = null;
                Class<?> clazz = null;
                for (int j = 0; j < ((ArrayList)object).size(); ++j) {
                    if (!string4.equals(((Attribute)((ArrayList)object).get(j)).getName())) continue;
                    clazz = ((Attribute)((ArrayList)object).get(j)).getValue().getClass();
                    bl = true;
                    break;
                }
                if (!bl) continue;
                StringHandler stringHandler = HandlerRegistry.getHandler(clazz);
                if (stringHandler == null) {
                    stringHandler = this.defaultHandler;
                }
                object2 = stringHandler.formValidObject((String)((Attribute)attributeList.get(i)).getValue(), clazz, this._shell.getLang());
                attributeList.set(i, new Attribute(string4, object2));
            }
            AttributeList attributeList2 = this.setAttributes_jmx(objectName, attributeList);
            string3 = this._langutils.attributeListToString(attributeList2);
        }
        catch (ScriptingException scriptingException) {
            throw scriptingException;
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            throw new ScriptingException(exception.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAttributes");
        }
        return string3;
    }

    public String invoke(String string, String string2) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke");
        }
        this._shell.setLastException(null);
        String string3 = new String();
        String string4 = this.invoke(string, string2, string3);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke");
        }
        return string4;
    }

    public String invoke(String string, String string2, String string3) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke");
        }
        this._shell.setLastException(null);
        String string4 = this.invoke(string, string2, string3, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke");
        }
        return string4;
    }

    public String invoke(String string, String string2, String string3, String string4) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke");
        }
        this._shell.setLastException(null);
        ObjectName objectName = this.makeObjectName(string);
        String string5 = new String();
        try {
            Object object;
            int n;
            ArrayList arrayList = null;
            String[] stringArray = this._langutils.stringToStringArray(string3);
            String[] stringArray2 = null;
            boolean bl = true;
            if (string4 == null) {
                bl = false;
                arrayList = this.signature(objectName, string2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "size of sig array: " + arrayList.size());
                }
                if (arrayList.size() == 0) {
                    stringArray2 = new String[stringArray.length];
                    for (n = 0; n < stringArray.length; ++n) {
                        stringArray2[n] = "java.lang.String";
                    }
                }
            } else {
                stringArray2 = this._langutils.stringToStringArray(string4);
            }
            n = 0;
            StringBuffer stringBuffer = new StringBuffer();
            if (stringArray2 == null) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    stringArray2 = (String[])arrayList.get(i);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "length of this sig " + stringArray2.length);
                    }
                    stringBuffer.append(Integer.toString(stringArray2.length));
                    if (i < arrayList.size() - 1) {
                        stringBuffer.append(", ");
                    }
                    if (stringArray2.length != stringArray.length) continue;
                    n = 1;
                    break;
                }
            } else {
                n = 1;
            }
            if (n == 0) {
                if (!bl) {
                    this._shell.setAndThrowScriptingException("WASX7139E", "Operation \"" + string2 + "\" requires " + stringBuffer.toString() + " parameters, but " + stringArray.length + " were supplied: " + string3, new Object[]{string2, stringBuffer.toString(), new Integer(stringArray.length), string3});
                } else {
                    this._shell.setAndThrowScriptingException("WASX7140E", "Length mismatch: " + stringArray.length + " parameters were specified, but " + stringArray2.length + " signatures were supplied. The same number must be specified for both.", new Object[]{new Integer(stringArray.length), new Integer(stringArray2.length)});
                }
            }
            Object[] objectArray = new Object[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                Class<Serializable> clazz = null;
                object = null;
                try {
                    clazz = stringArray2[i].equals("int") ? Integer.TYPE : (stringArray2[i].equals("boolean") ? Boolean.TYPE : (stringArray2[i].equals("char") ? Character.TYPE : (stringArray2[i].equals("byte") ? Byte.TYPE : (stringArray2[i].equals("short") ? Short.TYPE : (stringArray2[i].equals("long") ? Long.TYPE : (stringArray2[i].equals("float") ? Float.TYPE : (stringArray2[i].equals("double") ? Double.TYPE : Class.forName(stringArray2[i]))))))));
                    object = HandlerRegistry.getHandler(clazz);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Tr.warning(tc, "Caught ClassNotFoundException for " + stringArray2[i] + "; using String");
                    Class<Byte> clazz2 = clazz = class$java$lang$String == null ? AdminControlClient.class$("java.lang.String") : class$java$lang$String;
                }
                if (object == null) {
                    object = this.defaultHandler;
                }
                objectArray[i] = object.formValidObject(stringArray[i], clazz, this._shell.getLang());
            }
            Object object2 = null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "About to invoke " + string2 + " on " + objectName.toString());
                for (int i = 0; i < objectArray.length; ++i) {
                    object = null;
                    if (objectArray[i] != null && (((String)(object = objectArray[i].toString())).toLowerCase().lastIndexOf("password") >= 0 || ((String)object).equals(KEY_FILE_NAME) || ((String)object).equals(TRUST_FILE_NAME) || ((String)object).equals(PRIVATE_KEY) || ((String)object).equals(PUBLIC_KEY) || ((String)object).equals(SHARED_KEY))) {
                        object = "*****";
                    }
                    Tr.debug(tc, "parm " + i + ": " + (String)object);
                    if (objectArray[i] != null) {
                        Tr.debug(tc, "type of parm " + i + ": " + objectArray[i].getClass().getName());
                    }
                    Tr.debug(tc, "Signature element " + i + ": " + stringArray2[i]);
                }
            }
            object2 = this.invoke_jmx(objectName, string2, objectArray, stringArray2);
            string5 = this.formDisplayString(object2, false);
        }
        catch (ScriptingException scriptingException) {
            throw scriptingException;
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            throw new ScriptingException(exception.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke");
        }
        return string5;
    }

    protected String formDisplayString(Object object) throws ScriptingException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formDisplayString");
        }
        String string = this.formDisplayString(object, true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formDisplayString");
        }
        return string;
    }

    protected String formDisplayString(Object object, boolean bl) throws ScriptingException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "formDisplayString");
        }
        String string = new String();
        if (object != null) {
            Class<?> clazz = object.getClass();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "class of return object is " + clazz.getName());
            }
            Object[] objectArray = null;
            if (object instanceof Collection) {
                objectArray = ((Collection)object).toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] != null) continue;
                    objectArray[i] = "Null returned from server";
                }
            } else if (clazz.isArray()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Return object is an array");
                }
                objectArray = (Object[])object;
            }
            if (objectArray != null) {
                StringHandler stringHandler;
                Class<?> clazz2 = objectArray.getClass().getComponentType();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "class of elements is " + (clazz2 == null ? "null" : clazz2.getName()));
                }
                if ((stringHandler = HandlerRegistry.getHandler(clazz2)) == null) {
                    stringHandler = this.defaultHandler;
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "input to formDisplayString - " + objectArray[i].toString());
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Class:  - " + objectArray[i].getClass().getName());
                        }
                        arrayList.add(stringHandler.formDisplayString(objectArray[i], this._shell.getLang()));
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "oarray[" + i + "] is null ");
                }
                string = this._langutils.setToString(arrayList, bl);
            } else {
                StringHandler stringHandler = HandlerRegistry.getHandler(clazz);
                if (stringHandler == null) {
                    stringHandler = this.defaultHandler;
                }
                string = stringHandler.formDisplayString(object, this._shell.getLang());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "formDisplayString");
        }
        return string;
    }

    public String help() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "help");
        }
        String string = this._shell.getFormattedMessage("ADMINCONTROL_GENERAL_HELP", new Object[0], "no help available");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "help");
        }
        return string;
    }

    public String help(String string) {
        String string2;
        String string3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "help");
        }
        if ((string3 = this._shell.getFormattedMessage(string2 = "ADMINCONTROL_HELP_" + string.toUpperCase(), new Object[0], "No help available for " + string)).startsWith("No help available")) {
            string2 = "WASX7084E";
            string3 = this._shell.getFormattedMessage(string2, new Object[]{string}, "No help available for " + string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "help");
        }
        return string3;
    }

    public String queryNames() throws ScriptingException {
        this.helpInfo("queryNames");
        return new String();
    }

    public String queryNames_jmx() throws ScriptingException {
        this.helpInfo("queryNames_jmx");
        return new String();
    }

    public String getMBeanInfo_jmx() throws ScriptingException {
        this.helpInfo("getMBeanInfo_jmx");
        return new String();
    }

    public String isInstanceOf() throws ScriptingException {
        this.helpInfo("isInstanceOf");
        return new String();
    }

    public String isInstanceOf_jmx() throws ScriptingException {
        this.helpInfo("isInstanceOf_jmx");
        return new String();
    }

    public String isRegistered() throws ScriptingException {
        this.helpInfo("isRegistered");
        return new String();
    }

    public String isRegistered_jmx() throws ScriptingException {
        this.helpInfo("isRegistered_jmx");
        return new String();
    }

    public String getAttribute() throws ScriptingException {
        this.helpInfo("getAttribute");
        return new String();
    }

    public String getAttribute(Object object) throws ScriptingException {
        this.helpInfo("getAttribute");
        return new String();
    }

    public String getAttribute_jmx() throws ScriptingException {
        this.helpInfo("getAttribute_jmx");
        return new String();
    }

    public String getAttribute_jmx(Object object) throws ScriptingException {
        this.helpInfo("getAttribute_jmx");
        return new String();
    }

    public String getAttributes() throws ScriptingException {
        this.helpInfo("getAttributes");
        return new String();
    }

    public String getAttributes_jmx() throws ScriptingException {
        this.helpInfo("getAttributes_jmx");
        return new String();
    }

    public String getAttributes_jmx(Object object) throws ScriptingException {
        this.helpInfo("getAttributes_jmx");
        return new String();
    }

    public String setAttribute() throws ScriptingException {
        this.helpInfo("setAttribute");
        return new String();
    }

    public String setAttribute(Object object) throws ScriptingException {
        this.helpInfo("setAttribute");
        return new String();
    }

    public String setAttribute(Object object, Object object2) throws ScriptingException {
        this.helpInfo("setAttribute");
        return new String();
    }

    public String setAttribute_jmx() throws ScriptingException {
        this.helpInfo("setAttribute_jmx");
        return new String();
    }

    public String setAttribute_jmx(Object object) throws ScriptingException {
        this.helpInfo("setAttribute_jmx");
        return new String();
    }

    public String setAttributes() throws ScriptingException {
        this.helpInfo("setAttributes");
        return new String();
    }

    public String setAttributes(Object object) throws ScriptingException {
        this.helpInfo("setAttributes");
        return new String();
    }

    public String setAttributes_jmx() throws ScriptingException {
        this.helpInfo("setAttributes_jmx");
        return new String();
    }

    public String setAttributes_jmx(Object object) throws ScriptingException {
        this.helpInfo("setAttributes_jmx");
        return new String();
    }

    public String invoke() throws ScriptingException {
        this.helpInfo("invoke");
        return new String();
    }

    public String invoke(Object object) throws ScriptingException {
        this.helpInfo("invoke");
        return new String();
    }

    public String invoke_jmx() throws ScriptingException {
        this.helpInfo("invoke_jmx");
        return new String();
    }

    public String invoke_jmx(Object object) throws ScriptingException {
        this.helpInfo("invoke_jmx");
        return new String();
    }

    public String invoke_jmx(Object object, Object object2) throws ScriptingException {
        this.helpInfo("invoke_jmx");
        return new String();
    }

    public String invoke_jmx(Object object, Object object2, Object object3) throws ScriptingException {
        this.helpInfo("invoke_jmx");
        return new String();
    }

    public String trace() throws ScriptingException {
        this.helpInfo("trace");
        return new String();
    }

    public String makeObjectName() throws ScriptingException {
        this.helpInfo("makeObjectName");
        return new String();
    }

    public String completeObjectName() throws ScriptingException {
        this.helpInfo("completeObjectName");
        return new String();
    }

    public String testConnection() throws ScriptingException {
        this.helpInfo("testConnection");
        return new String();
    }

    public String stopServer() throws ScriptingException {
        this.helpInfo("stopServer");
        return new String();
    }

    public String startServer() throws ScriptingException {
        this.helpInfo("startServer");
        return new String();
    }

    public String getConfigId() throws ScriptingException {
        this.helpInfo("getConfigId");
        return new String();
    }

    public String getConfigId(String string) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigId - " + string);
        }
        this._shell.setLastException(null);
        String string2 = new String();
        String string3 = null;
        try {
            String string4;
            AdminConfigClient adminConfigClient = AdminConfigClient.getInstance();
            adminConfigClient.checkService();
            string3 = this.completeObjectName(string);
            if (string3 == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "completeObjectName - null");
                }
                return new String();
            }
            ObjectName objectName = null;
            StringBuffer stringBuffer = new StringBuffer();
            objectName = new ObjectName(string3);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ObjectName: " + objectName.toString());
            }
            if ((string4 = objectName.getKeyProperty("mbeanIdentifier")) != null) {
                int n = string4.lastIndexOf(47);
                if (n >= 0 && string4.substring(n, string4.length()).indexOf(".xml") >= 0) {
                    stringBuffer.append(string4.substring(0, n));
                    stringBuffer.append(":");
                    stringBuffer.append(string4.substring(n + 1));
                } else {
                    stringBuffer.append(string4);
                }
                string2 = adminConfigClient.internalGetID(stringBuffer.toString());
            }
        }
        catch (ScriptingException scriptingException) {
            throw scriptingException;
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            this._shell.setAndThrowScriptingException("MALFORMED_OBJECT_NAME", "String \"" + string3 + "\" is malformed; cannot create ObjectName", new Object[]{string3});
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            throw new ScriptingException(exception.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigId");
        }
        return string2;
    }

    public String startServer(String string) throws ConnectorException, AdminException, ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startServer - " + string);
        }
        this._shell.setLastException(null);
        String string2 = this.startServer(string, null, "0", false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startServer - " + string);
        }
        return string2;
    }

    public String startServer(String string, String string2) throws ConnectorException, AdminException, ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startServer", new Object[]{string, string2});
        }
        this._shell.setLastException(null);
        String string3 = this.startServer(string, string2, "0", true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startServer");
        }
        return string3;
    }

    public String startServer(String string, int n) throws ConnectorException, AdminException, ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startServer - " + string + " " + n);
        }
        this._shell.setLastException(null);
        String string2 = this.startServer(string, "", Integer.toString(n), false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startServer");
        }
        return string2;
    }

    public String startServer(String string, String string2, String string3) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startServer", new Object[]{string, string2, string3});
        }
        this._shell.setLastException(null);
        String string4 = this.startServer(string, string2, string3, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startServer");
        }
        return string4;
    }

    public String startServer(String string, String string2, int n) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startServer - " + string + " " + string2 + " " + n);
        }
        this._shell.setLastException(null);
        String string3 = this.startServer(string, string2, Integer.toString(n), false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startServer");
        }
        return string3;
    }

    protected String startServer(String string, String string2, String string3, boolean bl) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "serverName - " + string + " " + string2 + " " + string3 + " " + bl);
        }
        this._shell.setLastException(null);
        String string4 = null;
        try {
            StartServerCommand startServerCommand = new StartServerCommand(_client, this._shell, this);
            startServerCommand.setServerName(string);
            startServerCommand.setNodeName(string2);
            startServerCommand.setWaitTime(Integer.valueOf(string3));
            startServerCommand.setIsOverload(bl);
            startServerCommand.setDomain("WebSphere");
            startServerCommand.setProcessType(processType);
            string4 = (String)startServerCommand.invoke();
        }
        catch (ScriptingException scriptingException) {
            throw scriptingException;
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            throw new ScriptingException(exception.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startServer");
        }
        return string4;
    }

    public String stopServer(String string) throws ConnectorException, AdminException, ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "serverName - " + string);
        }
        this._shell.setLastException(null);
        String string2 = this.stopServer(string, null, null, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopServer - " + string);
        }
        return string2;
    }

    public String stopServer(String string, String string2) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "serverName - ", new Object[]{string, string2});
        }
        this._shell.setLastException(null);
        String string3 = this.stopServer(string, string2, null, true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopServer - " + string);
        }
        return string3;
    }

    public String stopServer(String string, String string2, String string3) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "serverName", new Object[]{string, string2, string3});
        }
        this._shell.setLastException(null);
        String string4 = this.stopServer(string, string2, string3, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopServer - " + string);
        }
        return string4;
    }

    protected String stopServer(String string, String string2, String string3, boolean bl) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "serverName - " + string + " " + string2 + " " + string3 + " " + bl);
        }
        this._shell.setLastException(null);
        String string4 = null;
        try {
            StopServerCommand stopServerCommand = new StopServerCommand(_client, this._shell, this);
            stopServerCommand.setServerName(string);
            stopServerCommand.setNodeName(string2);
            stopServerCommand.setImmediateMode(string3);
            stopServerCommand.setIsOverload(bl);
            stopServerCommand.setDomain("WebSphere");
            string4 = (String)stopServerCommand.invoke();
        }
        catch (ScriptingException scriptingException) {
            throw scriptingException;
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            throw new ScriptingException(exception.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopServer");
        }
        return string4;
    }

    public String testConnection(String string) throws ConnectorException, AdminException, ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "testConnection - " + string);
        }
        this._shell.setLastException(null);
        String string2 = null;
        try {
            TestConnectionCommand testConnectionCommand = new TestConnectionCommand(_client, this._shell, this, string);
            string2 = (String)testConnectionCommand.invoke();
        }
        catch (ScriptingException scriptingException) {
            if (scriptingException.toString().indexOf("WASX7387E") != -1) {
                string2 = this._shell.getFormattedMessage("WASX7387E", new Object[0], "TestConnection not supported when connection to 5.0 server");
                Tr.error(tc, "WASX7387E");
            }
            throw scriptingException;
        }
        catch (Exception exception) {
            this._shell.setLastException(exception);
            throw new ScriptingException(exception.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "testConnection - " + string);
        }
        return string2;
    }

    public String testConnection(String string, String string2) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "testConnection", new Object[]{string, string2});
        }
        this._shell.setLastException(null);
        String string3 = this._shell.getFormattedMessage("WASX7390E", new Object[0], "testConnection operation not supported");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "deprecated version of testConnection is invoked");
        }
        Tr.error(tc, "WASX7390E");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "testConnection");
        }
        return string3;
    }

    public String getPropertiesForDataSource(String string) throws ScriptingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPropertiesForDataSource");
        }
        this._shell.setLastException(null);
        String string2 = this._shell.getFormattedMessage("WASX7389E", new Object[0], "getPropertiesForDataSource operation not supported");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "deprecated version of getPropertiesForDataSource is invoked");
        }
        Tr.error(tc, "WASX7389E");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPropertiesForDataSource");
        }
        return string2;
    }

    public String trace(String string) throws ScriptingException {
        this._shell.setLastException(null);
        if (string != null) {
            try {
                ManagerAdmin.checkTraceString(string);
            }
            catch (MalformedTraceStringException malformedTraceStringException) {
                this._shell.setAndThrowScriptingException("WASX7141E", "Incorrect trace string supplied: " + string, new Object[]{string});
            }
            ManagerAdmin.setTraceState(string);
        }
        return new String();
    }

    protected String[] attributes(ObjectName objectName) throws ScriptingException, ConnectorException, JMException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "attributes");
        }
        MBeanInfo mBeanInfo = null;
        this.checkService();
        mBeanInfo = _client.getMBeanInfo(objectName);
        MBeanAttributeInfo[] mBeanAttributeInfoArray = mBeanInfo.getAttributes();
        String[] stringArray = new String[mBeanAttributeInfoArray.length];
        for (int i = 0; i < mBeanAttributeInfoArray.length; ++i) {
            stringArray[i] = mBeanAttributeInfoArray[i].getName();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "attributes");
        }
        return stringArray;
    }

    protected String attributeType(ObjectName objectName, String string) throws ScriptingException, ConnectorException, JMException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "attributes");
        }
        MBeanInfo mBeanInfo = null;
        String string2 = null;
        this.checkService();
        mBeanInfo = _client.getMBeanInfo(objectName);
        MBeanAttributeInfo[] mBeanAttributeInfoArray = mBeanInfo.getAttributes();
        boolean bl = false;
        for (int i = 0; i < mBeanAttributeInfoArray.length; ++i) {
            if (!string.equals(mBeanAttributeInfoArray[i].getName())) continue;
            string2 = mBeanAttributeInfoArray[i].getType();
            bl = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "attributes");
        }
        return string2;
    }

    protected ArrayList signature(ObjectName objectName, String string) throws ScriptingException, ConnectorException, JMException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "signature - " + string);
        }
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        MBeanInfo mBeanInfo = null;
        this.checkService();
        mBeanInfo = _client.getMBeanInfo(objectName);
        MBeanOperationInfo[] mBeanOperationInfoArray = mBeanInfo.getOperations();
        for (int i = 0; i < mBeanOperationInfoArray.length; ++i) {
            if (!string.equals(mBeanOperationInfoArray[i].getName())) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "found operation!");
            }
            MBeanParameterInfo[] mBeanParameterInfoArray = mBeanOperationInfoArray[i].getSignature();
            String[] stringArray = new String[mBeanParameterInfoArray.length];
            for (int j = 0; j < mBeanParameterInfoArray.length; ++j) {
                stringArray[j] = mBeanParameterInfoArray[j].getType();
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "set type " + j + " to " + stringArray[j]);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "adding sig: " + stringArray.toString());
            }
            arrayList.add(stringArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "signature");
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleNotification(Notification notification, Object object) {
        String string;
        if (notification == null) {
            if (!tc.isEventEnabled()) return;
            Tr.event(tc, "JMX event Recd: (handback obj= " + object + "): " + "Notification object is null");
            return;
        }
        Object object2 = notification.getUserData();
        if (tc.isEventEnabled()) {
            Tr.event(tc, "JMX event Recd: (handback obj= " + object + "): " + object2);
        }
        if (!this.waitTarget.contains(string = notification.getType())) return;
        String string2 = "waitObject";
        synchronized ("waitObject") {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "received event " + string);
            }
            this.waitTarget = null;
            "waitObject".notify();
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForCompletion(Vector vector, int n) {
        boolean bl = false;
        this.waitTarget = vector;
        String string = "waitObject";
        synchronized ("waitObject") {
            block7: {
                try {
                    "waitObject".wait(n);
                }
                catch (InterruptedException interruptedException) {
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug(tc, "Interrupted; time to work.");
                }
            }
            if (this.waitTarget == null) {
                bl = true;
            }
            this.waitTarget = null;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Returned from call..." + bl);
            }
            return bl;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

